/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.attachment.FtpConfigFactory;
import com.kingdee.eas.base.attachment.FtpConfigHelper;
import com.kingdee.eas.base.attachment.FtpConfigInfo;
import com.kingdee.eas.base.attachment.FtpHandleFacadeFactory;
import com.kingdee.eas.base.attachment.IFtpConfig;
import com.kingdee.eas.base.attachment.app.AbstractAttachmentFtpHandleFacadeControllerBean;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class AttachmentFtpHandleFacadeControllerBean
extends AbstractAttachmentFtpHandleFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.app.AttachmentFtpHandleFacadeControllerBean");

    @Override
    protected boolean _upload(Context ctx, String attachmentId, String fileId) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo = FtpConfigHelper.getFtpConfig(ctx);
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfo(ctx, attachmentId);
        String remotePath = FtpConfigHelper.getRemotePath(ctx, ftpConfigInfo.getRootPath(), attachmentInfo);
        FtpHandleFacadeFactory.getLocalInstance(ctx).upload(ftpConfigInfo, fileId, remotePath);
        this.updateAttachment(ctx, attachmentInfo, remotePath, ftpConfigInfo);
        return true;
    }

    @Override
    protected boolean _upload(Context ctx, IObjectValue attachmentInfo) throws BOSException, EASBizException {
        FtpConfigInfo ftpConfigInfo = FtpConfigHelper.getFtpConfig(ctx);
        AttachmentInfo attachmentInfo2 = (AttachmentInfo)attachmentInfo;
        String remotePath = FtpConfigHelper.getRemotePath(ctx, ftpConfigInfo.getRootPath(), attachmentInfo2);
        FtpHandleFacadeFactory.getLocalInstance(ctx).upload(ftpConfigInfo, attachmentInfo2.getFile(), remotePath);
        this.updateAttachment(ctx, attachmentInfo2, remotePath, ftpConfigInfo);
        return true;
    }

    @Override
    protected byte[] _download(Context ctx, String attachmentId) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfo(ctx, attachmentId);
        FtpConfigInfo ftpConfigInfo = this.getFtpConfig(ctx, attachmentInfo.getFtp().getId().toString());
        return FtpHandleFacadeFactory.getLocalInstance(ctx).download(ftpConfigInfo, attachmentInfo.getRemotePath());
    }

    @Override
    protected boolean _deleteFile(Context ctx, String attachmentId) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfo(ctx, attachmentId);
        FtpConfigInfo cfgInfo = attachmentInfo.getFtp();
        if (cfgInfo != null && cfgInfo.getId() != null) {
            FtpConfigInfo ftpConfigInfo = this.getFtpConfig(ctx, attachmentInfo.getFtp().getId().toString());
            return FtpHandleFacadeFactory.getLocalInstance(ctx).deleteFile(ftpConfigInfo, attachmentInfo.getRemotePath());
        }
        logger.error((Object)("Debug(\u5f02\u5e38\u9644\u4ef6\uff1a)" + attachmentId));
        return false;
    }

    private void updateAttachment(Context ctx, AttachmentInfo attachmentInfo, String remotePath, FtpConfigInfo ftpConfigInfo) throws EASBizException, BOSException {
        attachmentInfo.setRemotePath(remotePath);
        attachmentInfo.setStorageType(AttachmentStorageTypeEnum.FTP);
        attachmentInfo.setFtp(ftpConfigInfo);
        attachmentInfo.setFile(null);
        AttachmentFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(attachmentInfo.getId().toString()), attachmentInfo);
    }

    private FtpConfigInfo getFtpConfig(Context ctx, String ftpId) throws BOSException, EASBizException {
        IFtpConfig iFtpConfig = FtpConfigFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("host"));
        sic.add(new SelectorItemInfo("port"));
        sic.add(new SelectorItemInfo("userName"));
        sic.add(new SelectorItemInfo("password"));
        sic.add(new SelectorItemInfo("rootPath"));
        sic.add(new SelectorItemInfo("sftpStatus"));
        FtpConfigInfo ftpConfigInfo = iFtpConfig.getFtpConfigInfo((IObjectPK)new ObjectUuidPK(ftpId), sic);
        return ftpConfigInfo;
    }

    @Override
    protected boolean _updateContent(Context ctx, String attachmentId, byte[] content) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo = AttachmentFactory.getLocalInstance(ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachmentId));
        FtpConfigInfo ftpConfigInfo = this.getFtpConfig(ctx, attachmentInfo.getFtp().getId().toString());
        return FtpHandleFacadeFactory.getLocalInstance(ctx).updateContent(ftpConfigInfo, attachmentInfo.getRemotePath(), content);
    }

    @Override
    protected boolean _updateContent(Context ctx, String attachmentId, String fileId) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo = AttachmentFactory.getLocalInstance(ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachmentId));
        FtpConfigInfo ftpConfigInfo = this.getFtpConfig(ctx, attachmentInfo.getFtp().getId().toString());
        return FtpHandleFacadeFactory.getLocalInstance(ctx).updateContent(ftpConfigInfo, fileId, attachmentInfo.getRemotePath());
    }

    @Override
    protected void _download(Context ctx, String attachmentId, String localPath) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfo(ctx, attachmentId);
        FtpConfigInfo ftpConfigInfo = this.getFtpConfig(ctx, attachmentInfo.getFtp().getId().toString());
        FtpHandleFacadeFactory.getLocalInstance(ctx).download(localPath, attachmentInfo.getRemotePath(), ftpConfigInfo);
    }
}

