/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.ServerConfigHelper;
import com.kingdee.eas.base.attachment.ServerConfigInfo;
import com.kingdee.eas.base.attachment.app.IAttachmentMove;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentUploadServer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AttachmentMoveToServer
implements IAttachmentMove {
    private static final Logger logger = Logger.getLogger((String)AttachmentMoveToServer.class.getName());
    private AttachmentUploadServer aus;
    private ServerConfigInfo configInfo;

    public AttachmentMoveToServer(ServerConfigInfo configInfo) {
        this.configInfo = configInfo;
        this.aus = new AttachmentUploadServer();
    }

    @Override
    public void delete(Context ctx, String path) throws BOSException, EASBizException {
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public boolean move(Context ctx, AttachmentInfo attachmentInfo, String path) throws BOSException, EASBizException {
        File file;
        if (path != null && (file = new File(path)).exists()) {
            file.delete();
        }
        AttachmentFtpInfo attachmentFtpInfo = this.aus.addServerContent(path, attachmentInfo.getFile());
        if (path == null) {
            path = attachmentFtpInfo.getTempFileName();
        }
        return true;
    }

    @Override
    public String getPath(Context ctx, AttachmentInfo attachmentInfo) throws BOSException, EASBizException {
        return ServerConfigHelper.getEASServerPath(ctx, this.configInfo.getPath(), attachmentInfo);
    }

    @Override
    public void delete(Context ctx, Map pathMap) throws BOSException, EASBizException {
        if (pathMap == null) {
            return;
        }
        for (String path : pathMap.values()) {
            if (path == null) {
                return;
            }
            File file = new File(path);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    @Override
    public boolean updateAttachment(Context ctx, Map pathMap) throws BOSException, EASBizException {
        if (pathMap == null || pathMap.size() == 0) {
            return false;
        }
        String sql = "update t_bas_attachment set fremotepath = ?, fftpid = null, ffile = null,fstoragetype =2 where fid = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Set keySet = pathMap.keySet();
        for (Object key : keySet) {
            Object[] params = new Object[]{pathMap.get(key), key};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        return true;
    }
}

