/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.attachment.ObsConfigInfo;
import com.kingdee.eas.base.attachment.ObsException;
import com.kingdee.eas.base.attachment.app.AbstractObsHandleFacadeControllerBean;
import com.kingdee.eas.base.attachment.obs.BucketObjectOperation;
import com.kingdee.eas.base.attachment.obs.ObsBucketOperation;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.CryptoTean;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ObsHandleFacadeControllerBean
extends AbstractObsHandleFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.app.ObsHandleFacadeControllerBean");

    @Override
    protected int _upload(Context ctx, IObjectValue obsConfigInfo, byte[] file, String objectName) throws BOSException, EASBizException {
        ObsConfigInfo obsConfigInfo2 = (ObsConfigInfo)obsConfigInfo;
        try {
            return this.reUpload(ctx, obsConfigInfo2, file, objectName);
        }
        catch (Exception e) {
            this.obsExceptionProcess(e);
            return 0;
        }
    }

    private int reUpload(Context ctx, ObsConfigInfo obsConfigInfo, byte[] file, String objectName) throws Exception {
        String accessKeyId = obsConfigInfo.getAccessKeyId();
        String accessKeySecret = CryptoTean.decrypt((String)obsConfigInfo.getId().toString(), (String)obsConfigInfo.getAccessKeySecret());
        String endPoint = obsConfigInfo.getEndpoint();
        String obsBucketName = obsConfigInfo.getObsBucketName();
        BucketObjectOperation bucketObjectOperation = new BucketObjectOperation(endPoint, accessKeyId, accessKeySecret, obsBucketName);
        Integer uploadCode = bucketObjectOperation.uploadFileByByte(file, objectName);
        return uploadCode;
    }

    @Override
    protected int _uploadFile(Context ctx, IObjectValue obsConfigInfo, String fileUrl, String objectName) throws BOSException, EASBizException {
        ObsConfigInfo obsConfigInfo2 = (ObsConfigInfo)obsConfigInfo;
        try {
            return this.reUploadFile(ctx, obsConfigInfo2, fileUrl, objectName);
        }
        catch (Exception e) {
            this.obsExceptionProcess(e);
            return 0;
        }
    }

    private int reUploadFile(Context ctx, ObsConfigInfo obsConfigInfo, String fileUrl, String objectName) throws Exception {
        String accessKeyId = obsConfigInfo.getAccessKeyId();
        String accessKeySecret = CryptoTean.decrypt((String)obsConfigInfo.getId().toString(), (String)obsConfigInfo.getAccessKeySecret());
        String endPoint = obsConfigInfo.getEndpoint();
        String obsBucketName = obsConfigInfo.getObsBucketName();
        BucketObjectOperation bucketObjectOperation = new BucketObjectOperation(endPoint, accessKeyId, accessKeySecret, obsBucketName);
        Integer uploadCode = bucketObjectOperation.uploadFileByFile(new File(fileUrl), objectName);
        return uploadCode;
    }

    @Override
    protected boolean _delete(Context ctx, IObjectValue obsConfigInfo, String objectName) throws BOSException, EASBizException {
        ObsConfigInfo obsConfigInfo2 = (ObsConfigInfo)obsConfigInfo;
        try {
            return this.reDelete(ctx, obsConfigInfo2, objectName);
        }
        catch (Exception e) {
            this.obsExceptionProcess(e);
            return false;
        }
    }

    private boolean reDelete(Context ctx, ObsConfigInfo obsConfigInfo, String objectName) throws Exception {
        String accessKeyId = obsConfigInfo.getAccessKeyId();
        String accessKeySecret = CryptoTean.decrypt((String)obsConfigInfo.getId().toString(), (String)obsConfigInfo.getAccessKeySecret());
        String endPoint = obsConfigInfo.getEndpoint();
        String obsBucketName = obsConfigInfo.getObsBucketName();
        BucketObjectOperation bucketObjectOperation = new BucketObjectOperation(endPoint, accessKeyId, accessKeySecret, obsBucketName);
        bucketObjectOperation.deleteObject(objectName);
        return true;
    }

    @Override
    protected byte[] _download(Context ctx, IObjectValue obsConfigInfo, String objectName) throws BOSException, EASBizException {
        ObsConfigInfo obsConfigInfo2 = (ObsConfigInfo)obsConfigInfo;
        try {
            return this.reDownload(ctx, obsConfigInfo2, objectName);
        }
        catch (Exception e) {
            logger.error((Object)"obs\u7b2c\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            try {
                logger.error((Object)"obs\u518d\u4e00\u6b21\u91cd\u65b0\u4e0b\u8f7d");
                return this.reDownload(ctx, obsConfigInfo2, objectName);
            }
            catch (Exception e1) {
                logger.error((Object)"obs\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25", (Throwable)e1);
                this.obsExceptionProcess(e1);
                return null;
            }
        }
    }

    private byte[] reDownload(Context ctx, ObsConfigInfo obsConfigInfo, String objectName) throws Exception {
        String accessKeyId = obsConfigInfo.getAccessKeyId();
        String accessKeySecret = CryptoTean.decrypt((String)obsConfigInfo.getId().toString(), (String)obsConfigInfo.getAccessKeySecret());
        String endPoint = obsConfigInfo.getEndpoint();
        String obsBucketName = obsConfigInfo.getObsBucketName();
        BucketObjectOperation bucketObjectOperation = new BucketObjectOperation(endPoint, accessKeyId, accessKeySecret, obsBucketName);
        byte[] fileInputStream = bucketObjectOperation.getFileInputStream(objectName);
        return fileInputStream;
    }

    private void obsExceptionProcess(Exception e) throws BOSException, EASBizException {
        com.obs.services.exception.ObsException e1 = null;
        if (e instanceof com.obs.services.exception.ObsException) {
            e1 = (com.obs.services.exception.ObsException)e;
            String obsErrorCode = e1.getErrorCode();
            if (obsErrorCode.indexOf("RequestTimeout") > -1 || obsErrorCode.indexOf("SSL peer shut down incorrectly") > -1) {
                throw new ObsException(ObsException.OBSREQUESTTIMEOUT);
            }
            if (obsErrorCode.indexOf("BadDomainName") > -1) {
                throw new ObsException(ObsException.OBSBASDOMAINNAME);
            }
            if (obsErrorCode.indexOf("IncompleteBody") > -1) {
                throw new ObsException(ObsException.OBSINCOMPLETEBODY);
            }
            if (obsErrorCode.indexOf("InvalidBucket") > -1) {
                throw new ObsException(ObsException.OBSINVALIDBUCKET);
            }
            if (obsErrorCode.indexOf("InvalidBucketName") > -1) {
                throw new ObsException(ObsException.OBSINVALIDBUCKETNAME);
            }
            if (obsErrorCode.indexOf("AccessDenied") > -1) {
                throw new ObsException(ObsException.OBSACCESSDENIED);
            }
            if (obsErrorCode.indexOf("AccessForbidden") > -1) {
                throw new ObsException(ObsException.OBSACCESSFORBIDDEN);
            }
            if (obsErrorCode.indexOf("AllAccessDisabled") > -1) {
                throw new ObsException(ObsException.OBSALLACCESSDISABLED);
            }
            if (obsErrorCode.indexOf("NoSuchBucket") > -1) {
                throw new ObsException(ObsException.OBSNOSUCHBUCKET);
            }
            if (obsErrorCode.indexOf("BucketAlreadyExists") > -1) {
                throw new ObsException(ObsException.OBSBUCKETALREADYEXISTS);
            }
            if (obsErrorCode.indexOf("InternalError") > -1) {
                throw new ObsException(ObsException.OBSINTERNALERROR);
            }
            if (obsErrorCode.indexOf("ServiceUnavailable") > -1) {
                throw new ObsException(ObsException.OBSSERVICEUNAVAILABLE);
            }
        }
        throw new BOSException((Throwable)e);
    }

    @Override
    protected boolean _createBucket(Context ctx, IObjectValue obsConfigInfo, String bucketName) throws BOSException {
        ObsConfigInfo obsConfigInfo2 = (ObsConfigInfo)obsConfigInfo;
        try {
            return this.reCreateBucket(ctx, obsConfigInfo2, bucketName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean reCreateBucket(Context ctx, ObsConfigInfo obsConfigInfo, String bucketName) throws IOException {
        String accessKeyId = obsConfigInfo.getAccessKeyId();
        String accessKeySecret = obsConfigInfo.getAccessKeySecret();
        String endPoint = obsConfigInfo.getEndpoint();
        String obsBucketName = obsConfigInfo.getObsBucketName();
        ObsBucketOperation obsBucketOperation = new ObsBucketOperation(endPoint, accessKeyId, accessKeySecret);
        obsBucketOperation.createBucket(obsBucketName);
        return true;
    }

    @Override
    protected boolean _removeBucket(Context ctx, IObjectValue obsConfigInfo, String bucketName) throws BOSException {
        ObsConfigInfo obsConfigInfo2 = (ObsConfigInfo)obsConfigInfo;
        try {
            return this.reRemoveBucket(ctx, obsConfigInfo2, bucketName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean reRemoveBucket(Context ctx, ObsConfigInfo obsConfigInfo, String bucketName) throws Exception {
        String accessKeyId = obsConfigInfo.getAccessKeyId();
        String accessKeySecret = CryptoTean.decrypt((String)obsConfigInfo.getId().toString(), (String)obsConfigInfo.getAccessKeySecret());
        String endPoint = obsConfigInfo.getEndpoint();
        String obsBucketName = obsConfigInfo.getObsBucketName();
        ObsBucketOperation obsBucketOperation = new ObsBucketOperation(endPoint, accessKeyId, accessKeySecret);
        obsBucketOperation.removeBucket(obsBucketName);
        return true;
    }

    @Override
    protected boolean _testConnection(Context ctx, IObjectValue obsConfigInfo) throws BOSException, EASBizException {
        try {
            ObsConfigInfo obsConfigInfo2 = (ObsConfigInfo)obsConfigInfo;
            String accessKeyId = obsConfigInfo2.getAccessKeyId();
            String accessKeySecret = obsConfigInfo2.getAccessKeySecret();
            String endPoint = obsConfigInfo2.getEndpoint();
            String obsBucketName = obsConfigInfo2.getObsBucketName();
            ObsBucketOperation obsBucketOperation = new ObsBucketOperation(endPoint, accessKeyId, accessKeySecret);
            return obsBucketOperation.bucketIsExists(obsBucketName);
        }
        catch (Exception e) {
            this.obsExceptionProcess(e);
            return false;
        }
    }
}

