/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentTypeEnum;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoCollection;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentDownloadClient;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.DataZipUtils;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;

public class VariousAttachmentInfoMaker {
    Logger logger = Logger.getLogger(VariousAttachmentInfoMaker.class.getName());

    private static ComplexAttachmentInfo convertAIToCAI(AttachmentInfo ai) throws BOSException {
        ComplexAttachmentInfo cai = new ComplexAttachmentInfo();
        if (ai.getNumber() != null) {
            cai.setCode(ai.getNumber());
        }
        try {
            byte[] fileInfo = ai.getFile();
            if (ai.getFile() != null) {
                if (ai.getSizeInByte() == fileInfo.length) {
                    cai.setContent(fileInfo);
                } else {
                    cai.setContent(DataZipUtils.unpack((byte[])fileInfo));
                }
            }
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        if (ai.getCreateTime() != null) {
            cai.setCreateTime(ai.getCreateTime().toString());
        }
        if (ai.getCreator() != null) {
            cai.setCreatorName(ai.getCreator().getName());
        }
        if (ai.getCU() != null) {
            cai.setCuName(ai.getCU().getName());
        }
        if (ai.getDescription() != null) {
            cai.setDescription(ai.getDescription());
        }
        if (ai.getSimpleName() != null) {
            cai.setExtName(ai.getSimpleName());
        }
        if (ai.getId() != null) {
            cai.setId(ai.getId().toString());
        }
        cai.setIsShared(ai.isIsShared());
        if (ai.getName() != null) {
            cai.setMainName(ai.getName());
        }
        if (ai.getSize() != null) {
            cai.setSizeDesc(ai.getSize());
        }
        cai.setSizeInByte(ai.getSizeInByte());
        if (ai.getType() != null) {
            cai.setTypeDesc(ai.getType());
        }
        if (ai.getLastUpdateTime() != null) {
            cai.setUpdateTime(ai.getLastUpdateTime().toString());
        }
        if (ai.getLastUpdateUser() != null) {
            cai.setUpdatorName(ai.getLastUpdateUser().getName());
        }
        return cai;
    }

    public static ComplexAttachmentInfo makeComplexAttachmentInfo(IAttachment ia, IAttachmentFtpFacade iAff, String attchID, ComplexAttachmentInfoSelector cais) throws BOSException, EASBizException {
        AttachmentInfo ai = (AttachmentInfo)ia.getValue((IObjectPK)new ObjectUuidPK(attchID), cais.getInnerSelector());
        if (ai != null && cais.isHasContent()) {
            AttachmentDownloadClient downLoadClient = new AttachmentDownloadClient(iAff);
            ai.setFile(downLoadClient.downLoad2tyte(ai.getId().toString()));
        }
        return VariousAttachmentInfoMaker.convertAIToCAI(ai);
    }

    public static ComplexAttachmentInfo makeComplexAttachmentInfo(IAttachment ia, IAttachmentFtpFacade iAff, String attchID) throws BOSException, EASBizException {
        ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
        cais.needAll();
        AttachmentInfo ai = (AttachmentInfo)ia.getValue((IObjectPK)new ObjectUuidPK(attchID), cais.getInnerSelector());
        if (ai != null) {
            AttachmentDownloadClient downLoadClient = new AttachmentDownloadClient(iAff);
            ai.setFile(downLoadClient.downLoad2tyte(ai.getId().toString()));
        }
        return VariousAttachmentInfoMaker.convertAIToCAI(ai);
    }

    public static AttachmentInfo makeAttachmentInfo(IAttachment ia, String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        AttachmentInfo ai = new AttachmentInfo();
        String mainname = sai.getMainName();
        String extname = sai.getExtName();
        String description = sai.getDescription();
        String code = sai.getCode();
        byte[] content = sai.getContent();
        boolean isShared = sai.getIsShared();
        if (extname.equals("url")) {
            StringUtil4File.checkURL(ia, boID, mainname);
        } else {
            StringUtil4File.checkFile(ia, boID, sai, content);
        }
        MutilLangeToolForParam.muti2Obj((String)mainname, (IObjectValue)ai, (String)"name");
        MutilLangeToolForParam.muti2Obj((String)description, (IObjectValue)ai, (String)"description");
        String tempValue = ai.isIsShared() ? EASResource.getString((String)"yes") : EASResource.getString((String)"no");
        MutilLangeToolForParam.muti2Obj((String)tempValue, (IObjectValue)ai, (String)"sharedDesc");
        ai.setNumber(code);
        ai.setFile(content);
        ai.setIsShared(isShared && !extname.equals("url"));
        ai.setSimpleName(extname);
        ai.setType(extname.equals("url") ? "URL" : StringUtil4File.getFileTypeDescription(extname));
        ai.setSize(StringUtil4File.getFileSizeRepresentation(content == null ? sai.getLength() : (long)content.length));
        ai.setSizeInByte((int)(content == null ? sai.getLength() : (long)content.length));
        ai.setShareRange(sai.getShareRange());
        SecureRandom random = new SecureRandom();
        ai.setAttachID(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) + random.nextInt(9999));
        ai.getBoAttchAsso().add(VariousAttachmentInfoMaker.makeBoAttchAssoInfo(boID));
        ai.setBeizhu(sai.getBeizhu());
        ai.setAttachType(sai.getAttachType());
        ai.setAttachTypeEnum(AttachmentTypeEnum.getEnum(sai.getAttachTypeEnum()));
        ai.setRemotePath(sai.getFileUrl());
        return ai;
    }

    public static AttachmentInfo makeAppAttachmentInfo(Context ctx, IAttachment ia, String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        AttachmentInfo ai = new AttachmentInfo();
        String mainname = sai.getMainName();
        String extname = sai.getExtName();
        String description = sai.getDescription();
        String code = sai.getCode();
        byte[] content = sai.getContent();
        boolean isShared = sai.getIsShared();
        if (extname.equals("url")) {
            StringUtil4File.checkURL(ia, boID, mainname);
        } else {
            StringUtil4File.checkFile(ctx, ia, boID, sai, content);
        }
        MutilLangeToolForParam.muti2Obj((String)mainname, (IObjectValue)ai, (String)"name", (Context)ctx);
        MutilLangeToolForParam.muti2Obj((String)description, (IObjectValue)ai, (String)"description", (Context)ctx);
        String tempValue = ai.isIsShared() ? EASCommonResource.getString((String)"yes", (Locale)ctx.getLocale()) : EASCommonResource.getString((String)"no", (Locale)ctx.getLocale());
        MutilLangeToolForParam.muti2Obj((String)tempValue, (IObjectValue)ai, (String)"sharedDesc", (Context)ctx);
        ai.setNumber(code);
        ai.setFile(content);
        ai.setIsShared(isShared && !extname.equals("url"));
        ai.setSimpleName(extname);
        ai.setType(extname.equals("url") ? "URL" : StringUtil4File.getFileTypeDescription(extname, ctx));
        ai.setSize(StringUtil4File.getFileSizeRepresentation(content.length, ctx));
        ai.setSizeInByte(content.length);
        ai.setShareRange(sai.getShareRange());
        ai.setAttachID(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        ai.getBoAttchAsso().add(VariousAttachmentInfoMaker.makeBoAttchAssoInfo(boID, ctx));
        ai.setBeizhu(sai.getBeizhu());
        ai.setAttachType(sai.getAttachType());
        ai.setAttachTypeEnum(AttachmentTypeEnum.getEnum(sai.getAttachTypeEnum()));
        ai.setRemotePath(sai.getFileUrl());
        return ai;
    }

    public static BoAttchAssoInfo makeBoAttchAssoInfo(String boID, Context ctx) {
        BoAttchAssoInfo baai = new BoAttchAssoInfo();
        baai.setBoID(boID);
        baai.setAssoType(Resrcs.getString("NewAttachment", ctx.getLocale()));
        baai.setAssoBusObjType(BOSUuid.read((String)boID).getType().toString());
        return baai;
    }

    public static BoAttchAssoInfo makeBoAttchAssoInfo(String boID) {
        BoAttchAssoInfo baai = new BoAttchAssoInfo();
        baai.setBoID(boID);
        baai.setAssoType(Resrcs.getString("NewAttachment"));
        baai.setAssoBusObjType(BOSUuid.read((String)boID).getType().toString());
        return baai;
    }

    public static ComplexAttachmentInfoCollection makeComplexAttachmentInfoCollection(IAttachment ia, String oql) throws BOSException {
        AttachmentCollection ac = ia.getAttachmentCollection(oql);
        ComplexAttachmentInfoCollection caic = new ComplexAttachmentInfoCollection();
        int size = ac.size();
        for (int i = 0; i < size; ++i) {
            caic.add(VariousAttachmentInfoMaker.convertAIToCAI(ac.get(i)));
        }
        return caic;
    }
}

