/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.common.BoteBaseUtils;
import com.kingdee.bos.bot.engine.core.BotObjectCacheLoader;
import com.kingdee.bos.bot.engine.core.BotStructEntityInfo;
import com.kingdee.bos.bot.engine.core.BotStructManager;
import com.kingdee.bos.bot.engine.core.BotStructPropertyInfo;
import com.kingdee.bos.bot.engine.core.IBotExtSetRuleProvider;
import com.kingdee.bos.bot.engine.sql.BotSqlBuilder;
import com.kingdee.bos.bot.engine.sql.BotSqlUtils;
import com.kingdee.bos.bot.engine.sql.MappingSegmentSetInfo;
import com.kingdee.bos.bot.engine.sql.TableCreateSqlManager;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.TypelessObjectCollection;
import com.kingdee.bos.dao.TypelessObjectValue;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BotObjectCreator {
    private static final Logger logger = Logger.getLogger(BotObjectCreator.class);
    private BOTRelationCollection botRelations = null;
    private IObjectCollection destObjCols = null;
    private EntityObjectInfo entity = null;
    private String tableName = "";
    private Connection conn = null;
    private BotSqlBuilder sqlBuilder = null;
    private BotStructManager entityStructManager = new BotStructManager();
    private Map groupEntitysMap = new HashMap();
    private Map groupRelationMap = new HashMap();
    private final Context ctx;
    private boolean isDAP = false;

    public BotObjectCreator(Connection conn, EntityObjectInfo entity, String tableName, BotSqlBuilder sqlBuilder, Context ctx) {
        this.conn = conn;
        this.entity = entity;
        this.tableName = tableName;
        this.sqlBuilder = sqlBuilder;
        this.ctx = ctx;
    }

    public IObjectCollection create() throws BOSException, EASBizException {
        this.isDAP = this.sqlBuilder.isDAP();
        String sql = "";
        try {
            this.destObjCols = Utils.newObjectCollectionInstance((EntityObjectInfo)this.entity);
            this.botRelations = new BOTRelationCollection();
            this.entityStructManager = this.sqlBuilder.analyzeDestFiledsEntityStruct(this.entity);
            if (this.entityStructManager == null) {
                return this.destObjCols;
            }
            this.entityStructManager.checkEntityFieldStruct();
            sql = "select * from " + this.tableName + " order by " + "bot_tmp_MappingID" + ", " + "bot_tmp_RuleID" + ", " + "bot_tmp_SrcID" + ", " + "bot_tmp_EntryID";
            ResultSet rs = BotSqlUtils.executeQuery(this.conn, sql);
            long rowCount = 0L;
            while (rs.next()) {
                ++rowCount;
                Map currValuesMap = this.getAllCurrentRowDatas(rs);
                if (this.isDAP) {
                    Object assGrpDataValue = this.createExtRefDestObject(currValuesMap);
                    String propertyName = "__dest.entries.assistRecords.assGrp";
                    if (assGrpDataValue != null) {
                        currValuesMap.put(propertyName, assGrpDataValue);
                    }
                }
                BotStructEntityInfo mainStructInfo = this.entityStructManager.getRootStructInfo();
                this.createDestObject(mainStructInfo, currValuesMap, null, null, 0);
            }
            if (rowCount <= 0L) {
                throw new BTPException(BTPException.DESTBILLCOLSIZEISZERO);
            }
        }
        catch (Exception e) {
            throw new BOSException("Build Dest Object Error!" + e.getMessage(), (Throwable)e);
        }
        return this.destObjCols;
    }

    private Map getAllCurrentRowDatas(ResultSet rs) throws BOSException, EASBizException, SQLException {
        HashMap<String, Object> currValuesMap = new HashMap<String, Object>();
        Map props = this.entityStructManager.getProperties();
        Iterator ite = props.values().iterator();
        boolean i = false;
        while (ite.hasNext()) {
            BotStructPropertyInfo propInfo = (BotStructPropertyInfo)ite.next();
            String propName = propInfo.getPropName();
            String fullPropName = propInfo.getFullPropName();
            String columnName = propInfo.getColumnName();
            String seqID = rs.getString("bot_FID");
            Object dataValue = null;
            if (this.sqlBuilder.isCachedResultValue(seqID, fullPropName)) {
                dataValue = this.sqlBuilder.getCachedResultValue(seqID, fullPropName);
            } else {
                int dataType = BotSqlUtils.getDataTypeByName(rs, columnName);
                dataValue = BotSqlUtils.getDataFromDr(dataType, rs, columnName);
            }
            currValuesMap.put(fullPropName, dataValue);
        }
        int dataType = 12;
        Object dataValue = BotSqlUtils.getDataFromDr(dataType, rs, "bot_FID");
        currValuesMap.put("bot_FID", dataValue);
        dataValue = BotSqlUtils.getDataFromDr(dataType, rs, "bot_tmp_SrcEntity");
        currValuesMap.put("bot_tmp_SrcEntity", dataValue);
        dataValue = BotSqlUtils.getDataFromDr(dataType, rs, "bot_tmp_MappingID");
        currValuesMap.put("bot_tmp_MappingID", dataValue);
        dataValue = BotSqlUtils.getDataFromDr(dataType, rs, "bot_tmp_RuleID");
        currValuesMap.put("bot_tmp_RuleID", dataValue);
        dataValue = BotSqlUtils.getDataFromDr(dataType, rs, "bot_tmp_SrcID");
        currValuesMap.put("bot_tmp_SrcID", dataValue);
        dataValue = BotSqlUtils.getDataFromDr(dataType, rs, "bot_tmp_EntryID");
        currValuesMap.put("bot_tmp_EntryID", dataValue);
        return currValuesMap;
    }

    private IObjectValue createDestObject(BotStructEntityInfo structInfo, Map currValuesMap, String parentIDPath, BOTRelationInfo ownerRelation, int level) throws BOSException, EASBizException, SQLException {
        String srcObjectID;
        String entityPath;
        String key;
        if (structInfo == null) {
            return null;
        }
        boolean isNew = true;
        IObjectValue billObject = null;
        BOTRelationInfo relaInfo = null;
        BOSUuid currObjID = null;
        String strGroupKey = "";
        String entityPK = structInfo.getEntity().getLogicalKey().getName();
        String entityFullPK = structInfo.getEntityPath() + "." + entityPK;
        Map groupProperties = structInfo.getGroupProperties();
        if (groupProperties.size() > 0) {
            StringBuffer buffGroupKey = new StringBuffer();
            Iterator ite = groupProperties.values().iterator();
            Object dataValue = null;
            while (ite.hasNext()) {
                String fullPropName = (String)ite.next();
                dataValue = entityFullPK.equalsIgnoreCase(fullPropName) ? BOSUuid.create((BOSObjectType)structInfo.getBOSType()) : currValuesMap.get(fullPropName);
                buffGroupKey.append("__" + String.valueOf(dataValue));
            }
            strGroupKey = buffGroupKey.toString();
        }
        if ((billObject = (IObjectValue)this.groupEntitysMap.get(key = (entityPath = structInfo.getEntityPath()) + "__" + parentIDPath + "__" + strGroupKey)) == null) {
            if (currObjID == null) {
                currObjID = BOSUuid.create((BOSObjectType)structInfo.getBOSType());
            }
            billObject = BotObjectCreator.newObjectValueInstance(structInfo.getEntity());
            billObject.put(billObject.getPKField(), (Object)currObjID);
            this.groupEntitysMap.put(key, billObject);
            if (level == 0) {
                this.destObjCols.addObject(billObject);
            }
        } else {
            currObjID = (BOSUuid)billObject.get(billObject.getPKField());
            isNew = false;
        }
        if (level == 0) {
            srcObjectID = (String)currValuesMap.get("bot_tmp_SrcID");
            String relationKey = level + "_" + srcObjectID + "_" + currObjID.toString();
            relaInfo = (BOTRelationInfo)this.groupRelationMap.get(relationKey);
            if (relaInfo == null) {
                relaInfo = new BOTRelationInfo();
                relaInfo.setId(BOSUuid.create((BOSObjectType)relaInfo.getBOSType()));
                relaInfo.setSrcObjectID(srcObjectID);
                relaInfo.setDestObjectID(currObjID.toString());
                relaInfo.setSrcEntityID((String)currValuesMap.get("bot_tmp_SrcEntity"));
                relaInfo.setDestEntityID(structInfo.getBOSType().toString());
                relaInfo.setType(0);
                relaInfo.setOperatorID(this.ctx.getUserName());
                relaInfo.setBOTMappingID((String)currValuesMap.get("bot_tmp_MappingID"));
                relaInfo.setDate(new Date());
                this.botRelations.add(relaInfo);
                this.groupRelationMap.put(relationKey, relaInfo);
            }
        } else if (level == 1) {
            srcObjectID = ownerRelation.getSrcObjectID();
            String destObjectID = ownerRelation.getDestObjectID();
            String srcEntryID = (String)currValuesMap.get("bot_tmp_EntryID");
            String relationKey = level + "_" + srcObjectID + "_" + destObjectID + "_" + srcEntryID + "_" + currObjID.toString();
            if (this.groupRelationMap.get(relationKey) == null) {
                BOTRelationEntryInfo entryRelaInfo = new BOTRelationEntryInfo();
                entryRelaInfo.setId(BOSUuid.create((BOSObjectType)entryRelaInfo.getBOSType()));
                entryRelaInfo.setSrcObjectID(ownerRelation.getSrcObjectID());
                entryRelaInfo.setSrcEntryID(srcEntryID);
                entryRelaInfo.setSrcPropertyName("");
                entryRelaInfo.setSrcEntryPropName("");
                entryRelaInfo.setDestObjectID(ownerRelation.getDestObjectID());
                entryRelaInfo.setDestEntryID(currObjID.toString());
                entryRelaInfo.setDestPropertyName("");
                entryRelaInfo.setDestEntryPropName("");
                ownerRelation.getRelationEntries().add(entryRelaInfo);
                this.groupRelationMap.put(relationKey, relaInfo);
            }
        }
        if (billObject == null) {
            return null;
        }
        Map props = structInfo.getProperties();
        for (BotStructPropertyInfo propInfo : props.values()) {
            String propName = propInfo.getPropName();
            String fullPropName = propInfo.getFullPropName();
            Object dataValue = currValuesMap.get(fullPropName);
            if (dataValue == null) continue;
            if (propInfo.getProperty() instanceof LinkPropertyInfo) {
                IObjectValue refObj = null;
                if (dataValue instanceof String) {
                    String objID = (String)dataValue;
                    if (StringUtils.isEmpty((String)objID)) continue;
                    LinkPropertyInfo lnkProp = (LinkPropertyInfo)propInfo.getProperty();
                    BOSObjectType objBosType = lnkProp.getRelationship().getSupplierObject().getType();
                    refObj = BotObjectCacheLoader.getInstance(this.ctx).get(objBosType, objID);
                    billObject.put(propName, (Object)refObj);
                    continue;
                }
                if (dataValue instanceof IObjectValue) {
                    refObj = (IObjectValue)dataValue;
                    billObject.put(propName, (Object)refObj);
                    continue;
                }
                billObject.put(propName, dataValue);
                continue;
            }
            if (!isNew && propInfo.isSumField()) {
                this.sumDestBillFieldValue(billObject, currValuesMap, propInfo);
                continue;
            }
            if (billObject.get(propName) != null) continue;
            billObject.put(propName, dataValue);
        }
        List children = structInfo.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            BotStructEntityInfo subStructInfo = (BotStructEntityInfo)children.get(i);
            String parentLinkName = subStructInfo.getParentLinkName();
            EntityObjectInfo bo = subStructInfo.getEntity();
            if (subStructInfo.isEntry()) {
                IObjectValue subObjectValue;
                IObjectCollection coll = (IObjectCollection)billObject.get(parentLinkName);
                if (coll == null) {
                    coll = Utils.newObjectCollectionInstance((EntityObjectInfo)bo);
                    billObject.put(parentLinkName, (Object)coll);
                }
                if ((subObjectValue = this.createDestObject(subStructInfo, currValuesMap, parentIDPath + "__" + currObjID.toString(), relaInfo, level + 1)) == null) continue;
                coll.addObject(subObjectValue);
                continue;
            }
            String propertyName = "__dest.entries.assistRecords.assGrp";
            Object assGrpDataValue = currValuesMap.get(propertyName);
            if (assGrpDataValue == null) continue;
            billObject.put("assGrp", assGrpDataValue);
        }
        return billObject;
    }

    private void sumDestBillFieldValue(IObjectValue billObject, Map currValuesMap, BotStructPropertyInfo propInfo) throws BOSException {
        String fullPropName = propInfo.getFullPropName();
        String propName = propInfo.getPropName();
        Object objNew = currValuesMap.get(fullPropName);
        if (objNew == null) {
            return;
        }
        Object objOld = billObject.get(propName);
        if (objOld == null && objNew != null) {
            billObject.put(propName, objNew);
            return;
        }
        int dataType = propInfo.getDataType();
        Object data = null;
        if (dataType == 1 || dataType == 12) {
            String sOld = (String)billObject.get(propName);
            String sNew = (String)currValuesMap.get(fullPropName);
            data = String.valueOf(sOld) + String.valueOf(sNew);
        } else if (dataType == 4) {
            Integer iOld = (Integer)billObject.get(propName);
            Integer iNew = (Integer)currValuesMap.get(fullPropName);
            int iOldValue = iOld;
            int iNewValue = iNew;
            data = new Integer(iNewValue + iOldValue);
        } else if (dataType == 3 || dataType == 2) {
            BigDecimal bdOld = (BigDecimal)billObject.get(propName);
            BigDecimal bdNew = (BigDecimal)currValuesMap.get(fullPropName);
            data = bdOld.add(bdNew);
        } else if (dataType == -5) {
            Long lOld = (Long)billObject.get(propName);
            Long lNew = (Long)currValuesMap.get(fullPropName);
            long lOldValue = lOld;
            long lNewValue = lNew;
            data = new Long(lNewValue + lOldValue);
        } else if (dataType == 6 || dataType == 8) {
            Double dOld = (Double)billObject.get(propName);
            Double dNew = (Double)currValuesMap.get(fullPropName);
            double dOldValue = dOld.longValue();
            double dNewValue = dNew.longValue();
            data = new Double(dNewValue + dOldValue);
        }
        if (data != null) {
            billObject.put(propName, data);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IBotExtSetRuleProvider getExtSetHandlerClassInstance() throws BOSException {
        String refClass = "com.kingdee.eas.base.dap.DAPAssistant";
        IBotExtSetRuleProvider handler = null;
        try {
            Class<?> clz = Class.forName(refClass);
            handler = (IBotExtSetRuleProvider)clz.newInstance();
            if (handler == null) return handler;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return handler;
    }

    private Object createExtRefDestObject(Map currValuesMap) throws BOSException, EASBizException, SQLException {
        IBotExtSetRuleProvider handler = this.getExtSetHandlerClassInstance();
        if (handler == null) {
            return null;
        }
        String destPropertyName = handler.getDestPropertyName();
        String refProperty = handler.getRefPropertys();
        HashMap refParams = new HashMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)refProperty)) {
            String realRefProperty = BoteBaseUtils.getRealDestFieldName(refProperty);
            Object refObject = currValuesMap.get(realRefProperty);
            refParams.put(refProperty, refObject);
        }
        Map extPropertys = this.sqlBuilder.getExtPropertys();
        TableCreateSqlManager tableCreateSqlManager = this.sqlBuilder.getTableCreateSqlManager();
        for (String propName : extPropertys.keySet()) {
            String fullPropName = BoteBaseUtils.getRealDestFieldName(destPropertyName + "." + propName);
            Object paramValue = currValuesMap.get(fullPropName);
            MappingSegmentSetInfo segmentSetInfo = tableCreateSqlManager.getSegmentByFieldName(destPropertyName + "." + propName);
            PropertyInfo prop = segmentSetInfo.getPropertyInfo();
            if (prop != null && prop instanceof LinkPropertyInfo && paramValue instanceof String && !StringUtils.isEmpty((String)((String)paramValue))) {
                String objID = (String)paramValue;
                IObjectValue refObj = BotObjectCacheLoader.getInstance(this.ctx).get(objID);
                params.put(propName, refObj);
                continue;
            }
            params.put(propName, paramValue);
        }
        IObjectValue value = handler.newInstance(this.ctx, refParams, params);
        return value;
    }

    public BOTRelationCollection getBotRelations() {
        return this.botRelations;
    }

    public IObjectCollection getDestObjCols() {
        return this.destObjCols;
    }

    public static IObjectCollection newObjectCollectionInstance(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        assert (bo != null);
        if (bo == null) {
            return new TypelessObjectCollection();
        }
        String className = bo.getObjectCollectionClassRuntime();
        if (StringUtils.isEmpty((String)className)) {
            return new TypelessObjectCollection();
        }
        try {
            return (IObjectCollection)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new InvalidDAOMetaDataException("create object by objectCollectionClass error. entity name:" + bo.getName() + "\n" + e.getMessage(), (Throwable)e);
        }
    }

    public static IObjectValue newObjectValueInstance(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        assert (bo != null);
        if (bo == null) {
            return new TypelessObjectValue();
        }
        String className = bo.getObjectValueClassRuntime();
        if (StringUtils.isEmpty((String)className)) {
            return new TypelessObjectValue();
        }
        try {
            if ("com.kingdee.eas.ep.CoreBillBaseCustomInfo".equals(className)) {
                Class<?> clazz = Class.forName(className);
                Method method = clazz.getDeclaredMethod("setBOSType", BOSObjectType.class);
                IObjectValue info = (IObjectValue)clazz.newInstance();
                method.invoke((Object)info, bo.getType());
                return info;
            }
            return (IObjectValue)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new InvalidDAOMetaDataException("create object by objectValueClass error. entity name:" + bo.getName() + "\n" + e.getMessage(), (Throwable)e);
        }
    }
}

