/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.provider.BotFuncParamCollection;
import com.kingdee.bos.bot.engine.provider.IBotSQLFunctions;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.eas.util.EASCommonResource;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class BotKSqlFunctions
implements IBotSQLFunctions {
    private static String RES = "com.kingdee.eas.base.botp.BotpFunctionResx";
    private Locale locale = null;
    private Vector funcInfos = new Vector();
    public final String CATEGORY_MATH;
    public final String CATEGORY_DATE;
    public final String CATEGORY_STRING;
    public final String CATEGORY_OTHER;
    public static final String FUNC_ABS = "ABS";
    public static final String FUNC_CEILING = "CEILING";
    public static final String FUNC_COS = "COS";
    public static final String FUNC_EXP = "EXP";
    public static final String FUNC_FLOOR = "FLOOR";
    public static final String FUNC_LOG = "LOG";
    public static final String FUNC_PI = "PI";
    public static final String FUNC_SIGN = "SIN";
    public static final String FUNC_LOG10 = "LOG10";
    public static final String FUNC_SIN = "SIN";
    public static final String FUNC_SQRT = "SQRT";
    public static final String FUNC_TAN = "TAN";
    public static final String FUNC_ROUND = "ROUND";
    public static final String FUNC_MOD = "MOD";
    public static final String FUNC_NULLIF = "NULLIF";
    public static final String FUNC_ISNULL = "ISNULL";
    public static final String FUNC_ASCII = "ASCII";
    public static final String FUNC_CHAR = "CHAR";
    public static final String FUNC_LCASE = "LCASE";
    public static final String FUNC_LEFT = "LEFT";
    public static final String FUNC_LENGTH = "LENGTH";
    public static final String FUNC_LTRIM = "LTRIM";
    public static final String FUNC_RIGHT = "RIGHT";
    public static final String FUNC_RTRIM = "RTRIM";
    public static final String FUNC_UCASE = "UCASE";
    public static final String FUNC_SUBSTRING = "SUBSTRING";
    public static final String FUNC_CONCAT = "CONCAT";
    public static final String FUNC_REPLACE = "REPLACE";
    public static final String FUNC_CURDATE = "CURDATE";
    public static final String FUNC_CURTIME = "CURTIME";
    public static final String FUNC_DAYOFMONTH = "DAYOFMONTH";
    public static final String FUNC_DAYOFWEEK = "DAYOFWEEK";
    public static final String FUNC_DAYOFYEAR = "DAYOFYEAR";
    public static final String FUNC_HOUR = "HOUR";
    public static final String FUNC_MINUTE = "MINUTE";
    public static final String FUNC_MONTH = "MONTH";
    public static final String FUNC_NOW = "NOW";
    public static final String FUNC_QUARTER = "QUARTER";
    public static final String FUNC_SECOND = "SECOND";
    public static final String FUNC_WEEK = "WEEK";
    public static final String FUNC_YEAR = "YEAR";
    public static final String FUNC_DAYNAME = "DAYNAME";
    public static final String FUNC_MONTHNAME = "MONTHNAME";
    public static final String FUNC_CONVERT = "CONVERT";
    public static final String FUNC_DATEADD = "DATEADD";
    public static final String FUNC_DATEDIFF = "DATEDIFF";

    public BotKSqlFunctions(Locale locale) {
        this.locale = locale;
        this.CATEGORY_MATH = EASCommonResource.getString((String)RES, (String)"BOT_CATEGORY_BASEFUNC_MATH", (Locale)this.getLocal());
        this.CATEGORY_DATE = EASCommonResource.getString((String)RES, (String)"BOT_CATEGORY_BASEFUNC_DATE", (Locale)this.getLocal());
        this.CATEGORY_STRING = EASCommonResource.getString((String)RES, (String)"BOT_CATEGORY_BASEFUNC_STRING", (Locale)this.getLocal());
        this.CATEGORY_OTHER = EASCommonResource.getString((String)RES, (String)"BOT_CATEGORY_BASEFUNC_OTHER", (Locale)this.getLocal());
        this.initFunc();
    }

    public void initFunc() {
        this.addNewFunction(FUNC_ABS, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_CEILING, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_COS, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_EXP, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_FLOOR, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_LOG, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_PI, this.CATEGORY_MATH);
        this.addNewFunction("SIN", this.CATEGORY_MATH);
        this.addNewFunction(FUNC_LOG10, this.CATEGORY_MATH);
        this.addNewFunction("SIN", this.CATEGORY_MATH);
        this.addNewFunction(FUNC_SQRT, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_TAN, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_ROUND, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_MOD, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_NULLIF, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_ISNULL, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_ASCII, this.CATEGORY_MATH);
        this.addNewFunction(FUNC_CHAR, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_LCASE, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_LEFT, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_LENGTH, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_LTRIM, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_RIGHT, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_RTRIM, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_UCASE, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_SUBSTRING, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_CONCAT, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_REPLACE, this.CATEGORY_STRING);
        this.addNewFunction(FUNC_CURDATE, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_CURTIME, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_DAYOFMONTH, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_DAYOFWEEK, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_DAYOFYEAR, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_HOUR, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_MONTH, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_YEAR, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_NOW, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_QUARTER, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_SECOND, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_WEEK, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_YEAR, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_DAYNAME, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_MONTHNAME, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_CONVERT, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_DATEADD, this.CATEGORY_DATE);
        this.addNewFunction(FUNC_DATEDIFF, this.CATEGORY_DATE);
    }

    private void addNewFunction(String name, String category) {
        this.funcInfos.add(new FuncInfo(name, category, EASCommonResource.getString((String)RES, (String)name, (Locale)this.getLocal())));
    }

    private Locale getLocal() {
        if (this.locale == null) {
            this.locale = new Locale("l2");
        }
        return this.locale;
    }

    public String[] getAllFuncNames() {
        String[] funcNames = new String[this.funcInfos.size()];
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            funcNames[i] = ((FuncInfo)this.funcInfos.get((int)i)).funcName;
        }
        return funcNames;
    }

    public String getFuncCategory(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).funcCategory;
        }
        return null;
    }

    public String getFuncDesc(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).funcDesc;
        }
        return null;
    }

    public boolean existFunction(String funcName) {
        if (funcName == null) {
            return false;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            FuncInfo funcInfo = (FuncInfo)this.funcInfos.get(i);
            String tempName = funcInfo.funcName;
            if (!funcName.equalsIgnoreCase(tempName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean evalSQLFunction(Context ctx, String funcName, BotFuncParamCollection params) throws BOSException {
        return false;
    }

    public Object evalFunction(String funcName, List paramList) throws KScriptException {
        return null;
    }

    class FuncInfo {
        String funcName;
        String funcCategory;
        String funcDesc;

        public FuncInfo(String name, String category) {
            this.funcName = name;
            this.funcCategory = category;
            this.funcDesc = EASCommonResource.getString((String)RES, (String)name, (Locale)BotKSqlFunctions.this.getLocal());
        }

        public FuncInfo(String name, String category, String desc) {
            this.funcName = name;
            this.funcCategory = category;
            this.funcDesc = desc;
        }

        public FuncInfo() {
        }

        public void setFuncName(String name) {
            this.funcName = name;
        }

        public void setFuncDesc(String desc) {
            this.funcDesc = desc;
        }

        public void setFuncCatetory(String category) {
            this.funcCategory = category;
        }
    }
}

