/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.sql.BotSqlUtils;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.common.EASBizException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBException;

public class BotTempTableManager {
    private Context ctx = null;
    private List tempTableNameList = new ArrayList();
    protected BotSqlUtils util = null;

    public BotTempTableManager(Context ctx) {
        this.ctx = ctx;
        this.util = new BotSqlUtils(ctx);
    }

    public String createNewTempTable(String createTableSQL) throws BOSException, EASBizException {
        String tableName = "";
        try {
            tableName = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSQL);
            this.tempTableNameList.add(tableName);
        }
        catch (Exception e) {
            tableName = "";
            throw new BOSException("Create TempTable Faild!   sql=" + createTableSQL, (Throwable)e);
        }
        return tableName;
    }

    public void releaseTempTable(String tableName) throws BOSException, EASBizException {
        try {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tableName);
            this.tempTableNameList.remove(tableName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void executeSQL(String sql) throws Exception {
        Method method = BotSqlUtils.class.getMethod("executeSQL", String.class);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)this.util);
        try {
            txInvoker.invoke(method, new Object[]{sql}, 4);
        }
        catch (UndeclaredThrowableException e) {
            throw new Exception(e.getUndeclaredThrowable());
        }
        catch (BOSException e) {
            if (e.getCause() instanceof EJBException && ((EJBException)e.getCause()).getCausedByException() instanceof UndeclaredThrowableException) {
                EJBException ejbException = (EJBException)e.getCause();
                UndeclaredThrowableException unDeclareEx = (UndeclaredThrowableException)ejbException.getCausedByException();
                throw new Exception(unDeclareEx.getUndeclaredThrowable());
            }
            throw new Exception(e.getCause());
        }
        catch (Throwable e) {
            throw new Exception(e.getCause());
        }
    }

    public void executeBatch(List sqlList) throws Exception {
        Method method = BotSqlUtils.class.getMethod("executeBatch", List.class);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)this.util);
        try {
            txInvoker.invoke(method, new Object[]{sqlList}, 4);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public void executeBatch(String sql, List paramList) throws Exception {
        Method method = BotSqlUtils.class.getMethod("executeBatch", String.class, List.class);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)this.util);
        try {
            txInvoker.invoke(method, new Object[]{sql, paramList}, 4);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }
}

