/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bot.engine.common.BoteBaseUtils;
import com.kingdee.bos.bot.engine.sql.SQLSrcTableManager;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BoteWhereExprManager {
    private static final int WHERE_ID_NUMBER_MAX = 1000;
    private String[] entryNames = null;
    private String[] srcObjectIDList = null;
    private String[] srcEntryIDList = null;
    private EntityObjectInfo srcEntity = null;
    private SQLSrcTableManager srcTableManager = null;
    private List whereList = new ArrayList();

    public BoteWhereExprManager(EntityObjectInfo srcEntity, String[] srcObjectIDList, String[] entryNames, String[] srcEntryIDList, SQLSrcTableManager srcTableManager) {
        this.srcEntity = srcEntity;
        this.entryNames = entryNames;
        this.srcEntryIDList = srcEntryIDList;
        this.srcObjectIDList = srcObjectIDList;
        this.srcTableManager = srcTableManager;
    }

    public void init(Map dataFilterMap) throws BOSException {
        try {
            String tableName = this.srcEntity.getTable().getName();
            String tableAlias = this.srcTableManager.getMainTableAlias();
            StringBuffer entrysPath = new StringBuffer();
            entrysPath.append("__src");
            if (this.entryNames != null && this.entryNames.length > 0 && this.srcEntryIDList != null && this.srcEntryIDList.length > 0) {
                String entryName = this.entryNames[0];
                entrysPath.append(".").append(entryName);
                PropertyInfo prop = (PropertyInfo)this.srcEntity.getInheritedNoDuplicatedPropertiesRuntime().getObject((Object)entryName);
                LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
                RelationshipInfo relation = linkProp.getRelationship();
                EntityObjectInfo subEntity = relation.getSupplierObject();
                String entryTableName = subEntity.getTable().getName();
                String entryTableAlias = this.srcTableManager.getEntryTableAlias(entrysPath.toString());
                this.generateWhereList(this.srcEntryIDList, entryTableAlias, dataFilterMap);
            } else {
                this.generateWhereList(this.srcObjectIDList, tableAlias, dataFilterMap);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void generateWhereList(String[] idList, String tableAlias, Map dataFilterMap) {
        if (idList == null || idList.length <= 0) {
            return;
        }
        int[] arrayArea = BoteBaseUtils.getArrayAreaByStep(idList.length, 1000);
        int idx = 0;
        int count = 0;
        for (int k = 0; k < arrayArea.length; ++k) {
            StringBuffer sb = new StringBuffer();
            sb.append(" WHERE ");
            sb.append(tableAlias + ".fid in (");
            count = arrayArea[k];
            for (int i = 0; idx < idList.length && i < count; ++idx, ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("'" + idList[idx] + "'");
            }
            sb.append(")");
            if (dataFilterMap != null && dataFilterMap.size() > 0) {
                Iterator ite = dataFilterMap.values().iterator();
                while (ite.hasNext()) {
                    String dataFilter = ite.next().toString();
                    sb.append(" and ");
                    sb.append(dataFilter);
                }
            }
            this.whereList.add(sb.toString());
        }
    }

    public int size() {
        return this.whereList.size();
    }

    public String getWhereExpr(int index) {
        return (String)this.whereList.get(index);
    }
}

