/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bot.engine.sql.BotSqlNameMappingHelper;
import com.kingdee.bos.bot.engine.sql.FieldNameMappingManager;
import com.kingdee.bos.bot.engine.sql.MappingSegmentSetInfo;
import com.kingdee.bos.kscript.dom.expr.ArrayIndexerExpr;
import com.kingdee.bos.kscript.dom.expr.BigDecimalExpr;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.expr.UnaryExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TableCreateSqlManager {
    public static final String BOTE_TEMPTABLE_NAME = "BOTE_TEMPTABLE_NAME";
    protected EntityObjectInfo srcEntity = null;
    protected EntityObjectInfo destEntity = null;
    private FieldNameMappingManager fieldNameMappingManager = null;
    private Map fieldSqlMap = new HashMap();
    private Map fieldColumnMap = new HashMap();
    private Map columnFieldMap = new HashMap();
    private Map allDestFieldMap = new HashMap();
    private String strBuildTableSql = null;

    private void addNewTableField(String entityFieldName, String columnName, String sql) throws EASBizException, BOSException {
        this.fieldSqlMap.put(entityFieldName, sql);
        this.fieldColumnMap.put(entityFieldName, columnName);
        this.columnFieldMap.put(columnName, entityFieldName);
    }

    public void addField(String destPropertyName, MappingSegmentSetInfo segmentSetInfo) throws EASBizException, BOSException {
        this.innerBuildFieldSqlBySegment(destPropertyName, segmentSetInfo);
        this.allDestFieldMap.put(destPropertyName, segmentSetInfo);
    }

    public MappingSegmentSetInfo getSegmentByFieldName(String destPropertyName) {
        return (MappingSegmentSetInfo)this.allDestFieldMap.get(destPropertyName);
    }

    private void innerBuildFieldSqlBySegment(String destPropertyName, MappingSegmentSetInfo segmentSetInfo) throws EASBizException, BOSException {
        int mappingType;
        String fieldCreateSql = null;
        StringBuffer sb = new StringBuffer();
        BOTMappingInfo mappingInfo = segmentSetInfo.getMappingInfo();
        this.srcEntity = mappingInfo.getSrcEntity();
        if (!this.fieldSqlMap.containsKey(destPropertyName)) {
            String destColumnName = this.fieldNameMappingManager.getTableFieldNameByEntityFieldName(destPropertyName);
            String destColumnDataType = BotSqlNameMappingHelper.getDataTypeStrByFieldName(this.srcEntity, this.destEntity, destPropertyName);
            sb.append(destColumnName + " " + destColumnDataType);
            fieldCreateSql = sb.toString();
            this.addNewTableField(destPropertyName, destColumnName, fieldCreateSql);
        }
        if ((mappingType = segmentSetInfo.getMappingType().getType()) != 0 && mappingType != 1 && mappingType != 3) {
            String srcExpression = segmentSetInfo.getSrcExpression();
            this.processTempTableFieldSql(srcExpression);
        }
    }

    public void processTempTableFieldSql(String expression) throws EASBizException, BOSException {
        KScriptParser parser = new KScriptParser(expression);
        parser.parse();
        List stmtList = parser.stmtList;
        if (stmtList != null && stmtList.size() > 0) {
            if (stmtList.size() > 1) {
                for (int j = 0; j < stmtList.size(); ++j) {
                    CodeStmt stmt = (CodeStmt)stmtList.get(j);
                    ArrayList identCollection = new ArrayList();
                    BotUtil.computeIdent(stmt, identCollection);
                    for (int i = 0; i < identCollection.size(); ++i) {
                        String srcPropertyName = (String)identCollection.get(i);
                        if (!srcPropertyName.startsWith("__src") || this.fieldSqlMap.containsKey(srcPropertyName)) continue;
                        String fieldCreateSql = "";
                        StringBuffer sb = new StringBuffer();
                        String destColumnName = this.fieldNameMappingManager.getTableFieldNameByEntityFieldName(srcPropertyName);
                        String destColumnDataType = BotSqlNameMappingHelper.getDataTypeStrByFieldName(this.srcEntity, this.destEntity, srcPropertyName);
                        sb.append(destColumnName + " " + destColumnDataType);
                        fieldCreateSql = sb.toString();
                        this.addNewTableField(srcPropertyName, destColumnName, fieldCreateSql);
                    }
                }
            } else {
                CodeStmt stmt = (CodeStmt)stmtList.get(0);
                if (stmt instanceof ExprStmt) {
                    CodeExpr expr = ((ExprStmt)stmt).expr;
                    this.iteraterProcessTempTableFieldSql(expr);
                }
            }
        }
    }

    private void iteraterProcessTempTableFieldSql(CodeExpr expr) throws EASBizException, BOSException {
        if (expr == null) {
            return;
        }
        if (!(expr instanceof BigDecimalExpr || expr instanceof StringExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr || expr instanceof IdentifierExpr)) {
            if (expr instanceof PropertyExpr) {
                String srcPropertyName = ((PropertyExpr)expr).toString();
                if (!this.fieldSqlMap.containsKey(srcPropertyName)) {
                    String fieldCreateSql = "";
                    StringBuffer sb = new StringBuffer();
                    String destColumnName = this.fieldNameMappingManager.getTableFieldNameByEntityFieldName(srcPropertyName);
                    String destColumnDataType = BotSqlNameMappingHelper.getDataTypeStrByFieldName(this.srcEntity, this.destEntity, srcPropertyName);
                    sb.append(destColumnName + " " + destColumnDataType);
                    fieldCreateSql = sb.toString();
                    this.addNewTableField(srcPropertyName, destColumnName, fieldCreateSql);
                }
            } else if (expr instanceof BinaryOpExpr) {
                BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
                this.iteraterProcessTempTableFieldSql(binaryOpExpr.left);
                this.iteraterProcessTempTableFieldSql(binaryOpExpr.right);
            } else if (expr instanceof ArrayIndexerExpr) {
                ArrayIndexerExpr arrayIndexerExpr = (ArrayIndexerExpr)expr;
                this.iteraterProcessTempTableFieldSql(arrayIndexerExpr.targetObjExpr);
                this.iteraterProcessTempTableFieldSql(arrayIndexerExpr.indexExpr);
            } else if (expr instanceof UnaryExpr) {
                UnaryExpr unaryExpr = (UnaryExpr)expr;
                this.iteraterProcessTempTableFieldSql(unaryExpr.expr);
            } else if (expr instanceof MethodInvokeExpr) {
                String methodName = ((MethodInvokeExpr)expr).methodName;
                MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
                List paramList = methodInvokeExpr.paramList;
                for (int i = 0; i < paramList.size(); ++i) {
                    CodeExpr paramExpr = (CodeExpr)paramList.get(i);
                    this.iteraterProcessTempTableFieldSql(paramExpr);
                }
            }
        }
    }

    public String getCreateSql() throws EASBizException, BOSException {
        if (this.strBuildTableSql == null) {
            this.strBuildTableSql = this.innerGetCreateSql();
        }
        return this.strBuildTableSql;
    }

    private String innerGetCreateSql() throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE BOTE_TEMPTABLE_NAME(");
        this.innerAddConstFieldSql(sb);
        for (String destColumnName : this.fieldSqlMap.keySet()) {
            String strFieldSql = (String)this.fieldSqlMap.get(destColumnName);
            sb.append("," + strFieldSql);
        }
        sb.append(" ) ");
        return sb.toString();
    }

    private void innerAddConstFieldSql(StringBuffer sb) {
        sb.append("bot_FID VARCHAR(44) NOT NULL, ");
        sb.append("bot_tmp_SrcEntity VARCHAR(8), ");
        sb.append("bot_tmp_MappingID VARCHAR(44), ");
        sb.append("bot_tmp_RuleID VARCHAR(44), ");
        sb.append("bot_tmp_SrcID VARCHAR(44), ");
        sb.append("bot_tmp_EntryID VARCHAR(44) ");
    }

    public void setSrcEntity(EntityObjectInfo srcEntity) {
        this.srcEntity = srcEntity;
    }

    public void setDestEntity(EntityObjectInfo destEntity) {
        this.destEntity = destEntity;
    }

    public void setFieldNameMappingManager(FieldNameMappingManager fieldNameMappingManager) {
        this.fieldNameMappingManager = fieldNameMappingManager;
    }

    public void clear() {
        this.fieldSqlMap.clear();
        this.fieldColumnMap.clear();
        this.columnFieldMap.clear();
    }

    public String getSqlByField(String fieldName) {
        return (String)this.fieldSqlMap.get(fieldName);
    }

    public String getColumnByField(String fieldName) {
        if (fieldName.startsWith("__dest.")) {
            fieldName = fieldName.substring("__dest".length() + 1);
        }
        return (String)this.fieldColumnMap.get(fieldName);
    }

    public String getFieldByColumn(String columnName) {
        return (String)this.columnFieldMap.get(columnName);
    }

    public List getAllSrcFields() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator ite = this.fieldColumnMap.keySet().iterator();
        while (ite != null && ite.hasNext()) {
            String key = (String)ite.next();
            if (key == null || !key.startsWith("__src")) continue;
            list.add(key);
        }
        return list;
    }
}

