/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.bot.BOTDelRevRuleFactory;
import com.kingdee.bos.metadata.bot.BOTDelRevRuleInfo;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRevRuleFactory;
import com.kingdee.bos.metadata.bot.BOTRevRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTDelRevRule;
import com.kingdee.bos.metadata.bot.IBOTRevRule;
import com.kingdee.bos.metadata.bot.ObjectValueUtil;
import com.kingdee.bos.metadata.bot.app.AbstractBOTMappingControllerBean;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.bot.app.BOTRuleFilterTools;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotLogUtil;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.CoreBillBaseController;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOTMappingControllerBean
extends AbstractBOTMappingControllerBean {
    private static Logger logger = Logger.getLogger(BOTMappingControllerBean.class);
    private static final String ENACTMENTSERVICENAME = "com.kingdee.bos.workflow.service.ormrpc.EnactmentService";
    private static final String ARGU_NAME = "mappingId";
    private static final String FUNC_FULLNAME = "com.kingdee.eas.base.dap.DAPTransformerAuto";
    private static final String JOB_NAME = "botp";
    private static final Integer ALIAS_LENGTH = new Integer(80);
    private static final Integer ENALIAS_LENGTH = new Integer(255);
    private static final Integer NUMBER_LENGTH = new Integer(80);
    private static final String MANUAL_DEFAULT_LOGITEM = "manual_default_logitem";
    private static final String UPDATE = "Update";
    private static final String ADDNEW = "AddNew";
    private static final String IMPORT = "Import";
    private static final String DELETE = "Delete";
    private static final String ENABLE = "Enable";
    private static final String DISABLE = "Disable";
    private static final String RESXNAME = "com.kingdee.bos.metadata.bot.app.BOTResx";
    private static final String NAME = "name";
    private static final String ALIAS = "alias";

    @Override
    protected String _getTargetBillTypeList(Context ctx, String sourceBillType) throws BOSException, BOTPException {
        ArrayList list = BOTMappingHelper.getTargetBillTypeList(ctx, sourceBillType);
        ArrayList<String> aliasList = new ArrayList<String>();
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            try {
                String targetBillDisplayName = this.getEntityObjectInfoDisplayName(ctx, (String)list.get(i));
                if (targetBillDisplayName == null || targetBillDisplayName.length() < 1) {
                    targetBillDisplayName = "Has No Alias";
                }
                aliasList.add(targetBillDisplayName);
                continue;
            }
            catch (MetaDataNotFoundException e) {
                list.remove(i);
                --i;
                --count;
            }
        }
        StringBuffer destTypeAndAlias = new StringBuffer();
        destTypeAndAlias.append(BOTMappingHelper.listToString(list));
        destTypeAndAlias.append("|");
        destTypeAndAlias.append(BOTMappingHelper.listToString(aliasList));
        return destTypeAndAlias.toString();
    }

    private String getEntityObjectInfoDisplayName(Context ctx, String BOSTypeString) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo tempObj = loader.getEntity(BOSObjectType.create((String)BOSTypeString));
        return tempObj.getAlias();
    }

    @Override
    protected String _getSourceBillTypeListAndAlias(Context ctx, String destBillBosType) throws BOSException, BOTPException {
        ArrayList list = BOTMappingHelper.getSourceBillTypeList(ctx, destBillBosType);
        ArrayList<String> aliasList = new ArrayList<String>();
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            try {
                String srcBillDisplayName = this.getEntityObjectInfoDisplayName(ctx, (String)list.get(i));
                if (srcBillDisplayName == null || srcBillDisplayName.length() < 1) {
                    srcBillDisplayName = "Has No Alias";
                }
                aliasList.add(srcBillDisplayName);
                continue;
            }
            catch (MetaDataNotFoundException e) {
                list.remove(i);
                --i;
                --count;
            }
        }
        StringBuffer srcTypeAndAlias = new StringBuffer();
        srcTypeAndAlias.append(BOTMappingHelper.listToString(list));
        srcTypeAndAlias.append("|");
        srcTypeAndAlias.append(BOTMappingHelper.listToString(aliasList));
        return srcTypeAndAlias.toString();
    }

    @Override
    protected String _getSourceBillTypeList(Context ctx, String targetBillType) throws BOSException, BOTPException {
        ArrayList list = BOTMappingHelper.getSourceBillTypeList(ctx, targetBillType);
        return BOTMappingHelper.listToString(list);
    }

    @Override
    protected IObjectValue _getMapping(Context ctx, IObjectValue sourceBill, String targetBillType) throws BOSException, BOTPException {
        return this._getMapping(ctx, sourceBill, targetBillType, null);
    }

    @Override
    protected IObjectValue _getMapping(Context ctx, IObjectValue sourceBill, String targetBillType, DefineSysEnum defineSys) throws BOSException, BOTPException {
        return BOTMappingHelper.getMapping(ctx, sourceBill, targetBillType, defineSys);
    }

    @Override
    protected String _getGroupingProperties(Context ctx, IObjectValue mappingInfo) throws BOSException, BOTPException {
        ArrayList list = BOTMappingHelper.getGroupingProperties(ctx, (BOTMappingInfo)mappingInfo);
        return BOTMappingHelper.listToString(list);
    }

    @Override
    protected String _getRelationProperties(Context ctx, IObjectValue mappingInfo) throws BOSException, BOTPException {
        ArrayList list = BOTMappingHelper.getRelationProperties(ctx, (BOTMappingInfo)mappingInfo);
        return BOTMappingHelper.listToString(list);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo mappingInfo = (BOTMappingInfo)model;
            appLogId = this.writeAppLog(ctx, appLog, pk, mappingInfo, ADDNEW);
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
        ObjectValueUtil.checkPropertyBlank(model, NAME, ResourceBase.getString((String)RESXNAME, (String)NAME, (Locale)ctx.getLocale()));
        ObjectValueUtil.checkPropertyDup(ctx, model, NAME, ResourceBase.getString((String)RESXNAME, (String)NAME, (Locale)ctx.getLocale()));
        ObjectValueUtil.checkMPropertyBlank(ctx, model, ALIAS, ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()));
        ObjectValueUtil.checkMPropertyDup(ctx, model, ALIAS, ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()));
        ((BOTMappingInfo)model).setId(BOSUuid.read((String)pk.toString()));
        super._addnew(ctx, pk, model);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BOSUuid uuid = BOSUuid.create((BOSObjectType)model.getBOSType());
        ObjectUuidPK retPk = new ObjectUuidPK(uuid);
        ((BOTMappingInfo)model).setId(uuid);
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo mappingInfo = (BOTMappingInfo)model;
            appLogId = this.writeAppLog(ctx, appLog, (IObjectPK)retPk, mappingInfo, ADDNEW);
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
        BOTMappingControllerBean.checkPropertyLength(ctx, model);
        ObjectValueUtil.checkPropertyBlank(model, NAME, ResourceBase.getString((String)RESXNAME, (String)NAME, (Locale)ctx.getLocale()));
        ObjectValueUtil.checkPropertyDup(ctx, model, NAME, ResourceBase.getString((String)RESXNAME, (String)NAME, (Locale)ctx.getLocale()));
        ObjectValueUtil.checkMPropertyBlank(ctx, model, ALIAS, ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()));
        ObjectValueUtil.checkMPropertyDup(ctx, model, ALIAS, ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()));
        super._addnew(ctx, (IObjectPK)retPk, model);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
        return retPk;
    }

    public static void checkPropertyLength(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Locale[] locale = new Locale[]{LocaleUtils.locale_zh_CN, LocaleUtils.locale_zh_TW};
        for (int i = 0; i < locale.length; ++i) {
            String propertyValue = ((BOTMappingInfo)model).getAlias(locale[i]);
            if (propertyValue == null || propertyValue.length() <= ALIAS_LENGTH) continue;
            throw new EASBizException(EASBizException.CHECKTEXTLENGTH2, new Object[]{ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()), ALIAS_LENGTH});
        }
        String propertyValue = ((BOTMappingInfo)model).getAlias(LocaleUtils.locale_en_US);
        if (propertyValue != null && propertyValue.length() > ENALIAS_LENGTH) {
            throw new EASBizException(EASBizException.CHECKTEXTLENGTH2, new Object[]{ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()), ENALIAS_LENGTH});
        }
        String number = ((BOTMappingInfo)model).getName();
        if (number != null && number.length() > NUMBER_LENGTH) {
            throw new EASBizException(EASBizException.CHECKTEXTLENGTH2, new Object[]{ResourceBase.getString((String)RESXNAME, (String)NAME, (Locale)ctx.getLocale()), NUMBER_LENGTH});
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        BOTMappingInfo oldMappingInfo = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo mappingInfo = (BOTMappingInfo)model;
            oldMappingInfo = BOTMappingFactory.getLocalInstance(ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(((BOTMappingInfo)model).getId()));
            appLogId = this.writeAppLog(ctx, appLog, pk, mappingInfo, UPDATE, oldMappingInfo.getName());
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
        ObjectValueUtil.checkPropertyBlank(model, NAME, ResourceBase.getString((String)RESXNAME, (String)NAME, (Locale)ctx.getLocale()));
        ObjectValueUtil.checkPropertyDup(ctx, model, NAME, ResourceBase.getString((String)RESXNAME, (String)NAME, (Locale)ctx.getLocale()));
        BOTMappingInfo botMappingInfo = (BOTMappingInfo)model;
        if (botMappingInfo.getExtRule() != null && botMappingInfo.getExtRule().isIsEffected()) {
            ObjectValueUtil.checkMPropertyBlank(ctx, model, ALIAS, ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()));
            ObjectValueUtil.checkMPropertyDup(ctx, model, ALIAS, ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()));
        }
        BOTMappingControllerBean.checkPropertyLength(ctx, model);
        String sqlToObtainLock = "UPDATE T_BOT_MAPPING SET FALIAS_L1 = FALIAS_L1 WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sqlToObtainLock, (Object[])new Object[]{((BOTMappingInfo)model).getId().toString()});
        super._update(ctx, pk, model);
        MappingCache.getInstance(ctx).clear(pk.toString(), ctx);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
    }

    private void storeSchedule(Context ctx, BOTMappingInfo mappingInfo, boolean isNew) throws BOSException {
    }

    private IEnactmentService getEnactmentService(Context ctx) throws BOSException {
        return (IEnactmentService)BOSObjectFactory.createBOSObject((Context)ctx, (String)ENACTMENTSERVICENAME);
    }

    private void disableSchedule(Context ctx, BOTMappingInfo mappingInfo) throws BOSException {
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo mappingInfo = (BOTMappingInfo)this.getValue(ctx, pk);
            appLogId = this.writeAppLog(ctx, appLog, pk, mappingInfo, DELETE);
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
        String sqlToDisenableMapping = "select FisEffected from T_BOT_EXTMAPPING e inner join T_BOT_MAPPING m on m.FExtMappingID = e.fID where e.FisEffected = 1 and m.fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlToDisenableMapping, (Object[])new Object[]{String.valueOf(pk)});
        if (rs != null && rs.size() > 0) {
            throw new BOTPException(BOTPException.MAPPINGDELERROR);
        }
        super._delete(ctx, pk);
        MappingCache.getInstance(ctx).clear(pk.toString(), ctx);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
    }

    @Override
    protected IObjectValue _getMapping(Context ctx, IObjectCollection sourceBillCollection, String targetBillType) throws BOSException, BOTPException {
        return this._getMapping(ctx, sourceBillCollection, targetBillType, null);
    }

    @Override
    protected IObjectValue _getMapping(Context ctx, IObjectCollection sourceBillCollection, String targetBillType, DefineSysEnum defineSys) throws BOSException, BOTPException {
        return BOTMappingHelper.getMapping(ctx, sourceBillCollection, targetBillType, defineSys);
    }

    @Override
    protected ArrayList _getMatchProperties(Context ctx, String mappingId) throws BOSException, BOTPException, EASBizException {
        BOTMappingInfo mappingInfo = (BOTMappingInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)mappingId)));
        return BOTMappingHelper.getMatchProperties(ctx, mappingInfo);
    }

    @Override
    protected ArrayList _getGroupingProperties(Context ctx, String mappingId) throws BOSException, BOTPException, EASBizException {
        BOTMappingInfo mappingInfo = (BOTMappingInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)mappingId)));
        return BOTMappingHelper.getGroupingProperties(ctx, mappingInfo);
    }

    @Override
    protected ArrayList _getRelationProperties(Context ctx, String mappingId) throws BOSException, BOTPException, EASBizException {
        BOTMappingInfo mappingInfo = (BOTMappingInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)mappingId)));
        return BOTMappingHelper.getRelationProperties(ctx, mappingInfo);
    }

    @Override
    protected void _enableMapping(Context ctx, String mappingId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)mappingId));
        BOTMappingInfo mappingInfo = (BOTMappingInfo)this._getValue(ctx, (IObjectPK)pk);
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            appLogId = this.writeAppLog(ctx, appLog, (IObjectPK)pk, mappingInfo, ENABLE);
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
        String destBosType = mappingInfo.getDestEntityName();
        EntityObjectInfo bo = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)BOSObjectType.create((String)destBosType));
        this.checkMustInput(ctx, mappingInfo, bo, null, "");
        if (mappingInfo.getExtRule() != null && !mappingInfo.getExtRule().isIsEffected()) {
            String sqlToEnableMapping = "UPDATE T_BOT_EXTMAPPING SET FisEffected = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sqlToEnableMapping, (Object[])new Object[]{true, mappingInfo.getExtRule().getId().toString()});
            MappingCache.getInstance(ctx).clear(pk.toString(), ctx);
            CacheServiceFactory.getInstance().discardType(new BOTMappingInfo().getBOSType());
        }
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
    }

    @Override
    protected void _enableMapping(Context ctx, String currOrgID, List mappingIdList) throws BOSException, EASBizException {
        int i;
        IObjectPK appLogId;
        BOTMappingCollection mappings = BOTMappingHelper.getBOTMappingCollection(ctx, mappingIdList);
        this.preCheckOrgPermMappingRule(ctx, currOrgID, mappings, true);
        List newMappingIdList = this.preCheckEnableMappingRule(ctx, mappings);
        Iterator iterator = mappings.iterator();
        BOTMappingCollection mappings2 = new BOTMappingCollection();
        while (iterator.hasNext()) {
            BOTMappingInfo mappingInfo = (BOTMappingInfo)iterator.next();
            if (mappingInfo.getExtRule().isIsEffected()) continue;
            mappings2.add(mappingInfo);
        }
        mappings = mappings2;
        IAppLog appLog = null;
        ArrayList<IObjectPK> appLogIdList = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            appLogIdList = new ArrayList<IObjectPK>();
            for (int i2 = 0; i2 < mappings.size(); ++i2) {
                BOTMappingInfo mappingInfo = mappings.get(i2);
                appLogId = this.writeAppLog(ctx, appLog, (IObjectPK)new ObjectUuidPK(mappingInfo.getId()), mappingInfo, ENABLE);
                appLogIdList.add(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
        if (newMappingIdList == null || newMappingIdList.size() <= 0) {
            return;
        }
        StringBuffer sqlToEnableMapping = new StringBuffer();
        sqlToEnableMapping.append("UPDATE T_BOT_EXTMAPPING SET FisEffected = ? WHERE FID in (select FExtMappingID from T_BOT_MAPPING where FID in (");
        for (i = 0; i < newMappingIdList.size(); ++i) {
            if (i > 0) {
                sqlToEnableMapping.append(",");
            }
            sqlToEnableMapping.append("'" + newMappingIdList.get(i) + "'");
        }
        sqlToEnableMapping.append("))");
        DbUtil.execute((Context)ctx, (String)sqlToEnableMapping.toString(), (Object[])new Object[]{true});
        MappingCache.getInstance(ctx).clear(mappingIdList, ctx);
        CacheServiceFactory.getInstance().discardType(new BOTMappingInfo().getBOSType());
        try {
            for (i = 0; i < appLogIdList.size(); ++i) {
                appLogId = (IObjectPK)appLogIdList.get(i);
                if (appLogId == null) continue;
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
    }

    private List preCheckEnableMappingRule(Context ctx, BOTMappingCollection mappings) throws BOSException, EASBizException {
        ArrayList<BOSUuid> newMappingIdList = new ArrayList<BOSUuid>();
        if (mappings == null || mappings.size() <= 0) {
            return newMappingIdList;
        }
        ArrayList deletedMappingIDList = new ArrayList();
        Iterator ite = mappings.iterator();
        while (ite.hasNext()) {
            BOTMappingInfo mappingInfo = (BOTMappingInfo)ite.next();
            if (mappingInfo.getExtRule().isIsEffected()) continue;
            newMappingIdList.add(mappingInfo.getId());
            String destBosType = mappingInfo.getDestEntityName();
            EntityObjectInfo bo = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)BOSObjectType.create((String)destBosType));
            this.checkMustInput(ctx, mappingInfo, bo, null, "");
        }
        return newMappingIdList;
    }

    private void preCheckOrgPermMappingRule(Context ctx, String currOrgID, BOTMappingCollection mappings, boolean isEnableAction) throws BOSException, EASBizException {
        if (mappings == null || mappings.size() <= 0 || currOrgID == null) {
            return;
        }
        Iterator ite = mappings.iterator();
        while (ite.hasNext()) {
            BOTMappingInfo mappingInfo = (BOTMappingInfo)ite.next();
            String name = mappingInfo.getName();
            String mappingCU = mappingInfo.getCU().getId().toString();
            if (!(isEnableAction && !mappingInfo.getExtRule().isIsEffected() ? !mappingCU.equals(currOrgID) : !isEnableAction && mappingInfo.getExtRule().isIsEffected() && !mappingCU.equals(currOrgID))) continue;
            throw new BTPException(BTPException.NOMAPPINGORGPERM, new Object[]{name});
        }
    }

    private void checkMustInput(Context ctx, BOTMappingInfo mappingInfo, EntityObjectInfo bo, String parentFld, String currentEntryName) throws BOSException, EASBizException {
        int entryTimes = 0;
        PropertyCollection flds = bo.getInheritedPropertiesRuntime();
        int n = flds.size();
        for (int j = 0; j < n; ++j) {
            RelationshipInfo relation;
            String currFldName;
            PropertyInfo fld = flds.get(j);
            String string = currFldName = parentFld != null ? parentFld + "." + fld.getName() : fld.getName();
            if (fld instanceof LinkPropertyInfo && RelationshipType.COMPOSITION.equals((Object)(relation = ((LinkPropertyInfo)fld).getRelationship()).getType()) && !CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo)) && CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo))) {
                currentEntryName = fld.getName();
                if (relation.getChildProperty(bo) != null && entryTimes < 2) {
                    EntityObjectInfo childbo = relation.getChildObject(bo);
                    this.checkMustInput(ctx, mappingInfo, childbo, currFldName, currentEntryName);
                    ++entryTimes;
                }
            }
            if (!Boolean.TRUE.toString().equalsIgnoreCase(fld.getExtendedProperty("isForMapping")) || !Boolean.TRUE.toString().equalsIgnoreCase(fld.getExtendedProperty("isBOTPMustInput"))) continue;
            this.checkBOTPFieldInput(ctx, bo, fld, mappingInfo, currFldName, currentEntryName);
        }
    }

    private void checkBOTPFieldInput(Context ctx, EntityObjectInfo bo, PropertyInfo fld, BOTMappingInfo mappingInfo, String fullFldName, String entryName) throws BOSException, EASBizException {
        String fldName = bo.getAlias() + "." + fld.getAlias();
        String ruleName = mappingInfo.getName();
        BOTRuleCollection rules = mappingInfo.getRules();
        boolean isEntryProperty = true;
        if (fullFldName != null && fullFldName.split("[.]").length > 1) {
            entryName = fullFldName.split("[.]")[0];
        } else {
            isEntryProperty = false;
        }
        for (int i = 0; i < rules.size(); ++i) {
            boolean bCheck = false;
            BOTRuleInfo info = rules.get(i);
            if (isEntryProperty && !entryName.equals(info.getDestDetailEntryName())) continue;
            BOTRuleSegmentCollection segments = info.getRuleSegments();
            for (int j = 0; j < segments.size(); ++j) {
                BOTRuleSegmentInfo segInfo = segments.get(j);
                String destName = segInfo.getDestPropertyName();
                if (!destName.equalsIgnoreCase(fullFldName)) continue;
                bCheck = true;
                break;
            }
            if (bCheck) continue;
            throw new BOTPException(BOTPException.MUSTINPUTERROR, new Object[]{ruleName, fldName});
        }
    }

    @Override
    protected void _disableMapping(Context ctx, String mappingId) throws BOSException, EASBizException {
        IObjectPK appLogId = null;
        IAppLog appLog = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(mappingId);
            BOTMappingInfo mappingInfo = (BOTMappingInfo)this.getValue(ctx, (IObjectPK)pk);
            appLogId = this.writeAppLog(ctx, appLog, (IObjectPK)pk, mappingInfo, DISABLE);
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
        String sqlToDisenableMapping = "UPDATE T_BOT_EXTMAPPING SET FisEffected = ? WHERE FID in (select FExtMappingID from T_BOT_MAPPING where FID = ? )";
        DbUtil.execute((Context)ctx, (String)sqlToDisenableMapping, (Object[])new Object[]{false, mappingId});
        MappingCache.getInstance(ctx).clear(mappingId, ctx);
        CacheServiceFactory.getInstance().discardType(new BOTMappingInfo().getBOSType());
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
    }

    @Override
    protected void _disableMapping(Context ctx, String currOrgID, List mappingIdList) throws BOSException, EASBizException {
        int i;
        IObjectPK appLogId;
        if (mappingIdList == null || mappingIdList.size() <= 0) {
            return;
        }
        BOTMappingCollection mappings = BOTMappingHelper.getBOTMappingCollection(ctx, mappingIdList);
        this.preCheckOrgPermMappingRule(ctx, currOrgID, mappings, false);
        Iterator iterator = mappings.iterator();
        BOTMappingCollection mappings2 = new BOTMappingCollection();
        while (iterator.hasNext()) {
            BOTMappingInfo mappingInfo = (BOTMappingInfo)iterator.next();
            if (!mappingInfo.getExtRule().isIsEffected()) continue;
            mappings2.add(mappingInfo);
        }
        mappings = mappings2;
        ArrayList<IObjectPK> appLogIdList = null;
        IAppLog appLog = null;
        try {
            appLogIdList = new ArrayList<IObjectPK>();
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            for (int i2 = 0; i2 < mappings.size(); ++i2) {
                BOTMappingInfo mappingInfo = mappings.get(i2);
                appLogId = this.writeAppLog(ctx, appLog, (IObjectPK)new ObjectUuidPK(mappingInfo.getId()), mappingInfo, DISABLE);
                appLogIdList.add(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
        StringBuffer sqlToDisenableMapping = new StringBuffer();
        sqlToDisenableMapping.append("UPDATE T_BOT_EXTMAPPING SET FisEffected = ? WHERE FID in (select FExtMappingID from T_BOT_MAPPING where FID in (");
        for (i = 0; i < mappingIdList.size(); ++i) {
            if (i > 0) {
                sqlToDisenableMapping.append(",");
            }
            sqlToDisenableMapping.append("'" + mappingIdList.get(i) + "'");
        }
        sqlToDisenableMapping.append("))");
        DbUtil.execute((Context)ctx, (String)sqlToDisenableMapping.toString(), (Object[])new Object[]{false});
        MappingCache.getInstance(ctx).clear(mappingIdList, ctx);
        CacheServiceFactory.getInstance().discardType(new BOTMappingInfo().getBOSType());
        try {
            for (i = 0; i < appLogIdList.size(); ++i) {
                appLogId = (IObjectPK)appLogIdList.get(i);
                if (appLogId == null) continue;
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
    }

    @Override
    protected IObjectCollection _getMappingCollectionForSelect(Context ctx, IObjectCollection srcBillCollection, String targetType, DefineSysEnum defineSys) throws BOSException, BOTPException {
        return BOTMappingHelper.getMappingForSelectNew(ctx, srcBillCollection, targetType, defineSys);
    }

    @Override
    protected IObjectCollection _getMappingCollectionForSelect(Context ctx, IObjectCollection srcBillCollection, String targetType, DefineSysEnum defineSys, CtrlUnitInfo transmitCU) throws BOSException, BOTPException {
        return BOTMappingHelper.getMappingForSelectNew(ctx, srcBillCollection, targetType, defineSys, transmitCU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectValue _getMappingInfoByPK(Context ctx, IObjectPK botMappingPK) throws BOSException {
        Connection conn = null;
        BOTMappingInfo mappingInfo = null;
        if (botMappingPK != null) {
            try {
                conn = this.getConnection(ctx);
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new BOTMappingControllerBean().getBOSType(), (Context)ctx, (Connection)conn);
                mappingInfo = (BOTMappingInfo)dao.getValue(botMappingPK);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return mappingInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getGroupingProperties(Context ctx, IObjectPK botMappingPK) throws BOSException, BOTPException {
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new BOTMappingControllerBean().getBOSType(), (Context)ctx, (Connection)conn);
            BOTMappingInfo mappingInfo = (BOTMappingInfo)dao.getValue(botMappingPK);
            String string = this._getGroupingProperties(ctx, (IObjectValue)mappingInfo);
            return string;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected IObjectCollection _getMappingCollectionForSelectWithoutData(Context ctx, String srcBosType, String destBosType, Map transmitCtx) throws BOTPException, BOSException {
        return BOTMappingHelper.getMappingForSelect(ctx, srcBosType, destBosType, transmitCtx);
    }

    @Override
    protected boolean _checkBotMappingsHasSameGrpAndAggregate(Context ctx, List botMappingPkCols) throws BOSException {
        boolean result = true;
        boolean isFirst = true;
        ArrayList<String> grpPropertiesList = new ArrayList<String>();
        ArrayList<String> aggregatePropertiesList = new ArrayList<String>();
        ArrayList<String> nextGrpProperties = new ArrayList<String>();
        ArrayList<String> nextAggregateProperties = new ArrayList<String>();
        String sqlToGetGrpProperties = "SELECT distinct G.FGROUPINGPROPERTY GRPPROP FROM T_BOT_GROUPING G JOIN T_BOT_RULE R ON G.FRULEID = R.FID WHERE R.FMAPPINGID = ?";
        String sqlToGetAggreProperties = "SELECT distinct FDESTPROPERTYNAME AGGREGATEPROP FROM T_BOT_BOTAGGREGATEINFO WHERE FMAPPINGID=?";
        Iterator pkIter = botMappingPkCols.iterator();
        while (pkIter.hasNext()) {
            String botMappingId = pkIter.next().toString();
            IRowSet rsToGetGrpProperties = DbUtil.executeQuery((Context)ctx, (String)sqlToGetGrpProperties, (Object[])new Object[]{botMappingId});
            if (isFirst) {
                try {
                    while (rsToGetGrpProperties.next()) {
                        grpPropertiesList.add(rsToGetGrpProperties.getString("GRPPROP"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            nextGrpProperties.clear();
            try {
                while (rsToGetGrpProperties.next()) {
                    nextGrpProperties.add(rsToGetGrpProperties.getString("GRPPROP"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (nextGrpProperties.size() != grpPropertiesList.size() || !nextGrpProperties.containsAll(grpPropertiesList)) {
                result = false;
                break;
            }
            IRowSet rsToGetAggreProperties = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAggreProperties, (Object[])new Object[]{botMappingId});
            if (isFirst) {
                try {
                    while (rsToGetAggreProperties.next()) {
                        aggregatePropertiesList.add(rsToGetAggreProperties.getString("AGGREGATEPROP"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                isFirst = false;
                continue;
            }
            nextAggregateProperties.clear();
            try {
                while (rsToGetAggreProperties.next()) {
                    nextAggregateProperties.add(rsToGetAggreProperties.getString("AGGREGATEPROP"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (nextAggregateProperties.size() + nextAggregateProperties.size() == 0 || nextAggregateProperties.size() == aggregatePropertiesList.size() && nextAggregateProperties.containsAll(aggregatePropertiesList)) continue;
            result = false;
            break;
        }
        return result;
    }

    private CoreBillBaseCollection getSrcBillCollection(Context ctx, BOTMappingInfo botMappingInfo, EntityViewInfo evi) throws BOSException {
        CoreBillBaseCollection srcBillCols = new CoreBillBaseCollection();
        IDynamicObject iDyn = DynamicObjectFactory.getLocalInstance((Context)ctx);
        BOSObjectType bosObjectType = botMappingInfo.getSrcEntity().getBOSType();
        IObjectCollection dynCols = evi == null ? iDyn.getCollection(bosObjectType) : iDyn.getCollection(bosObjectType, evi);
        for (CoreBillBaseInfo billInfo : dynCols) {
            srcBillCols.add(billInfo);
        }
        return srcBillCols;
    }

    @Override
    protected String _getBotLogInfo(Context ctx, String botMappingId) throws BOSException {
        try {
            return BotLogUtil.getBotLog(ctx, botMappingId);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BOTMappingInfo botMappingInfo = (BOTMappingInfo)super._getValue(ctx, pk);
        if (botMappingInfo.getRevRule() != null && botMappingInfo.getRevRule().getId() != null && botMappingInfo.getRevRule().getId().toString().length() > 0) {
            IBOTRevRule iBotRevRule = BOTRevRuleFactory.getLocalInstance(ctx);
            BOTRevRuleInfo botRevRuleInfo = iBotRevRule.getValue((IObjectPK)new ObjectUuidPK(botMappingInfo.getRevRule().getId()));
            botMappingInfo.setRevRule(botRevRuleInfo);
        }
        if (botMappingInfo.getDelRevRule() != null && botMappingInfo.getDelRevRule().getId() != null && botMappingInfo.getDelRevRule().getId().toString().length() > 0) {
            IBOTDelRevRule iBotDelRevRule = BOTDelRevRuleFactory.getLocalInstance(ctx);
            BOTDelRevRuleInfo botDelRevRuleInfo = iBotDelRevRule.getValue((IObjectPK)new ObjectUuidPK(botMappingInfo.getDelRevRule().getId()));
            botMappingInfo.setDelRevRule(botDelRevRuleInfo);
        }
        return botMappingInfo;
    }

    @Override
    protected IObjectCollection _getMappingCollectionForSelect(Context ctx, IObjectCollection srcBillCols, String targetBosType, DefineSysEnum defineSys, Map transmitContext) throws BOSException, BOTPException {
        return BOTMappingHelper.getMappingForSelect(ctx, srcBillCols, targetBosType, defineSys, transmitContext);
    }

    @Override
    protected IObjectValue _getValueNoChild(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return (BOTMappingInfo)this.innerGetValueNoChild(ctx, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue innerGetValueNoChild(Context ctx, IObjectPK botMappingPK) throws BOSException, EASBizException {
        Connection conn = null;
        BOTMappingInfo mappingInfo = null;
        if (botMappingPK != null) {
            try {
                conn = this.getConnection(ctx);
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new BOTMappingControllerBean().getBOSType(), (Context)ctx, (Connection)conn);
                mappingInfo = (BOTMappingInfo)dao.getValueNoChild(botMappingPK);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return mappingInfo;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sqlToGetName = "SELECT TOP 1 FNAME FROM T_BOT_MAPPING WHERE FID = ?";
        IRowSet rsToGetName = DbUtil.executeQuery((Context)ctx, (String)sqlToGetName, (Object[])new Object[]{pk.toString()});
        try {
            if (rsToGetName.next()) {
                return rsToGetName.getString("FNAME");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return super._getLogInfo(ctx, pk);
    }

    @Override
    protected void _enableMapping(Context ctx, IObjectPK mappingId) throws BOSException, EASBizException {
        this._enableMapping(ctx, mappingId.toString());
    }

    @Override
    protected void _disableMapping(Context ctx, IObjectPK mappingId) throws BOSException, EASBizException {
        this._disableMapping(ctx, mappingId.toString());
    }

    @Override
    protected void _enableOrDisableMapping(Context ctx, IObjectPK botMappingPK) throws BOSException, EASBizException {
        String sqlToGetEffectedStatus = "SELECT TOP 1 EXT.FISEFFECTED FROM T_BOT_MAPPING M JOIN T_BOT_EXTMAPPING EXT ON EXT.FID = M.FEXTMAPPINGID AND M.FID = ?";
        IRowSet rsToGetEffectedStatus = DbUtil.executeQuery((Context)ctx, (String)sqlToGetEffectedStatus, (Object[])new Object[]{botMappingPK.toString()});
        try {
            if (rsToGetEffectedStatus != null && rsToGetEffectedStatus.next()) {
                boolean isEffected = rsToGetEffectedStatus.getBoolean("FISEFFECTED");
                if (isEffected) {
                    this._disableMapping(ctx, botMappingPK);
                } else {
                    this._enableMapping(ctx, botMappingPK);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected List _getBillPropertiesCannotModify(Context ctx, IObjectPK botMappingPK) throws BOSException, EASBizException {
        List propertiesList = null;
        if (botMappingPK != null) {
            BOTMappingInfo botInfo = this.getBOTMappingInfo(ctx, botMappingPK);
            propertiesList = botInfo.getBillPropertiesCannotModify();
        }
        return propertiesList;
    }

    @Override
    protected IObjectCollection _getMappingCollectionForSelect(Context ctx, String srcBillType, String targetType, DefineSysEnum defineSys) throws BOSException, BOTPException {
        return BOTMappingHelper.getMappingForSelect(ctx, srcBillType, targetType, defineSys, null);
    }

    @Override
    protected IObjectCollection _getMappingCollectionForSelect(Context ctx, String srcBillType, String targetBosType, DefineSysEnum defineSys, Map transmitContext) throws BOSException, BOTPException {
        return BOTMappingHelper.getMappingForSelect(ctx, srcBillType, targetBosType, defineSys, transmitContext);
    }

    protected IObjectCollection _getDAPMappingsForSelectUseRuleFilter(Context ctx, String srcBillType, String targetBosType, DefineSysEnum defineSys, Map transmitContext, String[] idList) throws BOSException, BOTPException {
        BOTMappingInfo info;
        BOTMappingCollection botMappingCols = BOTMappingHelper.getMappingForSelect(ctx, srcBillType, targetBosType, defineSys, transmitContext);
        if (botMappingCols.size() == 0) {
            return botMappingCols;
        }
        CoreBillBaseCollection bills = new CoreBillBaseCollection();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer();
        String strIdLists = BOTMappingHelper.objectArray2String(idList, ",");
        sbMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        filterInfo.setMaskString(sbMaskString.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
        try {
            bills = controller.getCoreBillBaseCollection(ctx, entityViewInfo);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        BOTMappingCollection errMappingCols = new BOTMappingCollection();
        for (int i = 0; i < botMappingCols.size(); ++i) {
            info = botMappingCols.get(i);
            if (!this.isErrorMapping(ctx, bills, info)) continue;
            errMappingCols.add(info);
        }
        for (int j = 0; j < errMappingCols.size(); ++j) {
            info = errMappingCols.get(j);
            botMappingCols.removeObject((IObjectValue)info);
        }
        return botMappingCols;
    }

    protected boolean isErrorMapping(Context ctx, CoreBillBaseCollection sourceBillCollection, BOTMappingInfo mappingInfo) throws BOSException {
        Map result = this.getRuleFilter((IObjectCollection)sourceBillCollection, mappingInfo);
        if (result.isEmpty()) {
            return false;
        }
        CoreBillBaseInfo info = sourceBillCollection.get(0);
        BOSObjectType bostype = info.getBOSType();
        EntityViewInfo evi = (EntityViewInfo)result.get("EntityViewInfo");
        CoreBillBaseCollection filteredCols = this.getSrcBillCollection(ctx, bostype.toString(), evi);
        return this.isErrorMapping((IObjectCollection)sourceBillCollection, (IObjectCollection)filteredCols, result);
    }

    protected boolean isErrorMapping(IObjectCollection sourceBillCollection, IObjectCollection filteredColsTMP, Map result) {
        if (result.isEmpty()) {
            return false;
        }
        boolean hasEntryFilter = (Boolean)result.get("hasEntryFilter");
        EntityViewInfo evi = (EntityViewInfo)result.get("EntityViewInfo");
        ArrayList<CoreBillBaseInfo> errorBillCollection = new ArrayList<CoreBillBaseInfo>();
        IObjectCollection filteredCols = filteredColsTMP;
        ArrayList<String> filteredIdList = new ArrayList<String>();
        int count = filteredCols.size();
        for (int i = 0; i < count; ++i) {
            IObjectValue filteredInfo = filteredCols.getObject(i);
            boolean flag = true;
            if (hasEntryFilter) {
                int es = evi.getEntryFilters().size();
                for (int e = 0; e < es; ++e) {
                    FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                    String entryName = entryFilterInfo.getEntryName();
                    if (filteredInfo.get(entryName) != null && filteredInfo.get(entryName) instanceof IObjectCollection && ((IObjectCollection)filteredInfo.get(entryName)).size() > 0) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                filteredIdList.add(filteredInfo.get("id").toString());
                continue;
            }
            filteredIdList.add(filteredInfo.get("id").toString());
        }
        HashMap pkListMap = new HashMap();
        for (int i = 0; i < filteredIdList.size(); ++i) {
            pkListMap.put(filteredIdList.get(i), null);
        }
        for (CoreBillBaseInfo sourceBillInfo : sourceBillCollection) {
            if (pkListMap.containsKey(sourceBillInfo.getId().toString())) continue;
            errorBillCollection.add(sourceBillInfo);
        }
        return errorBillCollection.size() > 0;
    }

    protected CoreBillBaseCollection getSrcBillCollection(Context ctx, String srcBillType, EntityViewInfo evi) throws BOSException {
        CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        try {
            sourceBillCollection = controller.getCoreBillBaseCollection(ctx, evi);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return sourceBillCollection;
    }

    private Map getRuleFilter(IObjectCollection sourceBillCollection, BOTMappingInfo mappingInfo) throws BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean hasEntryFilter = false;
        EntityViewInfo evi = this.getBOTMappingFilter(mappingInfo);
        evi.getSelector().add("id");
        FilterInfo filterInfo = evi.getFilter();
        if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
            int count = evi.getEntryFilters().size();
            for (int i = 0; i < count; ++i) {
                FilterInfo entryFilter = evi.getEntryFilters().get(i);
                String entryName = entryFilter.getEntryName();
                evi.getSelector().add(entryName + ".id");
            }
        }
        if (!(filterInfo != null && filterInfo.getFilterItems().size() != 0 || evi.getEntryFilters() != null && evi.getEntryFilters().size() != 0)) {
            return new HashMap();
        }
        ArrayList<Object> billIdList = new ArrayList<Object>();
        int count = sourceBillCollection.size();
        for (int i = 0; i < count; ++i) {
            billIdList.add(sourceBillCollection.getObject(i).get("id"));
        }
        FilterInfo newHeadFilterInfo = this.mergeFilterWithIdList(billIdList, filterInfo);
        if (filterInfo == null) {
            filterInfo = newHeadFilterInfo;
            evi.setFilter(newHeadFilterInfo);
        }
        if (hasEntryFilter) {
            int es = evi.getEntryFilters().size();
            for (int e = 0; e < es; ++e) {
                FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                String entryName = entryFilterInfo.getEntryName();
                ArrayList<Object> entryIdList = new ArrayList<Object>();
                int count2 = sourceBillCollection.size();
                for (int i = 0; i < count2; ++i) {
                    IObjectValue srcBillInfo = sourceBillCollection.getObject(i);
                    if (srcBillInfo.get(entryName) == null || !(srcBillInfo.get(entryName) instanceof IObjectCollection)) continue;
                    IObjectCollection entryCols = (IObjectCollection)srcBillInfo.get(entryName);
                    int entryCount = entryCols.size();
                    for (int j = 0; j < entryCount; ++j) {
                        entryIdList.add(entryCols.getObject(j).get("id"));
                    }
                }
                this.mergeFilterWithIdList(entryIdList, entryFilterInfo);
            }
        }
        result.put("hasEntryFilter", new Boolean(hasEntryFilter));
        result.put("EntityViewInfo", (Boolean)evi);
        return result;
    }

    private EntityViewInfo getBOTMappingFilter(BOTMappingInfo mappingInfo) throws BOSException {
        EntityViewInfo entityViewInfo;
        if (StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter())) {
            entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            entityViewInfo.setFilter(filterInfo);
        } else {
            try {
                entityViewInfo = BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 0);
            }
            catch (BOSException exc) {
                throw new BOSException(exc.getMessage(), (Throwable)exc);
            }
        }
        return entityViewInfo;
    }

    private FilterInfo mergeFilterWithIdList(List idList, FilterInfo filterInfo) {
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            Iterator iterFilter = filterInfo.getFilterItems().iterator();
            while (iterFilter.hasNext()) {
                if (index != 0) {
                    sbMaskString.append(" and ");
                }
                iterFilter.next();
                sbMaskString.append("#" + String.valueOf(index));
                ++index;
            }
            filterInfo.setMaskString(sbMaskString.toString());
        }
        StringBuffer sbNewMaskString = new StringBuffer();
        index = 0;
        if (idList.size() <= 0) {
            return filterInfo;
        }
        String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
        sbNewMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            filterInfo.setMaskString(sbNewMaskString.toString());
        } else {
            filterInfo.setMaskString("(" + filterInfo.getMaskString() + ") and (" + sbNewMaskString.toString() + ")");
        }
        return filterInfo;
    }

    private void removeUnSelect(List entriesKey, CoreBillBaseCollection sourceBillCollection, String entryName) {
        HashMap entriesMap = new HashMap();
        for (int k = 0; k < entriesKey.size(); ++k) {
            if (entriesKey.get(k) == null) continue;
            entriesMap.put(entriesKey.get(k).toString(), null);
        }
        boolean isHasSelect = false;
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            CoreBillBaseInfo bills = sourceBillCollection.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return;
            }
            Iterator iters = entries.iterator();
            while (iters.hasNext()) {
                CoreBaseInfo cInfo = (CoreBaseInfo)iters.next();
                if (entriesMap.containsKey(cInfo.get("id").toString())) continue;
                iters.remove();
            }
        }
    }

    @Override
    protected CoreBillBaseCollection _getNewBillCollectionByType(Context ctx, String srcBillType, String[] srcBillIDs, String[] entrieNames, List entriesKeys, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer();
        String strIdLists = BOTMappingHelper.objectArray2String(srcBillIDs, ",");
        sbMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        filterInfo.setMaskString(sbMaskString.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        try {
            sourceBillCollection = controller.getCoreBillBaseCollection(ctx, entityViewInfo);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        if (sourceBillCollection == null || sourceBillCollection.size() <= 0) {
            logger.error((Object)("The result of getNewBillCollectionByType() is empty!  controller=" + controller.getClass() + ",  entityViewInfo=" + entityViewInfo));
        }
        if (entriesKeys != null && entriesKeys.size() > 0) {
            this.removeUnSelect(entriesKeys, sourceBillCollection, entrieNames[0]);
        }
        return sourceBillCollection;
    }

    @Override
    protected IObjectCollection _getMappingCollectionForSelectUseRuleFilter(Context ctx, String srcBillType, String targetBosType, DefineSysEnum defineSys, Map transmitContext, String[] srcBillIDs, String[] entrieNames, List entriesKeys, SelectorItemCollection botpSelectors) throws BOSException, BOTPException {
        return BOTRuleFilterTools.getMappingCollectionByRuleFilter(ctx, srcBillType, targetBosType, defineSys, transmitContext, srcBillIDs, entrieNames, entriesKeys, botpSelectors);
    }

    @Override
    protected boolean _addLastMapping(Context ctx, Map params) throws BOSException, EASBizException {
        Object[] updateParams = new Object[]{params.get("userId"), params.get("curType"), params.get("createMode")};
        String updateSql = "update T_BOT_LastMapping set fdefault = 0 where fuserId=? and fcurType=? and fcreateMode=? and fdefault = 1";
        Object[] deleteParams = new Object[]{params.get("userId"), params.get("curType"), params.get("createMode"), params.get("destType")};
        String deleteSql = "delete from T_BOT_LastMapping where fuserId=? and fcurType=? and fcreateMode=? and fdestType=?";
        Object[] insertParams = params.values().toArray();
        String insertSql = "insert into T_BOT_LastMapping(fid,fuserId,fcurType,fcreateMode,fdestType,fmappingId,fdefault) values (?,?,?,?,?,?,?)";
        try {
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])updateParams);
            DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])deleteParams);
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])insertParams);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("insert into T_BOT_LastMapping error" + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _updateLastMaping(Context ctx, Map params) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected String _getLastMapping(Context ctx, Map params) throws BOSException, EASBizException {
        String srcType = String.valueOf(params.get("curType"));
        String createMode = String.valueOf(params.get("createMode"));
        String userId = ctx.getCaller().toString();
        String sql = "select fdestType,fMappingId from T_BOT_LastMapping where fcurType = '" + srcType + "' and fcreateMode = " + createMode + " and fuserid = '" + userId + "' order by fdefault desc";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> destTypeList = new ArrayList<String>();
        ArrayList<String> mappingidList = new ArrayList<String>();
        try {
            while (result.next()) {
                destTypeList.add(result.getString("fdestType"));
                mappingidList.add(result.getString("fMappingId"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        StringBuffer destTypeAndMappingId = new StringBuffer();
        destTypeAndMappingId.append(BOTMappingHelper.listToString(destTypeList));
        destTypeAndMappingId.append("|");
        destTypeAndMappingId.append(BOTMappingHelper.listToString(mappingidList));
        return destTypeAndMappingId.toString();
    }

    @Override
    protected boolean _deleteLastMapping(Context ctx, Map params) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected IObjectCollection _getMappingCollectionForSelectUseRuleFilter4Pre(Context ctx, String srcBillType, String targetBosType, DefineSysEnum defineSys, Map transmitContext, String[] srcBillIDs, String[] entrieNames, List entriesKeys, SelectorItemCollection botpSelectors) throws BOSException, BOTPException {
        if (transmitContext == null) {
            transmitContext = new HashMap<String, Boolean>();
        }
        transmitContext.put("isPreview", true);
        return BOTRuleFilterTools.getMappingCollectionByRuleFilter(ctx, srcBillType, targetBosType, defineSys, transmitContext, srcBillIDs, entrieNames, entriesKeys, botpSelectors);
    }

    protected IObjectPK writeAppLog(Context ctx, IAppLog appLog, IObjectPK pk, BOTMappingInfo mappingInfo, String methodName) throws BOSException {
        IObjectPK appLogId = null;
        if (appLog == null) {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
        }
        appLogId = appLog.writeLog(methodName, this.getBOSType(), pk, mappingInfo.getName() + "-" + mappingInfo.getAlias(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ResourceBase.getString((String)RESXNAME, (String)methodName, (Locale)ctx.getLocale()) + "(" + ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()) + ":" + mappingInfo.getAlias() + "; " + ResourceBase.getString((String)RESXNAME, (String)NAME, (Locale)ctx.getLocale()) + ":" + mappingInfo.getName() + "; id:" + mappingInfo.getId() + ")");
        return appLogId;
    }

    protected IObjectPK writeAppLog(Context ctx, IAppLog appLog, IObjectPK pk, BOTMappingInfo mappingInfo, String methodName, String coding) throws BOSException {
        IObjectPK appLogId = null;
        if (appLog == null) {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
        }
        appLogId = appLog.writeLog(methodName, this.getBOSType(), pk, coding + "-" + mappingInfo.getAlias(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ResourceBase.getString((String)RESXNAME, (String)methodName, (Locale)ctx.getLocale()) + "(" + ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()) + ":" + mappingInfo.getAlias() + "; " + ResourceBase.getString((String)RESXNAME, (String)NAME, (Locale)ctx.getLocale()) + ":" + mappingInfo.getName() + "; id:" + mappingInfo.getId() + ")");
        return appLogId;
    }
}

