/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.AbstractBOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingUtil;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.botp.BotpMappingInfo;
import com.kingdee.bos.workflow.botp.IBotpProvider;
import com.kingdee.bos.workflow.exception.WfBotpException;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.btp.app.BOTAppTools;
import com.kingdee.eas.base.btp.app.BOTOrgUtils;
import com.kingdee.eas.base.btp.app.BTPManagerControllerBean;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.app.CoreBillBaseController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class WfBOTPProvider
implements IBotpProvider {
    private static Logger logger = Logger.getLogger(WfBOTPProvider.class);

    public String[] transform(Context ctx, String billId, String orgId, String srcBillType, String destBillType) throws WfBotpException {
        CoreBillBaseCollection srcBillCollection = new CoreBillBaseCollection();
        CoreBillBaseInfo billInfo = null;
        BOTMappingCollection botMappings = null;
        try {
            IFullOrgUnit fullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            CtrlUnitInfo cu = fullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId)).getCU();
            HashMap<String, CtrlUnitInfo> transmitCtx = new HashMap<String, CtrlUnitInfo>();
            transmitCtx.put("TRANSMITCU", cu);
            IBOTMapping botMapping = BOTMappingFactory.getLocalInstance(ctx);
            botMappings = botMapping.getMappingCollectionForSelectUseRuleFilter(srcBillType, destBillType, DefineSysEnum.BTP, transmitCtx, new String[]{billId}, null, null, null);
            if (botMappings == null || botMappings.size() == 0) {
                throw new WfBotpException(1000, "\u627e\u4e0d\u5230\u5408\u9002\u7684\u89c4\u5219");
            }
            CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
            billInfo = controller.getCoreBillBaseInfo(ctx, (IObjectPK)new ObjectStringPK(billId));
        }
        catch (Exception e) {
            throw new WfBotpException(1001, e.fillInStackTrace());
        }
        srcBillCollection.add(billInfo);
        Iterator iter = botMappings.iterator();
        while (iter.hasNext()) {
            BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
            try {
                String entriesName = BOTMappingUtil.getSrcEntriesName(mappingInfo);
                BOTAppTools.execDataFilterMultiEntry(ctx, srcBillCollection, mappingInfo);
            }
            catch (Exception e) {
                botMappings.remove(mappingInfo);
            }
        }
        AbstractBOTMappingInfo botMappingInfo = null;
        int n = botMappings.size();
        for (int i = 0; i < n; ++i) {
            if (n == 1) {
                botMappingInfo = botMappings.get(0);
                break;
            }
            if (botMappingInfo == null) {
                botMappingInfo = botMappings.get(i);
                continue;
            }
            if (!botMappings.get(i).getLastUpdateTime().after(botMappingInfo.getLastUpdateTime())) continue;
            botMappingInfo = botMappings.get(i);
        }
        return this.transformByMappingId(ctx, billId, srcBillType, botMappingInfo.getId().toString());
    }

    public String[] transformByMappingId(Context ctx, String billId, String srcBillType, String botMappingId) throws WfBotpException {
        BOTMappingInfo botMappingInfo = null;
        CoreBillBaseCollection srcBillCollection = null;
        ObjectStringPK botMappingPK = null;
        try {
            IBOTMapping botMapping = BOTMappingFactory.getLocalInstance(ctx);
            botMappingPK = new ObjectStringPK(botMappingId);
            botMappingInfo = botMapping.getBOTMappingInfo((IObjectPK)botMappingPK);
            SelectorItemCollection botpSelectors = BotpHelper.getBOTPSelectors(botMappingInfo);
            botpSelectors.add("*");
            CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
            srcBillCollection = new CoreBillBaseCollection();
            CoreBillBaseInfo billInfo = controller.getCoreBillBaseInfo(ctx, (IObjectPK)new ObjectStringPK(billId), botpSelectors);
            srcBillCollection.add(billInfo);
        }
        catch (Exception e) {
            throw new WfBotpException(1001, e.fillInStackTrace());
        }
        if (botMappingInfo.getDefineSys().getValue() == 10 && botMappingInfo.getIsTempSave() == 0) {
            throw new WfBotpException(1000);
        }
        try {
            if (!this.reBuildControl(ctx, botMappingInfo, srcBillCollection, botMappingInfo.getDestEntityName())) {
                logger.error((Object)"The rule defines no repetition of generation!", new Throwable());
                throw new BOSException("\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210,The rule defines no repetition of generation!");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new WfBotpException(1003, "\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210", e1.fillInStackTrace());
        }
        try {
            ArrayList<String> destBillIds = new ArrayList<String>();
            if (botMappingInfo.get("destentityname").equals("2652E01E")) {
                IBotpProvider dapProvider = (IBotpProvider)BOTPTools.getProviderClassObject("BOTP_WFDAPPROVIDER");
                if (dapProvider != null) {
                    return dapProvider.transformByMappingId(ctx, billId, srcBillType, botMappingId);
                }
                logger.error((Object)"Can't find the WfDAPProvider.class in DAP package!", new Throwable());
                throw new BOSException("Can't find the WfDAPProvider.class in DAP package!");
            }
            IBTPManager btpManager = BTPManagerFactory.getLocalInstance(ctx);
            BTPTransformResult btpResult = btpManager.transform(srcBillCollection, botMappingInfo);
            BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
            Iterator destBillIter = btpResult.getBills().iterator();
            String orgPropertyName = null;
            HashMap contextMap = new HashMap();
            while (destBillIter.hasNext()) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillIter.next();
                if (orgPropertyName == null) {
                    orgPropertyName = BOTOrgUtils.getOrgPropertyNameByCoreBillBaseInfo(destBillInfo);
                }
                Context bosctx = BOTOrgUtils.switchOrgIfNeed(ctx, destBillInfo, orgPropertyName, contextMap);
                IBOSObject obj = BOSObjectFactory.createBOSObject((Context)bosctx, (BOSObjectType)destBillInfo.getBOSType());
                ICoreBillBase iBillBase = (ICoreBillBase)obj;
                iBillBase.handleAfterTransform("SAVE", (IObjectValue)destBillInfo);
                iBillBase.newHandleAfterTransform("SAVE", (IObjectValue)destBillInfo, botMappingId, (IObjectCollection)btpResult.getBOTRelationCollection());
                btpManager = BTPManagerFactory.getLocalInstance(bosctx);
                btpManager.saveRelations(destBillInfo, botRelationCols);
                destBillIds.add(destBillInfo.getId().toString());
            }
            String[] billIds = new String[destBillIds.size()];
            return destBillIds.toArray(billIds);
        }
        catch (Exception e) {
            throw new WfBotpException(1001, e.fillInStackTrace());
        }
    }

    public BotpMappingInfo[] getBotpMappingInfosByBoth(Context ctx, String srcBillType, String destBillType) throws WfBotpException {
        try {
            BOTMappingCollection botMappingInfos = (BOTMappingCollection)BOTMappingHelper.getMappingForSelectAllCU(ctx, srcBillType, destBillType, null);
            ArrayList<BotpMappingInfo> list = new ArrayList<BotpMappingInfo>();
            int n = botMappingInfos.size();
            for (int i = 0; i < n; ++i) {
                BOTMappingInfo botMappingInfo = botMappingInfos.get(i);
                if (botMappingInfo.getDefineSys().getValue() == 10 && botMappingInfo.getIsTempSave() == 0) continue;
                BotpMappingInfo mapping = new BotpMappingInfo(botMappingInfo.getId().toString(), botMappingInfo.getAlias());
                list.add(mapping);
            }
            BotpMappingInfo[] mappings = new BotpMappingInfo[list.size()];
            return list.toArray(mappings);
        }
        catch (BOTPException e) {
            throw new WfBotpException(1000, e.getMessage());
        }
        catch (BOSException e) {
            throw new WfBotpException(1003, e.getMessage());
        }
    }

    public BotpMappingInfo[] getBotpMappingInfosByBoth(Context ctx, String orgId, String srcBillType, String destBillType) throws WfBotpException {
        try {
            BOTMappingCollection botMappingInfos = null;
            HashMap<String, CtrlUnitInfo> transmitCtx = new HashMap<String, CtrlUnitInfo>();
            if (!StringUtils.isEmpty((String)orgId)) {
                IFullOrgUnit fullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                CtrlUnitInfo cu = fullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId)).getCU();
                transmitCtx.put("TRANSMITCU", cu);
                botMappingInfos = (BOTMappingCollection)BOTMappingHelper.getMappingForSelect(ctx, srcBillType, destBillType, transmitCtx);
            } else {
                botMappingInfos = (BOTMappingCollection)BOTMappingHelper.getMappingForSelectAllCU(ctx, srcBillType, destBillType, null);
            }
            ArrayList<BotpMappingInfo> list = new ArrayList<BotpMappingInfo>();
            int n = botMappingInfos.size();
            for (int i = 0; i < n; ++i) {
                BOTMappingInfo botMappingInfo = botMappingInfos.get(i);
                if (botMappingInfo.getDefineSys().getValue() == 10 && botMappingInfo.getIsTempSave() == 0) continue;
                BotpMappingInfo mapping = new BotpMappingInfo(botMappingInfo.getId().toString(), botMappingInfo.getAlias());
                list.add(mapping);
            }
            BotpMappingInfo[] mappings = new BotpMappingInfo[list.size()];
            return list.toArray(mappings);
        }
        catch (BOTPException e) {
            throw new WfBotpException(1000, e.getMessage());
        }
        catch (Exception e) {
            throw new WfBotpException(1003, e.getMessage());
        }
    }

    private boolean reBuildControl(Context ctx, BOTMappingInfo botMappingInfo, CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType) throws Exception {
        String reBuildControl = "";
        String extconfig = botMappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = null;
        BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
        if (extconfig != null && !extconfig.equals("")) {
            info = processor.marshallingExtConfig(extconfig);
            reBuildControl = info.getReBuildControl();
            if (reBuildControl == null || reBuildControl.equals("")) {
                reBuildControl = "1";
            }
        } else {
            reBuildControl = "1";
        }
        if (reBuildControl.equals("1")) {
            return true;
        }
        if (reBuildControl.equals("2") || reBuildControl.equals("3")) {
            return !BTPManagerControllerBean.hasReBuild(ctx, srcBillInfos, destBillTypeBOSType);
        }
        logger.error((Object)"\u63d0\u793a\uff1a\u91cd\u590d\u751f\u6210\u4e86\u76ee\u6807\u5355\u636e", new Throwable());
        return true;
    }
}

