/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot.runtime;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.ArrayIndexerExpr;
import com.kingdee.bos.kscript.dom.expr.BigDecimalExpr;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.ObjectCreateExpr;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.expr.UnaryExpr;
import com.kingdee.bos.kscript.dom.expr.VectorCreateExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ElseIfItem;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.kscript.dom.stmt.ReturnStmt;
import com.kingdee.bos.kscript.dom.stmt.VarDeclItem;
import com.kingdee.bos.kscript.dom.stmt.VarDeclStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.exception.TODOException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.base.bot.trace.TraceConstants;
import com.kingdee.eas.base.bot.trace.TraceManagerFactory;
import com.kingdee.eas.base.bot.trace.core.ITraceManager;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BotUtil {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.bot.runtime.BotUtil");
    static Map exprParam = null;

    public static IObjectValue cloneObject(IObjectValue data, EntityObjectInfo entity) throws InvalidDAOMetaDataException {
        IObjectValue newData = Utils.newObjectValueInstance((EntityObjectInfo)entity);
        Enumeration e = data.keys();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            newData.put(propertyName, data.get(propertyName));
        }
        return newData;
    }

    public static List getSrcBillPropList(BOTMappingInfo mappingInfo) throws KScriptException {
        ArrayList srcIdentList = new ArrayList();
        ArrayList<String> srcPropList = new ArrayList<String>();
        if (mappingInfo == null) {
            return null;
        }
        BOTRuleCollection rules = mappingInfo.getRules();
        if (rules == null) {
            return null;
        }
        int l = rules.size();
        for (int k = 0; k < l; ++k) {
            int i;
            BOTRuleInfo botRuleInfo = rules.get(k);
            BOTRuleSegmentCollection segmentCol = botRuleInfo.getRuleSegments();
            int size = segmentCol.size();
            for (i = 0; i < size; ++i) {
                BOTRuleSegmentInfo segment = segmentCol.get(i);
                String srcExpr = segment.getSrcPropertyName();
                if (StringUtils.isEmpty((String)srcExpr)) {
                    srcExpr = segment.getExpression();
                } else if (!srcExpr.startsWith("__src.")) {
                    srcExpr = "__src." + srcExpr;
                }
                BotUtil.computeIdent(srcExpr, srcIdentList);
            }
            int count = srcIdentList.size();
            for (i = 0; i < count; ++i) {
                String ident = (String)srcIdentList.get(i);
                if (!ident.startsWith("__src.") || StringUtils.isEmpty((String)(ident = ident.substring("__src.".length())))) continue;
                boolean bexists = false;
                for (int j = 0; j < srcPropList.size(); ++j) {
                    if (!((String)srcPropList.get(j)).equalsIgnoreCase(ident)) continue;
                    bexists = true;
                    break;
                }
                if (bexists) continue;
                srcPropList.add(ident);
            }
        }
        return srcPropList;
    }

    public static void computeIdent(String script, Collection identCol) throws KScriptException {
        if (script == null) {
            return;
        }
        KScriptParser parser = new KScriptParser(script);
        parser.parse();
        List stmtList = parser.stmtList;
        int size = stmtList.size();
        for (int i = 0; i < size; ++i) {
            CodeStmt stmt = (CodeStmt)stmtList.get(i);
            BotUtil.computeIdent(stmt, identCol);
        }
    }

    public static void computeIdent(CodeStmt stmt, Collection identCol) throws KScriptException {
        if (stmt instanceof ExprStmt) {
            CodeExpr expr = ((ExprStmt)stmt).expr;
            BotUtil.computeIdent(expr, identCol);
        } else if (stmt instanceof ReturnStmt) {
            CodeExpr expr = ((ReturnStmt)stmt).expr;
            BotUtil.computeIdent(expr, identCol);
        } else if (stmt instanceof VarDeclStmt) {
            VarDeclStmt declStmt = (VarDeclStmt)stmt;
            for (int i = 0; i < declStmt.varDeclList.size(); ++i) {
                VarDeclItem item = (VarDeclItem)declStmt.varDeclList.get(i);
                if (item.initExpr == null) continue;
                BotUtil.computeIdent(item.initExpr, identCol);
            }
        } else if (stmt instanceof IfStmt) {
            int i;
            IfStmt ifStmt = (IfStmt)stmt;
            BotUtil.computeIdent(ifStmt.testExpr, identCol);
            for (i = 0; i < ifStmt.trueStmtList.size(); ++i) {
                BotUtil.computeIdent((CodeStmt)ifStmt.trueStmtList.get(i), identCol);
            }
            if (ifStmt.elseStmtList != null) {
                for (i = 0; i < ifStmt.elseStmtList.size(); ++i) {
                    BotUtil.computeIdent((CodeStmt)ifStmt.elseStmtList.get(i), identCol);
                }
            }
            if (ifStmt.elseIfList != null) {
                for (i = 0; i < ifStmt.elseIfList.size(); ++i) {
                    ElseIfItem elseIf = (ElseIfItem)ifStmt.elseIfList.get(i);
                    BotUtil.computeIdent(elseIf.testExpr, identCol);
                    if (elseIf.stmtList == null) continue;
                    for (int j = 0; j < elseIf.stmtList.size(); ++j) {
                        BotUtil.computeIdent((CodeStmt)elseIf.stmtList.get(j), identCol);
                    }
                }
            }
        } else {
            throw new TODOException();
        }
    }

    public static void computeIdent(CodeExpr expr, Collection identCollection) throws KScriptException {
        if (expr == null) {
            return;
        }
        if (expr instanceof IdentifierExpr) {
            identCollection.add(expr.toString());
        } else if (expr instanceof PropertyExpr) {
            identCollection.add(expr.toString());
        } else if (expr instanceof UnaryExpr) {
            UnaryExpr unaryExpr = (UnaryExpr)expr;
            BotUtil.computeIdent(unaryExpr.expr, identCollection);
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            BotUtil.computeIdent(binaryOpExpr.left, identCollection);
            BotUtil.computeIdent(binaryOpExpr.right, identCollection);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            for (CodeExpr pramExpr : methodInvokeExpr.paramList) {
                BotUtil.computeIdent(pramExpr, identCollection);
            }
        } else if (expr instanceof ObjectCreateExpr) {
            ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
            for (CodeExpr pramExpr : objCreateExpr.paramList) {
                BotUtil.computeIdent(pramExpr, identCollection);
            }
        } else {
            if (expr instanceof BigDecimalExpr || expr instanceof StringExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr) {
                return;
            }
            if (expr instanceof ArrayIndexerExpr) {
                ArrayIndexerExpr arrayIndexerExpr = (ArrayIndexerExpr)expr;
                BotUtil.computeIdent(arrayIndexerExpr.targetObjExpr, identCollection);
                BotUtil.computeIdent(arrayIndexerExpr.indexExpr, identCollection);
            } else if (expr instanceof VectorCreateExpr) {
                VectorCreateExpr newVecExpr = (VectorCreateExpr)expr;
                for (int i = 0; i < newVecExpr.paramList.size(); ++i) {
                    CodeExpr pramExpr = (CodeExpr)newVecExpr.paramList.get(i);
                    BotUtil.computeIdent(pramExpr, identCollection);
                }
            } else {
                throw new TODOException();
            }
        }
    }

    public static boolean hasAggregateExpr(String expression) throws ParserException {
        try {
            KScriptParser parser = new KScriptParser(expression);
            parser.parse();
            List stmtList = parser.stmtList;
            return BotUtil.hasAggregateExpr(stmtList);
        }
        catch (ParserException e) {
            log.error((Object)("parse error. expression is : " + expression), (Throwable)e);
            throw e;
        }
    }

    public static List getAggregateExpr(String expression) throws ParserException {
        ArrayList aggExprList = new ArrayList();
        try {
            KScriptParser parser = new KScriptParser(expression);
            parser.parse();
            List stmtList = parser.stmtList;
            BotUtil.getAggregateExpr(stmtList, aggExprList);
        }
        catch (ParserException e) {
            log.error((Object)("parse error. expression is : " + expression), (Throwable)e);
            throw e;
        }
        return aggExprList;
    }

    private static boolean hasAggregateExpr(List stmtList) {
        if (stmtList.size() == 0 || stmtList.size() > 1) {
            return false;
        }
        int i = 0;
        if (i < stmtList.size()) {
            CodeStmt stmt = (CodeStmt)stmtList.get(i);
            if (stmt instanceof ExprStmt) {
                CodeExpr expr = ((ExprStmt)stmt).expr;
                return BotUtil.hasAggregateExpr(expr);
            }
            if (stmt instanceof IfStmt) {
                IfStmt ifStmt = (IfStmt)stmt;
                if (BotUtil.hasAggregateExpr(ifStmt.testExpr)) {
                    return true;
                }
                if (BotUtil.hasAggregateExpr(ifStmt.trueStmtList)) {
                    return true;
                }
                if (ifStmt.elseStmtList != null && BotUtil.hasAggregateExpr(ifStmt.elseStmtList)) {
                    return true;
                }
                if (ifStmt.elseIfList != null) {
                    for (int j = 0; j < ifStmt.elseIfList.size(); ++j) {
                        ElseIfItem elseIfItem = (ElseIfItem)ifStmt.elseIfList.get(j);
                        if (BotUtil.hasAggregateExpr(elseIfItem.testExpr)) {
                            return true;
                        }
                        if (!BotUtil.hasAggregateExpr(elseIfItem.stmtList)) continue;
                        return true;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private static void getAggregateExpr(List stmtList, List aggregateExprList) {
        if (stmtList.size() == 0 || stmtList.size() > 1) {
            return;
        }
        for (int i = 0; i < stmtList.size(); ++i) {
            CodeStmt stmt = (CodeStmt)stmtList.get(i);
            if (stmt instanceof ExprStmt) {
                CodeExpr expr = ((ExprStmt)stmt).expr;
                BotUtil.getAggregateExpr(expr, aggregateExprList);
                continue;
            }
            if (!(stmt instanceof IfStmt)) continue;
            IfStmt ifStmt = (IfStmt)stmt;
            BotUtil.getAggregateExpr(ifStmt.testExpr, aggregateExprList);
            BotUtil.getAggregateExpr(ifStmt.trueStmtList, aggregateExprList);
            BotUtil.getAggregateExpr(ifStmt.elseStmtList, aggregateExprList);
            if (ifStmt.elseIfList == null) continue;
            for (int j = 0; j < ifStmt.elseIfList.size(); ++j) {
                ElseIfItem elseIfItem = (ElseIfItem)ifStmt.elseIfList.get(j);
                BotUtil.getAggregateExpr(elseIfItem.testExpr, aggregateExprList);
                BotUtil.getAggregateExpr(elseIfItem.stmtList, aggregateExprList);
            }
        }
    }

    private static boolean hasAggregateExpr(CodeExpr expr) {
        if (expr instanceof BinaryOpExpr) {
            if (BotUtil.hasAggregateBinayOpExpr((BinaryOpExpr)expr)) {
                return true;
            }
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokExpr = (MethodInvokeExpr)expr;
            if (methodInvokExpr.methodName != null && (methodInvokExpr.methodName.equalsIgnoreCase("sum") || methodInvokExpr.methodName.equalsIgnoreCase("avg") || methodInvokExpr.methodName.equalsIgnoreCase("max") || methodInvokExpr.methodName.equalsIgnoreCase("min"))) {
                return true;
            }
            for (int i = 0; i < methodInvokExpr.paramList.size(); ++i) {
                CodeExpr pramExpr = (CodeExpr)methodInvokExpr.paramList.get(i);
                if (!BotUtil.hasAggregateExpr(pramExpr)) continue;
                return true;
            }
        }
        return false;
    }

    private static void getAggregateExpr(CodeExpr expr, List aggregateExprList) {
        if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            BotUtil.getAggregateExpr(binaryOpExpr.left, aggregateExprList);
            BotUtil.getAggregateExpr(binaryOpExpr.right, aggregateExprList);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokExpr = (MethodInvokeExpr)expr;
            if (methodInvokExpr.methodName != null && (methodInvokExpr.methodName.equalsIgnoreCase("sum") || methodInvokExpr.methodName.equalsIgnoreCase("avg") || methodInvokExpr.methodName.equalsIgnoreCase("max") || methodInvokExpr.methodName.equalsIgnoreCase("min"))) {
                aggregateExprList.add(methodInvokExpr.toString());
            }
            for (int i = 0; i < methodInvokExpr.paramList.size(); ++i) {
                CodeExpr pramExpr = (CodeExpr)methodInvokExpr.paramList.get(i);
                BotUtil.getAggregateExpr(pramExpr, aggregateExprList);
            }
        }
    }

    private static boolean hasAggregateBinayOpExpr(BinaryOpExpr expr) {
        if (BotUtil.hasAggregateExpr(expr.left)) {
            return true;
        }
        return BotUtil.hasAggregateExpr(expr.right);
    }

    public static void invokeReverseSave(ICoreBillBase srcBillInterface, IObjectPK srcBillPK, CoreBillBaseInfo srcBillInfo, BOTBillOperStateEnum oprtState, BOTRelationInfo botRelationInfo) throws BOSException, EASBizException {
        ITraceManager trace = TraceManagerFactory.newInstance(TraceConstants.TRACETYPE_BOTP);
        trace.newSub("invoke reverseSave");
        srcBillInterface.reverseSave(srcBillPK, srcBillInfo, oprtState, botRelationInfo);
        trace.endSub();
    }

    public static Map getExprParam(CodeStmt stmt, String srcPropertyNameVlaue) throws KScriptException {
        exprParam = new HashMap();
        if (stmt instanceof ExprStmt) {
            CodeExpr expr = ((ExprStmt)stmt).expr;
            BotUtil.getExprParam(expr, srcPropertyNameVlaue);
        } else if (stmt instanceof ReturnStmt) {
            CodeExpr expr = ((ReturnStmt)stmt).expr;
            BotUtil.getExprParam(expr, srcPropertyNameVlaue);
        } else if (stmt instanceof VarDeclStmt) {
            VarDeclStmt declStmt = (VarDeclStmt)stmt;
            for (int i = 0; i < declStmt.varDeclList.size(); ++i) {
                VarDeclItem item = (VarDeclItem)declStmt.varDeclList.get(i);
                if (item.initExpr == null) continue;
                BotUtil.getExprParam(item.initExpr, srcPropertyNameVlaue);
            }
        } else if (stmt instanceof IfStmt) {
            int i;
            IfStmt ifStmt = (IfStmt)stmt;
            BotUtil.getExprParam(ifStmt.testExpr, srcPropertyNameVlaue);
            for (i = 0; i < ifStmt.trueStmtList.size(); ++i) {
                BotUtil.getExprParam((CodeStmt)ifStmt.trueStmtList.get(i), srcPropertyNameVlaue);
            }
            if (ifStmt.elseStmtList != null) {
                for (i = 0; i < ifStmt.elseStmtList.size(); ++i) {
                    BotUtil.getExprParam((CodeStmt)ifStmt.elseStmtList.get(i), srcPropertyNameVlaue);
                }
            }
            if (ifStmt.elseIfList != null) {
                for (i = 0; i < ifStmt.elseIfList.size(); ++i) {
                    ElseIfItem elseIf = (ElseIfItem)ifStmt.elseIfList.get(i);
                    BotUtil.getExprParam(elseIf.testExpr, srcPropertyNameVlaue);
                    if (elseIf.stmtList == null) continue;
                    for (int j = 0; j < elseIf.stmtList.size(); ++j) {
                        BotUtil.getExprParam((CodeStmt)elseIf.stmtList.get(j), srcPropertyNameVlaue);
                    }
                }
            }
        } else {
            throw new TODOException();
        }
        return exprParam;
    }

    public static Map getExprParam(CodeExpr expr, String srcPropertyNameVlaue) throws KScriptException {
        if (expr == null) {
            return exprParam;
        }
        if (expr instanceof IdentifierExpr) {
            if (expr.toString().indexOf("__src") > -1) {
                exprParam.put(expr.toString(), srcPropertyNameVlaue);
            }
        } else if (expr instanceof PropertyExpr) {
            if (expr.toString().indexOf("__src") > -1) {
                exprParam.put(expr.toString(), srcPropertyNameVlaue);
            }
        } else if (expr instanceof UnaryExpr) {
            UnaryExpr unaryExpr = (UnaryExpr)expr;
            BotUtil.getExprParam(unaryExpr.expr, srcPropertyNameVlaue);
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            BotUtil.getExprParam(binaryOpExpr.left, srcPropertyNameVlaue);
            BotUtil.getExprParam(binaryOpExpr.right, srcPropertyNameVlaue);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            for (CodeExpr pramExpr : methodInvokeExpr.paramList) {
                if (pramExpr.toString().indexOf("__src") <= -1) continue;
                exprParam.put(pramExpr.toString(), srcPropertyNameVlaue);
            }
        } else if (expr instanceof ObjectCreateExpr) {
            ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
            for (CodeExpr pramExpr : objCreateExpr.paramList) {
                if (pramExpr.toString().indexOf("__src") <= -1) continue;
                exprParam.put(pramExpr.toString(), srcPropertyNameVlaue);
            }
        } else {
            if (expr instanceof BigDecimalExpr || expr instanceof StringExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr) {
                return exprParam;
            }
            if (expr instanceof ArrayIndexerExpr) {
                ArrayIndexerExpr arrayIndexerExpr = (ArrayIndexerExpr)expr;
                BotUtil.getExprParam(arrayIndexerExpr.targetObjExpr, srcPropertyNameVlaue);
                BotUtil.getExprParam(arrayIndexerExpr.indexExpr, srcPropertyNameVlaue);
            } else if (expr instanceof VectorCreateExpr) {
                VectorCreateExpr newVecExpr = (VectorCreateExpr)expr;
                for (int i = 0; i < newVecExpr.paramList.size(); ++i) {
                    CodeExpr pramExpr = (CodeExpr)newVecExpr.paramList.get(i);
                    if (pramExpr.toString().indexOf("__src") <= -1) continue;
                    exprParam.put(pramExpr.toString(), srcPropertyNameVlaue);
                }
            } else {
                throw new TODOException();
            }
        }
        return exprParam;
    }
}

