/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot.runtime;

import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EntityEntryStructure {
    private static final String ISENTRIES = "isEntries";
    private int level;
    public EntityObjectInfo entryEntity;
    private EntityEntryStructure owner;
    public Map entryVerticalMap;

    public EntityEntryStructure(int level, EntityObjectInfo entity, EntityEntryStructure owner) {
        this.level = level;
        this.entryEntity = entity;
        this.owner = owner;
        this.buildVerticalStructure();
    }

    public Map buildHorizontalStructure(String prefix) {
        HashMap entryHorizontalMap = new HashMap();
        this.transformVerticalToHorizonStructure(prefix, this.entryVerticalMap, entryHorizontalMap);
        return entryHorizontalMap;
    }

    private void transformVerticalToHorizonStructure(String prefix, Map entryVerticalMap, Map entryHorizontalMap) {
        Set key = entryVerticalMap.keySet();
        for (String propName : key) {
            EntityEntryStructure entry = (EntityEntryStructure)entryVerticalMap.get(propName);
            String entryPrefix = prefix == null ? propName : prefix + "." + propName;
            entryHorizontalMap.put(entryPrefix, entry);
            this.transformVerticalToHorizonStructure(entryPrefix, entry.entryVerticalMap, entryHorizontalMap);
        }
    }

    private void buildVerticalStructure() {
        this.entryVerticalMap = new HashMap();
        PropertyCollection props = this.entryEntity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo propInfo : props) {
            EntityEntryStructure entryInfo;
            EntityObjectInfo relateEntity = null;
            if (!(propInfo instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)propInfo).getRelationship();
            if (propInfo.getExtendedProperty("isInEntryrule") != null && propInfo.getExtendedProperty("isInEntryrule").equalsIgnoreCase("true")) {
                if (relation.getClientObject().getFullName().equals(this.entryEntity.getFullName())) {
                    relateEntity = relation.getSupplierObject();
                } else if (relation.getSupplierObject().getFullName().equals(this.entryEntity.getFullName())) {
                    relateEntity = relation.getClientObject();
                }
                if (relateEntity == null) continue;
                entryInfo = new EntityEntryStructure(this.level + 1, relateEntity, this);
                this.entryVerticalMap.put(propInfo.getName(), entryInfo);
                continue;
            }
            if (relation.getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty(ISENTRIES))) continue;
            if (relation.getClientObject().getFullName().equals(this.entryEntity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getSupplierObject();
            } else if (relation.getSupplierObject().getFullName().equals(this.entryEntity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getClientObject();
            }
            if (relateEntity == null) continue;
            entryInfo = new EntityEntryStructure(this.level + 1, relateEntity, this);
            this.entryVerticalMap.put(propInfo.getName(), entryInfo);
        }
    }
}

