/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.bot.trace.impl;

import com.kingdee.bos.bot.engine.common.LogUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.bot.trace.TraceParamInfo;
import com.kingdee.eas.base.bot.trace.TraceResultInfo;
import com.kingdee.eas.base.bot.trace.core.ITrace;
import com.kingdee.eas.base.bot.trace.core.ITraceSubObject;
import com.kingdee.eas.base.bot.trace.util.TraceLevel;
import com.kingdee.eas.base.botp.util.BOTPTools;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public abstract class BotpTraceBaseObject
implements ITrace {
    private Logger logger = LogUtils.getLogger(Thread.currentThread().getId() + "_" + Thread.currentThread().getName());
    protected String name = "";
    protected String msg = "";
    protected long lStartTime = 0L;
    protected long lEndTime = 0L;
    protected String startTime = "";
    protected String endTime = "";
    protected List children = new ArrayList();
    protected int level = 0;
    protected TraceLevel traceLevel = null;

    @Override
    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public void setTraceLevel(TraceLevel traceLevel) {
        this.traceLevel = traceLevel;
    }

    public int getLevel() {
        return this.level;
    }

    void setLevel(int level) {
        this.level = level;
    }

    @Override
    public long getExecTime() {
        return this.lEndTime - this.lStartTime;
    }

    @Override
    public void start(String name) {
        this.lEndTime = this.lStartTime = System.currentTimeMillis();
        this.startTime = BOTPTools.getCurrentTime();
        this.name = name;
    }

    @Override
    public void end() {
        this.lEndTime = System.currentTimeMillis();
        this.endTime = BOTPTools.getCurrentTime();
    }

    public List getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void add(ITraceSubObject sub) {
        this.children.add(sub);
    }

    public void remove(ITraceSubObject sub) {
        this.children.remove(sub);
    }

    protected void innerOutputMsg(String msg) {
        this.innerOutputMsg(msg, null);
    }

    protected void innerOutputMsg(String msg, Object obj) {
        this.innerOutputMsg(msg, obj, null);
    }

    protected void innerOutputMsg(String msg, Object obj, Throwable t) {
        if (this.traceLevel != null) {
            this.realOutputMsg(msg, obj, t);
        }
    }

    protected void realOutputMsg(String msg) {
        this.realOutputMsg(msg, null);
    }

    protected void realOutputMsg(String msg, Object obj) {
        this.realOutputMsg(msg, obj, null);
    }

    protected void realOutputMsg(String msg, Object obj, Throwable t) {
        String strObj;
        if (this.logger == null || this.traceLevel == null || this.traceLevel.equals(TraceLevel.LEVEL_NO)) {
            return;
        }
        String string = strObj = obj == null ? "" : obj.toString();
        if (t != null) {
            this.logger.error(msg + strObj, t);
        } else {
            this.logger.error(msg + strObj);
        }
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    @Override
    public void logInfoHead() {
    }

    @Override
    public void logInfoFoot() {
    }

    @Override
    public void log(TraceParamInfo objects) {
        if (objects == null) {
            return;
        }
        if (this.logger == null || this.traceLevel == null || this.traceLevel.equals(TraceLevel.LEVEL_NO) || this.traceLevel.equals(TraceLevel.LEVEL_SUMMARY)) {
            return;
        }
        String name = "params";
        this.innerOutputMsg(name + " size =" + objects.getLength());
        for (int i = 0; i < objects.getLength(); ++i) {
            Object obj = objects.get(i);
            if (obj instanceof List) {
                List list = (List)obj;
                this.innerOutputMsg(name + "[" + i + "]=" + obj.getClass() + ", size=" + list.size());
                for (int j = 0; j < list.size(); ++j) {
                    Object subVal = list.get(j);
                    if (subVal instanceof IObjectCollection) {
                        IObjectCollection coll = (IObjectCollection)subVal;
                        this.innerOutputMsg(name + "[" + i + "][" + j + "]=" + subVal.getClass() + ", size=" + coll.size());
                        for (int k = 0; k < coll.size(); ++k) {
                            this.innerOutputMsg("--[" + i + "][" + j + "][" + k + "]=" + coll.getObject(k));
                        }
                        continue;
                    }
                    this.innerOutputMsg("--[" + i + "][" + j + "]=" + subVal);
                }
                continue;
            }
            this.innerOutputMsg(name + "[" + i + "]=" + obj);
        }
    }

    @Override
    public void log(TraceResultInfo objects) {
        if (objects == null) {
            return;
        }
        if (this.logger == null || this.traceLevel == null || this.traceLevel.equals(TraceLevel.LEVEL_NO) || this.traceLevel.equals(TraceLevel.LEVEL_SUMMARY)) {
            return;
        }
        String name = "results";
        this.innerOutputMsg(name + " size =" + objects.getLength());
        for (int i = 0; i < objects.getLength(); ++i) {
            int j;
            Object coll;
            Object obj = objects.get(i);
            if (obj instanceof IObjectCollection) {
                coll = (IObjectCollection)obj;
                this.innerOutputMsg(name + "[" + i + "]=" + obj.getClass() + ", size=" + coll.size());
                for (j = 0; j < coll.size(); ++j) {
                    this.innerOutputMsg("--[" + i + "][" + j + "]=" + coll.getObject(j));
                }
                continue;
            }
            if (obj instanceof List) {
                coll = (List)obj;
                this.innerOutputMsg(name + "[" + i + "]=" + obj.getClass() + ", size=" + coll.size());
                for (j = 0; j < coll.size(); ++j) {
                    this.innerOutputMsg("--[" + i + "][" + j + "]=" + coll.get(j));
                }
                continue;
            }
            this.innerOutputMsg(name + "[" + i + "]=" + obj);
        }
    }

    @Override
    public void log(String msg, boolean bForce) {
        if (bForce) {
            this.realOutputMsg(msg);
        } else {
            this.log(msg);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }
}

