/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.bot.trace.impl;

import com.kingdee.eas.base.bot.trace.TraceParamInfo;
import com.kingdee.eas.base.bot.trace.TraceResultInfo;
import com.kingdee.eas.base.bot.trace.core.ITraceManager;
import com.kingdee.eas.base.bot.trace.core.ITraceObject;
import com.kingdee.eas.base.bot.trace.impl.BotpTraceObject;
import com.kingdee.eas.base.bot.trace.util.TraceLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class BotpTraceManager
implements ITraceManager {
    private static String prefixStr = "___";
    private ITraceObject root = null;
    private boolean inited = false;
    private TraceLevel traceLevel = null;
    private static final ThreadLocal local = new ThreadLocal();
    private Stack rootStack = new Stack();

    @Override
    public void setTraceLevel(TraceLevel traceLevel) {
        this.traceLevel = traceLevel != null ? traceLevel : TraceLevel.LEVEL_NO;
    }

    @Override
    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    private BotpTraceManager() {
    }

    public static String getPrefixStr() {
        return prefixStr;
    }

    public static void setPrefixStr(String prefixStr) {
        BotpTraceManager.prefixStr = prefixStr;
    }

    public static ITraceManager newInstance() {
        BotpTraceManager trace = (BotpTraceManager)local.get();
        if (trace == null) {
            trace = new BotpTraceManager();
            local.set(trace);
            trace.init();
        }
        return trace;
    }

    public static ITraceManager getInstance() {
        BotpTraceManager trace = (BotpTraceManager)local.get();
        if (trace == null) {
            trace = new BotpTraceManager();
            local.set(trace);
            trace.init();
        }
        return trace;
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void log(String msg) {
        if (this.root != null) {
            this.root.log(msg);
        }
    }

    @Override
    public void log(String msg, Object obj) {
        if (this.root != null) {
            this.root.log(msg, obj);
        }
    }

    @Override
    public void log(String msg, Object obj, String scriptId, long time) {
        if (this.root != null) {
            this.root.log(msg, obj, scriptId, time);
        }
    }

    @Override
    public void log(String msg, boolean bForce) {
        if (this.root != null) {
            this.root.log(msg, bForce);
        }
    }

    @Override
    public void log(TraceParamInfo params) {
        if (this.root != null) {
            this.root.log(params);
        }
    }

    @Override
    public void logScritpTime() {
        if (this.root != null) {
            this.root.logScritpTime();
        }
    }

    @Override
    public void log(TraceResultInfo results) {
        if (this.root != null) {
            this.root.log(results);
        }
    }

    @Override
    public void start(String name) {
        this.start(name, true);
    }

    public void start(String name, boolean bNest) {
        if (this.root != null) {
            if (!bNest) {
                this.root.end();
            } else {
                this.rootStack.add(this.root);
            }
        }
        this.root = new BotpTraceObject(this.traceLevel);
        this.root.start(name);
    }

    @Override
    public void end() {
        if (this.root != null) {
            this.root.end();
            this.root = !this.rootStack.isEmpty() ? (BotpTraceObject)this.rootStack.pop() : null;
        }
    }

    @Override
    public void error(Throwable e) {
        if (this.root != null) {
            this.root.error(e);
        }
    }

    @Override
    public void endSub() {
        if (this.root != null) {
            this.root.endSub();
        }
    }

    @Override
    public void newSub() {
        this.newSub("");
    }

    @Override
    public void newSub(String name) {
        this.newSub(name, "");
    }

    @Override
    public void newSub(String name, String msg) {
        if (this.root != null) {
            this.root.newSub(name, msg);
        }
    }

    @Override
    public long getCallTime(String name) {
        if (this.root != null) {
            return this.root.getCallTime(name);
        }
        return 0L;
    }

    @Override
    public List getCallNameList() {
        if (this.root != null) {
            return this.root.getCallNameList();
        }
        return new ArrayList();
    }

    public ITraceObject getRoot() {
        return this.root;
    }
}

