/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import java.util.List;
import org.apache.log4j.Logger;

public class MappingCache {
    private static Logger logger = Logger.getLogger(MappingCache.class);
    private final CustomCacheService mappingCache = new CustomCacheService("botp.getMapping");
    private static MappingCache mc = null;

    private MappingCache() {
    }

    public static MappingCache getInstance(Context ctx) {
        if (mc == null) {
            mc = new MappingCache();
        }
        return mc;
    }

    public void clear(Context ctx) {
        this.mappingCache.removeAll();
    }

    public void clear(String botMappingId, Context ctx) {
        String key = this.genKey(botMappingId.toString(), ctx);
        this.mappingCache.remove(key);
    }

    public void clear(String[] botMappingIds, Context ctx) {
        if (botMappingIds == null || botMappingIds.length == 0) {
            return;
        }
        int count = botMappingIds.length;
        for (int i = 0; i < count; ++i) {
            this.clear(botMappingIds[i], ctx);
        }
    }

    public void clear(List botMappingIds, Context ctx) {
        if (botMappingIds == null || botMappingIds.size() == 0) {
            return;
        }
        int count = botMappingIds.size();
        for (int i = 0; i < count; ++i) {
            this.clear(botMappingIds.get(i).toString(), ctx);
        }
    }

    private String genKey(String str, Context ctx) {
        return str + ctx.getAIS();
    }

    public synchronized BOTMappingInfo getMappingInfo(IObjectPK botMappingId, Context ctx) throws BOSException {
        if (botMappingId == null) {
            return null;
        }
        String key = this.genKey(botMappingId.toString(), ctx);
        BOTMappingInfo info = null;
        info = (BOTMappingInfo)this.mappingCache.get(key);
        if (info != null && info.getRules() != null && info.getRules().size() > 0) {
            return (BOTMappingInfo)info.clone();
        }
        if (info != null) {
            logger.error((Object)("\u89c4\u5219" + info.getAlias() + "\u4e22\u5931\u5206\u5f55\u89c4\u5219"));
        }
        try {
            BOTMappingInfo mappingInfo = BOTMappingFactory.getLocalInstance(ctx).getMappingInfoByPK(botMappingId);
            this.mappingCache.put(key, (Object)mappingInfo);
            return (BOTMappingInfo)mappingInfo.clone();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException("MappingCache Exception: " + e.getMessage());
        }
    }

    public BOTMappingInfo getMappingInfo(String botMappingId, Context ctx) throws BOSException {
        if (botMappingId == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(botMappingId);
        return this.getMappingInfo((IObjectPK)pk, ctx);
    }
}

