/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTExtMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BOTAppTools {
    private static Logger logger = Logger.getLogger(BOTAppTools.class);

    public static void execDataFilterMultiEntry(Context ctx, CoreBillBaseCollection srcCoreBillCollection, BOTMappingInfo mappingInfo) throws BOSException {
        if (srcCoreBillCollection == null || srcCoreBillCollection.size() <= 0 || mappingInfo == null || mappingInfo.getExtRule() == null) {
            return;
        }
        BOTExtMappingInfo extMappingInfo = mappingInfo.getExtRule();
        String dataFilter = extMappingInfo.getDataFilter();
        if (dataFilter == null || "".equals(dataFilter)) {
            return;
        }
        ArrayList<String> entriesNameList = new ArrayList<String>();
        EntityViewInfo evi = null;
        try {
            evi = BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 1);
            FilterCollection filterCol = evi.getEntryFilters();
            for (int i = 0; i < filterCol.size(); ++i) {
                FilterInfo filter = filterCol.get(i);
                entriesNameList.add(filter.getEntryName());
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        dataFilter = BOTAppTools.getDataFilterCombStr(ctx, srcCoreBillCollection, mappingInfo, entriesNameList);
        IDynamicObject iDynObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectCollection billCollection = iDynObj.getCollection(srcCoreBillCollection.get(0).getBOSType(), dataFilter);
        CoreBillBaseCollection filteredCollection = new CoreBillBaseCollection();
        int size = billCollection.size();
        for (int i = 0; i < size; ++i) {
            filteredCollection.add((CoreBillBaseInfo)billCollection.getObject(i));
        }
        int count = srcCoreBillCollection.size();
        for (int t = 0; t < count; ++t) {
            BOSUuid filteredBillId;
            int s;
            BOSUuid srcBillId = srcCoreBillCollection.get(t).getId();
            int fCount = filteredCollection.size();
            for (s = 0; s < fCount && !srcBillId.equals((Object)(filteredBillId = filteredCollection.get(s).getId())); ++s) {
            }
            if (s == fCount) {
                srcCoreBillCollection.removeObject(t);
                --t;
                --count;
                continue;
            }
            if (entriesNameList == null || entriesNameList.size() <= 0) continue;
            boolean bExistEntry = false;
            for (int k = 0; k < entriesNameList.size(); ++k) {
                String entriesName = (String)entriesNameList.get(k);
                CoreBillBaseInfo filteredInfo = filteredCollection.get(s);
                CoreBillBaseInfo srcBillInfo = srcCoreBillCollection.get(t);
                IObjectCollection billEntries = (IObjectCollection)srcBillInfo.get(entriesName);
                IObjectCollection filterEntries = (IObjectCollection)filteredInfo.get(entriesName);
                if (billEntries == null || filterEntries == null) continue;
                if (billEntries.size() != filterEntries.size()) {
                    int lastFound = 0;
                    int beCount = billEntries.size();
                    for (int z = 0; z < beCount; ++z) {
                        IObjectValue feBillEntry;
                        int fz;
                        IObjectValue billEntry = billEntries.getObject(z);
                        boolean flag = false;
                        int fBeCount = filterEntries.size();
                        for (fz = lastFound; fz < fBeCount; ++fz) {
                            feBillEntry = filterEntries.getObject(fz);
                            if (!billEntry.get("id").equals(feBillEntry.get("id"))) continue;
                            lastFound = fz + 1;
                            flag = true;
                            break;
                        }
                        for (fz = 0; fz < lastFound; ++fz) {
                            feBillEntry = filterEntries.getObject(fz);
                            if (!billEntry.get("id").toString().equals(feBillEntry.get("id").toString())) continue;
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        billEntries.removeObject(z);
                        --z;
                        --beCount;
                    }
                }
                if (billEntries.size() <= 0) continue;
                bExistEntry = true;
            }
            if (bExistEntry) continue;
            srcCoreBillCollection.removeObject(t);
            --t;
            --count;
        }
    }

    private static String getDataFilterCombStr(Context ctx, CoreBillBaseCollection srcCoreBillCollection, BOTMappingInfo mappingInfo, List entriesNameList) throws BOSException {
        String dataFilter = mappingInfo.getExtRule().getDataFilter();
        if (dataFilter == null || "".equals(dataFilter)) {
            return "";
        }
        EntityViewInfo evi = null;
        try {
            evi = BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 1);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer filterMask = new StringBuffer();
        StringBuffer strIdLists = new StringBuffer();
        int size = srcCoreBillCollection.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                strIdLists.append(",");
            }
            strIdLists.append(srcCoreBillCollection.get(i).getId().toString());
        }
        if (strIdLists.length() > 0) {
            filterMask.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists.toString(), CompareType.INCLUDE));
        }
        if (filterMask.length() > 0) {
            filterInfo.setMaskString(filterMask.toString());
        }
        if (evi.getFilter() != null && evi.getFilter().getFilterItems().size() > 0) {
            evi.getFilter().mergeFilter(filterInfo, "and");
        } else {
            evi.setFilter(filterInfo);
        }
        if (entriesNameList != null) {
            for (int k = 0; k < entriesNameList.size(); ++k) {
                String entriesName = (String)entriesNameList.get(k);
                FilterInfo entryFilterInfo = new FilterInfo();
                entryFilterInfo.setEntryName(entriesName);
                entryFilterInfo.setEntryilterType(EntryFilterType.NORMAL);
                StringBuffer entryFilterMask = new StringBuffer();
                StringBuffer strEntryIdLists = new StringBuffer();
                int size2 = srcCoreBillCollection.size();
                for (int i = 0; i < size2; ++i) {
                    CoreBillBaseInfo srcCoreBillInfo = srcCoreBillCollection.get(i);
                    IObjectCollection srcCoreBillEntryCols = (IObjectCollection)srcCoreBillInfo.get(entriesName);
                    if (srcCoreBillEntryCols == null) continue;
                    int count = srcCoreBillEntryCols.size();
                    for (int j = 0; j < count; ++j) {
                        IObjectValue srcCoreBillEntryInfo = srcCoreBillEntryCols.getObject(j);
                        if (i + j > 0) {
                            strEntryIdLists.append(",");
                        }
                        strEntryIdLists.append(srcCoreBillEntryInfo.get("id").toString());
                    }
                }
                if (strEntryIdLists.length() <= 0) continue;
                entryFilterMask.append("#" + String.valueOf(entryFilterInfo.getFilterItems().size()));
                entryFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strEntryIdLists.toString(), CompareType.INCLUDE));
                entryFilterInfo.setMaskString(entryFilterMask.toString());
                if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0 && evi.getEntryFilters().get(entriesName) != null) {
                    FilterInfo botEntryFilter = evi.getEntryFilters().get(entriesName);
                    if (botEntryFilter.getFilterItems().size() > 0) {
                        botEntryFilter.mergeFilter(entryFilterInfo, "and");
                        continue;
                    }
                    evi.getEntryFilters().remove(botEntryFilter);
                    evi.getEntryFilters().add(entryFilterInfo);
                    continue;
                }
                evi.getEntryFilters().add(entryFilterInfo);
            }
        }
        dataFilter = evi.toString();
        return dataFilter;
    }

    public static List getSrcEntriesNameList(Context ctx, CoreBillBaseCollection srcCoreBillCollection) {
        ArrayList<String> list = new ArrayList<String>();
        CoreBillBaseInfo baseInfo = null;
        if (srcCoreBillCollection != null && srcCoreBillCollection.size() > 0) {
            baseInfo = srcCoreBillCollection.get(0);
            BOSObjectType bosType = baseInfo.getBOSType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo bo = loader.getEntity(bosType);
            PropertyCollection flds = bo.getInheritedPropertiesRuntime();
            int n = flds.size();
            for (int j = 0; j < n; ++j) {
                RelationshipInfo relation;
                PropertyInfo fld = flds.get(j);
                if (!(fld instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ((LinkPropertyInfo)fld).getRelationship()).getType()) || CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo)) || !CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo))) continue;
                list.add(fld.getName());
            }
        }
        return list;
    }

    public static boolean isNewObjectValue(Context ctx, IObjectValue model, ICoreBillBase iBillBase) throws BOSException, EASBizException {
        if (model == null) {
            throw new BOSException("Illegal argument error, model:" + model + ", iBillBase:" + iBillBase);
        }
        if (iBillBase == null) {
            IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)model.getBOSType());
            iBillBase = (ICoreBillBase)obj;
        }
        Object destBillIdPk = model.get(model.getPKField());
        String destBillId = null;
        if (destBillIdPk != null) {
            destBillId = destBillIdPk.toString();
        }
        boolean isNew = destBillId == null || !iBillBase.exists((IObjectPK)new ObjectUuidPK(destBillId));
        return isNew;
    }

    public static boolean isNewObjectValue(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return BOTAppTools.isNewObjectValue(ctx, model, null);
    }

    public static boolean isNeedSubmitReverseWrite(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return BOTPTools.getExtendPropertyBooleanValue(ctx, model, "isSubmitReverseWrite", true);
    }

    public static boolean isDelRelationsWithoutEntries(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return BOTPTools.getExtendPropertyBooleanValue(ctx, model, "isDelRelationsWithoutEntries", false);
    }

    public static String getEntityObjectInfoExtendPro(Context ctx, String bosTypeString, String extendProName) throws BOSException, BTPException {
        return BOTPTools.getEntityObjectInfoExtendPro(ctx, bosTypeString, extendProName);
    }

    public static BOTMappingInfo getMappingInfoByRelationInCache(Context ctx, BOTRelationInfo relationInfo) throws BOSException {
        if (relationInfo == null) {
            return null;
        }
        String botMappingId = relationInfo.getBOTMappingID();
        BOTMappingInfo botMappingInfo = null;
        if (botMappingId != null && botMappingId.length() > 0) {
            botMappingInfo = MappingCache.getInstance(ctx).getMappingInfo(botMappingId, ctx);
        }
        return botMappingInfo;
    }

    public static BOTMappingInfo getMappingInfoByRelation(Context ctx, BOTRelationInfo relationInfo) throws BOSException {
        if (relationInfo == null) {
            return null;
        }
        IBOTMapping iBotMapping = BOTMappingFactory.getLocalInstance(ctx);
        String botMappingId = relationInfo.getBOTMappingID();
        BOTMappingInfo botMappingInfo = null;
        if (botMappingId != null && botMappingId.length() > 0) {
            try {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)botMappingId));
                botMappingInfo = (BOTMappingInfo)iBotMapping.getValue((IObjectPK)pk);
            }
            catch (EASBizException e) {
                throw new BOSException("Error !" + e.getMessage(), (Throwable)e);
            }
            catch (UuidException e) {
                throw new BOSException("Error !" + e.getMessage(), (Throwable)e);
            }
        }
        return botMappingInfo;
    }

    public static boolean IsSaveBotpEntryRelation(Context ctx, IObjectValue srcModel, IObjectValue destModel) throws BOSException, EASBizException {
        return BOTPTools.getExtendPropertyBooleanValue(ctx, srcModel, "IsSaveBotpEntryRelation", true) || BOTPTools.getExtendPropertyBooleanValue(ctx, destModel, "IsSaveBotpEntryRelation", true);
    }

    public static boolean IsSaveBotpEntryRelation(Context ctx, EntityObjectInfo srcEntity, EntityObjectInfo destEntity) throws BOSException, EASBizException {
        return BOTPTools.getExtendPropertyBooleanValue(ctx, srcEntity, "IsSaveBotpEntryRelation", true) || BOTPTools.getExtendPropertyBooleanValue(ctx, destEntity, "IsSaveBotpEntryRelation", true);
    }
}

