/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.RowSet;

public class BTPDAO {
    private static final String srcEntryIDName = "FSrcEntryID";
    private static final String destEntryIDName = "FDestEntryID";

    private BTPDAO() {
    }

    public static Map getDestEntries(Context ctx, String srcBOSType, String destBOSType, String[] srcEntriesID) throws BOSException {
        HashMap<String, BOTRelationEntryCollection> destEntriesMap = new HashMap<String, BOTRelationEntryCollection>();
        if (srcEntriesID.length == 0) {
            return destEntriesMap;
        }
        StringBuffer sbSQL = new StringBuffer("");
        int paramNum = srcEntriesID.length + 2;
        Object[] params = new Object[paramNum];
        for (int i = 0; i < srcEntriesID.length; ++i) {
            if (i == 0) {
                sbSQL.append("select  FSrcEntryID,FDestEntryID,FID,FSrcObjectID,FDestObjectID,FSrcEntryPropName,FDestEntryPropName,FSrcPropertyName,FDestPropertyName,FValue,FKeyID from T_BOT_RelationEntry a where (FSrcEntryID = ? ");
            } else {
                sbSQL.append(" or  FSrcEntryID = ? ");
            }
            params[i] = srcEntriesID[i];
        }
        sbSQL.append(" ) and FKeyID in (select FID from T_BOT_Relation where FBOTMappingID in (select FID from T_BOT_Mapping where FSrcEntityName = ? and FDestEntityName = ?)) order by FSrcEntryID");
        params[paramNum - 2] = srcBOSType;
        params[paramNum - 1] = destBOSType;
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])params);
        String srcEntryID = "";
        BOTRelationEntryCollection rec = new BOTRelationEntryCollection();
        try {
            while (rowset.next()) {
                if (rowset.getString(srcEntryIDName) == null || rowset.getString(srcEntryIDName).length() <= 0 || rowset.getString(destEntryIDName) == null || rowset.getString(destEntryIDName).length() <= 0) continue;
                if (srcEntryID.equals(rowset.getString(srcEntryIDName))) {
                    rec.add(BTPDAO.makeRelationEntry((RowSet)rowset));
                    continue;
                }
                destEntriesMap.put(srcEntryID, rec);
                srcEntryID = rowset.getString(srcEntryIDName);
                rec = new BOTRelationEntryCollection();
                rec.add(BTPDAO.makeRelationEntry((RowSet)rowset));
            }
            if (srcEntryID.length() > 1) {
                destEntriesMap.put(srcEntryID, rec);
            }
            return destEntriesMap;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    private static BOTRelationEntryInfo makeRelationEntry(RowSet rowset) throws BOSException {
        BOTRelationEntryInfo into = new BOTRelationEntryInfo();
        try {
            into.setSrcObjectID(rowset.getString("FSrcObjectID"));
            into.setDestObjectID(rowset.getString("FDestObjectID"));
            into.setSrcEntryID(rowset.getString(srcEntryIDName));
            into.setSrcEntryPropName(rowset.getString("FSrcEntryPropName"));
            into.setDestEntryID(rowset.getString(destEntryIDName));
            into.setDestEntryPropName(rowset.getString("FDestPropertyName"));
            into.setValue(rowset.getString("FValue"));
            return into;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }
}

