/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.common.BaseCommonException;
import com.kingdee.eas.base.common.ProcessCardEntryCollection;
import com.kingdee.eas.base.common.ProcessCardEntryInfo;
import com.kingdee.eas.base.common.ProcessCardInfo;
import com.kingdee.eas.base.common.app.AbstractProcessCardControllerBean;
import com.kingdee.eas.base.common.app.ProcessStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class ProcessCardControllerBean
extends AbstractProcessCardControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.common.app.ProcessStepCardEntryControllerBean");

    @Override
    protected void _enable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("status"));
        selectors.add(new SelectorItemInfo("version"));
        selectors.add(new SelectorItemInfo("CU.id"));
        ProcessCardInfo info = this.getProcessCardInfo(ctx, pk);
        if (info.getStatus() == ProcessStatusEnum.ENABLE) {
            throw new BaseCommonException(BaseCommonException.INFO_ENABLE);
        }
        info.setStatus(ProcessStatusEnum.ENABLE);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    @Override
    protected void _disable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("status"));
        selectors.add(new SelectorItemInfo("version"));
        selectors.add(new SelectorItemInfo("CU.id"));
        ProcessCardInfo info = this.getProcessCardInfo(ctx, pk, selectors);
        if (info.getStatus() == ProcessStatusEnum.DISABLE) {
            throw new BaseCommonException(BaseCommonException.INFO_DISABLE);
        }
        info.setStatus(ProcessStatusEnum.DISABLE);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProcessCardInfo info = (ProcessCardInfo)model;
        this._checkNumberBlank(info);
        this._checkNameBlank(info);
        this._checkEntrysBlank(info);
        return super._addnew(ctx, model);
    }

    private void _checkNameBlank(ProcessCardInfo info) throws BOSException, EASBizException {
        String name = info.getName();
        if (name == null || name.equals("")) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
    }

    private void _checkNumberBlank(ProcessCardInfo info) throws EASBizException, BOSException {
        String number = info.getNumber();
        if (number == null || number.equals("")) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"number"});
        }
    }

    private void _checkEntrysBlank(ProcessCardInfo info) throws EASBizException {
        ProcessCardEntryCollection entrys = info.getEntrys();
        if (entrys.size() > 0) {
            ProcessCardEntryInfo entry = null;
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                if (!StringUtils.isEmpty((String)entry.getName()) && !StringUtils.isEmpty((String)entry.getNumber())) continue;
                throw new BaseCommonException(BaseCommonException.INFO_DISABLE);
            }
        }
    }
}

