/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class FileOperateUtil {
    private static Logger logger = Logger.getLogger(FileOperateUtil.class);
    private static String type = "AES";

    public static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure, boolean keepRoot) throws Exception {
        byte[] buf = new byte[10240];
        if (sourceFile.isFile()) {
            zos.putNextEntry(new ZipEntry(name));
            try (FileInputStream in = new FileInputStream(sourceFile);){
                int len;
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
            }
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (KeepDirStructure && keepRoot) {
                        FileOperateUtil.compress(file, zos, name + "/" + file.getName(), KeepDirStructure, true);
                        continue;
                    }
                    FileOperateUtil.compress(file, zos, file.getName(), KeepDirStructure, true);
                }
            }
        }
    }

    public static void compress(String sourceDir, String targetDir, String name, boolean KeepDirStructure) throws Exception {
        FileOutputStream out = new FileOutputStream(new File(targetDir + File.separatorChar + name + ".zip"));
        ZipOutputStream zos = null;
        File sourceFile = new File(sourceDir);
        try {
            zos = new ZipOutputStream(out);
            FileOperateUtil.compress(sourceFile, zos, sourceFile.getName(), KeepDirStructure, false);
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            FileUtils.deleteDirectory((File)sourceFile);
            if (zos != null) {
                zos.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        if (!dest.exists()) {
            dest.mkdir();
        }
        if (src.isDirectory()) {
            File[] files;
            File newFile = new File(dest, src.getName());
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            for (File file : files = src.listFiles()) {
                if (file.isFile()) {
                    FileInputStream fis = new FileInputStream(file);
                    FileOutputStream fos = new FileOutputStream(new File(newFile, file.getName()));
                    try {
                        int len;
                        byte[] b = new byte[1024];
                        while ((len = fis.read(b)) != -1) {
                            fos.write(b, 0, len);
                        }
                        continue;
                    }
                    finally {
                        fos.close();
                        fis.close();
                    }
                }
                if (!file.isDirectory()) continue;
                FileOperateUtil.copyFile(file, newFile);
            }
        } else {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                int len;
                fis = new FileInputStream(src);
                File dfile = new File(dest + File.separator + src.getName());
                if (!dfile.exists()) {
                    dfile.createNewFile();
                }
                fos = new FileOutputStream(dfile);
                byte[] b = new byte[1024];
                while ((len = fis.read(b)) != -1) {
                    fos.write(b, 0, len);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
        }
    }

    public static void delFolder(String folderPath) {
        try {
            FileOperateUtil.delAllFile(folderPath);
            File myFilePath = new File(folderPath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            String tempFile = path + File.separatorChar + tempList[i];
            temp = path.endsWith("/") ? new File(path + tempList[i]) : new File(tempFile);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileOperateUtil.delAllFile(tempFile);
            FileOperateUtil.delFolder(tempFile);
            flag = true;
        }
        return flag;
    }
}

