/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.common.util.DateUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class SysPatchsUtil {
    private static Logger logger = Logger.getLogger(SysPatchsUtil.class);
    static Object patchService;
    static Method getPatchList;
    static Method getPatchName;
    static Method getModuleName;
    static Method getApplyVersion;
    static Method getApplyScope;
    static Method getInstallDate;
    static Method getIssueDate;
    static Method getDependRelation;
    static Method getIsInstall;

    public static List<Map<String, String>> getPatchList(boolean hideDup, boolean onlyInstalled) throws BOSException, ConnRefusedException, Exception {
        HashMap patchMap = new HashMap();
        SysPatchsUtil.loadClasses();
        ArrayList<Map<String, String>> patchList = (ArrayList<Map<String, String>>)getPatchList.invoke(patchService, new Object[0]);
        if (patchList != null) {
            try {
                HashMap map = (HashMap)patchList.get(0);
                Iterator iterator = map.keySet().iterator();
                HashMap patchVOMap = null;
                while (iterator.hasNext()) {
                    Object info = map.get(iterator.next().toString());
                    Boolean b = (Boolean)getIsInstall.invoke(info, new Object[0]);
                    String module = (String)getModuleName.invoke(info, new Object[0]);
                    String installDate = (String)getInstallDate.invoke(info, new Object[0]);
                    if (onlyInstalled && b != null && !b.booleanValue() || module == null) continue;
                    LinkedList<HashMap> lst = (LinkedList<HashMap>)patchMap.get(module);
                    if (lst == null) {
                        lst = new LinkedList<HashMap>();
                        patchVOMap = new HashMap();
                        patchMap.put(module, lst);
                    } else {
                        if (hideDup && lst.size() > 0) {
                            patchVOMap = (HashMap)lst.get(0);
                            if (installDate != null && patchVOMap.get("installdate") != null && installDate.compareTo(patchVOMap.get("installdate").toString()) <= 0) continue;
                            lst.remove(0);
                        }
                        patchVOMap = new HashMap();
                    }
                    patchVOMap.put("isInstalled", b);
                    patchVOMap.put("modulename", module);
                    patchVOMap.put("patchname", getPatchName.invoke(info, new Object[0]));
                    patchVOMap.put("installdate", getInstallDate.invoke(info, new Object[0]));
                    patchVOMap.put("issuedate", getIssueDate.invoke(info, new Object[0]));
                    patchVOMap.put("dependrelation", getDependRelation.invoke(info, new Object[0]));
                    patchVOMap.put("applyscope", getApplyScope.invoke(info, new Object[0]));
                    patchVOMap.put("applyversion", getApplyVersion.invoke(info, new Object[0]));
                    lst.add(patchVOMap);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        } else {
            throw new ConnRefusedException("Connection refused,please start admin Console");
        }
        if (patchMap.size() > 0) {
            Collection values = patchMap.values();
            Iterator itr = values.iterator();
            ArrayList<Map<String, String>> lst = new ArrayList<Map<String, String>>();
            while (itr.hasNext()) {
                lst.addAll((Collection)itr.next());
            }
            patchList = lst;
            for (int i = 0; i < patchList.size(); ++i) {
                String installdate = (String)((Map)patchList.get(i)).get("installdate");
                if (StringUtils.isNotEmpty((String)installdate)) {
                    try {
                        Date date = DateUtils.parseCustomDateString(installdate, "yyyy-MM-dd_HH-mm-ss");
                        ((Map)patchList.get(i)).put("installdate", DateUtils.getCustomDateString(date, "yyyy-MM-dd HH:mm:ss"));
                    }
                    catch (Exception e) {
                        ((Map)patchList.get(i)).put("installdate", installdate);
                        logger.error((Object)e);
                    }
                    continue;
                }
                ((Map)patchList.get(i)).put("installdate", "");
            }
            return patchList;
        }
        return null;
    }

    public static List<Map<String, String>> getPatchList() throws BOSException, ConnRefusedException, Exception {
        return SysPatchsUtil.getPatchList(false, false);
    }

    private static void loadClasses() throws BOSException, ConnRefusedException {
        if (getPatchList == null) {
            try {
                String home = System.getProperty("EAS_HOME");
                String adminhome = home + "/admin/plugins/";
                String filePath = adminhome + "admin.domain_1.0.0.jar";
                File file = new File(filePath);
                URL[] urls = new URL[2];
                if (file.exists()) {
                    urls[0] = file.toURI().toURL();
                }
                if ((file = new File(filePath = adminhome + "admin.framework_1.0.0.jar")).exists()) {
                    urls[1] = file.toURI().toURL();
                }
                URLClassLoader loader = new URLClassLoader(urls);
                String srvcfgFile = home + "/admin/config/server_app.xml";
                String port = "10061";
                try {
                    SAXReader reader = new SAXReader();
                    Document document = reader.read(new File(srvcfgFile));
                    Node node = document.selectSingleNode("/application/preference/preference/preference/port");
                    if (node != null && node.getText() != null) {
                        port = node.getText().trim();
                        System.out.println("dualrpc port:" + port);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                URI ssapServerURL = new URI("drpc://localhost:" + port);
                Class<?> serviceAccessorClass = loader.loadClass("com.kingdee.eas.tools.admin.framework.ssap.ServiceAccessor");
                Class<?> sessionlistener = loader.loadClass("com.kingdee.eas.tools.admin.framework.ssap.SessionListener");
                Class<?> vo = loader.loadClass("com.kingdee.eas.tools.admin.domain.patch.vo.VoEASPatchInfo");
                Method getinst = serviceAccessorClass.getMethod("getInstance", String.class, sessionlistener);
                Object defaultServiceAccessor = getinst.invoke(null, ssapServerURL.toString(), null);
                Method lookup = defaultServiceAccessor.getClass().getMethod("lookup", Class.class);
                patchService = lookup.invoke(defaultServiceAccessor, loader.loadClass("com.kingdee.eas.tools.admin.domain.PatchManagerService"));
                getPatchList = patchService.getClass().getMethod("getPatchList", new Class[0]);
                getPatchName = vo.getMethod("getPatchName", new Class[0]);
                getModuleName = vo.getMethod("getModuleName", new Class[0]);
                getApplyVersion = vo.getMethod("getApplyVersion", new Class[0]);
                getApplyScope = vo.getMethod("getApplyScope", new Class[0]);
                getInstallDate = vo.getMethod("getInstallDate", new Class[0]);
                getIssueDate = vo.getMethod("getIssueDate", new Class[0]);
                getDependRelation = vo.getMethod("getDependRelation", new Class[0]);
                getIsInstall = vo.getMethod("getIsInstall", new Class[0]);
            }
            catch (Exception e) {
                throw new ConnRefusedException("Connection refused, please start admin Console");
            }
        }
    }

    public static class ConnRefusedException
    extends Exception {
        public ConnRefusedException(String msg) {
            super(msg);
            logger.error((Object)msg);
        }
    }
}

