/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.common.util;

import com.kingdee.util.StringUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;

public class ZipComplexCipherUtil {
    public static String compress(String destFileName, String passwd, File ... files) {
        if (StringUtils.isEmpty((String)passwd)) {
            passwd = ZipComplexCipherUtil.genPassWord();
        }
        try {
            ZipFile zipFile = new ZipFile(destFileName);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(CompressionMethod.DEFLATE);
            parameters.setCompressionLevel(CompressionLevel.NORMAL);
            if (!StringUtils.isEmpty((String)passwd)) {
                parameters.setEncryptFiles(true);
                parameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
                zipFile.setPassword(passwd.toCharArray());
            }
            for (File file : files) {
                zipFile.addFile(file, parameters);
            }
            return destFileName;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String compress(String destFileName, String passwd, String ... filePaths) {
        int size = filePaths.length;
        File[] files = new File[size];
        for (int i = 0; i < size; ++i) {
            files[i] = new File(filePaths[i]);
        }
        return ZipComplexCipherUtil.compress(destFileName, passwd, files);
    }

    public static String compressFolder(String destFileName, String passwd, String folder) {
        File folderParam = new File(folder);
        if (folderParam.isDirectory()) {
            File[] files = folderParam.listFiles();
            return ZipComplexCipherUtil.compress(destFileName, passwd, files);
        }
        return null;
    }

    public static File[] deCompress(File zipFile, String dest, String passwd) throws ZipException {
        File destDir = new File(dest);
        if (destDir.isDirectory() && !destDir.exists()) {
            destDir.mkdir();
        }
        ZipFile zFile = new ZipFile(zipFile);
        zFile.setCharset(Charset.forName("UTF-8"));
        if (!zFile.isValidZipFile()) {
            throw new ZipException("The compressed file is illegal, and may be damaged");
        }
        if (zFile.isEncrypted()) {
            zFile.setPassword(passwd.toCharArray());
        }
        zFile.extractAll(dest);
        List headerList = zFile.getFileHeaders();
        ArrayList<File> extractedFileList = new ArrayList<File>();
        for (FileHeader fileHeader : headerList) {
            if (fileHeader.isDirectory()) continue;
            extractedFileList.add(new File(destDir, fileHeader.getFileName()));
        }
        File[] extractedFiles = new File[extractedFileList.size()];
        extractedFileList.toArray(extractedFiles);
        return extractedFiles;
    }

    public static File[] deCompress(File zipFile, String dest) {
        try {
            return ZipComplexCipherUtil.deCompress(zipFile, dest, null);
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File[] deCompress(String zipFilePath, String dest, String passwd) {
        try {
            return ZipComplexCipherUtil.deCompress(new File(zipFilePath), dest, passwd);
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File[] deCompress(String zipFilePath, String dest) {
        try {
            return ZipComplexCipherUtil.deCompress(new File(zipFilePath), dest, null);
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String genPassWord() {
        Date now = new Date();
        SimpleDateFormat formate = new SimpleDateFormat("yyyyMMdd");
        String dateNow = "kdeasc" + formate.format(now);
        return dateNow;
    }
}

