/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.AbstractEvsApiFacadeControllerBean;
import com.kingdee.eas.base.evs.app.apiservice.BeUnitServiceFacadeFactory;
import com.kingdee.eas.base.evs.app.apiservice.BizUnitServiceFacadeFactory;
import com.kingdee.eas.base.evs.app.apiservice.GLUnitServiceFacadeFactory;
import com.kingdee.eas.base.evs.app.apiservice.InvoiceUnitServiceFacadeFactory;
import com.kingdee.eas.base.evs.app.apiservice.api.EvsApiService;
import com.kingdee.eas.base.evs.app.apiservice.api.Message;
import com.kingdee.eas.base.evs.app.logmonitor.ApiCalledLogFactory;
import com.kingdee.eas.base.evs.app.logmonitor.ApiCalledLogInfo;
import com.kingdee.eas.base.evs.util.CheckUtil;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class EvsApiFacadeControllerBean
extends AbstractEvsApiFacadeControllerBean
implements EvsApiService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.evs.app.apiservice.EvsApiFacadeControllerBean");

    @Override
    protected String _push(Context ctx, String jsondatas) throws BOSException, EASBizException {
        try {
            int ssc_base_evs_LicenseCheck = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).licenseCheck("SSC_BASE_EVS");
            int ssc_evs_LicenseCheck = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).licenseCheck("SSC_EVS");
            int evs_LicenseCheck = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).licenseCheck("EVS");
            if (ssc_base_evs_LicenseCheck == 1 || evs_LicenseCheck == 1 || ssc_evs_LicenseCheck == 1) {
                return this.pushData(ctx, jsondatas);
            }
            throw new EASBizException(new NumericExceptionSubItem("0001", "\u7f3a\u5c11\u7535\u5b50\u51ed\u8bc1\u6c60\u6a21\u5757\u8bb8\u53ef\uff01"));
        }
        catch (EASBizException e) {
            return Message.error(e.getMessage());
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
            return Message.error();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushData(Context ctx, String jsondatas) throws BOSException, EASBizException {
        JSONObject jsonObject = JSONObject.parseObject((String)jsondatas);
        String dataTypeString = (String)jsonObject.get((Object)"DataType");
        if (StringUtils.isEmpty((String)dataTypeString)) {
            return Message.error(CheckUtil.checkNULL(ctx, "DataType"));
        }
        int dataType = Integer.parseInt(dataTypeString);
        String result = "";
        try {
            switch (dataType) {
                case 0: {
                    result = GLUnitServiceFacadeFactory.getLocalInstance(ctx).dataProcess(jsondatas);
                    break;
                }
                case 1: {
                    result = BizUnitServiceFacadeFactory.getLocalInstance(ctx).dataProcess(jsondatas);
                    break;
                }
                case 2: {
                    result = BeUnitServiceFacadeFactory.getLocalInstance(ctx).dataProcess(jsondatas);
                    break;
                }
                case 3: {
                    result = BeUnitServiceFacadeFactory.getLocalInstance(ctx).dataProcess(jsondatas);
                    break;
                }
                case 4: {
                    result = InvoiceUnitServiceFacadeFactory.getLocalInstance(ctx).dataProcess(jsondatas);
                    break;
                }
                default: {
                    result = Message.error(CheckUtil.checkSup(ctx, "DataType"));
                }
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            result = Message.error("EAS\u53d1\u751f\u4e86\u672a\u77e5\u7684\u5f02\u5e38,\u8bf7\u8054\u7cfb\u8fd0\u7ef4");
            logger.error((Object)e, e);
            String string = result;
            return string;
        }
        finally {
            try {
                ApiCalledLogInfo logInfo = new ApiCalledLogInfo();
                logInfo.setCompanyName(jsonObject.getString("NameOfAccountingEntity"));
                logInfo.setCreaditCode(jsonObject.getString("UnifiedSocialCreditCodeOfAccountingEntity"));
                logInfo.setDataType(dataTypeString);
                logInfo.setInvoiceType(jsonObject.getString("InvoiceType"));
                logInfo.setOriData(jsonObject.getString("Datas"));
                logInfo.setRandomCode(jsonObject.getString("RandomCode"));
                logInfo.setResult(result);
                ApiCalledLogFactory.getLocalInstance(ctx).addnewReuiredNew(logInfo);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

