/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.api.DataProcessUtil;
import com.kingdee.eas.base.evs.app.apiservice.api.Message;
import com.kingdee.eas.base.evs.app.apiservice.process.IProcessor;
import com.kingdee.eas.base.evs.app.datapool.BkrsInvoiceEntryUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.BkrsInvoiceEntryUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.BkrsInvoiceUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.BkrsInvoiceUnitFactory;
import com.kingdee.eas.base.evs.app.datapool.BkrsInvoiceUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.CompanyInfo;
import com.kingdee.eas.base.evs.app.datapool.DataRangeInfo;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.CheckUtil;
import com.kingdee.eas.base.evs.util.EVSSet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BkrsProcessor
implements IProcessor {
    private Logger logger = Logger.getLogger(BkrsProcessor.class);

    @Override
    public void checkRequired(Context ctx, JSONObject jsonObject) throws EASBizException {
        EVSSet evsSet1 = EVSSet.builder().add("UnifiedSocialCreditCodeOfAccountingEntity").add("NameOfAccountingEntity").add("PeriodNumber").add("PeriodYear");
        CheckUtil.checkNULL(ctx, (Map)jsonObject, evsSet1.get());
        EVSSet evsSet = EVSSet.builder().add("ReserveBalanceAtTheEndOfReconciliationCycle").add("YearOfBankReconciliationStatement").add("CustomerSettlementBankAccount").add("Currency").add("NumberOfBankBranch").add("NameOfCustomerAccount").add("OverdraftBalanceAtEndOfReconciliationCycle").add("MonthOfBankReconciliationStatement").add("AccountBalanceAtTheEndOfReconciliationCycleAmount").add("PK").add("FrozenBalanceAtTheEndOfReconciliationCycle").add("AvailableBalanceAtTheEndOfReconciliationCycleAmount");
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            CheckUtil.checkNULL(ctx, bill, evsSet.get());
        }
        HashSet<String> checkDupDateSet = new HashSet<String>();
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            if (checkDupDateSet.contains(bill.get("PK") + "")) {
                this.logger.error((Object)("BkrsProcessor\u88ab\u4e22\u5f03\u7684\u91cd\u590d\u6570\u636e\uff1a" + bill.get("PK")));
                datas.remove(i);
                --i;
            }
            checkDupDateSet.add(bill.get("PK") + "");
        }
    }

    @Override
    public String process(Context ctx, JSONObject jsonObject) throws BOSException, EASBizException {
        CoreBaseCollection colls = new CoreBaseCollection();
        CompanyInfo companyInfo = DataProcessUtil.processCompany(ctx, jsonObject);
        DataRangeInfo dataRangeInfo = DataProcessUtil.processDataRange(ctx, jsonObject, companyInfo);
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            BkrsInvoiceUnitCollection oldUnit = BkrsInvoiceUnitFactory.getLocalInstance(ctx).getBkrsInvoiceUnitCollection("where billPK = '" + bill.get("PK") + "'");
            BkrsInvoiceUnitInfo unitInfo = new BkrsInvoiceUnitInfo();
            if (oldUnit != null && oldUnit.size() > 0) {
                unitInfo.setId(oldUnit.get(0).getId());
            }
            unitInfo.setPrintTimes(AS.valueOf(bill.get("PrintTimes"), ""));
            unitInfo.setReserveBalanceAtTheEnd(AS.valueOf(bill.get("ReserveBalanceAtTheEndOfReconciliationCycle"), ""));
            unitInfo.setYearOfBankReconciliation(AS.valueOf(bill.get("YearOfBankReconciliationStatement"), ""));
            unitInfo.setIdentificationCodeOfIssuer(AS.valueOf(bill.get("IdentificationCodeOfIssuer"), ""));
            unitInfo.setCustomerSettlementBankAccount(AS.valueOf(bill.get("CustomerSettlementBankAccount"), ""));
            unitInfo.setPrintDate(AS.valueOf(bill.get("PrintDate"), ""));
            unitInfo.setBillPK(AS.valueOf(bill.get("PK"), ""));
            unitInfo.setBillNumber(AS.valueOf(bill.get("BillNumber"), ""));
            unitInfo.setCurrency(AS.valueOf(bill.get("Currency"), ""));
            unitInfo.setNumberOfBankBranch(AS.valueOf(bill.get("NumberOfBankBranch"), ""));
            unitInfo.setNameOfCustomerAccount(AS.valueOf(bill.get("NameOfCustomerAccount"), ""));
            unitInfo.setOverdraftBalanceAtEnd(AS.valueOf(bill.get("OverdraftBalanceAtEndOfReconciliationCycle"), ""));
            unitInfo.setMonthOfBankReconciliation(AS.valueOf(bill.get("MonthOfBankReconciliationStatement"), ""));
            unitInfo.setAccountBalanceAtTheEnd(AS.valueOf(bill.get("AccountBalanceAtTheEndOfReconciliationCycleAmount"), ""));
            unitInfo.setFrozenBalanceAtTheEnd(AS.valueOf(bill.get("FrozenBalanceAtTheEndOfReconciliationCycle"), ""));
            unitInfo.setCodeOfBankCustomer(AS.valueOf(bill.get("CodeOfBankCustomer"), ""));
            unitInfo.setAvailableBalanceAtTheEnd(AS.valueOf(bill.get("AvailableBalanceAtTheEndOfReconciliationCycleAmount"), ""));
            unitInfo.setFileName(AS.valueOf(bill.get("FileName")));
            JSONArray entry = (JSONArray)bill.get("InformationOfReconcileDetailsTuple");
            BkrsInvoiceEntryUnitCollection entryUnitCollection = new BkrsInvoiceEntryUnitCollection();
            for (int j = 0; j < entry.size(); ++j) {
                Map map = (Map)entry.get(j);
                BkrsInvoiceEntryUnitInfo entryUnitInfo = new BkrsInvoiceEntryUnitInfo();
                entryUnitInfo.setBookkeepingTime(AS.valueOf(map.get("TimeOfBookkeeping"), ""));
                entryUnitInfo.setSourceDocumentType(AS.valueOf(map.get("TypeOfSourceDocument"), ""));
                entryUnitInfo.setCreditOrDebit(AS.valueOf(map.get("IdentificationOfCreditOrDebit"), ""));
                entryUnitInfo.setBusinessSerialNumber(AS.valueOf(map.get("BusinessSerialNumber"), ""));
                entryUnitInfo.setAccountBalance(AS.valueOf(map.get("AccountBalance"), ""));
                entryUnitInfo.setBookKeepingDate(AS.valueOf(map.get("DateOfBookkeeping"), ""));
                entryUnitInfo.setTransactionCode(AS.valueOf(map.get("TransactionCode"), ""));
                entryUnitInfo.setReceiptNumber(AS.valueOf(map.get("NumberOfBankElectronicReceipt"), ""));
                entryUnitInfo.setDebitOrCreditOfBalance(AS.valueOf(map.get("DebitOrCreditOfBalance"), ""));
                entryUnitInfo.setReceiptNotes(AS.valueOf(map.get("NotesOfBankElectronicReceipt"), ""));
                entryUnitInfo.setSourceDocumentNumber(AS.valueOf(map.get("NumberOfSourceDocument"), ""));
                entryUnitInfo.setAccountOfCounterparty(AS.valueOf(map.get("AccountOfCounterparty"), ""));
                entryUnitInfo.setDepositoryBankOfCounterparty(AS.valueOf(map.get("DepositoryBankOfCounterparty"), ""));
                entryUnitInfo.setBusinessProType(AS.valueOf(map.get("TypesOfBusinessProducts"), ""));
                entryUnitInfo.setCounterpartyName(AS.valueOf(map.get("NameOfCounterparty"), ""));
                entryUnitInfo.setTransactionAmount(AS.valueOf(map.get("TransactionAmount"), ""));
                entryUnitInfo.setAccountOfBookkeepingJournal(AS.valueOf(map.get("JournalAccountOfBookkeeping"), ""));
                entryUnitInfo.setBookkeeper(AS.valueOf(map.get("Bookkeeper"), ""));
                entryUnitInfo.setOtherAccountingInformation(AS.valueOf(map.get("OtherAccountingInformation"), ""));
                entryUnitCollection.add(entryUnitInfo);
            }
            unitInfo.put("entry", (Object)entryUnitCollection);
            unitInfo.setDataRange(dataRangeInfo);
            DataProcessUtil.fillAuditData(ctx, unitInfo);
            colls.add((CoreBaseInfo)unitInfo);
        }
        if (!colls.isEmpty()) {
            BkrsInvoiceUnitFactory.getLocalInstance(ctx).saveBatchData(colls);
        }
        return Message.success();
    }
}

