/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice.process.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.api.DataProcessUtil;
import com.kingdee.eas.base.evs.app.apiservice.api.Message;
import com.kingdee.eas.base.evs.app.apiservice.process.IProcessor;
import com.kingdee.eas.base.evs.app.datapool.CompanyInfo;
import com.kingdee.eas.base.evs.app.datapool.InvoiceUnitBillCollection;
import com.kingdee.eas.base.evs.app.datapool.InvoiceUnitBillInfo;
import com.kingdee.eas.base.evs.app.datapool.SpclInvoiceUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.SpclInvoiceUnitFactory;
import com.kingdee.eas.base.evs.app.datapool.SpclInvoiceUnitInfo;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.CheckUtil;
import com.kingdee.eas.base.evs.util.EVSSet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpclInvoiceProcessor
implements IProcessor {
    private Logger logger = Logger.getLogger(SpclInvoiceProcessor.class);

    @Override
    public void checkRequired(Context ctx, JSONObject jsonObject) throws EASBizException {
        EVSSet evsSet = EVSSet.builder().add("UniqueCodeOfInvoice").add("NameOfSeller").add("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller").add("TotalAmountExcludingTax").add("TotalTaxAmount").add("TaxIncludedAmountInFigures").add("DateOfIssue").add("WhetherInvoiceIsRedInvoice").add("WhetherInvoiceHasBeenChecked").add("UniquePK");
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            CheckUtil.checkNULL(ctx, bill, evsSet.get());
        }
        HashSet<String> checkDupDateSet = new HashSet<String>();
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            if (checkDupDateSet.contains(bill.get("UniquePK") + "")) {
                this.logger.error((Object)("SpclInvoiceProcessor\u88ab\u4e22\u5f03\u7684\u91cd\u590d\u6570\u636e\uff1a" + bill.get("UniquePK")));
                datas.remove(i);
                --i;
            }
            checkDupDateSet.add(bill.get("UniquePK") + "");
        }
    }

    @Override
    public String process(Context ctx, JSONObject jsonObject) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        CompanyInfo companyInfo = DataProcessUtil.processCompany(ctx, jsonObject);
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            SpclInvoiceUnitCollection oldUnit = SpclInvoiceUnitFactory.getLocalInstance(ctx).getSpclInvoiceUnitCollection("where uniquePK = '" + bill.get("UniquePK") + "'");
            SpclInvoiceUnitInfo unitInfo = new SpclInvoiceUnitInfo();
            if (oldUnit != null && oldUnit.size() > 0) {
                unitInfo.setId(oldUnit.get(0).getId());
            }
            unitInfo.setUniqueCode(AS.valueOf(bill.get("UniqueCodeOfInvoice"), ""));
            unitInfo.setDeduction(AS.valueOf(bill.get("WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted"), ""));
            unitInfo.setConfirmedUse(AS.valueOf(bill.get("WhetherInvoiceUsageHasBeenConfirmed"), ""));
            unitInfo.setMatchingState(AS.valueOf(bill.get("MatchingStateBetweenBusinessDocumentsAndVatEInvoice"), ""));
            unitInfo.setContractNumber(AS.valueOf(bill.get("ContractNumber"), ""));
            unitInfo.setPaid(AS.valueOf(bill.get("WhetherInvoiceHasBeenPaid"), ""));
            unitInfo.setBankEleReceiptNum(AS.valueOf(bill.get("NumberOfBankElectronicReceipt"), ""));
            unitInfo.setIsInputVatTransOut(AS.valueOf(bill.get("WhetherInputVatHasBeenTransferredOut"), ""));
            unitInfo.setPretaxdudectBeginyear(AS.valueOf(bill.get("BeginningOfPreTaxDeductionYearOfIncomeTax"), ""));
            unitInfo.setPretaxdudectEndyear(AS.valueOf(bill.get("EndOfPreTaxDeductionYearOfIncomeTax"), ""));
            unitInfo.setExpPeriodBegin(AS.valueOf(bill.get("BeginningOfExpenditurePeriodUnderAccrualBasis"), ""));
            unitInfo.setExpPeriodEnd(AS.valueOf(bill.get("EndOfExpenditurePeriodUnderAccrualBasis"), ""));
            unitInfo.setDepmethod(AS.valueOf(bill.get("DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets"), ""));
            unitInfo.setUsage(AS.valueOf(bill.get("UsageConfirmation"), ""));
            unitInfo.setUsagePeriod(AS.valueOf(bill.get("PeriodOfUsageConfirmation"), ""));
            unitInfo.setTranOutInputVat(AS.valueOf(bill.get("AmountOfTransferredOutInputVat"), ""));
            unitInfo.setNameOfSeller(AS.valueOf(bill.get("NameOfSeller"), ""));
            unitInfo.setCreditCodeOfSeller(AS.valueOf(bill.get("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller"), ""));
            unitInfo.setTotalAmountExcludingTax(AS.valueOf(bill.get("TotalAmountExcludingTax"), ""));
            unitInfo.setTotalTaxAmount(AS.valueOf(bill.get("TotalTaxAmount"), ""));
            unitInfo.setTaxIncludedAmount(AS.valueOf(bill.get("TaxIncludedAmountInFigures"), ""));
            unitInfo.setIssueDate(AS.valueOf(bill.get("DateOfIssue"), ""));
            unitInfo.setFsOrAbs(AS.valueOf(bill.get("WhetherInvoiceHasBeenFactoredSoldOrSecuritized"), ""));
            unitInfo.setIsRedInvoice(AS.valueOf(bill.get("WhetherInvoiceIsRedInvoice"), ""));
            unitInfo.setHasBeenChecked(AS.valueOf(bill.get("WhetherInvoiceHasBeenChecked"), ""));
            unitInfo.setUniquePK(AS.valueOf(bill.get("UniquePK"), ""));
            unitInfo.setInvoiceCode(AS.valueOf(bill.get("InvoiceCode"), ""));
            unitInfo.setInvoiceNO(AS.valueOf(bill.get("InvoiceNO"), ""));
            unitInfo.setSerialNO(AS.valueOf(bill.get("SerialNO"), ""));
            unitInfo.setInvoiceType(AS.valueOf(bill.get("InvoiceType"), ""));
            unitInfo.setInvoiceTypeName(AS.valueOf(bill.get("InvoiceTypeName"), ""));
            unitInfo.setOriginalurl(AS.valueOf(bill.get("Originalurl"), ""));
            unitInfo.setPdfurl(AS.valueOf(bill.get("Pdfurl"), ""));
            unitInfo.setSnapshoturl(AS.valueOf(bill.get("Snapshoturl"), ""));
            unitInfo.setXbrlurl(AS.valueOf(bill.get("IssuerXbrlurl"), ""));
            unitInfo.setXbrlname(AS.valueOf(bill.get("IssuerXbrlName"), ""));
            InvoiceUnitBillCollection billEntry = new InvoiceUnitBillCollection();
            String[] bills = AS.valueOf(bill.get("Bills"), "").split(",");
            for (int j = 0; j < bills.length; ++j) {
                InvoiceUnitBillInfo info = new InvoiceUnitBillInfo();
                info.setBillId(bills[j]);
                billEntry.add(info);
            }
            unitInfo.put("bill", (Object)billEntry);
            unitInfo.setCompany(companyInfo);
            DataProcessUtil.fillAuditData(ctx, unitInfo);
            colls.add((CoreBaseInfo)unitInfo);
        }
        if (!colls.isEmpty()) {
            SpclInvoiceUnitFactory.getLocalInstance(ctx).saveBatchData(colls);
        }
        return Message.success();
    }
}

