/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter.voucher.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.voucher.AbstractVoucherDataConverter;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryInfo;
import com.kingdee.eas.base.evs.app.elcertificate.OrdInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.OrdInvoiceInfo;
import com.kingdee.eas.base.evs.app.elcertificate.helper.EleCertificatePoolHelperFactory;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class OrdInvoiceConverter
extends AbstractVoucherDataConverter {
    @Override
    public String getSql() {
        String sql = "select a.FUniqueCode,a.FpreTaxDedCompleted,a.fpretaxdudectBeginyear,a.FPretaxdudectEndyear,a.fexpPeriodBegin,a.FexpPeriodEnd,c.FcontractNumber FcontractNumber,c.FHasBeenPaid fpaid,c.FReceipt fbankEleReceiptNum,c.FMatchingState FmatchingState,c.FDepreciation FDepmethod,a.FNameOfSeller,a.FcreditCodeOfSeller, a.ftotalAmExcludTax,a.ftotalTaxAmount,a.taxInAmInFigures,a.fDateOfIssue,c.FFactoredSoldSecuritized ffsOrAbs,a.FUniquePK,c.FHasBeenBooked,g.FCompanyName,g.FCompanyCreaditCode,isnull(a.FIsRedInvoice,c.FRedInvoice) FRedInvoice,isnull(a.FHasBeenChecked,c.FHasBeenChecked) FHasBeenChecked,d.FVoucherId,e.FVoucherNumber,a.FXbrlurl,a.FXbrlname,f.FPeriodNumber,f.FPeriodYear from T_EVS_OrdInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK inner join T_EVS_DataRange f on e.FDataRangeId = f.fid inner join T_EVS_Company g on g.fid = f.FCompanyId ";
        return sql;
    }

    @Override
    public Map<String, Map<String, JSONObject>> getInformationOfAccountingDocumentsTuple(Context ctx, IRowSet rowSet) throws Exception {
        ArrayList<String> uniqueCodes = new ArrayList<String>();
        ArrayList<String> vouchers = new ArrayList<String>();
        while (rowSet.next()) {
            uniqueCodes.add(rowSet.getString("FUniqueCode"));
            vouchers.add(rowSet.getString("FVoucherId"));
        }
        String sql = "select a.FUniqueCode, d.FVoucherId from T_EVS_OrdInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK where a.FUniqueCode in (" + SQLUtils.getSQL(uniqueCodes) + ") and d.FVoucherId in (" + SQLUtils.getSQL(vouchers) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return this.getInformationOfAccountingDocumentsTuple0(ctx, rs);
    }

    @Override
    public void saveData(Context ctx, int periodYear, int periodNumber, IRowSet rowSet, Map<String, Map<String, JSONObject>> informationOfAccountingDocumentsTuple) throws Exception {
        CoreBaseCollection collection = new CoreBaseCollection();
        String taxNumber = "";
        HashSet<String> uniqueCodeSet = new HashSet<String>();
        HashSet<String> voucherNumberSet = new HashSet<String>();
        HashMap<String, OrdInvoiceInfo> ordMap = new HashMap<String, OrdInvoiceInfo>();
        while (rowSet.next()) {
            String fUniqueCode = rowSet.getString("FUniqueCode");
            String fVoucherNumber = rowSet.getString("FVoucherNumber");
            OrdInvoiceInfo invoiceInfo = null;
            if (uniqueCodeSet.contains(fUniqueCode)) {
                if (voucherNumberSet.contains(fUniqueCode + fVoucherNumber)) continue;
                invoiceInfo = (OrdInvoiceInfo)ordMap.get(fUniqueCode);
                invoiceInfo.setVoucherNumbers(invoiceInfo.getVoucherNumbers() + "," + fVoucherNumber);
                voucherNumberSet.add(fUniqueCode + fVoucherNumber);
                continue;
            }
            invoiceInfo = new OrdInvoiceInfo();
            ordMap.put(fUniqueCode, invoiceInfo);
            uniqueCodeSet.add(fUniqueCode);
            voucherNumberSet.add(fUniqueCode + fVoucherNumber);
            invoiceInfo.setUniquePK(fUniqueCode);
            invoiceInfo.setUniqueCode(fUniqueCode);
            invoiceInfo.setPreTaxDedCompleted(rowSet.getString("FpreTaxDedCompleted"));
            invoiceInfo.setPretaxdudectBeginyear(rowSet.getString("fpretaxdudectBeginyear"));
            invoiceInfo.setPretaxdudectEndyear(rowSet.getString("FPretaxdudectEndyear"));
            invoiceInfo.setExpPeriodBegin(rowSet.getString("fexpPeriodBegin"));
            invoiceInfo.setExpPeriodEnd(rowSet.getString("FexpPeriodEnd"));
            invoiceInfo.setContractNumber(rowSet.getString("FcontractNumber"));
            invoiceInfo.setPaid(rowSet.getString("fpaid"));
            invoiceInfo.setBankEleReceiptNum(rowSet.getString("fbankEleReceiptNum"));
            invoiceInfo.setMatchingState(rowSet.getString("FmatchingState"));
            invoiceInfo.setDepmethod(rowSet.getString("FDepmethod"));
            invoiceInfo.setNameOfSeller(rowSet.getString("FNameOfSeller"));
            invoiceInfo.setCreditCodeOfSeller(rowSet.getString("FcreditCodeOfSeller"));
            invoiceInfo.setTotalAmExcludTax(rowSet.getString("ftotalAmExcludTax"));
            invoiceInfo.setTotalTaxAmount(rowSet.getString("ftotalTaxAmount"));
            invoiceInfo.setTaxInAmInFigures(rowSet.getString("taxInAmInFigures"));
            invoiceInfo.setDateOfIssue(rowSet.getString("fDateOfIssue"));
            invoiceInfo.setFsOrAbs(rowSet.getString("ffsOrAbs"));
            invoiceInfo.setHasBeenBooked(rowSet.getString("FHasBeenBooked"));
            invoiceInfo.setAccountName(rowSet.getString("FCompanyName"));
            String fCompanyCreaditCode = rowSet.getString("FCompanyCreaditCode");
            taxNumber = StringUtils.isEmpty((String)taxNumber) ? fCompanyCreaditCode : taxNumber;
            invoiceInfo.setCreditCode(fCompanyCreaditCode);
            invoiceInfo.setRedInvoice(rowSet.getString("FRedInvoice"));
            invoiceInfo.setHasBeenChecked(rowSet.getString("FHasBeenChecked"));
            Map<String, JSONObject> map = informationOfAccountingDocumentsTuple.get(invoiceInfo.getUniqueCode());
            JSONArray array = new JSONArray();
            InvoiceVoucherEntryCollection voucherEntryCollection = new InvoiceVoucherEntryCollection();
            for (Map.Entry<String, JSONObject> entry : map.entrySet()) {
                InvoiceVoucherEntryInfo voucherEntryInfo = new InvoiceVoucherEntryInfo();
                voucherEntryInfo.setVoucherId(entry.getKey());
                voucherEntryCollection.add(voucherEntryInfo);
                array.add((Object)entry.getValue());
            }
            invoiceInfo.setVoucher(array.toJSONString());
            invoiceInfo.put("voucherEntry", (Object)voucherEntryCollection);
            invoiceInfo.setVoucherNumbers(fVoucherNumber);
            invoiceInfo.setIssureXbrlUrl(rowSet.getString("FXbrlurl"));
            invoiceInfo.setIssureXbrlName(rowSet.getString("FXbrlname"));
            invoiceInfo.setPeriodYear(rowSet.getInt("FPeriodYear"));
            invoiceInfo.setPeriodNumber(rowSet.getInt("FPeriodNumber"));
            collection.add((CoreBaseInfo)invoiceInfo);
        }
        if (!uniqueCodeSet.isEmpty()) {
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_InvoiceVoucherEntry where FParentID in (select fid from T_EVS_OrdInvoice where FUniqueCode in (" + SQLUtils.getSQL(uniqueCodeSet) + ") and FPeriodYear = ? and FPeriodNumber = ?)"), (Object[])new Object[]{periodYear, periodNumber});
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_OrdInvoice where FUniqueCode in (" + SQLUtils.getSQL(uniqueCodeSet) + ") and FPeriodYear = ? and FPeriodNumber = ?"), (Object[])new Object[]{periodYear, periodNumber});
            EleCertificatePoolHelperFactory.getInstance(ctx, "inv_ord").syncExportRecord2New(ctx, collection, periodYear, periodNumber, taxNumber, uniqueCodeSet);
            OrdInvoiceFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
    }
}

