/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter.voucher.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.voucher.AbstractVoucherDataConverter;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryInfo;
import com.kingdee.eas.base.evs.app.elcertificate.RaiInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.RaiInvoiceInfo;
import com.kingdee.eas.base.evs.app.elcertificate.helper.EleCertificatePoolHelperFactory;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RaiInvoiceConverter
extends AbstractVoucherDataConverter {
    @Override
    public String getSql() {
        String sql = "select a.FticketNumber,a.Fdeducted,a.FtaxDedPeriod,a.FDateOfIssue,a.FamountExTax,a.ftaxRate,a.FtaxAmount,c.FHasBeenBooked,g.FCompanyName,g.FCompanyCreaditCode,isnull(a.FIsRedInvoice,c.FRedInvoice) FRedInvoice,c.FHasBeenChecked,d.FVoucherId,e.FVoucherNumber,a.FXbrlurl,a.FXbrlname,f.FPeriodNumber,f.FPeriodYear,a.FUniquePK from T_EVS_RaiInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK inner join T_EVS_DataRange f on e.FDataRangeId = f.fid inner join T_EVS_Company g on g.fid = f.FCompanyId ";
        return sql;
    }

    @Override
    public Map<String, Map<String, JSONObject>> getInformationOfAccountingDocumentsTuple(Context ctx, IRowSet rowSet) throws Exception {
        ArrayList<String> ticketNumbers = new ArrayList<String>();
        ArrayList<String> vouchers = new ArrayList<String>();
        while (rowSet.next()) {
            ticketNumbers.add(rowSet.getString("FticketNumber"));
            vouchers.add(rowSet.getString("FVoucherId"));
        }
        String sql = "select a.FticketNumber, d.FVoucherId from T_EVS_RaiInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK where a.FticketNumber in (" + SQLUtils.getSQL(ticketNumbers) + ") and d.FVoucherId in (" + SQLUtils.getSQL(vouchers) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return this.getInformationOfAccountingDocumentsTuple0(ctx, rs);
    }

    @Override
    public void saveData(Context ctx, int periodYear, int periodNumber, IRowSet rowSet, Map<String, Map<String, JSONObject>> informationOfAccountingDocumentsTuple) throws Exception {
        CoreBaseCollection collection = new CoreBaseCollection();
        String taxNumber = "";
        HashSet<String> ticketNumberSet = new HashSet<String>();
        HashSet<String> voucherNumberSet = new HashSet<String>();
        HashMap<String, RaiInvoiceInfo> raiMap = new HashMap<String, RaiInvoiceInfo>();
        while (rowSet.next()) {
            String fticketNumber = rowSet.getString("FticketNumber");
            String fVoucherNumber = rowSet.getString("FVoucherNumber");
            RaiInvoiceInfo invoiceInfo = null;
            if (ticketNumberSet.contains(fticketNumber)) {
                if (voucherNumberSet.contains(fticketNumber + fVoucherNumber)) continue;
                invoiceInfo = (RaiInvoiceInfo)raiMap.get(fticketNumber);
                invoiceInfo.setVoucherNumbers(invoiceInfo.getVoucherNumbers() + "," + fVoucherNumber);
                voucherNumberSet.add(fticketNumber + fVoucherNumber);
                continue;
            }
            invoiceInfo = new RaiInvoiceInfo();
            raiMap.put(fticketNumber, invoiceInfo);
            ticketNumberSet.add(fticketNumber);
            voucherNumberSet.add(fticketNumber + fVoucherNumber);
            invoiceInfo.setUniquePK(fticketNumber);
            invoiceInfo.setTicketNumber(fticketNumber);
            String deducted = AS.valueOf(rowSet.getString("Fdeducted"));
            if (StringUtils.isEmpty((String)deducted)) {
                invoiceInfo.setDeducted("false");
                invoiceInfo.setTaxDedPeriod("");
            } else {
                invoiceInfo.setDeducted(deducted);
                invoiceInfo.setTaxDedPeriod(AS.valueOf(rowSet.getString("FtaxDedPeriod"), rowSet.getInt("FPeriodYear") + "" + (rowSet.getInt("FPeriodNumber") < 10 ? "0" + rowSet.getInt("FPeriodNumber") : Integer.valueOf(rowSet.getInt("FPeriodNumber")))));
            }
            invoiceInfo.setDateOfIssue(rowSet.getString("FDateOfIssue"));
            invoiceInfo.setAmountExTax(rowSet.getString("FamountExTax"));
            invoiceInfo.setTaxRate(rowSet.getString("ftaxRate"));
            invoiceInfo.setTaxAmount(rowSet.getString("FtaxAmount"));
            invoiceInfo.setHasBeenBooked(rowSet.getString("FHasBeenBooked"));
            invoiceInfo.setAccountName(rowSet.getString("FCompanyName"));
            String fCompanyCreaditCode = rowSet.getString("FCompanyCreaditCode");
            taxNumber = StringUtils.isEmpty((String)taxNumber) ? fCompanyCreaditCode : taxNumber;
            invoiceInfo.setCreditCode(fCompanyCreaditCode);
            invoiceInfo.setRedInvoice(rowSet.getString("FRedInvoice"));
            invoiceInfo.setHasBeenChecked(rowSet.getString("FHasBeenChecked"));
            Map<String, JSONObject> map = informationOfAccountingDocumentsTuple.get(invoiceInfo.getTicketNumber());
            JSONArray array = new JSONArray();
            InvoiceVoucherEntryCollection voucherEntryCollection = new InvoiceVoucherEntryCollection();
            for (Map.Entry<String, JSONObject> entry : map.entrySet()) {
                InvoiceVoucherEntryInfo voucherEntryInfo = new InvoiceVoucherEntryInfo();
                voucherEntryInfo.setVoucherId(entry.getKey());
                voucherEntryCollection.add(voucherEntryInfo);
                array.add((Object)entry.getValue());
            }
            invoiceInfo.setVoucher(array.toJSONString());
            invoiceInfo.put("voucherEntry", (Object)voucherEntryCollection);
            invoiceInfo.setVoucherNumbers(fVoucherNumber);
            invoiceInfo.setIssureXbrlUrl(rowSet.getString("FXbrlurl"));
            invoiceInfo.setIssureXbrlName(rowSet.getString("FXbrlname"));
            invoiceInfo.setPeriodYear(rowSet.getInt("FPeriodYear"));
            invoiceInfo.setPeriodNumber(rowSet.getInt("FPeriodNumber"));
            collection.add((CoreBaseInfo)invoiceInfo);
        }
        if (!ticketNumberSet.isEmpty()) {
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_InvoiceVoucherEntry where FParentID in (select fid from T_EVS_RaiInvoice where FticketNumber in (" + SQLUtils.getSQL(ticketNumberSet) + ") and FPeriodYear = ? and FPeriodNumber = ?)"), (Object[])new Object[]{periodYear, periodNumber});
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_RaiInvoice where FticketNumber in (" + SQLUtils.getSQL(ticketNumberSet) + ") and FPeriodYear = ? and FPeriodNumber = ?"), (Object[])new Object[]{periodYear, periodNumber});
            EleCertificatePoolHelperFactory.getInstance(ctx, "rai").syncExportRecord2New(ctx, collection, periodYear, periodNumber, taxNumber, ticketNumberSet);
            RaiInvoiceFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
    }
}

