/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.license;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.license.BJDES;
import com.kingdee.eas.base.evs.license.LoadLicenseFile;
import com.kingdee.eas.base.evs.license.RSA;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.Coder;
import com.kingdee.eas.base.license.file.LicenseCodeManagerFactory;
import com.kingdee.eas.base.license.file.MD5Helper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class EvsLicenseUtil {
    private static Logger logger = Logger.getLogger(EvsLicenseUtil.class);

    public static boolean checkLicense(Context ctx) {
        try {
            String user = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo().getUser();
            String localUser = EvsLicenseUtil.getUser(user);
            Properties prop = LoadLicenseFile.loadProperties(ctx);
            String licenseValue = (String)prop.get("licenseKey");
            String licensePwd = (String)prop.get("privatePwd");
            if (StringUtils.isEmpty((String)licenseValue) || StringUtils.isEmpty((String)licensePwd)) {
                throw new EASBizException(new NumericExceptionSubItem("00", "\u65e0\u7535\u5b50\u4f1a\u8ba1\u6570\u636e\u6807\u51c6license"), new Object[]{"\u65e0 \u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u6570\u636e\u6807\u51c6 license!\u8bf7\u628a\u82b1\u62ec\u53f7\u4e2d\u7684\u5185\u5bb9\u63d0\u4f9b\u7ed9\u7ba1\u7406\u5458\u7533\u8bf7license! {" + new BASE64Encoder().encode(("user:" + user).getBytes()) + "}"});
            }
            String license = BJDES.jdkDes(licenseValue, licensePwd);
            String[] str = license.split("\\^_\\^");
            if (EvsLicenseUtil.getDBTime(ctx).getTime() > Long.parseLong(str[0]) || System.currentTimeMillis() > Long.parseLong(str[0])) {
                throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u6570\u636e\u6807\u51c6 license\u5df2\u8fc7\u671f"), new Object[]{"\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u6570\u636e\u6807\u51c6 license\u5df2\u8fc7\u671f!\u8bf7\u628a\u82b1\u62ec\u53f7\u4e2d\u7684\u5185\u5bb9\u63d0\u4f9b\u7ed9\u7ba1\u7406\u5458\u66f4\u6362license! {" + new BASE64Encoder().encode(("user:" + user + " license.user:" + str[2]).getBytes()) + "}"});
            }
            if (str[2].indexOf(localUser) < 0) {
                throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u4f1a\u8ba1\u6570\u636e\u6807\u51c6 license \u4e0d\u5408\u6cd5"), new Object[]{"license\u4e0d\u5408\u6cd5!\u8bf7\u628a\u82b1\u62ec\u53f7\u4e2d\u7684\u5185\u5bb9\u63d0\u4f9b\u7ed9\u7ba1\u7406\u5458\u66f4\u6362license! {" + new BASE64Encoder().encode(("user:" + user + " license.user:" + str[2]).getBytes()) + "}"});
            }
            return true;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static String getUser(String user) {
        List ipList = LicenseCodeManagerFactory.getInstance().getIpList();
        logger.error((Object)ipList.size());
        if (ipList.size() == 1) {
            return LicenseCodeManagerFactory.getInstance().getSoftCode((String)ipList.get(0));
        }
        for (int i = 0; i < ipList.size(); ++i) {
            String softCode = LicenseCodeManagerFactory.getInstance().getSoftCode((String)ipList.get(i));
            logger.error((Object)("ip : " + (String)ipList.get(i) + " softCode : " + softCode));
            if (user.indexOf(softCode) <= -1) continue;
            return softCode;
        }
        return "noCode";
    }

    private static Timestamp getDBTime(Context ctx) {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)" SELECT now() ");
            if (rs.next()) {
                return rs.getTimestamp(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Timestamp(System.currentTimeMillis());
    }

    private static boolean buyOut(String encryptMd5) {
        try {
            String checkMd5 = MD5Helper.getStringMD5((String)EvsLicenseUtil.getEncryptMd5());
            String encrypt = Coder.hexStr2Str((String)encryptMd5);
            byte[] base64 = Coder.decryptBASE64((String)encrypt);
            String srcMd5 = new String(RSA.getInstance().decrypt(base64));
            if (checkMd5.equals(srcMd5)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static String getEncryptMd5() throws Exception {
        Date forEver = new Date(0L);
        return forEver.getTime() + "";
    }
}

