/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.unitdata.billData;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.unitdata.DocFactory;
import com.kingdee.eas.base.evs.unitdata.billData.BizDocUint;
import com.kingdee.eas.base.evs.unitdata.billData.IBizRelationUnitData;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceInfoHandler;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefBizRelationUnitDataImpl
implements IBizRelationUnitData {
    private static Logger logger = Logger.getLogger((String)DefBizRelationUnitDataImpl.class.getName());

    @Override
    public Map<String, List<BizDocUint>> getBizUnitByVoucher(Context ctx, List<String> voucherIds) throws EASBizException {
        Map<String, Map<String, List<String>>> relMapping = this.getRelationIds(ctx, voucherIds);
        HashMap<String, List<BizDocUint>> voucherBillMap = new HashMap<String, List<BizDocUint>>();
        for (Map.Entry<String, Map<String, List<String>>> entryV : relMapping.entrySet()) {
            String voucherId = entryV.getKey();
            Map<String, List<String>> billMapping = entryV.getValue();
            ArrayList<BizDocUint> units = new ArrayList<BizDocUint>();
            for (Map.Entry<String, List<String>> entryB : billMapping.entrySet()) {
                InvoiceInfoHandler handler = DocFactory.getInvoiceHandler(ctx, entryB.getKey());
                Map<String, BizDocUint> docsByBillIds = handler.getDocsByBillIds(ctx, entryB.getValue());
                for (Map.Entry<String, BizDocUint> entry : docsByBillIds.entrySet()) {
                    entry.getValue().put("PK", voucherId + entry.getKey());
                    units.add(entry.getValue());
                }
            }
            voucherBillMap.put(voucherId, units);
        }
        return voucherBillMap;
    }

    protected Map<String, Map<String, List<String>>> getRelationIds(Context ctx, List<String> ids) throws EASBizException {
        HashMap<String, Map<String, List<String>>> result = new HashMap<String, Map<String, List<String>>>();
        for (int i = 0; i < ids.size(); ++i) {
            result.put(ids.get(i), this.getBillIds(ctx, ids.get(i)));
        }
        return result;
    }

    protected Map<String, List<String>> getBillIds(Context ctx, String id) throws EASBizException {
        String[] split;
        HashMap<String, List<String>> ObjIdMap = new HashMap<String, List<String>>();
        if (StringUtils.isEmpty((String)id)) {
            return ObjIdMap;
        }
        ArrayList<String[]> upstreamObjIdList = this.getUpstreamObjIdByDestID(ctx, id);
        if (upstreamObjIdList.isEmpty()) {
            return ObjIdMap;
        }
        HashSet<String> bosTypeSet = new HashSet<String>();
        String propValue = "4A44F49F#\u8d39\u7528\u62a5\u9500\u5355,C57003BC#\u5dee\u65c5\u8d39\u62a5\u9500\u5355,48DA3A71#\u5e94\u4ed8\u5355,30BD2798#\u7269\u54c1\u91c7\u8d2d\u62a5\u9500\u5355,92F938DD#\u5bf9\u516c\u8d39\u7528\u62a5\u9500\u5355";
        for (String s : split = propValue.split(",")) {
            bosTypeSet.add(s.split("#")[0]);
        }
        int safetynumber = 10;
        while (safetynumber > 0) {
            ArrayList<String[]> tempObjId = new ArrayList<String[]>();
            this.fillObjIdMap(upstreamObjIdList, bosTypeSet, ObjIdMap);
            --safetynumber;
            for (String[] str : upstreamObjIdList) {
                ArrayList<String[]> upstreamObjIdList2 = this.getUpstreamObjIdByDestID(ctx, str[0]);
                if (upstreamObjIdList2.size() <= 0) continue;
                tempObjId.addAll(upstreamObjIdList2);
            }
            if (tempObjId.size() == 0) break;
            upstreamObjIdList = tempObjId;
        }
        return ObjIdMap;
    }

    protected void fillObjIdMap(ArrayList<String[]> upstreamObjIdList, Set<String> bosTypeSet, Map<String, List<String>> objIdMap) {
        for (int i = 0; i < upstreamObjIdList.size(); ++i) {
            List<Object> ids;
            String id = upstreamObjIdList.get(i)[0];
            String bosType = upstreamObjIdList.get(i)[1];
            if (!bosTypeSet.contains(bosType)) continue;
            if (!objIdMap.containsKey(bosType)) {
                ids = new ArrayList();
                objIdMap.put(bosType, ids);
            }
            ids = objIdMap.get(bosType);
            ids.add(id);
            objIdMap.put(bosType, ids);
        }
    }

    private ArrayList<String[]> getUpstreamObjIdByDestID(Context ctx, String destObjId) {
        ArrayList<String[]> srcObjIdList = new ArrayList<String[]>();
        if (StringUtils.isEmpty((String)destObjId)) {
            return srcObjIdList;
        }
        try {
            IRowSet rsToGetDestObjId = DbUtil.executeQuery((Context)ctx, (String)"SELECT FSRCOBJECTID, FSrcEntityID FROM T_BOT_RELATION  WHERE FDESTOBJECTID=?", (Object[])new String[]{destObjId});
            while (rsToGetDestObjId.next()) {
                srcObjIdList.add(new String[]{rsToGetDestObjId.getString("FSRCOBJECTID"), rsToGetDestObjId.getString("FSrcEntityID")});
            }
        }
        catch (SQLException e) {
            logger.error((Object)("destId = " + destObjId + ",result = " + destObjId), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("destId = " + destObjId + ",result = " + destObjId), (Throwable)e);
        }
        return srcObjIdList;
    }
}

