/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class DateFormatUtil {
    public static final String timeType = "Time";
    public static final String dateType = "Date";
    public static final String timeStampType = "TimeStamp";
    public static final String DATEFORMAT = "yyyy-MM-dd";
    public static final String DATETIMEFORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIMEFORMAT = "HH:mm:ss";
    public static final String BATCHNUMBERFORMAT = "yyyyMMddHHmmssSSS";
    static final String expr = "^((\\d{2}(([02468][048])|([13579][26]))[-\\/\\._]?((((0?[13578])|(1[02]))[-\\/\\._]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[-\\/\\._]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[-\\/\\._]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[-\\/\\._]?((((0?[13578])|(1[02]))[-\\/\\._]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[-\\/\\._]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[-\\/\\._]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1][0-9])|([2][0-4]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$";
    static final Pattern compile = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[-\\/\\._]?((((0?[13578])|(1[02]))[-\\/\\._]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[-\\/\\._]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[-\\/\\._]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[-\\/\\._]?((((0?[13578])|(1[02]))[-\\/\\._]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[-\\/\\._]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[-\\/\\._]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1][0-9])|([2][0-4]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");

    public static boolean isDataNumber(String content) {
        return compile.matcher(content).matches();
    }

    public static boolean isDataTimeNumer(String value) {
        return DateFormatUtil.isDataNumber(value) && value.length() >= 19;
    }

    public static boolean isDataTime(String type) {
        return timeType.equals(type) || dateType.equals(type) || timeStampType.equals(type);
    }

    public static String format(Date date, String formatType) {
        SimpleDateFormat df = new SimpleDateFormat(formatType);
        String format = df.format(date);
        return format;
    }

    public static String format(String type, Object value) {
        if (dateType.equals(type)) {
            Date date = (Date)value;
            SimpleDateFormat df = new SimpleDateFormat(DATEFORMAT);
            String format = df.format(date);
            return format;
        }
        if (timeType.equals(type)) {
            Date date = (Date)value;
            SimpleDateFormat df = new SimpleDateFormat(TIMEFORMAT);
            String format = df.format(date);
            return format;
        }
        if (timeStampType.equals(type)) {
            Date date = (Date)value;
            SimpleDateFormat df = new SimpleDateFormat(DATETIMEFORMAT);
            String format = df.format(date);
            return format;
        }
        return "";
    }

    public static String getBatchNumber() {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat(BATCHNUMBERFORMAT);
        return df.format(date);
    }
}

