/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.util;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class OfdUtil {
    private static Logger logger = Logger.getLogger((String)OfdUtil.class.getName());

    public static String json2Xbrl(JSONObject jsonObject, String configId) {
        try {
            Assert.notNull((Object)SingletonHolder.json2XbrlMethod, (String)"json2XbrlMethod");
            Assert.notNull((Object)SingletonHolder.jsonToXbrlInstance, (String)"jsonToXbrlInstance");
            return (String)SingletonHolder.json2XbrlMethod.invoke(SingletonHolder.jsonToXbrlInstance, jsonObject, configId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String json = "{\"UnifiedSocialCreditCodeOfAccountingEntity\":\"914403006188392540\",\"WhetherInvoiceHasBeenChecked\":\"true\",\"DateOfIssue\":\"2022-05-25\",\"TotalTaxAmount\":\"3.89\",\"AmountOfTransferredOutInputVat\":\"0\",\"TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller\":\"91440101MA9W17WF3P\",\"TotalAmountExcludingTax\":\"129.53\",\"UniqueCodeOfInvoice\":\"228adf37e2584128b61089e3783fd6730\",\"NameOfSeller\":\"\u5e7f\u5dde\u4ea4\u6295\u5e7f\u6cb3\u9ad8\u901f\u516c\u8def\u6709\u9650\u516c\u53f8\",\"WhetherInvoiceUsageHasBeenConfirmed\":\"true\",\"WhetherInvoiceHasBeenPaid\":\"true\",\"NameOfAccountingEntity\":\"914403006188392540\",\"InformationOfAccountingDocumentsTuple\":\"{\\\"InformationOfDebitAndCreditEntryTuple\\\":[{\\\"RecordedAmount\\\":\\\"133.42\\\",\\\"DebitOrCredit\\\":\\\"0\\\",\\\"NameOfGeneralLedgerSubject\\\":\\\"\u73b0\u91d1\\\",\\\"NameOfSubsidiaryLedgerSubject\\\":\\\"\u73b0\u91d1\\\"},{\\\"RecordedAmount\\\":\\\"133.42\\\",\\\"DebitOrCredit\\\":\\\"1\\\",\\\"NameOfGeneralLedgerSubject\\\":\\\"\u94f6\u884c\u5b58\u6b3e\\\",\\\"NameOfSubsidiaryLedgerSubject\\\":\\\"\u94f6\u884c\u5b58\u6b3e\\\"}],\\\"PostingDate\\\":\\\"2022-02-17\\\",\\\"AccountingPeriod\\\":\\\"2022-02\\\",\\\"NumberOfAccountingDocuments\\\":\\\"0007\\\",\\\"SummaryOfAccountingDocuments\\\":\\\"2022-02-17\\\"}\",\"WhetherInvoiceHasBeenBooked\":\"true\",\"PeriodOfUsageConfirmation\":\"2022-02\",\"WhetherInputVatHasBeenTransferredOut\":\"false\",\"TaxIncludedAmountInFigures\":\"133.42\",\"WhetherInvoiceIsRedInvoice\":\"false\",\"UsageConfirmation\":\"0\"}";
        String inv_spcl_receiver = OfdUtil.json2Xbrl(JSONObject.parseObject((String)json), "inv_spcl_receiver");
        System.out.println(inv_spcl_receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> getxbrlBytes(byte[] ofdBytes) {
        OutputStream outputStream = null;
        ZipFile zipFile = null;
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", ".tmp");
            outputStream = new FileOutputStream(tempFile);
            outputStream.write(ofdBytes);
            zipFile = new ZipFile(tempFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                if (!name.contains("Doc_0") || !name.contains("Attachs") || !name.contains("issuer") || !name.endsWith(".xml")) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                HashMap<String, byte[]> result = new HashMap<String, byte[]>(1);
                result.put(name.substring(name.lastIndexOf("/") + 1), IOUtils.toByteArray((InputStream)inputStream));
                HashMap<String, byte[]> hashMap = result;
                return hashMap;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        return null;
    }

    private static class SingletonHolder {
        private static Class jsonToXbrlClz = null;
        public static Method json2XbrlMethod = null;
        public static Object jsonToXbrlInstance = null;

        private SingletonHolder() {
        }

        static {
            try {
                jsonToXbrlClz = Class.forName("com.pansoft.xbrl.xbrljson.convert.JsonToXbrl");
                jsonToXbrlInstance = jsonToXbrlClz.newInstance();
                json2XbrlMethod = jsonToXbrlClz.getMethod("convertXbrlXml", JSONObject.class, String.class);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
            catch (InstantiationException e) {
                logger.error((Object)e);
            }
        }
    }
}

