/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.xbrlBuild;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.EvsApiFacadeFactory;
import com.kingdee.eas.base.evs.constant.ExtConstant;
import com.kingdee.eas.base.evs.listener.ListenerManager;
import com.kingdee.eas.base.evs.unitdata.BkerUnitDataFactory;
import com.kingdee.eas.base.evs.unitdata.BkrsUnitDataFactory;
import com.kingdee.eas.base.evs.unitdata.IUnit;
import com.kingdee.eas.base.evs.unitdata.PiaoFactory;
import com.kingdee.eas.base.evs.unitdata.VoucherDataFactory;
import com.kingdee.eas.base.evs.unitdata.VoucherRelationUnitDataFactory;
import com.kingdee.eas.base.evs.unitdata.VoucherUnitDataFactory;
import com.kingdee.eas.base.evs.unitdata.be.BEDocUnit;
import com.kingdee.eas.base.evs.unitdata.be.IBkerUnitData;
import com.kingdee.eas.base.evs.unitdata.be.IBkrsUnitData;
import com.kingdee.eas.base.evs.unitdata.billData.BizDocUint;
import com.kingdee.eas.base.evs.unitdata.billData.IBizRelationUnitData;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceDoc;
import com.kingdee.eas.base.evs.unitdata.fi.IVoucherUnitData;
import com.kingdee.eas.base.evs.unitdata.fi.IVouchers;
import com.kingdee.eas.base.evs.unitdata.pcloud.IPiaoUnitData;
import com.kingdee.eas.base.evs.unitdata.pcloud.Invoice;
import com.kingdee.eas.base.evs.util.DateFormatUtil;
import com.kingdee.eas.base.evs.util.IDUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataGeneratorEngine {
    private static Logger logger = Logger.getLogger(DataGeneratorEngine.class);

    public static void genDataStandards(Context ctx, CompanyOrgUnitInfo org, int periodYear, int periodNumber) throws EASBizException, BOSException {
        DataGeneratorEngine.genVoucherRelUnit(ctx, org, periodYear, periodNumber);
        if (periodNumber < 13) {
            DataGeneratorEngine.genBkrsRelUnit(ctx, org, periodYear, periodNumber);
        } else {
            logger.error((Object)("bkrs has no " + periodNumber));
        }
    }

    public static void genBkrsUnit(Context ctx, CompanyOrgUnitInfo org, int periodYear, int periodNumber, List<BEDocUnit> bkrsUnits) throws BOSException, EASBizException {
        try {
            JSONObject dataJson = new JSONObject();
            ArrayList<JSONObject> billJsonList = new ArrayList<JSONObject>();
            dataJson.put("UnifiedSocialCreditCodeOfAccountingEntity", (Object)org.getTaxNumber());
            dataJson.put("NameOfAccountingEntity", (Object)(StringUtils.isEmpty((String)org.getString("registeredCode")) ? org.getName() : org.getString("registeredCode")));
            dataJson.put("PeriodNumber", (Object)(periodNumber < 10 ? "0" + periodNumber : periodNumber + ""));
            dataJson.put("PeriodYear", (Object)(periodYear + ""));
            dataJson.put("DataType", (Object)"3");
            dataJson.put("Datas", billJsonList);
            for (BEDocUnit unit : bkrsUnits) {
                JSONObject json = new JSONObject();
                for (Map.Entry<String, Object> obj : unit.get().entrySet()) {
                    json.put(obj.getKey(), obj.getValue());
                }
                billJsonList.add(json);
            }
            if (dataJson.size() > 0) {
                String push = EvsApiFacadeFactory.getLocalInstance(ctx).push(dataJson.toJSONString());
                logger.error((Object)("bkrs--push:" + push));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static void genBkrsRelUnitByESids(Context ctx, CompanyOrgUnitInfo org, int periodYear, int periodNumber, List<String> ids) throws BOSException, EASBizException {
        ArrayList<BEDocUnit> datas = new ArrayList<BEDocUnit>();
        List<IBkrsUnitData> services = BkrsUnitDataFactory.getService(ctx);
        for (IBkrsUnitData service : services) {
            Map<String, BEDocUnit> data = service.getBkrsUnitDataByESids(ctx, periodYear, periodNumber, org, ids);
            if (data == null) continue;
            for (Map.Entry<String, BEDocUnit> entry : data.entrySet()) {
                datas.add(entry.getValue());
            }
        }
        if (datas.size() > 0) {
            DataGeneratorEngine.genBkrsUnit(ctx, org, periodYear, periodNumber, datas);
        } else {
            logger.error((Object)"genBkrsRel has not datas");
        }
    }

    public static void genBkrsRelUnit(Context ctx, CompanyOrgUnitInfo org, int periodYear, int periodNumber) throws BOSException, EASBizException {
        ArrayList<BEDocUnit> datas = new ArrayList<BEDocUnit>();
        List<IBkrsUnitData> services = BkrsUnitDataFactory.getService(ctx);
        for (IBkrsUnitData service : services) {
            datas.addAll(service.getBkrsUnitData(ctx, periodYear, periodNumber, org));
        }
        if (datas.size() > 0) {
            DataGeneratorEngine.genBkrsUnit(ctx, org, periodYear, periodNumber, datas);
        } else {
            logger.error((Object)"genBkrsRel has not datas");
        }
    }

    public static void genVoucherRelUnit(Context ctx, CompanyOrgUnitInfo org, int periodYear, int periodNumber) throws BOSException, EASBizException {
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)periodYear, (int)periodNumber, (CompanyOrgUnitInfo)org);
        List<IVouchers> voucherServices = VoucherDataFactory.getService(ctx);
        ArrayList<String> voucherColl = new ArrayList<String>();
        for (IVouchers voucherData : voucherServices) {
            List<String> voucherIds = voucherData.getVoucherIds(ctx, periodInfo, org);
            if (voucherIds == null || voucherIds.size() <= 0) continue;
            voucherColl.addAll(voucherIds);
        }
        DataGeneratorEngine.genVoucherRelUnit(ctx, org, periodYear, periodNumber, voucherColl);
    }

    public static void genVoucherRelUnit(Context ctx, CompanyOrgUnitInfo org, int periodYear, int periodNumber, List<String> voucherDatas) throws BOSException, EASBizException {
        DataGeneratorEngine.genVoucherUnit(ctx, org, periodYear, periodNumber, voucherDatas);
        DataGeneratorEngine.genBizUnit(ctx, org, voucherDatas);
        DataGeneratorEngine.genBkerUnit(ctx, org, voucherDatas);
        DataGeneratorEngine.genInvoiceUnit(ctx, org, voucherDatas);
    }

    public static void genBkerUnit(Context ctx, CompanyOrgUnitInfo org, List<String> voucherDatas) throws EASBizException, BOSException {
        HashMap<String, List<BEDocUnit>> bkerMap = new HashMap<String, List<BEDocUnit>>();
        List<IBkerUnitData> srcService = BkerUnitDataFactory.getService(ctx);
        for (IBkerUnitData relationData : srcService) {
            try {
                Map<String, List<BEDocUnit>> bizUnitByVoucher = relationData.getBizUnitByVoucher(ctx, voucherDatas);
                bkerMap.putAll(bizUnitByVoucher);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        DataGeneratorEngine.bkerGenertor(ctx, org, bkerMap);
    }

    private static void bkerGenertor(Context ctx, CompanyOrgUnitInfo org, Map<String, List<BEDocUnit>> bkerMap) throws BOSException, EASBizException {
        block6: {
            try {
                JSONObject dataJson = new JSONObject();
                ArrayList<JSONObject> billJsonList = new ArrayList<JSONObject>();
                dataJson.put("UnifiedSocialCreditCodeOfAccountingEntity", (Object)org.getTaxNumber());
                dataJson.put("NameOfAccountingEntity", (Object)(StringUtils.isEmpty((String)org.getString("registeredCode")) ? org.getName() : org.getString("registeredCode")));
                dataJson.put("DataType", (Object)"2");
                dataJson.put("Datas", billJsonList);
                for (Map.Entry<String, List<BEDocUnit>> entries : bkerMap.entrySet()) {
                    String voucherId = entries.getKey();
                    List<BEDocUnit> bkerList = entries.getValue();
                    for (BEDocUnit unit : bkerList) {
                        if (unit == null) continue;
                        JSONObject json = new JSONObject();
                        json.put("WhetherInvoiceHasBeenClaimed", (Object)"true");
                        json.put("UniqueCodeOfInvoice", (Object)unit.getUniqueCode());
                        json.put("WhetherReceiptHasBeenTransferredToBank", (Object)"true");
                        json.put("WhetherReceiptHasBeenReconciled", (Object)"true");
                        json.put("Vouchers", (Object)voucherId);
                        json.put("WhetherReceiptHasBeenBooked", (Object)"true");
                        json.put("DateOfIssue", (Object)DateFormatUtil.format(new Date(), "yyyy-MM-dd"));
                        json.put("Currency", (Object)"RMB");
                        json.put("IdentifyingCode", (Object)IDUtils.getId());
                        for (Map.Entry<String, Object> obj : unit.get().entrySet()) {
                            json.put(obj.getKey(), obj.getValue());
                        }
                        billJsonList.add(json);
                    }
                }
                if (billJsonList.size() > 0) {
                    String push = EvsApiFacadeFactory.getLocalInstance(ctx).push(dataJson.toJSONString());
                    logger.error((Object)("bker--push:" + push));
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if (ctx.get((Object)"easBizUniqueCode4Evs") == null) break block6;
                ListenerManager instance = ListenerManager.getInstance();
                instance.publishError(ctx, ctx.get((Object)"easBizUniqueCode4Evs").toString(), e.getMessage());
            }
        }
    }

    public static void genBizUnit(Context ctx, CompanyOrgUnitInfo org, List<String> voucherDatas) throws BOSException, EASBizException {
        block7: {
            try {
                List<IBizRelationUnitData> srcService = VoucherRelationUnitDataFactory.getService(ctx);
                for (IBizRelationUnitData relationData : srcService) {
                    Map<String, List<BizDocUint>> bizUnitByVoucher = relationData.getBizUnitByVoucher(ctx, voucherDatas);
                    if (bizUnitByVoucher == null) continue;
                    JSONObject dataJson = new JSONObject();
                    ArrayList<JSONObject> billJsonList = new ArrayList<JSONObject>();
                    dataJson.put("UnifiedSocialCreditCodeOfAccountingEntity", (Object)org.getTaxNumber());
                    dataJson.put("NameOfAccountingEntity", (Object)(StringUtils.isEmpty((String)org.getString("registeredCode")) ? org.getName() : org.getString("registeredCode")));
                    dataJson.put("DataType", (Object)"1");
                    dataJson.put("Datas", billJsonList);
                    for (Map.Entry<String, List<BizDocUint>> entry : bizUnitByVoucher.entrySet()) {
                        String voucherId = entry.getKey();
                        List<BizDocUint> value = entry.getValue();
                        if (value == null || value.size() == 0) continue;
                        for (BizDocUint unit : value) {
                            JSONObject billJson = new JSONObject();
                            billJson.put("PK", unit.get().get("PK"));
                            billJson.put("BillPK", unit.get().get("BillPK"));
                            billJson.put("Vouchers", (Object)voucherId);
                            billJson.put("BillNumber", unit.get().get("BillNumber"));
                            billJson.put("WhetherInputVatHasBeenTransferredOut", unit.get().get("WhetherInputVatHasBeenTransferredOut"));
                            billJson.put("AmountOfTransferredOutInputVat", unit.get().get("AmountOfTransferredOutInputVat"));
                            billJson.put("ContractNumber", unit.get().get("ContractNumber"));
                            billJson.put("MatchingStateBetweenBusinessDocumentsAndVatEInvoice", unit.get().get("MatchingStateBetweenBusinessDocumentsAndVatEInvoice"));
                            billJson.put("DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets", unit.get().get("DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets"));
                            billJson.put("WhetherInvoiceHasBeenFactoredSoldOrSecuritized", unit.get().get("WhetherInvoiceHasBeenFactoredSoldOrSecuritized"));
                            billJson.put("WhetherInvoiceIsRedInvoice", unit.get().get("WhetherInvoiceIsRedInvoice"));
                            billJson.put("WhetherInvoiceHasBeenChecked", unit.get().get("WhetherInvoiceHasBeenChecked"));
                            billJson.put("WhetherInvoiceUsageHasBeenConfirmed", unit.get().get("WhetherInvoiceUsageHasBeenConfirmed"));
                            billJson.put("UsageConfirmation", unit.get().get("UsageConfirmation"));
                            billJson.put("PeriodOfUsageConfirmation", unit.get().get("PeriodOfUsageConfirmation"));
                            billJson.put("WhetherInvoiceHasBeenBooked", unit.get().get("WhetherInvoiceHasBeenBooked"));
                            billJson.put("WhetherInvoiceHasBeenPaid", unit.get().get("WhetherInvoiceHasBeenPaid"));
                            billJson.put("NumberOfBankElectronicReceipt", unit.get().get("NumberOfBankElectronicReceipt"));
                            for (Map.Entry<String, Object> unitEntry : unit.get().entrySet()) {
                                billJson.put(unitEntry.getKey(), unitEntry.getValue());
                            }
                            JSONArray invoiceArr = new JSONArray();
                            List invoices = (List)unit.get().get("Invoices");
                            for (InvoiceDoc invoiceDoc : invoices) {
                                JSONObject invoiceJSON = new JSONObject();
                                invoiceJSON.put("SerialNumber", (Object)invoiceDoc.getSerialNum());
                                invoiceJSON.put("InvoiceNumber", (Object)invoiceDoc.getNumber());
                                invoiceJSON.put("InvoiceType", (Object)invoiceDoc.getInvoiceType());
                                invoiceJSON.put("InvoiceCode", (Object)invoiceDoc.getCode());
                                invoiceJSON.put("UniqueCodeOfInvoice", (Object)invoiceDoc.getUniqueCode());
                                invoiceJSON.put("UniquePK", (Object)(unit.get().get("PK") + invoiceDoc.getUniqueCode()));
                                invoiceArr.add((Object)invoiceJSON);
                            }
                            billJson.put("Invoices", (Object)invoiceArr);
                            billJsonList.add(billJson);
                        }
                    }
                    if (billJsonList.size() <= 0) continue;
                    String push = EvsApiFacadeFactory.getLocalInstance(ctx).push(dataJson.toJSONString());
                    logger.error((Object)("bill--push:" + push));
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if (ctx.get((Object)"easBizUniqueCode4Evs") == null) break block7;
                ListenerManager instance = ListenerManager.getInstance();
                instance.publishError(ctx, ctx.get((Object)"easBizUniqueCode4Evs").toString(), e.getMessage());
            }
        }
    }

    public static void genInvoiceUnit(Context ctx, CompanyOrgUnitInfo org, List<String> voucherDatas) throws EASBizException {
        block13: {
            try {
                List<IBizRelationUnitData> srcService = VoucherRelationUnitDataFactory.getService(ctx);
                for (IBizRelationUnitData relationData : srcService) {
                    Map<String, List<Invoice>> piaoUnits;
                    Map<String, List<BizDocUint>> bizUnitByVoucher = relationData.getBizUnitByVoucher(ctx, voucherDatas);
                    HashMap<String, List<InvoiceDoc>> allDocUnitMap = new HashMap<String, List<InvoiceDoc>>();
                    for (Map.Entry<String, List<BizDocUint>> entry : bizUnitByVoucher.entrySet()) {
                        List<BizDocUint> value = entry.getValue();
                        if (value == null || value.size() == 0) continue;
                        ArrayList invoiceDocList = new ArrayList();
                        for (BizDocUint unit : value) {
                            List invoices = (List)unit.get().get("Invoices");
                            invoiceDocList.addAll(invoices);
                        }
                        allDocUnitMap.put(entry.getKey(), invoiceDocList);
                    }
                    IPiaoUnitData service = PiaoFactory.getService(ctx);
                    if (service == null || (piaoUnits = service.getUnitData(ctx, allDocUnitMap, org)) == null || piaoUnits.size() == 0) continue;
                    HashMap unitMap = new HashMap();
                    for (String string : ExtConstant.INVOICE_TYPE_PK) {
                        unitMap.put(string, new ArrayList());
                    }
                    for (Map.Entry entry : piaoUnits.entrySet()) {
                        List units = (List)entry.getValue();
                        for (Invoice piaoUnit : units) {
                            JSONObject piaoJson = new JSONObject();
                            ((List)unitMap.get(piaoUnit.getType())).add(piaoJson);
                            for (Map.Entry<String, Object> piaoEntry : piaoUnit.get().entrySet()) {
                                piaoJson.put(piaoEntry.getKey(), piaoEntry.getValue());
                            }
                        }
                    }
                    for (Map.Entry entry : unitMap.entrySet()) {
                        if (entry.getValue() == null || ((List)entry.getValue()).size() == 0) continue;
                        JSONObject dataJson = new JSONObject();
                        try {
                            dataJson.put("UnifiedSocialCreditCodeOfAccountingEntity", (Object)org.getTaxNumber());
                            dataJson.put("NameOfAccountingEntity", (Object)(StringUtils.isEmpty((String)org.getString("registeredCode")) ? org.getName() : org.getString("registeredCode")));
                            dataJson.put("DataType", (Object)"4");
                            dataJson.put("InvoiceType", entry.getKey());
                            dataJson.put("Datas", entry.getValue());
                            String push = EvsApiFacadeFactory.getLocalInstance(ctx).push(dataJson.toJSONString());
                            if (push != null && push.contains("\u64cd\u4f5c\u5931\u8d25")) {
                                logger.error((Object)((String)entry.getKey() + "--invoice--push--ERROR:" + dataJson.toJSONString()));
                            }
                            logger.error((Object)((String)entry.getKey() + "--invoice--push:" + push));
                        }
                        catch (Exception e) {
                            logger.error((Object)((String)entry.getKey() + "--invoice--push--Exception:" + dataJson.toJSONString()));
                            logger.error((Object)e, (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if (ctx.get((Object)"easBizUniqueCode4Evs") == null) break block13;
                ListenerManager instance = ListenerManager.getInstance();
                instance.publishError(ctx, ctx.get((Object)"easBizUniqueCode4Evs").toString(), e.getMessage());
            }
        }
    }

    public static void genVoucherUnit(Context ctx, CompanyOrgUnitInfo orgUnitInfo, int periodYear, int periodNumber, List<String> voucherDatas) throws BOSException, EASBizException {
        block5: {
            try {
                List<IVoucherUnitData> services = VoucherUnitDataFactory.getService(ctx);
                if (services != null) {
                    for (IVoucherUnitData service : services) {
                        Map<String, IUnit> unitData = service.getUnitData(ctx, voucherDatas);
                        if (unitData == null || unitData.size() == 0) {
                            return;
                        }
                        JSONObject dataJson = new JSONObject();
                        dataJson.put("UnifiedSocialCreditCodeOfAccountingEntity", (Object)orgUnitInfo.getTaxNumber());
                        dataJson.put("NameOfAccountingEntity", (Object)(StringUtils.isEmpty((String)orgUnitInfo.getString("registeredCode")) ? orgUnitInfo.getName() : orgUnitInfo.getString("registeredCode")));
                        dataJson.put("PeriodNumber", (Object)(periodNumber < 10 ? "0" + periodNumber : periodNumber + ""));
                        dataJson.put("PeriodYear", (Object)(periodYear + ""));
                        dataJson.put("DataType", (Object)"0");
                        dataJson.put("Datas", unitData.values());
                        String push = EvsApiFacadeFactory.getLocalInstance(ctx).push(dataJson.toJSONString());
                        logger.error((Object)("voucher--push:" + push));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if (ctx.get((Object)"easBizUniqueCode4Evs") == null) break block5;
                ListenerManager instance = ListenerManager.getInstance();
                instance.publishError(ctx, ctx.get((Object)"easBizUniqueCode4Evs").toString(), e.getMessage());
            }
        }
    }
}

