/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extendcontrols.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public final class BosHelper {
    private static final Logger logger = Logger.getLogger(BosHelper.class);

    public static String getMainObjectPKField(QueryInfo queryInfo) {
        if (queryInfo == null) {
            return null;
        }
        return BosHelper.getMainObjectPKField(MetaDataPK.create((String)queryInfo.getFullName()));
    }

    public static String getMainObjectPKField(MetaDataPK queryPK) {
        if (queryPK == null) {
            return null;
        }
        return BosHelper.getQuery(queryPK).getMainObjectPKField();
    }

    public static BOSObjectType getMainEntityType(MetaDataPK pk) {
        if (pk == null) {
            return null;
        }
        BOSObjectType type = null;
        SimpleEntity entity = BosHelper.getQuery(pk).mainEntity();
        if (entity != null) {
            type = entity.getType();
        }
        return type;
    }

    public static String getListUI(MetaDataPK pk) {
        SimpleEntity entity;
        if (pk == null) {
            return null;
        }
        SimpleQuery query = BosHelper.getQuery(pk);
        String listUI = query.getExtendedProperty("listUI");
        if (StringUtils.isEmpty((String)listUI) && (entity = query.mainEntity()) != null) {
            listUI = entity.getExtendedProperty("listUI");
        }
        return listUI;
    }

    public static SimpleQuery getQueryWithSelectors(MetaDataPK pk) {
        if (pk == null) {
            return null;
        }
        SimpleQuery query = null;
        try {
            QuerySelect select = new QuerySelect(pk.getFullName());
            select.setDependProject((Project.Projects)pk.getKeyValue("dependProject"));
            select.selectAttribute("alias");
            select.propertyUnitSelect().selectSelector(new String[]{"returnType", "displayName"}, SysContext.getSysContext().getOriginLocale()).extendPropertySelect().select(new String[]{"isVisibleForKDTable", "ColWidthInKDTable", "displayFormat"});
            select.extendPropertySelect().select(new String[]{"F7WindowTitle", "f7WindowTitle"});
            query = MetaDataAccessFactory.getRemoteInstance().select(select);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return query;
    }

    public static QueryInfo getQueryInfo(MetaDataPK pk) {
        if (pk == null) {
            return null;
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery((IMetaDataPK)pk);
    }

    public static SimpleQuery getQuery(MetaDataPK pk) {
        if (pk == null) {
            return null;
        }
        SimpleQuery query = null;
        try {
            QuerySelect select = new QuerySelect(pk.getFullName());
            select.setDependProject((Project.Projects)pk.getKeyValue("dependProject"));
            select.selectMainObjectPKField();
            select.mainEntitySelect().extendPropertySelect().select(new String[]{"listUI"});
            select.propertyUnitSelect().selectCommonQueryFilter(new String[]{"returnType", "displayName"});
            select.extendPropertySelect().select(new String[]{"f7QueryClassName", "f7queryclassname", "defaultF7UI", "allFilterFieldName", "allFilterFieldDesc", "isF7Maintain", "listUI"});
            query = MetaDataAccessFactory.getRemoteInstance().select(select);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return query;
    }

    public static IObjectValue getRemoteValue(String pkValue, BOSObjectType bostype, SelectorItemCollection selectorCollection) {
        BOSUuid id = BOSUuid.read((String)pkValue);
        IObjectValue objectValue = null;
        try {
            objectValue = selectorCollection != null ? DynamicObjectFactory.getRemoteInstance().getValue(bostype, (IObjectPK)new ObjectUuidPK(id), selectorCollection) : DynamicObjectFactory.getRemoteInstance().getValue(bostype, (IObjectPK)new ObjectUuidPK(id));
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            objectValue = null;
        }
        return objectValue;
    }

    public static IObjectValue[] getRemoteValues(String[] pkValues, BOSObjectType bostype, SelectorItemCollection selectorCollection) {
        int size = pkValues.length;
        IObjectValue[] objectValues = new IObjectValue[size];
        for (int i = 0; i < size; ++i) {
            objectValues[i] = BosHelper.getRemoteValue(pkValues[i], bostype, selectorCollection);
        }
        return objectValues;
    }

    public static IQueryExecutor createQueryExecutor(MetaDataPK metaDataPK) {
        IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metaDataPK);
        if (queryExecutor != null) {
            queryExecutor.option().isAutoTranslateEnum = true;
            queryExecutor.option().isAutoTranslateBoolean = true;
            queryExecutor.option().isAutoIgnoreZero = true;
        }
        return queryExecutor;
    }

    public static IQueryExecutor createQueryExecutor(MetaDataPK metaDataPK, Context ctx) {
        IQueryExecutor queryExecutor = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metaDataPK) : QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)metaDataPK, (Context)ctx);
        if (queryExecutor != null) {
            queryExecutor.option().isAutoTranslateEnum = true;
            queryExecutor.option().isAutoTranslateBoolean = true;
            queryExecutor.option().isAutoIgnoreZero = true;
        }
        return queryExecutor;
    }
}

