/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.ItemInfo;
import com.kingdee.eas.base.log.LogException;
import com.kingdee.eas.base.log.app.AbstractLogServiceControllerBean;
import com.kingdee.eas.base.log.app.AppLogControllerBean;
import com.kingdee.eas.base.log.common.Resource;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.util.UuidException;
import java.util.HashMap;

public class LogServiceControllerBean
extends AbstractLogServiceControllerBean {
    public static final String LOG_SERVICE = "LOG_SERVICE";
    public static final String LOG_ITEMS = "LOG_ITEMS";
    public static final String LOG_METHOD_ALIAS = "LOG_METHOD_ALIAS";
    public static final String LOG_INSTANCENO = "LOG_INSTANCE_NO";
    public static final String LOG_ENTITY_OBJECT_NAME = "LOG_ENTITY_OBJECT_NAME";
    public static String resClassName = "com.kingdee.eas.base.log.common.LogResource";
    public static final int LOG_PRIORITY = 1000;

    @Override
    protected void _addLog(Context ctx, IObjectValue objectValue) throws BOSException {
        AppLogInfo appLog = (AppLogInfo)objectValue;
        ItemInfo item = appLog.getLogItem();
        IAppLog ctrl = AppLogFactory.getLocalInstance(ctx);
        this.validate(ctx, appLog);
        if (appLog.getLogItem() == null) {
            throw new BOSException("AppLog" + Resource.BINDED_LOG_ITEM + Resource.IS_NULL);
        }
        if (appLog.getLogItem().getName() == null || appLog.getLogItem().getName().trim().equals("")) {
            throw new BOSException("AppLog" + Resource.BINDED_LOG_ITEM + Resource.SNAME + Resource.IS_NULL);
        }
        this.addLog(ctx, item.getName(), appLog);
    }

    @Override
    protected void _addLog(Context ctx, String itemName, IObjectValue objectValue) throws BOSException {
        AppLogInfo appLog = (AppLogInfo)objectValue;
        IAppLog ctrl = AppLogFactory.getLocalInstance(ctx);
        this.validate(ctx, appLog);
    }

    @Override
    protected void _deleteLog(Context ctx) throws BOSException {
        FilterInfo filterInfo = null;
        IAppLog ctrl = AppLogFactory.getLocalInstance(ctx);
        IObjectPK[] pk = ctrl.getPKList(filterInfo, null);
        if (pk != null) {
            for (int i = 0; i < pk.length; ++i) {
                ctrl.delete(pk[i]);
            }
        }
    }

    @Override
    protected void _deleteLogByID(Context ctx, String id) throws BOSException {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            IAppLog ctrl = AppLogFactory.getLocalInstance(ctx);
            ctrl.delete((IObjectPK)pk);
        }
        catch (UuidException uuidEx) {
            throw new BOSException(Resource.PARA + "id" + Resource.ISNOT + Resource.EFFECTIVE + "BOSUuid" + Resource.TYPE + Resource.SSTRING);
        }
    }

    @Override
    protected void _setDumpUpperLimit(Context ctx, int count) throws LogException, BOSException {
        AppLogControllerBean ctrlBean = new AppLogControllerBean();
        ctrlBean.setDumpPolicy(ctx, count);
    }

    @Override
    protected int _getDumpUpperLimit(Context ctx) throws BOSException {
        AppLogControllerBean ctrlBean = new AppLogControllerBean();
        return ctrlBean.getDumpPolicy(ctx);
    }

    @Override
    protected void _Dump(Context ctx) throws BOSException {
    }

    @Override
    protected void _deleteLogFromHistory(Context ctx) throws BOSException {
        IAppLog ctrl = AppLogFactory.getLocalInstance(ctx);
        ctrl.deleteFromHistory(null);
    }

    @Override
    protected void _deleteLogFromHistoryByID(Context ctx, String id) throws BOSException {
        IAppLog ctrl = AppLogFactory.getLocalInstance(ctx);
        ctrl.deleteFromHistory(id);
    }

    @Override
    protected void _validate(Context ctx, IObjectValue objValue) throws BOSException {
        AppLogInfo obj = (AppLogInfo)objValue;
        if (obj == null) {
            throw new BOSException(Resource.PARA + "appLog" + Resource.IS + "null");
        }
        if (obj.getUserID() == null) {
            throw new BOSException(Resource.PARA + "appLog" + Resource.CONTAINS + "userID" + Resource.CANNOT + Resource.IS + "null" + Resource.OR + Resource.NULLl_STRING);
        }
        if (obj.getUserName() == null || obj.getUserName().trim().equals("")) {
            throw new BOSException(Resource.PARA + "appLog" + Resource.CONTAINS + "userName" + Resource.CANNOT + Resource.IS + "null" + Resource.OR + Resource.NULLl_STRING);
        }
        if (obj.getClientIP() == null || obj.getClientIP().trim().equals("")) {
            throw new BOSException(Resource.PARA + "appLog" + Resource.CONTAINS + "clientIP" + Resource.CANNOT + Resource.IS + "null" + Resource.OR + Resource.NULLl_STRING);
        }
        if (obj.getOccurTime() == null) {
            throw new BOSException(Resource.PARA + "appLog" + Resource.CONTAINS + "occurTime" + Resource.CANNOT + Resource.IS + "null");
        }
        if (obj.getClientName() == null || obj.getClientName().trim().equals("")) {
            throw new BOSException(Resource.PARA + "appLog" + Resource.CONTAINS + "clientName" + Resource.CANNOT + Resource.IS + "null" + Resource.OR + Resource.NULLl_STRING);
        }
        if (obj.getMethodName() == null || obj.getMethodName().trim().equals("")) {
            throw new BOSException(Resource.PARA + "appLog" + Resource.CONTAINS + "methodName" + Resource.CANNOT + Resource.IS + "null" + Resource.OR + Resource.NULLl_STRING);
        }
    }

    @Override
    protected void _logServiceRegister(Context ctx) throws BOSException {
    }

    private void setCompanyName(SolutionInfo soInfo, CompanyOrgUnitInfo mInfo, HashMap hash) {
        if (soInfo == null) {
            return;
        }
        if (mInfo == null) {
            return;
        }
        String strKey = "FCompanyName_";
        LanguageCollection lC = soInfo.getLanguages();
        String strDefPix = soInfo.getDefaultLanguage().getPostfix();
        for (int i = 0; i < lC.size(); ++i) {
            LanguageInfo lInfo = lC.get(i);
            String key = strKey + lInfo.getPostfix();
            if (lInfo.getPostfix().equals(strDefPix)) {
                if (mInfo == null) {
                    hash.put(key, "");
                    continue;
                }
                hash.put(key, mInfo.getName());
                continue;
            }
            if (mInfo == null) {
                hash.put(key, "");
                continue;
            }
            hash.put(key, mInfo.get("name", lInfo.getLocale()));
        }
    }

    private Object getID() {
        AppLogInfo appLogInfo = new AppLogInfo();
        String id = BOSUuid.create((BOSObjectType)appLogInfo.getBOSType()).toString();
        return id;
    }

    private Object getUserId(Context ctx) {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        return userInfo == null ? "" : userInfo.getId().toString();
    }

    private Object getUserName(Context ctx) {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        return userInfo == null ? "" : userInfo.getName();
    }

    private SolutionInfo getSolutionInfo(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo soInfo = loader.getSolution();
        return soInfo;
    }

    private CompanyOrgUnitInfo getCompanyName(Context ctx) {
        CompanyOrgUnitInfo info = null;
        String companyId = ContextUtils.getCurrentCompany((Context)ctx).toString();
        if (companyId != null && !companyId.equals("")) {
            try {
                ICompanyOrgUnit iOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                info = (CompanyOrgUnitInfo)iOrg.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return info;
    }

    private Object getClientName(Context ctx) {
        Object obj = ctx.get((Object)"ClientName");
        return obj == null ? "" : obj.toString();
    }

    private Object getClientIp(Context ctx) {
        Object obj = ctx.get((Object)"ClientIP");
        return obj == null ? "" : obj.toString();
    }
}

