/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.app.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.contrast.InfoAccess;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MDEvent;
import com.kingdee.bos.metadata.MDListener;
import com.kingdee.bos.metadata.MDReferenceFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.service.binding.ConcreteServiceBinder;
import com.kingdee.bos.service.binding.LogServiceItem;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.service.log.define.LogBizRefInfo;
import com.kingdee.bos.service.log.define.LogItemCollection;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.bos.service.log.define.MethodRefCollection;
import com.kingdee.bos.service.log.define.MethodRefInfo;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.log.app.adapter.PrivacyProtectUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.ThreadLocalCache;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class LogServiceAdapter
extends AbstractServiceAdapter
implements IServiceAdapter {
    Logger logger = Logger.getLogger((String)LogServiceAdapter.class.getName());
    public static final String LOG_SERVICE = "LOG_SERVICE";
    public static final String LOG_ITEMS = "LOG_ITEMS";
    public static final String LOG_METHOD_ALIAS = "LOG_METHOD_ALIAS";
    public static final String LOG_INSTANCENO = "LOG_INSTANCE_NO";
    public static final String LOG_ENTITY_OBJECT_NAME = "LOG_ENTITY_OBJECT_NAME";
    public static final int LOG_PRIORITY = 0;
    private static final Map logParamIndexCache = new HashMap(100);
    private static boolean isInit = false;

    public int getPriority() {
        return 0;
    }

    public void execute(IServiceContext serviceContext) throws BOSException {
        Context context = serviceContext.getContext();
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        String[] itemNames = this.getLogItemName(serviceContext);
        if (itemNames == null || itemNames.length == 0) {
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService(LOG_SERVICE);
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance(context);
        block14: for (int i = 0; i < itemNames.length; ++i) {
            Stack logIdStack;
            StackElement element;
            int logItemLevel = LogServerUtil.getLogItemLevel(context, itemNames[i]);
            int levelSetting = LogServerUtil.getCurrentLevelSetting(context);
            if (levelSetting == 3 && logItemLevel != 64 || levelSetting == 2 && logItemLevel == 256 || !this.isInvoke(itemNames[i], serviceContext, context)) continue;
            if (serviceContext.getExecutionMode() == 0) {
                Stack logIdStack2;
                String storeItemName = LogControllManager.getInstance().getItemName();
                if ("fa_FaEvaluateBill_UnPassAudit".equalsIgnoreCase(itemNames[i]) || "fa_FaEvaluateBill_PassAudit".equalsIgnoreCase(itemNames[i]) || "fa_FaClearBill_PassAudit".equalsIgnoreCase(itemNames[i]) || "fa_FaClearBill_UnPassAduit".equalsIgnoreCase(itemNames[i]) || "fa_FaChangeBill_PassAudit".equalsIgnoreCase(itemNames[i]) || "fa_FaChangeBill_UnPassAudit".equalsIgnoreCase(itemNames[i]) || "fa_cardinit_addnew".equalsIgnoreCase(itemNames[i])) {
                    LogControllManager.getInstance().setItemName(itemNames[i]);
                } else if (!"fa_FaCurCard_Update".equalsIgnoreCase(itemNames[i]) && !"fa_FaCurCard_AddNew".equalsIgnoreCase(itemNames[i])) {
                    LogControllManager.getInstance().setItemName(null);
                }
                if (!LogControllManager.getInstance().isEnableLog() || "fa_FaCurCard_Update".equalsIgnoreCase(itemNames[i]) && ("fa_FaEvaluateBill_UnPassAudit".equalsIgnoreCase(storeItemName) || "fa_FaEvaluateBill_PassAudit".equalsIgnoreCase(storeItemName) || "fa_FaClearBill_PassAudit".equalsIgnoreCase(storeItemName) || "fa_FaClearBill_UnPassAduit".equalsIgnoreCase(storeItemName) || "fa_FaChangeBill_UnPassAudit".equalsIgnoreCase(storeItemName) || "fa_FaChangeBill_PassAudit".equalsIgnoreCase(storeItemName))) {
                    this.logger.info((Object)("LogControllManager.getInstance().isEnableLog,itemNames[i] is " + itemNames[i]));
                    return;
                }
                if (!LogControllManager.getInstance().isEnableLog() || "fa_FaCurCard_AddNew".equalsIgnoreCase(itemNames[i]) && "fa_cardinit_addnew".equalsIgnoreCase(storeItemName)) {
                    this.logger.info((Object)("LogControllManager.getInstance().isEnableLog,itemNames[i] is " + itemNames[i]));
                    return;
                }
                if (!LogControllManager.getInstance().isEnableLog() || "fa_FaChangeBill_PassAudit".equalsIgnoreCase(itemNames[i]) && "fa_FaChangeBill_PassAudit".equalsIgnoreCase(storeItemName)) {
                    this.logger.info((Object)("LogControllManager.getInstance().isEnableLog,itemNames[i] is " + itemNames[i]));
                    return;
                }
                if ("fa_FaChangeBill_PassAudit".equalsIgnoreCase(itemNames[i])) {
                    hashLog.put("successed", new Boolean(true));
                }
                LogServerUtil.setLogInfo(serviceContext, context, hashLog);
                if (hashLog.get("FClientIP") == null || hashLog.get("FClientIP").toString().equals("")) {
                    try {
                        String ipAddress = ORMRPConfig.getRpcClientIP();
                        if (!StringUtils.isEmpty((String)ipAddress) && !"/127.0.0.1".equals(ipAddress)) {
                            hashLog.put("FClientIP", ipAddress.substring(1));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e);
                    }
                }
                if (!(logIdStack2 = this.getThreadStack()).isEmpty()) {
                    element = (StackElement)logIdStack2.peek();
                    if ("im_countingTask_update".equalsIgnoreCase(itemNames[i]) && "im_countingTask_makeCountingTable".equalsIgnoreCase(element.logItemName)) {
                        return;
                    }
                    if (logIdStack2.size() > 10) {
                        logIdStack2.clear();
                    }
                }
                String tmpInstanceId = this.getInstanceID(serviceContext);
                logIdStack2.push(new StackElement((String)hashLog.get("FID"), tmpInstanceId, itemNames[i]));
                this.putThreadStack(logIdStack2);
                hashLog.put("isSuccessed", new Boolean(false));
                String methodName = null;
                if (serviceContext.getBoType() != null) {
                    hashLog.put("FEntityID", serviceContext.getBoType().toString());
                    BusinessObjectInfo entityInfo = this.getEntityInfo(serviceContext);
                    if (entityInfo != null) {
                        hashLog.put("FEntityName", entityInfo.getName());
                        this.setEntityAlias(this.getSolutionInfo(context), entityInfo, hashLog);
                        MethodInfo mInfo = this.getMethodInfo(entityInfo, serviceContext);
                        if (mInfo != null) {
                            methodName = mInfo.getName();
                            hashLog.put("FMethodName", methodName);
                            this.setMethodAlias(this.getSolutionInfo(context), mInfo, hashLog);
                        }
                    }
                }
                hashLog.put("FInstanceID", tmpInstanceId);
                try {
                    hashLog.put("FInstanceNo", this.getInstanceNO(serviceContext, itemNames[i]));
                    if ("kickoutUser".equalsIgnoreCase(itemNames[i]) || "interruptSession".equalsIgnoreCase(itemNames[i])) {
                        hashLog.put("FInstanceNo", (String)serviceContext.getOperationParameters()[1]);
                    }
                }
                catch (EASBizException e) {
                    this.logger.error((Object)("Log Service Err:" + e.getMessage()), (Throwable)e);
                }
                catch (BOSException e) {
                    this.logger.error((Object)("Log Service Err:" + e.getMessage()), (Throwable)e);
                }
                hashLog.put("FItemName", itemNames[i]);
                try {
                    appLog.writeLog(hashLog);
                }
                catch (Throwable te) {
                    if (logIdStack2 != null) {
                        logIdStack2.clear();
                    }
                    throw new BOSException(te);
                }
                if (!(serviceContext.getExecutionMode() != 0 || "delete".equalsIgnoreCase(methodName) || "gl_voucher_post".equals(itemNames[i]) || "bgItem_addNew".equals(itemNames[i]) || "scm_saleContract_close".equals(itemNames[i]) || !LogControllManager.getInstance().isEnableLog() || serviceContext.isBatchExctue())) {
                    this.logger.info((Object)"LogControllManager.getInstance().disableLog();");
                    LogControllManager.getInstance().disableLog();
                }
                if (serviceContext.isBatchExctue()) {
                    ServiceStateManager.getInstance().enableNextCallService(LOG_SERVICE);
                } else {
                    ServiceStateManager.getInstance().disableNextCallService(LOG_SERVICE);
                }
                if (!"gl_voucher_post".equals(itemNames[i]) && !"bgItem_addNew".equals(itemNames[i])) continue;
                ServiceStateManager.getInstance().enableNextCallServices();
                continue;
            }
            if (serviceContext.getExecutionMode() != 1 || (logIdStack = this.getThreadStack()) == null || logIdStack.isEmpty()) continue;
            for (int j = 0; j < logIdStack.size(); ++j) {
                element = (StackElement)logIdStack.elementAt(j);
                if (!itemNames[i].equals(element.logItemName)) continue;
                String instanceId = element.instanceId;
                String instanceId2 = this.getInstanceID(serviceContext);
                if (instanceId != null && (instanceId2 == null || !instanceId.trim().equals(instanceId2.trim()))) continue;
                hashLog.put("FID", element.logId);
                try {
                    hashLog.put("FInstanceNo", this.getInstanceNO(serviceContext, itemNames[i]));
                    if ("kickoutUser".equalsIgnoreCase(itemNames[i]) || "interruptSession".equalsIgnoreCase(itemNames[i])) {
                        hashLog.put("FInstanceNo", (String)serviceContext.getOperationParameters()[1]);
                    }
                }
                catch (EASBizException e) {
                    this.logger.error((Object)("Log Service Err:" + e.getMessage()), (Throwable)e);
                }
                catch (BOSException e) {
                    this.logger.error((Object)("Log Service Err:" + e.getMessage()), (Throwable)e);
                }
                hashLog.put("isSuccessed", new Boolean(true));
                try {
                    hashLog.put("appLogDetail", this.getInsDetail(serviceContext, itemNames[i]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    appLog.writeLog(hashLog);
                }
                catch (Throwable te) {
                    if (logIdStack != null) {
                        logIdStack.clear();
                    }
                    throw new BOSException(te);
                }
                logIdStack.remove(j);
                LogControllManager.getInstance().enableLog();
                ServiceStateManager.getInstance().enableNextCallService(LOG_SERVICE);
                continue block14;
            }
        }
    }

    private Stack getThreadStack() {
        Stack logIdStack = null;
        Map logInfoMap = ThreadLocalCache.getRegion((String)"loginfo");
        logIdStack = logInfoMap == null || logInfoMap.isEmpty() ? new Stack() : (Stack)logInfoMap.get("logIdStack");
        if (logIdStack == null) {
            logIdStack = new Stack();
        }
        return logIdStack;
    }

    private void putThreadStack(Stack logIdStack) {
        Map logInfoMap = ThreadLocalCache.getRegion((String)"loginfo");
        logInfoMap.put("logIdStack", logIdStack);
    }

    public String getName() {
        return LOG_SERVICE;
    }

    private String[] getLogItemName(IServiceContext ctx) {
        String[] itName = new String[1];
        String[] itemNames = (String[])ctx.getServiceParameter(LOG_SERVICE, LOG_ITEMS);
        String logItem = "";
        if (itemNames != null && !ctx.isBatchExctue() && itemNames.length > 1 && itemNames[0] == itemNames[itemNames.length - 1]) {
            itName[0] = logItem = itemNames[0];
            return itName;
        }
        return itemNames;
    }

    private static Map getLoggedParameterIndexs(LogItemInfo logItemInfo) {
        if (logItemInfo == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Integer> indexs = new HashMap<String, Integer>(2);
        for (LogBizRefInfo logBizRefInfo : logItemInfo.getLogBizRefCollection()) {
            MethodRefCollection methodRefCol = logBizRefInfo.getMethodRefCollection();
            for (MethodRefInfo methodRefInfo : methodRefCol) {
                indexs.put(methodRefInfo.getInnerID(), methodRefInfo.getLoggedParameterIndex());
            }
        }
        return indexs;
    }

    private synchronized void initLogParamIndexCache(Context ctx) {
        if (!isInit) {
            LogItemCollection logItemCol = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getLog().getLogItems();
            Iterator iter = logItemCol.iterator();
            LogItemInfo logItemInfo = null;
            while (iter.hasNext()) {
                logItemInfo = (LogItemInfo)iter.next();
                logParamIndexCache.put(logItemInfo.getName(), LogServiceAdapter.getLoggedParameterIndexs(logItemInfo));
            }
            isInit = true;
        }
    }

    private int getLoggedParameterIndex(IServiceContext svcCtx, String itemName) {
        Integer index;
        this.initLogParamIndexCache(svcCtx.getContext());
        Map indexs = (Map)logParamIndexCache.get(itemName);
        if (indexs != null && (index = (Integer)indexs.get(svcCtx.getOperationPK().toString())) != null) {
            return index;
        }
        return 0;
    }

    private String getLogInfo(IServiceContext svcCtx, String id) throws BOSException, EASBizException {
        if (BOSUuid.isValid((String)id, (boolean)true)) {
            BOSUuid bosUuid = BOSUuid.read((String)id);
            return this.getLogInfo(svcCtx, bosUuid);
        }
        return null;
    }

    private String getLogInfo(IServiceContext svcCtx, BOSUuid bosUuid) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(bosUuid);
        BOSObjectType bosType = bosUuid.getType();
        IBOSObject bosObject = BOSObjectFactory.createBOSObject((Context)svcCtx.getContext(), (BOSObjectType)bosType);
        if (bosObject instanceof ICoreBase) {
            ICoreBase dataBase = (ICoreBase)bosObject;
            return dataBase.getLogInfo((IObjectPK)pk);
        }
        return null;
    }

    private String getLogInfoWhenNotEntiy(Object[] params, IServiceContext svcCtx) throws EASBizException, BOSException {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) continue;
            if (params[i] instanceof String) {
                return this.getLogInfo(svcCtx, (String)params[i]);
            }
            if (params[i] instanceof String[]) {
                String[] ids = (String[])params[i];
                StringBuffer buffer = new StringBuffer("");
                for (int j = 0; j < ids.length; ++j) {
                    buffer.append(this.getLogInfo(svcCtx, ids[j]));
                }
                return buffer.toString();
            }
            if (params[i] instanceof BOSUuid) {
                return this.getLogInfo(svcCtx, (BOSUuid)params[i]);
            }
            if (params[i] instanceof BOSUuid[]) {
                BOSUuid[] ids = (BOSUuid[])params[i];
                StringBuffer buffer = new StringBuffer("");
                for (int j = 0; j < ids.length; ++j) {
                    buffer.append(this.getLogInfo(svcCtx, ids[j]));
                }
                return buffer.toString();
            }
            if (params[i] instanceof IObjectPK) {
                IObjectPK pk = (IObjectPK)params[i];
                return this.getLogInfo(svcCtx, pk.toString());
            }
            if (params[i] instanceof IObjectPK[]) {
                IObjectPK[] pks = (IObjectPK[])params[i];
                StringBuffer buffer = new StringBuffer("");
                for (int j = 0; j < pks.length; ++j) {
                    buffer.append(this.getLogInfo(svcCtx, pks[j].toString()));
                }
                return buffer.toString();
            }
            if (params[i] instanceof CoreBaseInfo) {
                CoreBaseInfo vo = (CoreBaseInfo)params[i];
                return vo.getLogInfo();
            }
            if (!(params[i] instanceof CoreBaseInfo[])) continue;
            CoreBaseInfo[] vos = (CoreBaseInfo[])params[i];
            StringBuffer buffer = new StringBuffer("");
            for (int k = 0; k < vos.length; ++k) {
                buffer.append(vos[k].getLogInfo()).append(" ");
            }
            return buffer.toString();
        }
        return null;
    }

    public String getInstanceNO(IServiceContext svcCtx, String itemName) throws EASBizException, BOSException {
        Object[] params = svcCtx.getOperationParameters();
        if (params == null) {
            return null;
        }
        int parameterIndex = this.getLoggedParameterIndex(svcCtx, itemName);
        if (parameterIndex != 0) {
            return params[parameterIndex].toString();
        }
        try {
            IBOSObject bosObject = BOSObjectFactory.createBOSObject((Context)svcCtx.getContext(), (BOSObjectType)svcCtx.getBoType());
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)svcCtx.getContext());
            if (bosObject instanceof ICoreBase) {
                ICoreBase dataBase = (ICoreBase)bosObject;
                int n = params.length;
                for (int i = 0; i < n; ++i) {
                    StringBuffer buffer;
                    String[] ids;
                    String sid;
                    if (params[i] == null) continue;
                    if (params[i] instanceof String && BOSUuid.isValid((String)(sid = (String)params[i]), (boolean)true)) {
                        BOSUuid bosUuid = BOSUuid.read((String)sid);
                        ObjectUuidPK pk = new ObjectUuidPK(bosUuid);
                        if (!dataBase.exists((IObjectPK)pk)) continue;
                        return dataBase.getLogInfo((IObjectPK)pk);
                    }
                    if (params[i] instanceof String[]) {
                        ids = (String[])params[i];
                        buffer = new StringBuffer("");
                        for (int j = 0; j < ids.length; ++j) {
                            BOSUuid bosUuid;
                            ObjectUuidPK pk;
                            if (!BOSUuid.isValid((String)ids[j], (boolean)true) || !dataBase.exists((IObjectPK)(pk = new ObjectUuidPK(bosUuid = BOSUuid.read((String)ids[j]))))) continue;
                            buffer.append(dataBase.getLogInfo((IObjectPK)pk)).append(" ");
                        }
                        return buffer.toString();
                    }
                    if (params[i] instanceof BOSUuid) {
                        BOSUuid id = (BOSUuid)params[i];
                        ObjectUuidPK pk = new ObjectUuidPK(id);
                        if (!dataBase.exists((IObjectPK)pk)) continue;
                        return dataBase.getLogInfo((IObjectPK)pk);
                    }
                    if (params[i] instanceof BOSUuid[]) {
                        ids = (BOSUuid[])params[i];
                        buffer = new StringBuffer("");
                        for (int j = 0; j < ids.length; ++j) {
                            ObjectUuidPK pk = new ObjectUuidPK((BOSUuid)ids[j]);
                            if (!dataBase.exists((IObjectPK)pk)) continue;
                            buffer.append(dataBase.getLogInfo((IObjectPK)pk)).append(" ");
                        }
                        return buffer.toString();
                    }
                    if (params[i] instanceof IObjectPK) {
                        IObjectPK pk = (IObjectPK)params[i];
                        if (!dataBase.exists(pk)) continue;
                        return dataBase.getLogInfo(pk);
                    }
                    if (params[i] instanceof IObjectPK[]) {
                        IObjectPK[] pks = (IObjectPK[])params[i];
                        return dataBase.getLogInfo(pks);
                    }
                    if (params[i] instanceof CoreBaseInfo) {
                        CoreBaseInfo vo = (CoreBaseInfo)params[i];
                        return vo.getLogInfo();
                    }
                    if (!(params[i] instanceof CoreBaseInfo[])) continue;
                    CoreBaseInfo[] vos = (CoreBaseInfo[])params[i];
                    buffer = new StringBuffer("");
                    for (int k = 0; k < vos.length; ++k) {
                        buffer.append(vos[k].getLogInfo()).append(" ");
                    }
                    return buffer.toString();
                }
            } else if (loader.isFacade(svcCtx.getBoType())) {
                return this.getLogInfoWhenNotEntiy(params, svcCtx);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Log Service Err:" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private String getInstanceID(IServiceContext ctx) {
        Object[] params = ctx.getOperationParameters();
        if (params == null) {
            return null;
        }
        try {
            int n = params.length;
            for (int i = 0; i < n; ++i) {
                if (params[i] instanceof IObjectPK) {
                    return params[i].toString();
                }
                if (!(params[i] instanceof IObjectValue)) continue;
                IObjectValue info = (IObjectValue)params[i];
                String strPk = info.getPKField();
                if (strPk == null || info.get(strPk) == null) {
                    return null;
                }
                return info.get(strPk).toString();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Log Service Err:" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private SolutionInfo getSolutionInfo(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo soInfo = loader.getSolution();
        return soInfo;
    }

    private void setEntityAlias(SolutionInfo soInfo, BusinessObjectInfo entInfo, HashMap hash) {
        if (soInfo == null) {
            return;
        }
        String strKey = "FEntityAlias_";
        LanguageCollection lC = soInfo.getLanguages();
        for (int i = 0; i < lC.size(); ++i) {
            LanguageInfo lInfo = lC.get(i);
            String key = strKey + lInfo.getPostfix().toUpperCase();
            hash.put(key, entInfo.get("alias", lInfo.getOriginalLocale()));
        }
    }

    private void setMethodAlias(SolutionInfo soInfo, MethodInfo mInfo, HashMap hash) {
        if (soInfo == null) {
            return;
        }
        String strKey = "FMethodAlias_";
        LanguageCollection lC = soInfo.getLanguages();
        for (int i = 0; i < lC.size(); ++i) {
            LanguageInfo lInfo = lC.get(i);
            String key = strKey + lInfo.getPostfix().toUpperCase();
            hash.put(key, mInfo.get("alias", lInfo.getOriginalLocale()));
        }
    }

    private BusinessObjectInfo getEntityInfo(IServiceContext svcCtx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)svcCtx.getContext());
        BOSObjectType boType = svcCtx.getBoType();
        EntityObjectInfo boInfo = null;
        if (svcCtx.getMetaType().equals((Object)MetaDataTypeList.ENTITY)) {
            boInfo = loader.getEntity(boType);
        } else if (svcCtx.getMetaType().equals((Object)MetaDataTypeList.FACADE)) {
            boInfo = loader.getFacade(boType);
        }
        return boInfo;
    }

    private MethodInfo getMethodInfo(BusinessObjectInfo info, IServiceContext svcCtx) {
        MethodInfo methodInfo = null;
        for (MethodInfo method : info.getAllMethodsRuntime()) {
            if (!method.getString("innerID").equals(svcCtx.getOperationPK().toString())) continue;
            methodInfo = method;
            break;
        }
        return methodInfo;
    }

    private boolean isInvoke(String itemName, IServiceContext serviceContext, Context context) {
        ServiceBindItem[] items = ConcreteServiceBinder.getServiceBinder((Context)context).getServiceBindings(serviceContext.getMetaType(), serviceContext.getBoType(), serviceContext.getOperationPK());
        if (items == null) {
            return false;
        }
        int n = items.length;
        for (int i = 0; i < n; ++i) {
            if (items[i].getType() != 1 || !items[i].getName().equalsIgnoreCase(itemName)) continue;
            int invokeMode = ((LogServiceItem)items[i].getServiceItem()).getMethodInvokeMode();
            if (invokeMode == 32) {
                return true;
            }
            if (invokeMode == 8) {
                return true;
            }
            return invokeMode == 16;
        }
        return false;
    }

    private Map analyzeDetail(IServiceContext svcCtx, String itemName, IObjectPK pk, Object newValue) throws Exception {
        EntityObjectInfo bo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)svcCtx.getContext()).getEntity(svcCtx.getBoType());
        IObjectBase iObjectBase = (IObjectBase)BOSObjectFactory.createBOSObject((Context)svcCtx.getContext(), (BOSObjectType)svcCtx.getBoType());
        InfoAccess infoAccess = new InfoAccess(bo);
        SelectorItemCollection col = infoAccess.getSelectors();
        CoreBaseInfo oldVal = LogServiceAdapter.getValueByRequiresNew(iObjectBase, pk, col);
        CoreBaseInfo newInfo = (CoreBaseInfo)newValue;
        if (newInfo.get("Cell") != null) {
            newInfo.setString("Cell", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("Cell")));
        }
        if (oldVal.get("Cell") != null) {
            oldVal.setString("Cell", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("Cell")));
        }
        if (newInfo.get("NCell") != null) {
            newInfo.setString("NCell", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("NCell")));
        }
        if (oldVal.get("NCell") != null) {
            oldVal.setString("NCell", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("NCell")));
        }
        if (newInfo.get("Email") != null) {
            newInfo.setString("Email", PrivacyProtectUtil.hideEmailInfo((String)newInfo.get("Email")));
        }
        if (oldVal.get("Email") != null) {
            oldVal.setString("Email", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("Email")));
        }
        if (newInfo.get("officephone") != null) {
            newInfo.setString("officephone", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("officephone")));
        }
        if (oldVal.get("officephone") != null) {
            oldVal.setString("officephone", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("officephone")));
        }
        if (newInfo.get("backupcell") != null) {
            newInfo.setString("backupcell", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("backupcell")));
        }
        if (oldVal.get("backupcell") != null) {
            oldVal.setString("backupcell", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("backupcell")));
        }
        if (newInfo.get("backupemail") != null) {
            newInfo.setString("backupemail", PrivacyProtectUtil.hideEmailInfo((String)newInfo.get("backupemail")));
        }
        if (oldVal.get("backupemail") != null) {
            oldVal.setString("backupemail", PrivacyProtectUtil.hideEmailInfo((String)oldVal.get("backupemail")));
        }
        if (newInfo.get("bankaccountnumber") != null) {
            newInfo.setString("bankaccountnumber", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("bankaccountnumber")));
        }
        if (oldVal.get("bankaccountnumber") != null) {
            oldVal.setString("bankaccountnumber", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("bankaccountnumber")));
        }
        if (newInfo.get("phone") != null) {
            newInfo.setString("phone", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("phone")));
        }
        if (oldVal.get("phone") != null) {
            oldVal.setString("phone", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("phone")));
        }
        if (newInfo.get("mobile") != null) {
            newInfo.setString("mobile", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("mobile")));
        }
        if (oldVal.get("mobile") != null) {
            oldVal.setString("mobile", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("mobile")));
        }
        if (newInfo.get("bankaccount") != null) {
            newInfo.setString("bankaccount", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("bankaccount")));
        }
        if (oldVal.get("bankaccount") != null) {
            oldVal.setString("bankaccount", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("bankaccount")));
        }
        if (newInfo.get("homePhone") != null) {
            newInfo.setString("homePhone", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("homePhone")));
        }
        if (oldVal.get("homePhone") != null) {
            oldVal.setString("homePhone", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("homePhone")));
        }
        if (newInfo.get("contractPhone") != null) {
            newInfo.setString("contractPhone", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("contractPhone")));
        }
        if (oldVal.get("contractPhone") != null) {
            oldVal.setString("contractPhone", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("contractPhone")));
        }
        if (newInfo.get("standbyPhone") != null) {
            newInfo.setString("standbyPhone", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("standbyPhone")));
        }
        if (oldVal.get("standbyPhone") != null) {
            oldVal.setString("standbyPhone", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("standbyPhone")));
        }
        if (newInfo.get("idCard") != null) {
            newInfo.setString("idCard", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("idCard")));
        }
        if (oldVal.get("idCard") != null) {
            oldVal.setString("idCard", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("idCard")));
        }
        if (newInfo.get("emailAddress") != null) {
            newInfo.setString("emailAddress", PrivacyProtectUtil.hidePhoneInfo((String)newInfo.get("emailAddress")));
        }
        if (oldVal.get("emailAddress") != null) {
            oldVal.setString("emailAddress", PrivacyProtectUtil.hidePhoneInfo((String)oldVal.get("emailAddress")));
        }
        infoAccess.setNewValue((IObjectValue)newInfo);
        infoAccess.setOldValue((IObjectValue)oldVal);
        return infoAccess.contrastInfoToMap();
    }

    private static CoreBaseInfo getValueByRequiresNew(IObjectBase objectBase, IObjectPK pk, SelectorItemCollection col) throws Exception {
        try {
            Method method = objectBase.getClass().getMethod("getValue", IObjectPK.class, SelectorItemCollection.class);
            Object[] params = new Object[]{pk, col};
            int transaction = 3;
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)objectBase);
            Object resutl = txInvoker.invoke(method, params, transaction);
            return (CoreBaseInfo)resutl;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }

    public Map getInsDetail(IServiceContext svcCtx, String itemName) throws EASBizException, BOSException {
        Object[] params = svcCtx.getOperationParameters();
        if (params == null) {
            return null;
        }
        int parameterIndex = this.getLoggedParameterIndex(svcCtx, itemName);
        if (parameterIndex != 0) {
            // empty if block
        }
        try {
            IBOSObject bosObject = BOSObjectFactory.createBOSObject((Context)svcCtx.getContext(), (BOSObjectType)svcCtx.getBoType());
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)svcCtx.getContext());
            if (bosObject instanceof ICoreBase) {
                ICoreBase dataBase = (ICoreBase)bosObject;
                int n = params.length;
                for (int i = 0; i < n; ++i) {
                    CoreBaseInfo pk;
                    BOSUuid id;
                    ObjectUuidPK pk2;
                    StringBuffer buffer;
                    String[] ids;
                    BOSUuid bosUuid;
                    ObjectUuidPK pk3;
                    String sid;
                    if (params[i] == null || params[i] instanceof String && BOSUuid.isValid((String)(sid = (String)params[i]), (boolean)true) && !dataBase.exists((IObjectPK)(pk3 = new ObjectUuidPK(bosUuid = BOSUuid.read((String)sid))))) continue;
                    if (params[i] instanceof String[]) {
                        ids = (String[])params[i];
                        buffer = new StringBuffer("");
                        for (int j = 0; j < ids.length; ++j) {
                            BOSUuid bosUuid2;
                            ObjectUuidPK pk4;
                            if (!BOSUuid.isValid((String)ids[j], (boolean)true) || !dataBase.exists((IObjectPK)(pk4 = new ObjectUuidPK(bosUuid2 = BOSUuid.read((String)ids[j]))))) continue;
                            buffer.append(dataBase.getLogInfo((IObjectPK)pk4)).append(" ");
                        }
                    }
                    if (params[i] instanceof BOSUuid && !dataBase.exists((IObjectPK)(pk2 = new ObjectUuidPK(id = (BOSUuid)params[i])))) continue;
                    if (params[i] instanceof BOSUuid[]) {
                        ids = (BOSUuid[])params[i];
                        buffer = new StringBuffer("");
                        for (int j = 0; j < ids.length; ++j) {
                            ObjectUuidPK pk5 = new ObjectUuidPK((BOSUuid)ids[j]);
                            if (!dataBase.exists((IObjectPK)pk5)) continue;
                            buffer.append(dataBase.getLogInfo((IObjectPK)pk5)).append(" ");
                        }
                    }
                    if (params[i] instanceof IObjectPK) {
                        pk = (CoreBaseInfo)params[i];
                        if (!dataBase.exists((IObjectPK)pk)) continue;
                        return this.analyzeDetail(svcCtx, itemName, (IObjectPK)pk, params[2]);
                    }
                    if (params[i] instanceof IObjectPK[]) {
                        pk = (CoreBaseInfo)params[i];
                    }
                    if (params[i] instanceof CoreBaseInfo) {
                        pk = (CoreBaseInfo)params[i];
                    }
                    if (!(params[i] instanceof CoreBaseInfo[])) continue;
                    CoreBaseInfo[] vos = (CoreBaseInfo[])params[i];
                    buffer = new StringBuffer("");
                    for (int k = 0; k < vos.length; ++k) {
                        buffer.append(vos[k].getLogInfo()).append(" ");
                    }
                }
            } else if (loader.isFacade(svcCtx.getBoType())) {
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Log Service Err:" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    static {
        MDReferenceFactory.addLogListener((MDListener)new MDListener(){

            public void performed(MDEvent e) {
                if (e.getType() == 0) {
                    logParamIndexCache.clear();
                    isInit = false;
                }
            }
        });
    }

    static class StackElement
    implements Serializable {
        String logId = null;
        String instanceId = null;
        String logItemName = null;

        StackElement(String logId, String instanceId, String logItemName) {
            this.logId = logId;
            this.instanceId = instanceId;
            this.logItemName = logItemName;
        }
    }
}

