/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.condit;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.risk.BaseLogicRuleEntryInfo;
import com.kingdee.eas.base.risk.LogicType;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.service.common.RealValUtils;
import com.kingdee.eas.base.risk.service.condit.IEntryInterface;
import com.kingdee.eas.base.risk.service.condit.IModelConditInterface;
import com.kingdee.eas.base.risk.service.logicCalcd.ILogicInterface;
import com.kingdee.eas.base.risk.service.logicCalcd.LogicCalcdFactory;
import com.kingdee.eas.base.risk.service.pojo.Calculation;
import com.kingdee.eas.base.risk.service.pojo.Expression;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;

public class PaySafeFilerRule
implements IModelConditInterface,
IEntryInterface {
    protected Context ctx;
    protected RiskParam param;
    protected RiskModelInfo riskModelInfo;

    public PaySafeFilerRule(Context ctx, RiskParam param, RiskModelInfo riskModelInfo) {
        this.ctx = ctx;
        this.param = param;
        this.riskModelInfo = riskModelInfo;
    }

    @Override
    public IObjectCollection getEntryCollection() {
        return (IObjectCollection)this.riskModelInfo.get("modelRuleEntry");
    }

    public Object match() throws RiskException {
        IObjectCollection collectionEntry = this.getEntryCollection();
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (int i = 0; i < collectionEntry.size(); ++i) {
            BaseLogicRuleEntryInfo conditEntryInfo = (BaseLogicRuleEntryInfo)collectionEntry.getObject(i);
            Object calcdLeft = RealValUtils.getRealValue(this.ctx, this.param, (IObjectValue)this.riskModelInfo, conditEntryInfo, conditEntryInfo.getFieldType(), conditEntryInfo.getCompareField());
            String compareValue = conditEntryInfo.getCompareValue();
            Object calcdRight = RealValUtils.getRealValue(this.ctx, this.param, (IObjectValue)this.riskModelInfo, conditEntryInfo, conditEntryInfo.getFieldType(), compareValue);
            ILogicInterface logicInterface = LogicCalcdFactory.getInstance(this.ctx, conditEntryInfo.getCompare(), conditEntryInfo.getRelationType(), calcdLeft);
            boolean calcdValue = logicInterface.getCalcdValue(this.ctx, this.param, this.riskModelInfo, conditEntryInfo, calcdLeft, calcdRight);
            Expression expression = Expression.builder().setLeftBracket(conditEntryInfo.getLeftBracket().getValue()).setCalcdValue(calcdValue).setRightBracket(conditEntryInfo.getRightBracket().getValue());
            LogicType logic = conditEntryInfo.getLogic();
            if (i < collectionEntry.size() - 1) {
                if (logic == null) {
                    throw new RiskException(new NumericExceptionSubItem("00", "logic error;logic is null or logic is illegal"));
                }
                expression.setLogic(logic.getValue());
            }
            list.add(expression);
        }
        return Calculation.builder().setList(list).getCalculationResult();
    }
}

