/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.riskManage;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.risk.AM;
import com.kingdee.eas.base.risk.CheckGroupInfo;
import com.kingdee.eas.base.risk.ControlMode;
import com.kingdee.eas.base.risk.RiskExecuteFacadeFactory;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.service.common.DataSnapshotUtil;
import com.kingdee.eas.base.risk.service.pojo.BatchRiskResult;
import com.kingdee.eas.base.risk.service.pojo.DataSnapshot;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.base.risk.service.pojo.RiskResult;
import com.kingdee.eas.base.risk.service.pojo.TypeAttr;
import com.kingdee.eas.base.risk.service.pojo.WeakRiskType;
import com.kingdee.eas.base.risk.service.riskManage.ModelFactory;
import com.kingdee.eas.base.risk.service.threads.RiskThreadPool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RiskServiceEvent {
    private static Logger logger = Logger.getLogger(RiskServiceEvent.class);

    protected RiskResult defaultResult(Context ctx, String billId) {
        return RiskResult.builder().setBillId(billId).setAllExecSuccess(true);
    }

    protected BatchRiskResult defaultResultBatch(Context ctx, List<String> billIds) {
        BatchRiskResult batch = new BatchRiskResult();
        List<RiskResult> successDetail = batch.getSuccessDetail();
        List<RiskResult> failDetail = batch.getFailDetail();
        ArrayList futureList = new ArrayList();
        for (String billId : billIds) {
            this.groupRiskResult(batch, successDetail, failDetail, this.defaultResult(ctx, billId));
        }
        return batch;
    }

    protected RiskResult getRisk(Context ctx, IObjectValue modelValue, List riskDesigner, ControlMode controlMode, String execBatchNumber) {
        RiskParam riskParam = this.initRiskParam(ctx, RiskParam.builder(), modelValue, controlMode, riskDesigner);
        riskParam.getDataSnapshot().setBatchNumber(execBatchNumber);
        RiskResult riskResult = this.doRiskBus(ctx, riskParam);
        return riskResult;
    }

    protected RiskResult getRisk(Context ctx, String billId, List riskDesigner, ControlMode controlMode, String execBatchNumber) {
        RiskParam riskParam = this.initRiskParam(ctx, RiskParam.builder(), billId, controlMode, riskDesigner);
        riskParam.getDataSnapshot().setBatchNumber(execBatchNumber);
        RiskResult riskResult = this.doRiskBus(ctx, riskParam);
        return riskResult;
    }

    protected RiskParam initRiskParam(Context ctx, RiskParam riskParam, IObjectValue modelValue, ControlMode controlMode, List riskDesigner) {
        riskParam.setModel(modelValue).setAm(AM.MO).setControlMode(controlMode).setDesignerList(riskDesigner);
        return riskParam;
    }

    protected RiskParam initRiskParam(Context ctx, RiskParam riskParam, String billId, ControlMode controlMode, List riskDesigner) {
        riskParam.setBillId(billId).setAm(AM.DB).setControlMode(controlMode).setDesignerList(riskDesigner);
        return riskParam;
    }

    protected BatchRiskResult getRiskBatch(Context ctx, List<String> billIds, List riskDesigner, ControlMode controlMode) {
        BatchRiskResult batch = new BatchRiskResult();
        List<RiskResult> successDetail = batch.getSuccessDetail();
        List<RiskResult> failDetail = batch.getFailDetail();
        ArrayList<Future<RiskResult>> futureList = new ArrayList<Future<RiskResult>>();
        for (String string : billIds) {
            RiskResult weakRiskResult = null;
            if (riskDesigner == null || riskDesigner.size() == 0) {
                weakRiskResult = RiskResult.builder().setBillId(string).setAllExecSuccess(true);
                this.groupRiskResult(batch, successDetail, failDetail, weakRiskResult);
                continue;
            }
            RiskParam riskParam = this.initRiskParam(ctx, RiskParam.builder(), string, controlMode, riskDesigner);
            Future<RiskResult> future = RiskThreadPool.submit(ctx, riskParam, this);
            futureList.add(future);
        }
        if (futureList != null && futureList.size() > 0) {
            for (Future future : futureList) {
                try {
                    RiskResult riskResult = (RiskResult)future.get();
                    this.groupRiskResult(batch, successDetail, failDetail, riskResult);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                catch (ExecutionException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
        return batch;
    }

    protected void groupRiskResult(BatchRiskResult batch, List<RiskResult> successDetail, List<RiskResult> failDetail, RiskResult weakRiskResult) {
        if (weakRiskResult.isAllExecSuccess()) {
            batch.addSuccessNum();
            successDetail.add(weakRiskResult);
        } else {
            batch.addFailNum();
            failDetail.add(weakRiskResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public RiskResult doRiskBus(Context ctx, RiskParam param) {
        RiskResult result;
        block16: {
            long begin = System.currentTimeMillis();
            result = null;
            this.beforeParamAdapter(ctx, param);
            this.paramAdapter(ctx, param);
            List<RiskModelInfo> riskItems = this.getRiskItems(ctx, param);
            this.idToModel(ctx, riskItems, param);
            this.putDefResult(ctx, riskItems, param);
            this.beforeExecute(ctx, param, riskItems);
            this.doExecute(ctx, param, riskItems);
            this.afterExecute(ctx, param, riskItems);
            result = this.getExecuteResult(ctx, param, riskItems);
            try {
                DataSnapshotUtil.writeDesignInvoke(ctx, param);
                DataSnapshotUtil.writeRiskInvoke(ctx, param);
                this.persistDataSnapshot(ctx, param);
            }
            catch (Throwable e) {
                logger.error((Object)e, e);
            }
            long end = System.currentTimeMillis();
            try {
                logger.error((Object)("doRiskBus-TotalTime:" + (end - begin) + ";RiskResult:" + JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})));
            }
            catch (Throwable e) {
                logger.error((Object)e, e);
            }
            break block16;
            catch (Throwable e) {
                try {
                    logger.error((Object)e, e);
                    DataSnapshotUtil.writeErrLog(ctx, param, null, e);
                    result = this.defaultResult(ctx, param.getBillId());
                }
                catch (Throwable throwable) {
                    try {
                        DataSnapshotUtil.writeDesignInvoke(ctx, param);
                        DataSnapshotUtil.writeRiskInvoke(ctx, param);
                        this.persistDataSnapshot(ctx, param);
                    }
                    catch (Throwable e2) {
                        logger.error((Object)e2, e2);
                    }
                    long end2 = System.currentTimeMillis();
                    try {
                        logger.error((Object)("doRiskBus-TotalTime:" + (end2 - begin) + ";RiskResult:" + JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})));
                    }
                    catch (Throwable e3) {
                        logger.error((Object)e3, e3);
                    }
                    throw throwable;
                }
                try {
                    DataSnapshotUtil.writeDesignInvoke(ctx, param);
                    DataSnapshotUtil.writeRiskInvoke(ctx, param);
                    this.persistDataSnapshot(ctx, param);
                }
                catch (Throwable e4) {
                    logger.error((Object)e4, e4);
                }
                end = System.currentTimeMillis();
                try {
                    logger.error((Object)("doRiskBus-TotalTime:" + (end - begin) + ";RiskResult:" + JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})));
                }
                catch (Throwable e5) {
                    logger.error((Object)e5, e5);
                }
            }
        }
        return result;
    }

    protected boolean hasSaved(Context ctx, String billEntity, List bizModelList) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)billEntity));
        Object type = entityObjectInfo.get("bosType");
        String bosType = type.toString();
        if (bizModelList == null || bizModelList.size() == 0) {
            return false;
        }
        BOSUuid bosUuid = ((CoreBaseInfo)bizModelList.get(0)).getId();
        if (bosUuid == null || !BOSUuid.isValid((String)bosUuid.toString(), (boolean)false) || !DynamicObjectFactory.getLocalInstance((Context)ctx).exists(BOSObjectType.create((String)bosType), (IObjectPK)new ObjectUuidPK(bosUuid.toString()))) {
            logger.error((Object)"data has not saved");
            return false;
        }
        return true;
    }

    protected boolean hasSaved(Context ctx, RiskParam param) throws BOSException {
        String billEntity = param.getDesignerList().get(0).getBillEntity();
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)billEntity));
        Object type = entityObjectInfo.get("bosType");
        String bosType = type.toString();
        if (!BOSUuid.isValid((String)param.getBillId(), (boolean)false) || !DynamicObjectFactory.getLocalInstance((Context)ctx).exists(BOSObjectType.create((String)bosType), (IObjectPK)new ObjectUuidPK(param.getBillId()))) {
            logger.error((Object)"data has not saved");
            return false;
        }
        return true;
    }

    protected void beforeParamAdapter(Context ctx, RiskParam param) {
        String billId = param.getBillId();
        if (StringUtils.isEmpty((CharSequence)billId)) {
            Object id = param.getModel().get("id");
            if (id == null) {
                String tempID = BOSUuid.create((BOSObjectType)param.getModel().getBOSType()).toString();
                param.getModel().put("id", (Object)tempID);
                billId = tempID;
            } else {
                billId = id.toString();
            }
        }
        param.setBillId(billId);
    }

    protected void persistDataSnapshot(Context ctx, RiskParam param) throws BOSException, EASBizException {
        RiskExecuteFacadeFactory.getLocalInstance(ctx).persistDataSnapshot(param);
    }

    protected void putDefResult(Context ctx, List<RiskModelInfo> riskItems, RiskParam param) {
        ArrayList<WeakRiskType> typeList = new ArrayList<WeakRiskType>();
        RiskResult weakRiskResult = RiskResult.builder().setList(typeList);
        weakRiskResult.setBillId(param.getBillId());
        weakRiskResult.setBillNumber((String)param.getModel().get("number"));
        param.getParams().put("__$$weakRiskResultColl", weakRiskResult);
        HashMap<String, CheckGroupInfo> checkGroupMap = new HashMap<String, CheckGroupInfo>();
        for (int i = 0; i < riskItems.size(); ++i) {
            RiskModelInfo riskModelInfo = riskItems.get(i);
            CheckGroupInfo checkGroup = riskModelInfo.getCheckGroup();
            if (checkGroup == null) {
                checkGroup = new CheckGroupInfo();
                checkGroup.setWeight(Integer.MIN_VALUE);
                checkGroup.setNumber(riskModelInfo.getControlModel().getName());
                checkGroup.setName(riskModelInfo.getControlModel().getAlias());
            }
            if (checkGroupMap.containsKey(checkGroup.getNumber())) continue;
            checkGroupMap.put(checkGroup.getNumber(), checkGroup);
        }
        Set entries = checkGroupMap.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            CheckGroupInfo value = (CheckGroupInfo)iterator.next().getValue();
            ArrayList<TypeAttr> list = new ArrayList<TypeAttr>();
            WeakRiskType riskType = WeakRiskType.builder().setTypeName(value.getName()).setTypeValue(value.getNumber()).setWeight(value.getWeight()).setList(list);
            typeList.add(riskType);
        }
    }

    protected void idToModel(Context ctx, List<RiskModelInfo> riskItems, RiskParam param) throws BOSException, EASBizException {
        RiskExecuteFacadeFactory.getLocalInstance(ctx).idToModel(riskItems, param);
        this.idToModelAdapter(ctx, riskItems, param);
    }

    protected void idToModelAdapter(Context ctx, List<RiskModelInfo> riskItems, RiskParam param) {
    }

    protected RiskResult getExecuteResult(Context ctx, RiskParam param, List<RiskModelInfo> riskItems) {
        WeakRiskType weakRiskType;
        List<TypeAttr> typeList;
        List<WeakRiskType> list;
        RiskResult result = (RiskResult)param.getParams().get("__$$weakRiskResultColl");
        result = this.sortResult(ctx, param, result);
        if (ControlMode.funControl.equals((Object)param.getControlMode()) && (list = result.getList()) != null && list.size() > 0 && ((typeList = (weakRiskType = list.get(0)).getList()) == null || typeList.size() == 0)) {
            result.setList(null);
        }
        return result;
    }

    protected RiskResult sortResult(Context ctx, RiskParam param, RiskResult result) {
        List<WeakRiskType> list = result.getList();
        Collections.sort(list, new Comparator<WeakRiskType>(){

            @Override
            public int compare(WeakRiskType o1, WeakRiskType o2) {
                return o1.getWeight() < o2.getWeight() ? -1 : 1;
            }
        });
        for (WeakRiskType type : list) {
            List<TypeAttr> typeList = type.getList();
            if (typeList == null || typeList.size() <= 0) continue;
            Collections.sort(typeList, new Comparator<TypeAttr>(){

                @Override
                public int compare(TypeAttr o1, TypeAttr o2) {
                    if (o1.getLevel() > o2.getLevel()) {
                        return -1;
                    }
                    if (o1.getLevel() == o2.getLevel()) {
                        return o1.getSeq() < o2.getSeq() ? -1 : 1;
                    }
                    return 1;
                }
            });
        }
        return result;
    }

    protected void doExecute(Context ctx, RiskParam param, List<RiskModelInfo> riskItems) {
        for (RiskModelInfo riskModelInfo : riskItems) {
            this.beforeItem(ctx, param, riskModelInfo);
            this.doItem(ctx, param, riskModelInfo);
            this.afterItem(ctx, param, riskModelInfo);
        }
    }

    protected void afterItem(Context ctx, RiskParam param, RiskModelInfo riskModelInfo) {
    }

    protected void doItem(Context ctx, RiskParam param, RiskModelInfo riskModelInfo) {
        try {
            ModelFactory.getInstance(ctx).executeItem(ctx, param, riskModelInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            DataSnapshotUtil.writeErrLog(ctx, param, riskModelInfo.getId().toString(), e);
        }
    }

    protected void beforeItem(Context ctx, RiskParam param, RiskModelInfo riskModelInfo) {
    }

    protected void beforeExecute(Context ctx, RiskParam param, List<RiskModelInfo> riskItems) {
        this.setDataSnapshot(ctx, param);
        long begin = System.currentTimeMillis();
        this.doBeforeExecute(ctx, param, riskItems);
        long end = System.currentTimeMillis();
        logger.error((Object)("beforeExecuteItem-TotalTime:" + (end - begin)));
    }

    protected void setDataSnapshot(Context ctx, RiskParam param) {
        DataSnapshot dataSnapshot = param.getDataSnapshot();
        IObjectValue objectValue = param.getModel();
        if (objectValue == null) {
            return;
        }
        String billId = param.getBillId();
        dataSnapshot.setBillId(billId);
        if (param.getModel() != null) {
            BOSObjectType type = param.getModel().getBOSType();
            dataSnapshot.setBillBosType(type.toString());
        } else {
            ObjectUuidPK uuidPK = new ObjectUuidPK(billId);
            BOSObjectType type = uuidPK.getObjectType();
            dataSnapshot.setBillBosType(type.toString());
        }
    }

    protected void afterExecute(Context ctx, RiskParam param, List<RiskModelInfo> riskItems) {
        long begin = System.currentTimeMillis();
        this.doAfterExecute(ctx, param, riskItems);
        long end = System.currentTimeMillis();
        logger.error((Object)("afterExecuteItem-TotalTime:" + (end - begin)));
    }

    protected void doAfterExecute(Context ctx, RiskParam param, List<RiskModelInfo> riskItems) {
    }

    protected void doBeforeExecute(Context ctx, RiskParam param, List<RiskModelInfo> riskItems) {
    }

    protected List<RiskModelInfo> getRiskItems(Context ctx, RiskParam param) throws BOSException, EASBizException {
        return RiskExecuteFacadeFactory.getLocalInstance(ctx).getRiskItems(param, param.getControlMode());
    }

    protected void paramAdapter(Context ctx, RiskParam param) {
    }
}

