/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.tools.smecloud.apigw.gwclient;

import com.kingdee.eas.base.risk.tools.smecloud.apigw.exception.ApiException;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.http.HttpClient;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApiCallBack;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApiRequest;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApiResult;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApigwConfig;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.util.CommontUtil;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.util.SHAUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;

public class ApigwClient
extends HttpClient {
    private ApigwConfig config;
    private static final String AUTH_VERSION = "2.0";
    private static final ApigwClient instance = new ApigwClient();
    private static final String[] DEFAULT_SIGNHEADERS = new String[]{"X-Api-Nonce", "X-Api-TimeStamp"};
    private final Random rand = new SecureRandom();

    @Override
    public void init(ApigwConfig config) {
        super.init(config);
        this.config = config;
    }

    public static ApigwClient getInstance() {
        return instance;
    }

    public ApiResult send(ApiRequest apiRequest) {
        this.setSignature(apiRequest);
        return this.syncRequest(apiRequest);
    }

    @Override
    public void downloadFile(ApiRequest apiRequest, String filepath) {
        this.setSignature(apiRequest);
        super.downloadFile(apiRequest, filepath);
    }

    public void asyncSend(ApiRequest apiRequest, ApiCallBack apiCallback) {
        this.setSignature(apiRequest);
        this.asyncRequest(apiRequest, apiCallback);
    }

    private void setSignature(ApiRequest apiRequest) {
        String[] signHeaders;
        if (apiRequest.getSignHeaders().size() > 0) {
            List<String> s = apiRequest.getSignHeaders();
            s.addAll(Arrays.asList(DEFAULT_SIGNHEADERS));
            Collections.sort(s);
            signHeaders = s.toArray(new String[s.size()]);
        } else {
            signHeaders = DEFAULT_SIGNHEADERS;
        }
        apiRequest.addHeader("X-Api-ClientID", this.config.getClientID());
        apiRequest.addHeader("X-Api-Auth-Version", AUTH_VERSION);
        apiRequest.addHeader("X-Api-TimeStamp", this.getTimestamp());
        apiRequest.addHeader("X-Api-Nonce", this.getNonce(10));
        apiRequest.addHeader("X-Api-SignHeaders", String.join((CharSequence)",", signHeaders));
        apiRequest.addHeader("X-Api-Signature", this.getSignature(apiRequest.getMethod().getValue(), this.getPathEncode(apiRequest.getPath()), this.getQueryEncode(apiRequest.getQuerys()), signHeaders, apiRequest.getHeaders()));
    }

    private String getPathEncode(String path) {
        try {
            return URLEncoder.encode(path, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
    }

    private String getTimestamp() {
        return Long.toString(System.currentTimeMillis());
    }

    public String getNonce(int len) {
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            rs.append(this.rand.nextInt(10));
        }
        return rs.toString();
    }

    private String getQueryEncode(Map<String, String> querys) {
        try {
            if (!CommontUtil.isEmpty(querys)) {
                ArrayList<String> list = new ArrayList<String>(querys.size());
                for (Map.Entry<String, String> entry : querys.entrySet()) {
                    String key = URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.toString());
                    String value = URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.toString());
                    list.add(key + "=" + value);
                }
                Collections.sort(list);
                String rawQueryString = String.join((CharSequence)"&", list);
                String[] queryStrings = rawQueryString.split("&");
                list.clear();
                for (String param : queryStrings) {
                    int index = param.indexOf("=");
                    if (index < 1) continue;
                    String key = URLEncoder.encode(param.substring(0, index), StandardCharsets.UTF_8.toString());
                    String value = URLEncoder.encode(param.substring(index + 1), StandardCharsets.UTF_8.toString());
                    list.add(key + "=" + value);
                }
                return String.join((CharSequence)"&", list);
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return "";
    }

    private String getSignature(String method, String path, String query, String[] signatureHeaders, Map<String, String> headers) {
        StringBuilder b = new StringBuilder();
        b.append(method);
        b.append("\n");
        b.append(path);
        b.append("\n");
        b.append(query);
        b.append("\n");
        for (String x : signatureHeaders) {
            b.append(x.toLowerCase());
            b.append(":");
            b.append(headers.get(x));
            b.append("\n");
        }
        String s = SHAUtil.SHA256HMAC(b.toString(), this.config.getClientSecret());
        if (s != null) {
            return Base64.encodeBase64String((byte[])s.getBytes());
        }
        return "";
    }
}

