/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.tools.smecloud.apigw.model;

import com.kingdee.eas.base.risk.tools.smecloud.apigw.constant.HttpMethod;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.FileStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiRequest {
    private byte[] body;
    private String scheme = "https";
    private String host;
    private String path;
    private final HttpMethod method;
    private File binaryFile;
    private InputStream binaryStream;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> querys;
    private Map<String, String> formData;
    private Map<String, File> formFile;
    private Map<String, InputStream> formFileStream;
    private Map<String, FileStream> fileStreams;
    private Map<String, String> formParam;
    private String requestContentType = null;
    private List<String> signHeaders = new ArrayList<String>();

    public void setBinaryStream(InputStream binaryStream) {
        this.requestContentType = "application/octet-stream; charset=utf-8";
        this.binaryStream = binaryStream;
    }

    public void setFormFileStream(Map<String, InputStream> formFileStream) {
        this.formFileStream = formFileStream;
    }

    public InputStream getBinaryStream() {
        return this.binaryStream;
    }

    public Map<String, InputStream> getFormFileStream() {
        return this.formFileStream;
    }

    public ApiRequest(HttpMethod method, String host, String path) {
        this.method = method;
        this.host = host;
        this.path = path;
    }

    public Map<String, FileStream> getFileStreams() {
        return this.fileStreams;
    }

    public void setFileStreams(Map<String, FileStream> fileStreams) {
        this.fileStreams = fileStreams;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setFormParam(Map<String, String> formParam) {
        this.formParam = formParam;
    }

    public void setFormData(Map<String, String> formData) {
        this.formData = formData;
    }

    public void setFormFile(Map<String, File> formFile) {
        this.formFile = formFile;
    }

    public void setQuerys(Map<String, String> querys) {
        this.querys = querys;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void addHeaders(Map<String, String> headerMap) {
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addSignHeaders(String sign, String value) {
        this.signHeaders.add(sign);
        this.addHeader(sign, value);
    }

    public List<String> getSignHeaders() {
        return this.signHeaders;
    }

    public void setBodyJson(byte[] body) {
        this.requestContentType = "application/json; charset=utf-8";
        this.body = body;
    }

    public void setBodyText(byte[] body) {
        this.requestContentType = "application/text; charset=utf-8";
        this.body = body;
    }

    public void setFile(File f) {
        this.requestContentType = "application/octet-stream; charset=utf-8";
        this.binaryFile = f;
    }

    public Map<String, String> getQuerys() {
        return this.querys;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getFormParam() {
        return this.formParam;
    }

    public Map<String, File> getFormFile() {
        return this.formFile;
    }

    public Map<String, String> getFormData() {
        return this.formData;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getPath() {
        return this.path;
    }

    public String getHost() {
        return this.host;
    }

    public byte[] getBody() {
        return this.body;
    }

    public File getFile() {
        return this.binaryFile;
    }
}

