/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.license.client.monitor.LicenseClientUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;

public class LicensePermissionUtils {
    public static boolean checkLicence(String fullName, String reportName) throws Exception {
        boolean hasLicence = false;
        LicenseUserInfo user = (LicenseUserInfo)SysContext.getSysContext().getProperty((Object)"License.UserInfo");
        LicenseController lc = FrameWorkClientUtils.getLicenseController();
        if (user == null) {
            return hasLicence;
        }
        int licenselcFlag = lc.requestLicense(user, fullName);
        switch (licenselcFlag) {
            case 1: {
                hasLicence = true;
                break;
            }
            case 4: {
                MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)LicensePermissionUtils.constructLicenseMessage(lc, fullName, reportName), (int)0);
                LicensePermissionUtils.abort();
                break;
            }
            case 2: {
                MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"), (String)LicensePermissionUtils.constructLicenseMessage(lc, fullName, reportName), (int)0);
                LicensePermissionUtils.abort();
            }
        }
        return hasLicence;
    }

    public static void releaseLicense(String fullName) {
        String sessionId = SysContext.getSysContext().getSessionID();
        try {
            LicenseController lc = FrameWorkClientUtils.getLicenseController();
            lc.releaseLicense(sessionId, fullName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String constructLicenseMessage(LicenseController lc, String fullName, String reportName) throws LicenseException {
        if (lc == null || fullName == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ClassName"));
        buffer.append("[" + fullName + "]");
        buffer.append("\n");
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ModuleName"));
        String moduleName = lc.getModuleByPackage(fullName);
        if (moduleName == null || moduleName.trim().length() == 0) {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_UnlimitUI"));
        } else {
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)moduleName) + "[" + moduleName + "]");
        }
        buffer.append("\n");
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_SubSystem"));
        String subSysName = LicenseClientUtil.getSubSystemNameByModularName((String)moduleName);
        if (subSysName == null || subSysName.trim().length() == 0) {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_UnlimitUI"));
        } else {
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)subSysName) + "[" + subSysName + "]");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    private static void abort() {
        SysUtil.abort();
    }

    public static void checkPermission(IObjectPK arg0, IObjectPK arg1, String viewPermission) throws EASBizException, BOSException {
        PermissionHelper.checkFunctionPermission(null, null, (String)viewPermission);
    }
}

