/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.report.IReportServer;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportProperty;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.ReportTreeNode;
import com.kingdee.eas.base.report.ReportTreeNodeInfo;
import com.kingdee.eas.base.report.ReportUtil;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public abstract class ReportServerBase
extends AbstractBOSObject
implements IReportServer {
    private Context webContext = null;
    private String listDisplayFileName = "";
    private int reportType = 0;
    private HashMap reportMoveCacheMap = null;
    private Boolean isSort = Boolean.FALSE;
    private Integer totalRowCount = new Integer(2);
    protected Integer sortClickType = new Integer(2);
    private String tablename = "";

    public Integer getTotalRowCount() {
        return this.totalRowCount;
    }

    public void setTotalRowCount(Integer totalRowCount) {
        this.totalRowCount = totalRowCount;
    }

    public Boolean isSort() {
        return this.isSort;
    }

    public void setSort(Boolean isSort) {
        this.isSort = isSort;
    }

    public Integer getSortClickType() {
        return this.sortClickType;
    }

    public void setSortClickType(Integer sortClickType) {
        System.out.println("\u62a5\u8868\u5f00\u53d1\uff0c\u8bbe\u7f6e\u8fc7\u6ee4\u70b9\u51fb\u7c7b\u578b\u4e3a:" + sortClickType);
        this.sortClickType = sortClickType == 2 || sortClickType == 1 ? sortClickType : new Integer(2);
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int reportType) {
        this.reportType = reportType;
    }

    public String getListDisplayFileName() {
        return this.listDisplayFileName;
    }

    public void setListDisplayFileName(String listDisplayFileName) {
        this.listDisplayFileName = listDisplayFileName;
    }

    public Context getWebContext() {
        return this.webContext;
    }

    @Override
    public void setWebContext(Context webContext) {
        this.webContext = webContext;
    }

    public Context getContext() {
        if (this.webContext == null) {
            return super.getContext();
        }
        return this.webContext;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    @Override
    public HashMap getListAndReportData(String reportID, ReportProperty reportProperty, RptParams filter) throws Exception {
        if (filter.getBoolean("isconnect")) {
            filter = this.buildFilterFromConnect(filter, (RptParams)filter.getObject("totalfilter"), (HashMap)filter.getObject("rowdata"));
            filter.setBoolean("isconnect", false);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        IRowSet dataList = this.getList(reportID, filter);
        if (dataList != null && dataList.first()) {
            this.reportType = 2;
            this.reportMoveCacheMap = new HashMap();
            filter.setObject("position", (Object)ReportUtil.getOneRowData(dataList));
            result.put("datalist", dataList);
            String ldf = this.listDisplayFileName;
            if (ldf != null && ldf.trim() != "") {
                result.put("listdisplayfieldname", ldf);
            }
            HashMap map = null;
            map = reportProperty.isVirtualMode() ? this.prepareData(reportID, filter, null) : this.getData(reportID, filter);
            result.putAll(map);
        } else {
            HashMap rptInfo = new HashMap();
            this.buildReportInfo(reportID, filter, rptInfo);
            result.putAll(rptInfo);
        }
        return result;
    }

    protected IRowSet getList(String reportID, RptParams filter) throws Exception {
        return null;
    }

    @Override
    public HashMap getData(String reportID, RptParams filter) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (filter.getBoolean("isconnect")) {
            filter = this.buildFilterFromConnect(filter, (RptParams)filter.getObject("totalfilter"), (HashMap)filter.getObject("rowdata"));
            filter.setBoolean("isconnect", false);
        }
        IRowSet data = this.getReportData(reportID, filter);
        this.buildReportInfo(reportID, filter, result);
        result.put("reportdata", data);
        result.put("issort", this.isSort);
        result.put("totalrowcount", this.totalRowCount);
        result.put("sortclicktype", this.sortClickType);
        return result;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        throw new ReportException(ReportException.REPORT_NO_LINEQUERY);
    }

    private void buildReportInfo(String reportID, RptParams filter, HashMap result) throws Exception, BOSException {
        ReportHeader header = this.getReportHeader(reportID, filter);
        result.put("reportheader", header);
        ReportTitles titles = this.getReportTitles(reportID, filter);
        result.put("reporttitle", titles);
        ReportFormatConditions reportFormatConditions = this.buildReportFormatConditions(reportID);
        if (reportFormatConditions != null) {
            result.put("reportformatconditions", reportFormatConditions);
        }
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        Locale locale = this.getContext().getLocale();
        String strSQL = "";
        strSQL = "SELECT T_BAS_REPORTHEADER.FID,FParentFieldName,FReportID,FCaption_" + locale + " as FCaption,FFieldName,FDecimalField,FDecimal, FColType,FWidth,FAlign,FLevel,FIndex,FMergeable,FFormatString,fishiberarchy,fleaffield   FROM T_BAS_REPORTHEADER  LEFT JOIN T_BAS_RptDataType ON T_BAS_RptDataType.FParentID=T_BAS_REPORTHEADER.FID  WHERE  FReportID = ?  Order By FLevel,FIndex,FParentFieldName ";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)strSQL, (Object[])new Object[]{reportID});
        return rs.next() ? ReportHeader.createReportHeader(rs) : new ReportHeader();
    }

    @Override
    public HashMap prepareData(String reportID, RptParams filter, String tableName) throws BaseException {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (tableName != null && !tableName.trim().equals("")) {
                this.dropTempTable(reportID, filter, tableName);
            }
            if (filter.getBoolean("isconnect")) {
                filter = this.buildFilterFromConnect(filter, (RptParams)filter.getObject("totalfilter"), (HashMap)filter.getObject("rowdata"));
                filter.setBoolean("isconnect", false);
            }
            if (this.reportType == 2) {
                String value = ((HashMap)filter.getObject("position")).values().toString();
                boolean found = false;
                System.out.println("value:" + value);
                for (int i = 1; i <= this.reportMoveCacheMap.size(); ++i) {
                    String tempValue = this.reportMoveCacheMap.get(String.valueOf(i)).toString();
                    System.out.println("tempValue:" + tempValue);
                    if (!tempValue.equalsIgnoreCase(value)) continue;
                    found = true;
                    tableName = this.reportMoveCacheMap.get(String.valueOf(i)).toString();
                    break;
                }
                if (!found) {
                    tableName = this.buildReportDataForVirtual(reportID, filter);
                    this.reportMoveCacheMap.put(String.valueOf(this.reportMoveCacheMap.size() + 1), tableName);
                }
            } else {
                tableName = this.buildReportDataForVirtual(reportID, filter);
            }
            result.put("tablename", tableName);
            result.put("issort", this.isSort);
            result.put("totalrowcount", this.totalRowCount);
            result.put("sortclicktype", this.sortClickType);
            this.buildReportInfo(reportID, filter, result);
            return result;
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    @Override
    public void dropTempTable(String reportID, RptParams filter, String tableName) throws BaseException {
        if (this.reportType == 2) {
            if (this.reportMoveCacheMap == null) {
                return;
            }
            for (int i = 1; i <= this.reportMoveCacheMap.size(); ++i) {
                TempTablePool.getInstance((Context)this.getContext()).releaseTable(this.reportMoveCacheMap.get(String.valueOf(i)).toString());
            }
        } else {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(tableName);
        }
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        return null;
    }

    @Override
    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName), (int)start, (int)rows);
        return rs;
    }

    protected abstract IRowSet getReportData(String var1, RptParams var2) throws Exception;

    protected abstract ReportTitles getReportTitles(String var1, RptParams var2) throws BaseException;

    @Override
    public ReportTitles getReportTitlesExt(String reportID, RptParams filter) throws BaseException {
        return this.getReportTitles(reportID, filter);
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        String strSQL = "SELECT FID,FINDEX,FREPORTID,FFIELDNAME,FCELLVALUE,FCELLVALUE2,FCONDITION,FAPPLYROW,FBACKCOLOR,FFORECOLOR,FFONTBOLD FROM T_BAS_RPTFORMATCONDITIONS WHERE FReportID = ? Order By FIndex ";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)strSQL, (Object[])new Object[]{reportID});
        return rs.next() ? ReportFormatConditions.createReportFormatCondtions(rs) : null;
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public IRowSet getHiberarchyData(String reportID, RptParams filter, HashMap rowData) throws BaseException {
        return null;
    }

    @Override
    public ReportTreeNode buildTreeNode(String reportID, RptParams filter) throws BaseException {
        return null;
    }

    @Override
    public List getChildReportTreeNodeData(String reportID, RptParams filter, ReportTreeNodeInfo currentNodeInfo) throws BaseException {
        return null;
    }

    @Override
    public Integer getRowCount(String tempTable) throws BOSException {
        return 0;
    }
}

