/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.ssc.AssignRuleInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.app.AbstractAssignRuleControllerBean;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AssignRuleControllerBean
extends AbstractAssignRuleControllerBean {
    private static final long serialVersionUID = -2050533123860379527L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.AssignRuleControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((AssignRuleInfo)model).setShareCenterID(ShareCenterUtils.getShareCenterIdByCtx(ctx));
        this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
        this._checkPriorityDup(ctx, (AssignRuleInfo)model);
        ((AssignRuleInfo)model).setIsEnable(true);
        ((AssignRuleInfo)model).setRole(null);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
        this._checkPriorityDup(ctx, (AssignRuleInfo)model);
        super._update(ctx, pk, model);
    }

    private void _checkPriorityDup(Context ctx, AssignRuleInfo assignRuleInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("priority", (Object)assignRuleInfo.getPriority(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (assignRuleInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)assignRuleInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (assignRuleInfo.getBussAttr() != null) {
            filterItem = new FilterItemInfo("bussAttr.id", (Object)assignRuleInfo.getBussAttr().getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (assignRuleInfo.getShareCenterID() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)assignRuleInfo.getShareCenterID());
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            throw new SSCException(SSCException.PRIORITY_DUPLICATED);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AssignRuleInfo assignRuleInfo;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if ((assignRuleInfo = (AssignRuleInfo)model).getBussAttr() != null) {
            filterItem = new FilterItemInfo("bussAttr.id", (Object)assignRuleInfo.getBussAttr().getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (assignRuleInfo.getShareCenterID() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)assignRuleInfo.getShareCenterID());
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected List _getRuleColConfigList(Context ctx, String attrId) throws BOSException {
        ArrayList attrNumList = new ArrayList();
        try {
            IRowSet rs = this._getDynamicAttrSQL(ctx, attrId);
            while (rs.next()) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                String number = rs.getString("number");
                String name = rs.getString("name");
                int type = rs.getInt("type");
                m.put("number", number);
                m.put("name", name);
                m.put("type", type);
                attrNumList.add(m);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.deleteMultNumber(attrNumList);
        return attrNumList;
    }

    @Override
    protected List _getRuleColConfigByBillType(Context ctx, String billTypeID) throws BOSException, EASBizException {
        ArrayList attrNumList = new ArrayList();
        try {
            IRowSet rs = this._getDynamicAttrSQLByBillType(ctx, billTypeID);
            while (rs.next()) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                String id = rs.getString("id");
                String number = rs.getString("number");
                String name = rs.getString("name");
                String shareCenterID = rs.getString("shareCenterID");
                String topShareCenterID = rs.getString("topShareCenterID");
                int type = rs.getInt("type");
                m.put("id", id);
                m.put("number", number);
                m.put("name", name);
                m.put("type", type);
                m.put("shareCenterID", shareCenterID);
                m.put("topShareCenterID", topShareCenterID);
                attrNumList.add(m);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.deleteMultNumber(attrNumList);
        return attrNumList;
    }

    @Override
    protected List _getRuleColConfigByBillTypeId(Context ctx, String billTypeID) throws BOSException {
        ArrayList attrNumList = new ArrayList();
        try {
            IRowSet rs = this._getDynamicAttrSQLByBillTypeId(ctx, billTypeID);
            while (rs.next()) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                String id = rs.getString("id");
                String number = rs.getString("number");
                String name = rs.getString("name");
                int type = rs.getInt("type");
                m.put("id", id);
                m.put("number", number);
                m.put("name", name);
                m.put("type", type);
                attrNumList.add(m);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.deleteMultNumber(attrNumList);
        return attrNumList;
    }

    private void deleteMultNumber(List attrNumList) {
        HashSet<String> numberSet = new HashSet<String>();
        if (attrNumList != null && !attrNumList.isEmpty()) {
            int size = attrNumList.size();
            for (int i = 0; i < size; ++i) {
                Map map = (Map)attrNumList.get(i);
                String number = (String)map.get("number");
                if (numberSet.contains(number)) {
                    attrNumList.set(i, "0");
                    continue;
                }
                numberSet.add(number);
            }
            while (attrNumList.remove("0")) {
            }
        }
    }

    private IRowSet _getDynamicAttrSQL(Context ctx, String attrId) throws BOSException, SSCException {
        String shareCenterId = "";
        String sscShareCenterId = "";
        try {
            shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
            sscShareCenterId = ShareCenterUtils.getTopShareCenter(ctx).getId().toString();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("select distinct da.fnumber as number, da.fname_l2 as name, da.ftype as type").append(" from T_SSC_DynamicAttribute da left outer join T_SSC_BUSSINESSATTRIBUTE ba on ba.FbillTypeID = da.FbillTypeID").append(" left outer join T_SSC_BUSSINESSATTRIBUTEEXT baex on baex.fbussidID = ba.fid").append(" where  (ba.fid=? or baex.fid =? or da.FbillTypeID is null) and da.fshareCenterId in (?,?)");
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{attrId, attrId, shareCenterId, sscShareCenterId});
    }

    private IRowSet _getDynamicAttrSQLByBillType(Context ctx, String billTypeID) throws BOSException, SSCException {
        return this._getDynamicAttrSQLByBillType(ctx, billTypeID, null);
    }

    private IRowSet _getDynamicAttrSQLByBillType(Context ctx, String billTypeID, String shareCenterId) throws BOSException, SSCException {
        String sscShareCenterId = "";
        try {
            if (StringUtils.isBlank((String)shareCenterId)) {
                shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
            }
            sscShareCenterId = ShareCenterUtils.getTopShareCenter(ctx).getId().toString();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("select distinct da.fid as id,da.fnumber as number, da.fname_" + ctx.getLocale().toString() + " as name, da.ftype as type, da.fshareCenterId as shareCenterID ").append(", '" + sscShareCenterId + "' as topShareCenterID ").append(" from T_SSC_DynamicAttribute da ").append(" where  (da.fBillTypeID=? or da.FbillTypeID is null) and da.fshareCenterId in (?,?)");
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{billTypeID, shareCenterId, sscShareCenterId});
    }

    private IRowSet _getDynamicAttrSQLByBillTypeId(Context ctx, String billTypeID) throws BOSException, SSCException {
        String shareCenterId = "";
        String sscShareCenterId = "";
        try {
            shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
            sscShareCenterId = ShareCenterUtils.getTopShareCenter(ctx).getId().toString();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("select distinct da.fid as id,da.fnumber as number, da.fname_l2 as name, da.ftype as type").append(" from T_SSC_DynamicAttribute da ").append(" where da.fBillTypeID=? and da.fshareCenterId in (?,?)");
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{billTypeID, shareCenterId, sscShareCenterId});
    }

    @Override
    protected List _getRuleColConfigList(Context ctx, String billTypeId, String shareCenterId) throws BOSException, EASBizException {
        ArrayList attrNumList = new ArrayList();
        try {
            IRowSet rs = this._getDynamicAttrSQLByBillType(ctx, billTypeId, shareCenterId);
            while (rs.next()) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                String number = rs.getString("number");
                String name = rs.getString("name");
                String shareCenterID = rs.getString("shareCenterID");
                String topShareCenterID = rs.getString("topShareCenterID");
                int type = rs.getInt("type");
                m.put("number", number);
                m.put("name", name);
                m.put("type", type);
                m.put("shareCenterID", shareCenterID);
                m.put("topShareCenterID", topShareCenterID);
                attrNumList.add(m);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.deleteMultNumber(attrNumList);
        return attrNumList;
    }
}

