/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.BillTypeExtCollection;
import com.kingdee.eas.base.ssc.BillTypeExtFactory;
import com.kingdee.eas.base.ssc.BillTypeExtInfo;
import com.kingdee.eas.base.ssc.BillTypeFactory;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SingleLoginFacadeFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractBillTypeControllerBean;
import com.kingdee.eas.base.ssc.app.erp.EASIntelligentAuditWebService;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.ERPWebServiceBill;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.wssc.util.NodeUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BillTypeControllerBean
extends AbstractBillTypeControllerBean {
    private static Logger logger = Logger.getLogger(BillTypeControllerBean.class);
    private static final long serialVersionUID = -3608243120352902241L;

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameDup(ctx, (DataBaseInfo)model);
        BillTypeInfo typeInfo = (BillTypeInfo)model;
        UserInfo userInfo = ShareCenterUtils.getSSCUserInfoByCtx(ctx);
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
        BillTypeInfo typeInfo = (BillTypeInfo)model;
        UserInfo userInfo = ShareCenterUtils.getSSCUserInfoByCtx(ctx);
        IObjectPK pk = super._addnew(ctx, model);
        if (!ShareCenterUtils.isCurrentUserSSCAdmin(ctx, userInfo)) {
            typeInfo.setId(BOSUuid.read((String)pk.toString()));
            BillTypeExtInfo extInfo = new BillTypeExtInfo();
            extInfo.setShareCenterId(userInfo.getShareCenterId());
            extInfo.setStandardCoefficient(typeInfo.getStandardCoefficient());
            extInfo.setBillType(typeInfo);
            BillTypeExtFactory.getLocalInstance(ctx).addnew(extInfo);
        }
        return pk;
    }

    private void _checkDefault(Context ctx, String billTypeNumber, NumericExceptionSubItem excp) throws BOSException, EASBizException {
        Map cfgMap = SingleLoginFacadeFactory.getLocalInstance(ctx).getBillType2ModelCodeMap();
        if (cfgMap.containsKey(billTypeNumber)) {
            throw new SSCException(excp, new Object[]{billTypeNumber});
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BillTypeInfo info = (BillTypeInfo)model;
        this._checkNumberDup(ctx, (IObjectValue)info);
        BillTypeInfo btInfo = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo(pk);
        btInfo.setStandardCoefficient(info.getStandardCoefficient());
        btInfo.setIsOpenImage(info.isIsOpenImage());
        if (("ER_BizAccountBill".equals(btInfo.getNumber()) || "ER_TravelAccountBill".equals(btInfo.getNumber())) && !btInfo.getNumber().equals(info.getNumber())) {
            throw new SSCException(SSCException.DEFAULTNOTEDIT, new Object[]{btInfo.getNumber()});
        }
        UserInfo userInfo = ShareCenterUtils.getSSCUserInfoByCtx(ctx);
        if (!ShareCenterUtils.isCurrentUserSSCAdmin(ctx, userInfo)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billType", (Object)pk.toString()));
            filter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)ShareCenterUtils.getShareCenterIdByCtx(ctx)));
            view.setFilter(filter);
            BillTypeExtCollection beColl = BillTypeExtFactory.getLocalInstance(ctx).getBillTypeExtCollection(view);
            if (beColl.size() == 0) {
                BillTypeExtInfo extInfo = new BillTypeExtInfo();
                extInfo.setShareCenterId(userInfo.getShareCenterId());
                extInfo.setStandardCoefficient(btInfo.getStandardCoefficient());
                extInfo.setIsOpenImage(btInfo.isIsOpenImage());
                extInfo.setBillType(btInfo);
                BillTypeExtFactory.getLocalInstance(ctx).addnew(extInfo);
            } else {
                BillTypeExtInfo extInfo = beColl.get(0);
                extInfo.setShareCenterId(userInfo.getShareCenterId());
                extInfo.setStandardCoefficient(btInfo.getStandardCoefficient());
                extInfo.setIsOpenImage(btInfo.isIsOpenImage());
                extInfo.setBillType(btInfo);
                BillTypeExtFactory.getLocalInstance(ctx).update(H.PK(extInfo.getId()), extInfo);
            }
        } else {
            super._update(ctx, pk, model);
        }
    }

    private boolean isOnlyUpdateStander(BillTypeInfo oldInfo, BillTypeInfo newInfo) {
        boolean flag = oldInfo.getNumber().equals(newInfo.getNumber()) && oldInfo.getName().equals(newInfo.getName()) && oldInfo.getDescription() == newInfo.getDescription();
        return flag;
    }

    @Override
    protected IBriefViewTreeNode _getBillEntityTree(Context ctx, String erpId) throws BOSException, EASBizException {
        try {
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
            if (service == null) {
                throw new BOSException("can not find ERPWebServiceImpl");
            }
            if (service instanceof ERPWebServiceBill) {
                return ((ERPWebServiceBill)((Object)service)).getBillEntityTree(ctx, erpId);
            }
            throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected DefaultKingdeeTreeNode _getBillFiledTree(Context ctx, String erpId, String billEntity) throws BOSException, EASBizException {
        try {
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
            if (service == null) {
                throw new BOSException("can not find ERPWebServiceImpl");
            }
            if (service instanceof ERPWebServiceBill) {
                return ((ERPWebServiceBill)((Object)service)).getBillFiledTree(ctx, erpId, billEntity);
            }
            throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected String _getBillEntityTreeJson(Context ctx, String erpId) throws BOSException, EASBizException {
        try {
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
            if (service == null) {
                throw new BOSException("can not find ERPWebServiceImpl");
            }
            if (service instanceof ERPWebServiceBill) {
                return ((ERPWebServiceBill)((Object)service)).getBillEntityTreeJson(ctx, erpId);
            }
            throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected String _getBillFiledTreeJson(Context ctx, String erpId, String billEntity) throws BOSException, EASBizException {
        if (this.isSscBaseBill(ctx, billEntity)) {
            NodeUtils node = new NodeUtils(ctx, 0, billEntity, null);
            return node.getBillFiledTreeJson();
        }
        try {
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
            if (service == null) {
                throw new BOSException("can not find ERPWebServiceImpl");
            }
            if (service instanceof ERPWebServiceBill) {
                return ((ERPWebServiceBill)((Object)service)).getBillFiledTreeJson(ctx, erpId, billEntity);
            }
            throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected String _getBillFiledTreeJson(Context ctx, String erpId, String billEntity, int showLevelCount) throws BOSException, EASBizException {
        if (this.isSscBaseBill(ctx, billEntity)) {
            NodeUtils node = new NodeUtils(ctx, showLevelCount, billEntity, null);
            return node.getBillFiledTreeJson();
        }
        try {
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
            if (service == null) {
                throw new BOSException("can not find ERPWebServiceImpl");
            }
            if (service instanceof ERPWebServiceBill) {
                return ((ERPWebServiceBill)((Object)service)).getBillFiledTreeJson(ctx, erpId, billEntity, showLevelCount);
            }
            throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean isSscBaseBill(Context ctx, String billEntity) {
        try {
            Project.Projects projects = Project.Projects.getProjects((Project[])new Project[]{new Project("tBj8Gt3jAcrgQ8CoPwoByiyY1lE=")}, null);
            for (EntityObjectInfo entity = (EntityObjectInfo)MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).get(MetaDataTypeList.ENTITY, (IMetaDataPK)MetaDataPK.create((String)billEntity), projects); entity != null; entity = entity.getBaseEntity()) {
                if (!"com.kingdee.eas.base.ssc.app.SscBaseBill".equals(entity.getFullName())) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return false;
    }

    @Override
    protected String _getBillTransformRules(Context ctx, String erpId, String billIds, String type, Object modelOrgValue) throws BOSException, EASBizException {
        try {
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
            if (service == null) {
                throw new BOSException("can not find ERPWebServiceImpl");
            }
            if (service instanceof ERPWebServiceBill) {
                return ((ERPWebServiceBill)((Object)service)).getBillTransformRules(ctx, erpId, billIds, type, modelOrgValue);
            }
            throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected String _getBillTransformRulesForPreview(Context ctx, String erpId, String billIds, String type, Object modelOrgValue) throws BOSException {
        try {
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
            if (service == null) {
                throw new BOSException("can not find ERPWebServiceImpl");
            }
            if (service instanceof ERPWebServiceBill) {
                return ((ERPWebServiceBill)((Object)service)).getBillTransformRulesForPreview(ctx, erpId, billIds, type, modelOrgValue);
            }
            throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected Map _getBillAttribute(Context ctx, String erpId, String billId, List keys, String otherParams) throws BOSException {
        try {
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
            if (service == null) {
                throw new BOSException("can not find ERPWebServiceImpl");
            }
            if (service instanceof EASIntelligentAuditWebService) {
                return ((EASIntelligentAuditWebService)((Object)service)).getBillAttribute(ctx, erpId, billId, keys, null);
            }
            throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

