/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.CheckResultEnum;
import com.kingdee.eas.base.ssc.CheckTypeEnum;
import com.kingdee.eas.base.ssc.CreditDeForAuditQualityFacadeFactory;
import com.kingdee.eas.base.ssc.CreditDemotionForSpotFacadeFactory;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.CreditLogFactory;
import com.kingdee.eas.base.ssc.CreditParamsEntryFactory;
import com.kingdee.eas.base.ssc.CreditParamsFacadeFactory;
import com.kingdee.eas.base.ssc.CreditScoreInfo;
import com.kingdee.eas.base.ssc.DynValueHisFactory;
import com.kingdee.eas.base.ssc.DynValueHisInfo;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.base.ssc.JobUnpassReaFactory;
import com.kingdee.eas.base.ssc.SampleLibraryFactory;
import com.kingdee.eas.base.ssc.SampleLibraryInfo;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskCollection;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskFactory;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskInfo;
import com.kingdee.eas.base.ssc.app.AbstractCreditRelegationArithmeticFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.ChangeSourceEnum;
import com.kingdee.eas.base.ssc.app.InfluenceCreditTypeEnum;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.credit.CreditCache;
import com.kingdee.eas.base.ssc.tool.credit.CreditParamsUtils;
import com.kingdee.eas.base.ssc.tool.credit.CreditUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class CreditRelegationArithmeticFacadeControllerBean
extends AbstractCreditRelegationArithmeticFacadeControllerBean {
    private static final long serialVersionUID = -3333374675065531433L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CreditRelegationArithmeticFacadeControllerBean");

    @Override
    protected void _shareAuditCreditScore(Context ctx, JobInfo jobInfo, boolean isAuditPass, double isPass) throws BOSException, EASBizException {
        this._shareAuditChangeCreditByScore(ctx, jobInfo.getId().toString());
    }

    private List<SampleLibraryQualityTaskInfo> getTaskList(Context ctx, String parentId) {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<SampleLibraryQualityTaskInfo> lstTask = new ArrayList<SampleLibraryQualityTaskInfo>();
        try {
            SampleLibraryInfo sampLibInfo = SampleLibraryFactory.getLocalInstance(ctx).getSampleLibraryInfo(H.PK(parentId));
            InfluenceCreditTypeEnum type = null;
            if (CheckTypeEnum.afterAudit.equals((Object)sampLibInfo.getCheckType())) {
                type = InfluenceCreditTypeEnum.sharedReview;
            }
            if (CheckTypeEnum.AuditCheck.equals((Object)sampLibInfo.getCheckType())) {
                type = InfluenceCreditTypeEnum.auditQuality;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(" SELECT SQ.FID taskID,JS.FID jobID FROM T_SSC_samplelibraryqualitytask SQ ");
            buffer.append(" INNER JOIN T_SSC_JOBHIS JS ON JS.FBILLID=SQ.FBILLID ");
            buffer.append(" WHERE JS.FISLASTLEVEL =1 ");
            buffer.append(" AND SQ.FPARENTID = ? ");
            IRowSet tIRowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{parentId});
            while (tIRowSet.next()) {
                map.put(tIRowSet.getString("taskID"), tIRowSet.getString("jobID"));
            }
            SampleLibraryQualityTaskCollection sqTaskColl = SampleLibraryQualityTaskFactory.getLocalInstance(ctx).getSampleLibraryQualityTaskCollection("select * where parent = '" + parentId + "'");
            for (int i = 0; sqTaskColl != null && i < sqTaskColl.size(); ++i) {
                SampleLibraryQualityTaskInfo taskInfo = sqTaskColl.get(i);
                try {
                    String jobId = (String)map.get(taskInfo.getId().toString());
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jobId) && CreditParamsUtils.isMatchCreditParam(ctx, jobId, type)) {
                        SampleLibraryQualityTaskInfo info = new SampleLibraryQualityTaskInfo();
                        info.setId(taskInfo.getId());
                        info.setString("checkResult", taskInfo.getCheckResult() == null ? "" : taskInfo.getCheckResult().getValue());
                        info.setBillId(taskInfo.getBillId());
                        BillTypeInfo billTypeInfo = new BillTypeInfo();
                        billTypeInfo.setId(BOSUuid.read((String)taskInfo.getBillType().getId().toString()));
                        info.setBillType(billTypeInfo);
                        lstTask.add(info);
                        continue;
                    }
                    logger.error((Object)("\u4e0d\u5339\u914d\u89c4\u5219\u6216\u8005\u662fjobId\u662f\u7a7a\u7684\uff1a" + taskInfo.getId().toString()));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return lstTask;
    }

    private boolean isMatchCreditRuleByShareCenter(Context ctx, String scId, String bussAttrId, String jobId) {
        try {
            String isCredit = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(scId), (String)"SSC_CREDIT_MANAGER");
            if (!"true".equalsIgnoreCase(isCredit)) {
                logger.error((Object)"\u4fe1\u7528\u53c2\u6570\u672a\u542f\u7528\uff0c\u5982\u9700\u4f7f\u7528\u4fe1\u7528\uff0c\u8bf7\u5f00\u542f\u4fe1\u7528\u53c2\u6570");
                return false;
            }
            if (!CreditParamsFacadeFactory.getLocalInstance(ctx).whetherInfluenceCredit(scId, InfluenceCreditTypeEnum.sharedAudit)) {
                logger.error((Object)"\u5171\u4eab\u5ba1\u6838\u4e0d\u5f71\u54cd\u4fe1\u7528\uff0c\u5982\u9700\u53d8\u66f4\uff0c\u8bf7\u5728\u4fe1\u7528\u53c2\u6570\u8bbe\u7f6e\u4e2d\u914d\u7f6e");
                return false;
            }
            BussinessAttributeInfo bInfo = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo("select billType.id,billType.name where id='" + bussAttrId + "'");
            String billTypeID = bInfo.getBillType().getId().toString();
            if (!CreditParamsEntryFactory.getLocalInstance(ctx).exists("where billType.id = '" + billTypeID + "'")) {
                logger.error((Object)("\u5355\u636e\u7c7b\u578b" + bInfo.getBillType().getName() + "\u4e0d\u5f71\u54cd\u4fe1\u7528\uff0c\u5982\u9700\u53d8\u66f4\uff0c\u8bf7\u5728\u4fe1\u7528\u53c2\u6570\u8bbe\u7f6e\u4e2d\u914d\u7f6e"));
                return false;
            }
            if (!CreditParamsUtils.isMatchCreditParam(ctx, jobId, InfluenceCreditTypeEnum.sharedAudit)) {
                logger.error((Object)("\u4efb\u52a1" + jobId + "\u4e0d\u6ee1\u8db3\u5355\u636e\u4fe1\u7528\u89c4\u5219"));
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private String getBillCreatorIdByJobId(Context ctx, String jobId) throws BOSException, EASBizException {
        String querySql = "select FDinamicValue from T_SSC_DynValueHis where FJobIDID=? and FDynamicIDID='4VBUlqSUQuO8g8sPkTkXsZvLn80='";
        String creatorId = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{jobId});
            if (rs.next()) {
                creatorId = rs.getString("FDinamicValue");
            }
            if (StringUtils.isEmpty(creatorId)) {
                querySql = "select FDinamicValue from T_SSC_DynamicValue where FJobIDID=? and FDynamicIDID='4VBUlqSUQuO8g8sPkTkXsZvLn80='";
                rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{jobId});
                if (rs.next()) {
                    creatorId = rs.getString("FDinamicValue");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return creatorId;
    }

    private String getBillCreatorIdByBillId(Context ctx, String billId) throws BOSException {
        String creatorId = null;
        try {
            JobHisInfo job = JobHisFactory.getLocalInstance(ctx).getJobHisInfo("select id where billID = '" + billId + "' and isLastLevel=1");
            DynValueHisInfo dyVal = DynValueHisFactory.getLocalInstance(ctx).getDynValueHisInfo("select dinamicValue where dynamicID = '4VBUlqSUQuO8g8sPkTkXsZvLn80=' and jobID='" + job.getId().toString() + "'");
            return dyVal.getDinamicValue();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return creatorId;
        }
    }

    private CreditFilesNewInfo getNewCreditFilesInfo(Context ctx, BigDecimal dscore, CreditFilesNewInfo creditFilesInfo) throws BOSException, EASBizException {
        CreditFilesNewInfo newCreditFilesInfo = (CreditFilesNewInfo)creditFilesInfo.clone();
        BigDecimal oneHundred = new BigDecimal("100");
        CreditScoreInfo creditScoreInfo = null;
        if (dscore.compareTo(BigDecimal.ZERO) <= 0) {
            dscore = BigDecimal.ZERO;
            creditScoreInfo = CreditUtils.getMinCreditScoreInfo(ctx);
        } else if (dscore.compareTo(oneHundred) >= 0) {
            dscore = oneHundred;
            creditScoreInfo = CreditUtils.getMaxCreditScoreInfo(ctx);
        } else {
            creditScoreInfo = CreditUtils.getCreditScoreInfo(ctx, dscore);
        }
        newCreditFilesInfo.setCreditScore(dscore);
        newCreditFilesInfo.setCreditRating(creditScoreInfo);
        return newCreditFilesInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _shareAuditChangeCreditByScore(Context ctx, String jobId) throws BOSException, EASBizException {
        if (!JobHisFactory.getLocalInstance(ctx).exists("where id = '" + jobId + "'")) {
            throw new EASBizException(new NumericExceptionSubItem("XXXXX", jobId + "\u6ca1\u6709\u5df2\u5b8c\u6210\u7684\u4efb\u52a1"));
        }
        JobHisInfo jobhisInfo = JobHisFactory.getLocalInstance(ctx).getJobHisInfo("where id = '" + jobId + "'");
        if (JobState.Passed.equals((Object)jobhisInfo.getJobState()) || JobState.ToVouchered.equals((Object)jobhisInfo.getJobState())) {
            if (!jobhisInfo.isIsLastLevel()) {
                if (!JobUnpassReaFactory.getLocalInstance(ctx).exists("where job.id = '" + jobhisInfo.getId().toString() + "'")) return;
                this._shareAuditMinusScore(ctx, jobId);
                return;
            } else {
                this._shareAuditAddScore(ctx, jobId);
            }
            return;
        } else {
            this._shareAuditMinusScore(ctx, jobId);
        }
    }

    @Override
    protected void _shareAuditAddScore(Context ctx, String scId, String userId, BigDecimal score, String jobId, String description) throws BOSException, EASBizException {
        if (null == score || score.compareTo(BigDecimal.ZERO) == 0) {
            logger.error((Object)"score\u4e3a0");
            return;
        }
        CreditFilesNewInfo oldCreditFilesInfo = CreditUtils.getCreditFilesInfo(ctx, userId);
        BigDecimal dscore = oldCreditFilesInfo.getCreditScore().add(score);
        CreditFilesNewInfo newCreditFilesInfo = this.getNewCreditFilesInfo(ctx, dscore, oldCreditFilesInfo);
        if (score.compareTo(BigDecimal.ZERO) == 1) {
            CreditUtils.updateCreditFilesByAddScore(ctx, newCreditFilesInfo.getCreditRating().getId().toString(), newCreditFilesInfo.getCreditScore(), oldCreditFilesInfo.getId().toString());
        } else {
            CreditUtils.updateCreditFilesByMinusScore(ctx, newCreditFilesInfo.getCreditRating().getId().toString(), newCreditFilesInfo.getCreditScore(), oldCreditFilesInfo.getId().toString());
        }
        if (StringUtils.isEmpty((String)description)) {
            StringBuffer tDescription = new StringBuffer();
            if (score.compareTo(BigDecimal.ZERO) == 1) {
                tDescription.append("\u7ec8\u5ba1\u901a\u8fc7,\u4ece" + oldCreditFilesInfo.getCreditScore().setScale(2, 4) + "\u5347\u5230");
            }
            if (score.compareTo(BigDecimal.ZERO) == -1) {
                String reducereason = CreditUtils.getUnPassReason(ctx, ChangeSourceEnum.sharedAudit, scId, jobId);
                tDescription.append(reducereason);
                tDescription.append("\u7ec8\u5ba1\u901a\u8fc7,\u4ece" + oldCreditFilesInfo.getCreditScore().setScale(2, 4) + "\u964d\u5230");
            }
            tDescription.append(newCreditFilesInfo.getCreditScore().setScale(2, 4) + "\u5206!");
            tDescription.append("\u73b0\u7b49\u7ea7\u4e3a" + newCreditFilesInfo.getCreditRating().getName());
            description = tDescription.toString();
        }
        CreditLogFactory.getLocalInstance(ctx).writeShareAuditAddScoreCreditLog(jobId, oldCreditFilesInfo, newCreditFilesInfo, description);
    }

    @Override
    protected void _shareAuditMinusScore(Context ctx, String scId, String userId, BigDecimal score, String jobId, String description) throws BOSException, EASBizException {
        if (null == score || score.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        CreditFilesNewInfo oldCreditFilesInfo = CreditUtils.getCreditFilesInfo(ctx, userId);
        BigDecimal dscore = oldCreditFilesInfo.getCreditScore().subtract(score);
        CreditFilesNewInfo newCreditFilesInfo = this.getNewCreditFilesInfo(ctx, dscore, oldCreditFilesInfo);
        CreditUtils.updateCreditFilesByMinusScore(ctx, newCreditFilesInfo.getCreditRating().getId().toString(), newCreditFilesInfo.getCreditScore(), oldCreditFilesInfo.getId().toString());
        if (StringUtils.isEmpty((String)description)) {
            StringBuffer tDescription = new StringBuffer();
            String reducereason = CreditUtils.getUnPassReason(ctx, ChangeSourceEnum.sharedAudit, scId, jobId);
            tDescription.append(reducereason);
            tDescription.append("\u5ba1\u6279\u4e0d\u901a\u8fc7,\u4ece" + oldCreditFilesInfo.getCreditScore().setScale(2, 4) + "\u964d\u5230");
            tDescription.append(newCreditFilesInfo.getCreditScore().setScale(2, 4) + "\u5206");
            tDescription.append("\u73b0\u7b49\u7ea7\u4e3a" + newCreditFilesInfo.getCreditRating().getName());
            description = tDescription.toString();
        }
        CreditLogFactory.getLocalInstance(ctx).writeShareAuditMinusScoreCreditLog(jobId, oldCreditFilesInfo, newCreditFilesInfo, description);
    }

    @Override
    protected void _shareAuditAddScore(Context ctx, String jobId) throws BOSException, EASBizException {
        if (!JobHisFactory.getLocalInstance(ctx).exists("where id = '" + jobId + "'")) {
            throw new EASBizException(new NumericExceptionSubItem("XXXXX", jobId + "\u6ca1\u6709\u5df2\u5b8c\u6210\u7684\u4efb\u52a1"));
        }
        JobHisInfo jobHisInfo = JobHisFactory.getLocalInstance(ctx).getJobHisInfo("where id = '" + jobId + "'");
        String userId = this.getBillCreatorIdByJobId(ctx, jobId);
        if (StringUtils.isEmpty((String)userId)) {
            logger.error((Object)("\u65e0\u6cd5\u6839\u636e" + jobId + "\u627e\u5230\u63d0\u5355\u4eba\uff0c\u8bf7\u68c0\u67e5\u5171\u4eab\u4efb\u52a1\u811a\u672c\u914d\u7f6e\u7684jobCreateID\u662f\u5426\u6709\u503c"));
            return;
        }
        String scId = jobHisInfo.getShareCenterID().getId().toString();
        if (!this.isMatchCreditRuleByShareCenter(ctx, scId, jobHisInfo.getBussAttrID().getId().toString(), jobId)) {
            return;
        }
        BigDecimal score = CreditUtils.getJobAddScore(ctx, jobHisInfo);
        this._shareAuditAddScore(ctx, scId, userId, score, jobId, "");
    }

    @Override
    protected void _shareAuditMinusScore(Context ctx, String jobId) throws BOSException, EASBizException {
        if (!JobHisFactory.getLocalInstance(ctx).exists("where id = '" + jobId + "'")) {
            throw new EASBizException(new NumericExceptionSubItem("XXXXX", jobId + "\u6ca1\u6709\u5df2\u5b8c\u6210\u7684\u4efb\u52a1"));
        }
        JobHisInfo jobHisInfo = JobHisFactory.getLocalInstance(ctx).getJobHisInfo("where id = '" + jobId + "'");
        String userId = this.getBillCreatorIdByJobId(ctx, jobId);
        if (StringUtils.isEmpty((String)userId)) {
            logger.error((Object)("\u65e0\u6cd5\u6839\u636e" + jobId + "\u627e\u5230\u63d0\u5355\u4eba\uff0c\u8bf7\u68c0\u67e5\u5171\u4eab\u4efb\u52a1\u811a\u672c\u914d\u7f6e\u7684jobCreateID\u662f\u5426\u6709\u503c"));
            return;
        }
        if (!this.isMatchCreditRuleByShareCenter(ctx, jobHisInfo.getShareCenterID().getId().toString(), jobHisInfo.getBussAttrID().getId().toString(), jobId)) {
            return;
        }
        BigDecimal jobMinusScore = CreditUtils.getJobMinusScore(ctx, jobHisInfo);
        if (jobMinusScore.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        this._shareAuditMinusScore(ctx, jobHisInfo.getShareCenterID().getId().toString(), userId, jobMinusScore, jobId, "");
    }

    @Override
    protected void _shareAuditChangeCreditByRule(Context ctx, String jobId) throws BOSException, EASBizException {
    }

    private SampleLibraryQualityTaskInfo getSampleLibraryQualityTaskInfo(Context ctx, String billId, CheckTypeEnum checkTypeEnum) throws BOSException {
        String oql = "where parent.checkType = " + checkTypeEnum.getValue() + " and billId = '" + billId + "'";
        SampleLibraryQualityTaskCollection taskColls = SampleLibraryQualityTaskFactory.getLocalInstance(ctx).getSampleLibraryQualityTaskCollection(oql);
        SampleLibraryQualityTaskInfo taskInfo = null;
        if (taskColls.size() > 0) {
            taskInfo = taskColls.get(0);
        }
        return taskInfo;
    }

    private void qualityCheckAddScore(Context ctx, String userId, BigDecimal score, String sampleLibraryQualityTaskId, String description) throws EASBizException, BOSException {
        if (null == score || score.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        CreditFilesNewInfo oldCreditFilesInfo = CreditUtils.getCreditFilesInfo(ctx, userId);
        BigDecimal dscore = oldCreditFilesInfo.getCreditScore().add(score);
        CreditFilesNewInfo newCreditFilesInfo = this.getNewCreditFilesInfo(ctx, dscore, oldCreditFilesInfo);
        if (StringUtils.isEmpty((String)description)) {
            StringBuilder tDescription = new StringBuilder();
            tDescription.append("\u8d28\u68c0\u5408\u683c,\u52a0\u5206\uff1b\u4ece" + oldCreditFilesInfo.getCreditScore().setScale(2, 4) + "\u5206\u52a0\u5230" + newCreditFilesInfo.getCreditScore().setScale(2, 4) + "\u5206\uff0c\u73b0\u7b49\u7ea7\u4e3a\uff1a" + oldCreditFilesInfo.getCreditRating() + "\u3002");
            description = tDescription.toString();
        }
        CreditUtils.updateCreditFilesByAddScore(ctx, newCreditFilesInfo.getCreditRating().getId().toString(), newCreditFilesInfo.getCreditScore(), oldCreditFilesInfo.getId().toString());
        CreditLogFactory.getLocalInstance(ctx).writeQulityCheckAddScoreCreditLog(sampleLibraryQualityTaskId, oldCreditFilesInfo, newCreditFilesInfo, description);
    }

    private void qualityCheckMinusScore(Context ctx, String userId, BigDecimal score, String sampleLibraryQualityTaskId, String scId, String description) throws EASBizException, BOSException {
        if (null == score || score.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        CreditFilesNewInfo oldCreditFilesInfo = CreditUtils.getCreditFilesInfo(ctx, userId);
        BigDecimal dscore = oldCreditFilesInfo.getCreditScore().subtract(score);
        CreditFilesNewInfo newCreditFilesInfo = this.getNewCreditFilesInfo(ctx, dscore, oldCreditFilesInfo);
        CreditUtils.updateCreditFilesByMinusScore(ctx, newCreditFilesInfo.getCreditRating().getId().toString(), newCreditFilesInfo.getCreditScore(), oldCreditFilesInfo.getId().toString());
        if (StringUtils.isEmpty((String)description)) {
            String reason = CreditUtils.getUnPassReason(ctx, ChangeSourceEnum.auditQuality, scId, sampleLibraryQualityTaskId);
            description = "\u8d28\u68c0\u4e0d\u5408\u683c:" + reason + "\u51cf" + score.setScale(2, 4) + "\u5206";
        }
        CreditLogFactory.getLocalInstance(ctx).writeQulityCheckMinusScoreCreditLog(sampleLibraryQualityTaskId, oldCreditFilesInfo, newCreditFilesInfo, description);
    }

    private void qualityCheckManualAudit(Context ctx, String shareCenterId, SampleLibraryQualityTaskInfo taskInfo, String userId) throws EASBizException, BOSException {
        BigDecimal minusScore = CreditUtils.getQualityMinusScore(ctx, shareCenterId, taskInfo.getId().toString());
        if (taskInfo.getCheckResult().equals((Object)CheckResultEnum.unqualify) && minusScore.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal shareAuditAddScore = CreditUtils.getAddScore(ctx, taskInfo.getBillId(), ChangeSourceEnum.sharedAudit);
            minusScore = minusScore.add(shareAuditAddScore);
            this.qualityCheckMinusScore(ctx, userId, minusScore, taskInfo.getId().toString(), shareCenterId, null);
        }
    }

    private void qualityCheckAutoAudit(Context ctx, String shareCenterId, SampleLibraryQualityTaskInfo taskInfo, String userId) throws EASBizException, BOSException {
        SampleLibraryQualityTaskInfo spotCheckTask = this.getSampleLibraryQualityTaskInfo(ctx, taskInfo.getBillId(), CheckTypeEnum.afterAudit);
        if (taskInfo.getCheckResult().equals((Object)CheckResultEnum.qualify)) {
            BigDecimal spotCheckAddScore;
            if (null == spotCheckTask || null == spotCheckTask.getCheckResult()) {
                this.qualityCheckAddScore(ctx, userId, CreditCache.getAddScorePerBill(ctx, shareCenterId), taskInfo.getId().toString(), null);
            } else if (spotCheckTask != null && spotCheckTask.getCheckResult().equals((Object)CheckResultEnum.qualify) && (spotCheckAddScore = CreditUtils.getAddScore(ctx, taskInfo.getBillId(), ChangeSourceEnum.sharedReview)).compareTo(BigDecimal.ZERO) == 0) {
                this.qualityCheckAddScore(ctx, userId, CreditCache.getAddScorePerBill(ctx, shareCenterId), taskInfo.getId().toString(), null);
            }
        } else if (taskInfo.getCheckResult().equals((Object)CheckResultEnum.unqualify)) {
            BigDecimal spotCheckMinusScore;
            BigDecimal minusScore = CreditUtils.getQualityMinusScore(ctx, shareCenterId, taskInfo.getId().toString());
            if (minusScore.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            if (null == spotCheckTask || null == spotCheckTask.getCheckResult()) {
                this.qualityCheckMinusScore(ctx, userId, minusScore, taskInfo.getId().toString(), shareCenterId, null);
            } else if (spotCheckTask.getCheckResult().equals((Object)CheckResultEnum.qualify)) {
                BigDecimal spotCheckAddScore = CreditUtils.getAddScore(ctx, taskInfo.getBillId(), ChangeSourceEnum.sharedReview);
                minusScore = minusScore.add(spotCheckAddScore);
                this.qualityCheckMinusScore(ctx, userId, minusScore, taskInfo.getId().toString(), shareCenterId, null);
            } else if (spotCheckTask.getCheckResult().equals((Object)CheckResultEnum.unqualify) && (spotCheckMinusScore = CreditUtils.getMinusScore(ctx, taskInfo.getBillId(), ChangeSourceEnum.sharedReview)).compareTo(BigDecimal.ZERO) == 0) {
                this.qualityCheckMinusScore(ctx, userId, minusScore, taskInfo.getId().toString(), shareCenterId, null);
            }
        }
    }

    private boolean isMatchCreditRuleByQualityCheck(Context ctx, String scId) {
        try {
            String isCredit = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(scId), (String)"SSC_CREDIT_MANAGER");
            if (!"true".equalsIgnoreCase(isCredit)) {
                logger.error((Object)"\u4fe1\u7528\u53c2\u6570\u672a\u542f\u7528\uff0c\u5982\u9700\u4f7f\u7528\u4fe1\u7528\uff0c\u8bf7\u5f00\u542f\u4fe1\u7528\u53c2\u6570");
                return false;
            }
            if (!CreditParamsFacadeFactory.getLocalInstance(ctx).whetherInfluenceCredit(scId, InfluenceCreditTypeEnum.auditQuality)) {
                logger.error((Object)"\u8d28\u68c0\u4e0d\u5f71\u54cd\u4fe1\u7528\uff0c\u5982\u9700\u53d8\u66f4\uff0c\u8bf7\u5728\u4fe1\u7528\u53c2\u6570\u8bbe\u7f6e\u4e2d\u914d\u7f6e");
                return false;
            }
            String sql = "select count(1) from t_ssc_CreditParamsEntry";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && rs.getInt(1) == 0) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private String getShareCenterId(Context ctx, String taskId) {
        String sql = "select jh.FShareCenterID scId from T_SSC_samplelibraryqualitytask sk left join t_ssc_jobhis jh on sk.fbillid=jh.fbillid where sk.fid='" + taskId + "' and jh.fislastlevel=1 and jh.fjobstate in('3','10')";
        IRowSet rs = null;
        String jobid = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                jobid = rs.getString("scId");
            }
        }
        catch (BOSException e) {
            logger.error((Object)"creditDeForAuditQuauy--@getJobId--filed ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"creditDeForAuditQuauy--@getJobId--SQLException--filed ", (Throwable)e);
        }
        return jobid;
    }

    @Override
    protected void _qualityCheckChangeCreditByScore(Context ctx, List sampleLibraryIds) throws BOSException, EASBizException {
        for (int i = 0; i < sampleLibraryIds.size(); ++i) {
            List<SampleLibraryQualityTaskInfo> taskList = this.getTaskList(ctx, String.valueOf(sampleLibraryIds.get(i)));
            for (SampleLibraryQualityTaskInfo taskInfo : taskList) {
                boolean isJobAuto;
                String billTypeID;
                String shareCenterId = this.getShareCenterId(ctx, taskInfo.getId().toString());
                if (!this.isMatchCreditRuleByQualityCheck(ctx, shareCenterId) || !CreditUtils.isCreditByBillTypeId(ctx, shareCenterId, billTypeID = taskInfo.getBillType().getId().toString())) continue;
                try {
                    isJobAuto = CreditUtils.isJobAuto(ctx, taskInfo.getBillId());
                }
                catch (Exception e) {
                    continue;
                }
                String userId = this.getBillCreatorIdByBillId(ctx, taskInfo.getBillId());
                if (StringUtils.isEmpty((String)userId)) {
                    logger.error((Object)("\u65e0\u6cd5\u6839\u636e" + taskInfo.getBillId() + "\u627e\u5230\u63d0\u5355\u4eba\uff0c\u8bf7\u68c0\u67e5\u5171\u4eab\u4efb\u52a1\u811a\u672c\u914d\u7f6e\u7684jobCreateID\u662f\u5426\u6709\u503c"));
                    continue;
                }
                if (isJobAuto) {
                    this.qualityCheckAutoAudit(ctx, shareCenterId, taskInfo, userId);
                    continue;
                }
                this.qualityCheckManualAudit(ctx, shareCenterId, taskInfo, userId);
            }
        }
    }

    @Override
    protected void _qualityCheckChangeCreditByRule(Context ctx, List sampleLibraryIds) throws BOSException, EASBizException {
        for (int i = 0; i < sampleLibraryIds.size(); ++i) {
            String sampleLibraryId = (String)sampleLibraryIds.get(i);
            CreditDeForAuditQualityFacadeFactory.getLocalInstance(ctx).creditDeAuditQuality(sampleLibraryId);
        }
    }

    private boolean isMatchCreditRuleBySpotCheck(Context ctx, String scId, String sampleLibraryQualityTaskId) {
        try {
            String isCredit = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(scId), (String)"SSC_CREDIT_MANAGER");
            if (!"true".equalsIgnoreCase(isCredit)) {
                logger.error((Object)"\u4fe1\u7528\u53c2\u6570\u672a\u542f\u7528\uff0c\u5982\u9700\u4f7f\u7528\u4fe1\u7528\uff0c\u8bf7\u5f00\u542f\u4fe1\u7528\u53c2\u6570");
                return false;
            }
            if (!CreditParamsFacadeFactory.getLocalInstance(ctx).whetherInfluenceCredit(scId, InfluenceCreditTypeEnum.sharedReview)) {
                logger.error((Object)"\u62bd\u68c0\u4e0d\u5f71\u54cd\u4fe1\u7528\uff0c\u5982\u9700\u53d8\u66f4\uff0c\u8bf7\u5728\u4fe1\u7528\u53c2\u6570\u8bbe\u7f6e\u4e2d\u914d\u7f6e");
                return false;
            }
            SampleLibraryQualityTaskInfo slqtInfo = SampleLibraryQualityTaskFactory.getLocalInstance(ctx).getSampleLibraryQualityTaskInfo("select billType.id,billType.name,billid where id='" + sampleLibraryQualityTaskId + "'");
            String billTypeID = slqtInfo.getBillType().getId().toString();
            if (!CreditParamsEntryFactory.getLocalInstance(ctx).exists("where billType.id = '" + billTypeID + "'")) {
                logger.error((Object)("\u5355\u636e\u7c7b\u578b" + slqtInfo.getBillType().getName() + "\u4e0d\u5f71\u54cd\u4fe1\u7528\uff0c\u5982\u9700\u53d8\u66f4\uff0c\u8bf7\u5728\u4fe1\u7528\u53c2\u6570\u8bbe\u7f6e\u4e2d\u914d\u7f6e"));
                return false;
            }
            String jobId = this.getJobIdByTaskId(ctx, sampleLibraryQualityTaskId);
            if (StringUtils.isEmpty((String)jobId)) {
                logger.error((Object)("\u6839\u636e\u4efb\u52a1id\u53d6jobid\u4e3a\u7a7a-sampleLibraryQualityTaskId:" + sampleLibraryQualityTaskId));
                return false;
            }
            if (!CreditParamsUtils.isMatchCreditParam(ctx, jobId, InfluenceCreditTypeEnum.sharedReview)) {
                logger.error((Object)("\u4efb\u52a1" + jobId + "\u4e0d\u6ee1\u8db3\u5355\u636e\u4fe1\u7528\u89c4\u5219"));
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private String getJobIdByTaskId(Context ctx, String sampleLibraryQualityTaskId) throws SQLException, BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT SQ.FID taskID,JS.FID jobID FROM T_SSC_samplelibraryqualitytask SQ ");
        buffer.append(" INNER JOIN T_SSC_JOBHIS JS ON JS.FBILLID=SQ.FBILLID ");
        buffer.append(" WHERE JS.FISLASTLEVEL =1 ");
        buffer.append(" AND SQ.Fid = ? ");
        IRowSet tIRowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{sampleLibraryQualityTaskId});
        if (tIRowSet.next()) {
            return tIRowSet.getString("jobID");
        }
        return null;
    }

    @Override
    protected void _spotCheckChangeCreditByScore(Context ctx, String sampleTaskId) throws BOSException, EASBizException {
        SampleLibraryQualityTaskInfo spotCheckTaskInfo = SampleLibraryQualityTaskFactory.getLocalInstance(ctx).getSampleLibraryQualityTaskInfo((IObjectPK)new ObjectUuidPK(sampleTaskId));
        if (spotCheckTaskInfo.getCheckResult().equals((Object)CheckResultEnum.qualify)) {
            this._spotCheckAddScore(ctx, sampleTaskId);
        } else if (spotCheckTaskInfo.getCheckResult().equals((Object)CheckResultEnum.unqualify)) {
            this._spotCheckMinusScore(ctx, sampleTaskId);
        }
    }

    @Override
    protected void _spotCheckAddScore(Context ctx, String sampleLibraryQualityTaskId) throws BOSException, EASBizException {
        BigDecimal spotCheckAddScore;
        String shareCenterId = this.getShareCenterId(ctx, sampleLibraryQualityTaskId);
        if (!this.isMatchCreditRuleBySpotCheck(ctx, shareCenterId, sampleLibraryQualityTaskId)) {
            return;
        }
        SampleLibraryQualityTaskInfo spotCheckTaskInfo = SampleLibraryQualityTaskFactory.getLocalInstance(ctx).getSampleLibraryQualityTaskInfo((IObjectPK)new ObjectUuidPK(sampleLibraryQualityTaskId));
        String billId = spotCheckTaskInfo.getBillId();
        String userId = this.getBillCreatorIdByBillId(ctx, billId);
        if (StringUtils.isEmpty((String)userId)) {
            logger.error((Object)("\u65e0\u6cd5\u6839\u636e" + billId + "\u627e\u5230\u63d0\u5355\u4eba\uff0c\u8bf7\u68c0\u67e5\u5171\u4eab\u4efb\u52a1\u811a\u672c\u914d\u7f6e\u7684jobCreateID\u662f\u5426\u6709\u503c"));
            return;
        }
        SampleLibraryQualityTaskInfo qualityCheckTask = this.getSampleLibraryQualityTaskInfo(ctx, billId, CheckTypeEnum.AuditCheck);
        if (null == qualityCheckTask || null == qualityCheckTask.getCheckResult()) {
            this._spotCheckAddScore(ctx, userId, CreditCache.getAddScorePerBill(ctx, shareCenterId), sampleLibraryQualityTaskId, null);
        } else if (qualityCheckTask != null && qualityCheckTask.getCheckResult().equals((Object)CheckResultEnum.qualify) && (spotCheckAddScore = CreditUtils.getAddScore(ctx, billId, ChangeSourceEnum.auditQuality)).compareTo(BigDecimal.ZERO) == 0) {
            this._spotCheckAddScore(ctx, userId, CreditCache.getAddScorePerBill(ctx, shareCenterId), sampleLibraryQualityTaskId, null);
        }
    }

    @Override
    protected void _spotCheckAddScore(Context ctx, String userId, BigDecimal score, String sampleLibraryQualityTaskId, String description) throws BOSException, EASBizException {
        if (null == score || score.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        CreditFilesNewInfo oldCreditFilesInfo = CreditUtils.getCreditFilesInfo(ctx, userId);
        BigDecimal dscore = oldCreditFilesInfo.getCreditScore().add(score);
        CreditFilesNewInfo newCreditFilesInfo = this.getNewCreditFilesInfo(ctx, dscore, oldCreditFilesInfo);
        CreditUtils.updateCreditFilesByAddScore(ctx, newCreditFilesInfo.getCreditRating().getId().toString(), newCreditFilesInfo.getCreditScore(), oldCreditFilesInfo.getId().toString());
        if (StringUtils.isEmpty((String)description)) {
            StringBuffer tDescription = new StringBuffer();
            tDescription.append("\u5171\u4eab\u62bd\u68c0\u5408\u683c\u52a0\u5206,\u4ece" + Double.parseDouble(oldCreditFilesInfo.getCreditScore().toString()) + "\u5206\u52a0\u5206\u5230").append(Double.parseDouble(newCreditFilesInfo.getCreditScore().toString()) + "\u5206");
            description = tDescription.toString();
        }
        CreditLogFactory.getLocalInstance(ctx).writeSpotCheckAddScoreCreditLog(sampleLibraryQualityTaskId, oldCreditFilesInfo, newCreditFilesInfo, description);
    }

    @Override
    protected void _spotCheckMinusScore(Context ctx, String sampleLibraryQualityTaskId) throws BOSException, EASBizException {
        BigDecimal spotCheckMinusScore;
        String shareCenterId = this.getShareCenterId(ctx, sampleLibraryQualityTaskId);
        if (!this.isMatchCreditRuleBySpotCheck(ctx, shareCenterId, sampleLibraryQualityTaskId)) {
            return;
        }
        BigDecimal minusScore = CreditUtils.getSpotMinusScore(ctx, shareCenterId, sampleLibraryQualityTaskId);
        if (minusScore.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        SampleLibraryQualityTaskInfo spotCheckTaskInfo = SampleLibraryQualityTaskFactory.getLocalInstance(ctx).getSampleLibraryQualityTaskInfo((IObjectPK)new ObjectUuidPK(sampleLibraryQualityTaskId));
        String billId = spotCheckTaskInfo.getBillId();
        String userId = this.getBillCreatorIdByBillId(ctx, billId);
        if (StringUtils.isEmpty((String)userId)) {
            logger.error((Object)("\u65e0\u6cd5\u6839\u636e" + billId + "\u627e\u5230\u63d0\u5355\u4eba\uff0c\u8bf7\u68c0\u67e5\u5171\u4eab\u4efb\u52a1\u811a\u672c\u914d\u7f6e\u7684jobCreateID\u662f\u5426\u6709\u503c"));
            return;
        }
        SampleLibraryQualityTaskInfo qualityCheckTask = this.getSampleLibraryQualityTaskInfo(ctx, billId, CheckTypeEnum.AuditCheck);
        if (null == qualityCheckTask || null == qualityCheckTask.getCheckResult()) {
            this._spotCheckMinusScore(ctx, shareCenterId, userId, minusScore, sampleLibraryQualityTaskId, null);
        } else if (qualityCheckTask.getCheckResult().equals((Object)CheckResultEnum.qualify)) {
            BigDecimal spotCheckAddScore = CreditUtils.getAddScore(ctx, billId, ChangeSourceEnum.auditQuality);
            minusScore = minusScore.add(spotCheckAddScore);
            this._spotCheckMinusScore(ctx, shareCenterId, userId, minusScore, sampleLibraryQualityTaskId, null);
        } else if (qualityCheckTask.getCheckResult().equals((Object)CheckResultEnum.unqualify) && (spotCheckMinusScore = CreditUtils.getMinusScore(ctx, billId, ChangeSourceEnum.auditQuality)).compareTo(BigDecimal.ZERO) == 0) {
            this._spotCheckMinusScore(ctx, shareCenterId, userId, minusScore, sampleLibraryQualityTaskId, null);
        }
    }

    @Override
    protected void _spotCheckMinusScore(Context ctx, String scId, String userId, BigDecimal score, String sampleLibraryQualityTaskId, String description) throws BOSException, EASBizException {
        if (null == score || score.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        CreditFilesNewInfo oldCreditFilesInfo = CreditUtils.getCreditFilesInfo(ctx, userId);
        BigDecimal dscore = oldCreditFilesInfo.getCreditScore().subtract(score);
        CreditFilesNewInfo newCreditFilesInfo = this.getNewCreditFilesInfo(ctx, dscore, oldCreditFilesInfo);
        CreditUtils.updateCreditFilesByMinusScore(ctx, newCreditFilesInfo.getCreditRating().getId().toString(), newCreditFilesInfo.getCreditScore(), oldCreditFilesInfo.getId().toString());
        if (StringUtils.isEmpty((String)description)) {
            StringBuffer tDescription = new StringBuffer();
            String reducereason = CreditUtils.getUnPassReason(ctx, ChangeSourceEnum.sharedReview, scId, sampleLibraryQualityTaskId);
            tDescription.append("\u5171\u4eab\u62bd\u68c0\u4e0d\u5408\u683c\u4fe1\u7528\u964d\u7ea7,\u539f\u56e0 :" + reducereason + ",\u4ece" + oldCreditFilesInfo.getCreditRating() + "\u7ea7\u522b\u964d\u7ea7\u4e3a");
            tDescription.append(newCreditFilesInfo.getCreditRating() + "\u7ea7\u522b");
            description = tDescription.toString();
        }
        CreditLogFactory.getLocalInstance(ctx).writeSpotCheckMinusScoreCreditLog(sampleLibraryQualityTaskId, oldCreditFilesInfo, newCreditFilesInfo, description);
    }

    @Override
    protected void _spotCheckChangeCreditByRule(Context ctx, String sampleLibraryQualityTaskId) throws BOSException, EASBizException {
        SampleLibraryQualityTaskInfo sampleLibraryQualityTaskInfo = SampleLibraryQualityTaskFactory.getLocalInstance(ctx).getSampleLibraryQualityTaskInfo((IObjectPK)new ObjectUuidPK(sampleLibraryQualityTaskId));
        String billId = sampleLibraryQualityTaskInfo.getBillId();
        ArrayList<String> reason = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FREDUCEREASON");
        sb.append(" FROM T_SSC_CreditSLRRSE");
        sb.append(" where FREASONBYGXFHID in(");
        sb.append(" select FUPQUALIFYREASONID from T_SSC_TaskUnpassReason where FTASKID = ?");
        sb.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{sampleLibraryQualityTaskId});
            while (rs.next()) {
                reason.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("sql:" + sb.toString() + ",taskId:" + sampleLibraryQualityTaskId));
        }
        JobHisInfo jobhisInfo = JobHisFactory.getLocalInstance(ctx).getJobHisInfo("where billID = '" + billId + "' and isLastLevel=1");
        String[] reasonArr = new String[reason.size()];
        for (int i = 0; i < reason.size(); ++i) {
            reasonArr[i] = (String)reason.get(i);
        }
        CreditDemotionForSpotFacadeFactory.getLocalInstance(ctx).creditDemotionByspot(billId, jobhisInfo.getId().toString(), reasonArr);
    }
}

