/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.ssc.ExtendERPFactory;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.app.AbstractEASWebServiceSetFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.WebServiceSetDao;
import com.kingdee.eas.base.ssc.app.erp.eas.CommonUtil;
import com.kingdee.eas.base.ssc.app.erp.eas.EASCfgUtil;
import com.kingdee.eas.base.ssc.erp.eas.EASConfig;
import com.kingdee.eas.base.ssc.erp.eas.EASLoginBean;
import com.kingdee.eas.base.ssc.erp.eas.EASWebServiceBean;
import com.kingdee.eas.base.ssc.tool.cache.SSCCacheManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EASWebServiceSetFacadeControllerBean
extends AbstractEASWebServiceSetFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.EASWebServiceSetFacadeControllerBean");

    @Override
    protected void _saveEASLoginBean(Context ctx, EASLoginBean easLoginBean) throws BOSException, EASBizException {
        String cfgFolder = "eas";
        this._saveEASLoginBean(ctx, cfgFolder, easLoginBean);
    }

    @Override
    protected EASLoginBean _getEASLoginBean(Context ctx) throws BOSException, EASBizException {
        String cfgFolder = "eas";
        return this._getEASLoginBean(ctx, cfgFolder);
    }

    @Override
    protected void _saveEASWebServiceBean(Context ctx, EASWebServiceBean easWebServiceBean) throws BOSException, EASBizException {
        String cfgFolder = "eas";
        this._saveEASWebServiceBean(ctx, cfgFolder, easWebServiceBean);
    }

    @Override
    protected EASWebServiceBean _getEASWebServiceBean(Context ctx) throws BOSException, EASBizException {
        String cfgFolder = "eas";
        return this._getEASWebServiceBean(ctx, cfgFolder);
    }

    @Override
    protected boolean _testConnection(Context ctx, EASLoginBean easLoginBean, String loginWsdl) throws BOSException, EASBizException {
        if (easLoginBean == null) {
            logger.error((Object)"-----easLoginBean is null------");
            return false;
        }
        boolean re = false;
        try {
            re = CommonUtil.loginEAS(easLoginBean, loginWsdl);
        }
        catch (Exception e) {
            throw new EASBizException(SSCException.WRONG_CINFIG, (Throwable)e);
        }
        return re;
    }

    @Override
    protected void _saveEASConfig(Context ctx, EASConfig easConfig) throws BOSException, EASBizException {
        if (easConfig == null) {
            return;
        }
        this._saveEASLoginBean(ctx, easConfig.getCfgFolder(), easConfig.getEasLoginBean());
        this._saveEASWebServiceBean(ctx, easConfig.getCfgFolder(), easConfig.getEasWebServiceBean());
        this._saveSSCConfig(ctx, easConfig.getErpId(), easConfig.getSscConfigMap());
    }

    private void _saveEASWebServiceBean(Context ctx, String cfgFolder, EASWebServiceBean easWebServiceBean) throws BOSException, EASBizException {
        if (easWebServiceBean == null) {
            return;
        }
        Properties prop = new Properties();
        prop.setProperty("eas.messagecenter.wsdl", easWebServiceBean.getMessage() == null ? "" : easWebServiceBean.getMessage());
        prop.setProperty("eas.login.wsdl", easWebServiceBean.getLogin() == null ? "" : easWebServiceBean.getLogin());
        prop.setProperty("eas.workflow.notify.wsdl", easWebServiceBean.getWorkflow() == null ? "" : easWebServiceBean.getWorkflow());
        prop.setProperty("eas.orgfacade.wsdl", easWebServiceBean.getOrg() == null ? "" : easWebServiceBean.getOrg());
        prop.setProperty("eas.userfacade.wsdl", easWebServiceBean.getPerson() == null ? "" : easWebServiceBean.getPerson());
        prop.setProperty("eas.bill.url", easWebServiceBean.getBillUrl() == null ? "" : easWebServiceBean.getBillUrl());
        prop.setProperty("eas.workflow.url", easWebServiceBean.getWorlflowUrl() == null ? "" : easWebServiceBean.getWorlflowUrl());
        prop.setProperty("eas.picture.url", easWebServiceBean.getPictureUrl() == null ? "" : easWebServiceBean.getPictureUrl());
        prop.setProperty("image.picture.url", easWebServiceBean.getPhoto() == null ? "" : easWebServiceBean.getPhoto());
        prop.setProperty("eas.login.ltpa.url", easWebServiceBean.getLoginLtpa() == null ? "" : easWebServiceBean.getLoginLtpa());
        prop.setProperty("eas.histore.agreement.url", easWebServiceBean.getHistory() == null ? "" : easWebServiceBean.getHistory());
        prop.setProperty("image.system.type", easWebServiceBean.getImageType());
        if (!StringUtils.isEmpty((String)easWebServiceBean.getDiscardForCmpUrl())) {
            prop.setProperty("eas.discard.for.cpt.url", easWebServiceBean.getDiscardForCmpUrl());
        }
        prop.setProperty("deployType", easWebServiceBean.getDeployType());
        if (!StringUtils.isEmpty((String)easWebServiceBean.getErpIp())) {
            prop.setProperty("erp.ip", easWebServiceBean.getErpIp());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getErpPort())) {
            prop.setProperty("erp.port", easWebServiceBean.getErpPort());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getImageIp())) {
            prop.setProperty("image.ip", easWebServiceBean.getImageIp());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getImagePort())) {
            prop.setProperty("image.port", easWebServiceBean.getImagePort());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getMessageTail())) {
            prop.setProperty("eas.messagecenter.wsdl.tail", easWebServiceBean.getMessageTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getLoginTail())) {
            prop.setProperty("eas.login.wsdl.tail", easWebServiceBean.getLoginTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getWorkflowTail())) {
            prop.setProperty("eas.workflow.notify.wsdl.tail", easWebServiceBean.getWorkflowTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getOrgTail())) {
            prop.setProperty("eas.orgfacade.wsdl.tail", easWebServiceBean.getOrgTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getPersonTail())) {
            prop.setProperty("eas.userfacade.wsdl.tail", easWebServiceBean.getPersonTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getBillUrlTail())) {
            prop.setProperty("eas.bill.url.tail", easWebServiceBean.getBillUrlTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getWorlflowUrlTail())) {
            prop.setProperty("eas.workflow.url.tail", easWebServiceBean.getWorlflowUrlTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getPictureUrlTail())) {
            prop.setProperty("eas.picture.url.tail", easWebServiceBean.getPictureUrlTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getPhotoTail())) {
            prop.setProperty("image.picture.url.tail", easWebServiceBean.getPhotoTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getLoginLtpaTail())) {
            prop.setProperty("eas.login.ltpa.url.tail", easWebServiceBean.getLoginLtpaTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getHistoryTail())) {
            prop.setProperty("eas.histore.agreement.url.tail", easWebServiceBean.getHistoryTail());
        }
        if (!StringUtils.isEmpty((String)easWebServiceBean.getDiscardForCmpUrlTail())) {
            prop.setProperty("eas.discard.for.cpt.url.tail", easWebServiceBean.getDiscardForCmpUrlTail());
        }
        WebServiceSetDao.save(prop, CommonUtil.getAbsoluteREMOTE_PATH(cfgFolder));
    }

    private void _saveEASLoginBean(Context ctx, String cfgFolder, EASLoginBean easLoginBean) throws BOSException, EASBizException {
        if (easLoginBean == null) {
            return;
        }
        Properties prop = new Properties();
        prop.setProperty("userName", easLoginBean.getUserName());
        prop.setProperty("password", easLoginBean.getPassword() == null ? "" : easLoginBean.getPassword());
        prop.setProperty("slnName", easLoginBean.getSlnName() == null ? "eas" : easLoginBean.getSlnName());
        prop.setProperty("language", easLoginBean.getLanguage() == null ? "L2" : easLoginBean.getLanguage());
        prop.setProperty("dcName", easLoginBean.getDcName());
        prop.setProperty("dbType", easLoginBean.getDbType());
        WebServiceSetDao.save(prop, CommonUtil.getAbsoluteEASLOGIN_PATH(cfgFolder));
    }

    @Override
    protected EASConfig _getEASConfig(Context ctx) throws BOSException, EASBizException {
        String cfgFolder = "eas";
        return this._getEASConfig(ctx, cfgFolder);
    }

    @Override
    protected EASConfig _getEASConfig(Context ctx, String cfgFolder) throws BOSException, EASBizException {
        EASConfig easConfig = new EASConfig();
        easConfig.setEasLoginBean(this._getEASLoginBean(ctx, cfgFolder));
        easConfig.setEasWebServiceBean(this._getEASWebServiceBean(ctx, cfgFolder));
        return easConfig;
    }

    private EASLoginBean _getEASLoginBean(Context ctx, String cfgFolder) throws BOSException, EASBizException {
        Properties prop = WebServiceSetDao.getProperties(CommonUtil.getAbsoluteEASLOGIN_PATH(cfgFolder));
        EASLoginBean easLoginBean = new EASLoginBean();
        easLoginBean.setUserName(prop.getProperty("userName"));
        easLoginBean.setPassword(prop.getProperty("password"));
        easLoginBean.setSlnName(prop.getProperty("slnName"));
        easLoginBean.setLanguage(prop.getProperty("language"));
        easLoginBean.setDcName(prop.getProperty("dcName"));
        easLoginBean.setDbType(prop.getProperty("dbType"));
        SSCCacheManager.clearCache("erp_config_properties_map");
        return easLoginBean;
    }

    private EASWebServiceBean _getEASWebServiceBean(Context ctx, String cfgFolder) throws BOSException, EASBizException {
        Properties prop = WebServiceSetDao.getProperties(CommonUtil.getAbsoluteREMOTE_PATH(cfgFolder));
        EASWebServiceBean easWebServiceBean = new EASWebServiceBean();
        easWebServiceBean.setBillUrl(prop.getProperty("eas.bill.url"));
        easWebServiceBean.setHistory(prop.getProperty("eas.histore.agreement.url"));
        easWebServiceBean.setLogin(prop.getProperty("eas.login.wsdl"));
        easWebServiceBean.setLoginLtpa(prop.getProperty("eas.login.ltpa.url"));
        easWebServiceBean.setMessage(prop.getProperty("eas.messagecenter.wsdl"));
        easWebServiceBean.setOrg(prop.getProperty("eas.orgfacade.wsdl"));
        easWebServiceBean.setPerson(prop.getProperty("eas.userfacade.wsdl"));
        easWebServiceBean.setPhoto(prop.getProperty("image.picture.url"));
        easWebServiceBean.setPictureUrl(prop.getProperty("eas.picture.url"));
        easWebServiceBean.setWorkflow(prop.getProperty("eas.workflow.notify.wsdl"));
        easWebServiceBean.setWorlflowUrl(prop.getProperty("eas.workflow.url"));
        easWebServiceBean.setImageType(prop.getProperty("image.system.type"));
        easWebServiceBean.setDiscardForCmpUrl(prop.getProperty("eas.discard.for.cpt.url"));
        easWebServiceBean.setErpIp(prop.getProperty("erp.ip"));
        easWebServiceBean.setErpPort(prop.getProperty("erp.port"));
        easWebServiceBean.setImageIp(prop.getProperty("image.ip"));
        easWebServiceBean.setImagePort(prop.getProperty("image.port"));
        easWebServiceBean.setBillUrlTail(prop.getProperty("eas.bill.url.tail"));
        easWebServiceBean.setHistoryTail(prop.getProperty("eas.histore.agreement.url.tail"));
        easWebServiceBean.setLoginTail(prop.getProperty("eas.login.wsdl.tail"));
        easWebServiceBean.setLoginLtpaTail(prop.getProperty("eas.login.ltpa.url.tail"));
        easWebServiceBean.setMessageTail(prop.getProperty("eas.messagecenter.wsdl.tail"));
        easWebServiceBean.setOrgTail(prop.getProperty("eas.orgfacade.wsdl.tail"));
        easWebServiceBean.setPersonTail(prop.getProperty("eas.userfacade.wsdl.tail"));
        easWebServiceBean.setPhotoTail(prop.getProperty("image.picture.url.tail"));
        easWebServiceBean.setPictureUrlTail(prop.getProperty("eas.picture.url.tail"));
        easWebServiceBean.setWorkflowTail(prop.getProperty("eas.workflow.notify.wsdl.tail"));
        easWebServiceBean.setWorlflowUrlTail(prop.getProperty("eas.workflow.url.tail"));
        easWebServiceBean.setDiscardForCmpUrlTail(prop.getProperty("eas.discard.for.cpt.url.tail"));
        easWebServiceBean.setDeployType(prop.getProperty("deployType"));
        SSCCacheManager.clearCache("erp_config_properties_map");
        return easWebServiceBean;
    }

    @Override
    protected String _getImageSysTypeByBussAttrId(Context ctx, String bussAttrId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT sa.FExtendErpID extendErpId");
        sb.append(" FROM T_SSC_BussinessAttribute ba,T_SSC_BILLTYPE bt,T_SSC_SystemAttribute sa");
        sb.append(" WHERE ba.FBILLTYPEID = bt.FID");
        sb.append(" AND bt.FSYSATTRID = sa.FID");
        sb.append(" AND ba.fid=?");
        Object[] params = new Object[]{bussAttrId};
        String extendId = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            if (rs.next()) {
                extendId = rs.getString("extendErpId");
            }
        }
        catch (SQLException e) {
            logger.error((Object)("sql:" + sb.toString()));
            logger.error((Object)("param:" + bussAttrId));
            logger.error((Object)"get extendERPId err", (Throwable)e);
        }
        if (StringUtils.isEmpty((String)extendId)) {
            return null;
        }
        ExtendERPInfo extendERPInfo = ExtendERPFactory.getLocalInstance(ctx).getExtendERPInfo((IObjectPK)new ObjectStringPK(extendId));
        String imageSystemType = EASCfgUtil.getValue(ctx, extendERPInfo, "image.system.type");
        return imageSystemType;
    }

    @Override
    protected String _getImageSysType(Context ctx) throws BOSException, EASBizException {
        String sql = "select sa.FExtendErpID extendErpId from  T_SSC_SystemAttribute sa where sa.FID = '73xvBgslTUGHhIpSWanVysuCaH0='";
        String extendId = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                extendId = rs.getString("extendErpId");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"get extendERPId err", (Throwable)e);
        }
        if (StringUtils.isEmpty((String)extendId)) {
            return null;
        }
        ExtendERPInfo extendERPInfo = ExtendERPFactory.getLocalInstance(ctx).getExtendERPInfo((IObjectPK)new ObjectStringPK(extendId));
        String imageSystemType = EASCfgUtil.getValue(ctx, extendERPInfo, "image.system.type");
        return imageSystemType;
    }

    @Override
    protected boolean _saveSSCConfig(Context ctx, String erpId, Map sscConfigMap) throws BOSException, EASBizException {
        ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
        if (service == null) {
            throw new EASBizException(new NumericExceptionSubItem("ERPIMPL_NOTFIND", "can not find ERPWebServiceImpl"));
        }
        return service.saveSSCConfig2Erp(ctx, erpId, sscConfigMap);
    }

    @Override
    protected EASConfig _getEASConfigByERPId(Context ctx, String erpId) throws BOSException, EASBizException {
        EASConfig easConfig = new EASConfig();
        ExtendERPInfo extendERPInfo = null;
        extendERPInfo = ERPUtil.getExtendERPInfoByID(ctx, erpId);
        easConfig.setEasLoginBean(this._getEASLoginBean(ctx, extendERPInfo.getCfgFolder()));
        easConfig.setEasWebServiceBean(this._getEASWebServiceBean(ctx, extendERPInfo.getCfgFolder()));
        easConfig.setSscConfigMap(this._getSSCconfig(ctx, erpId));
        easConfig.setErpId(erpId);
        easConfig.setCfgFolder(extendERPInfo.getCfgFolder());
        easConfig.setErpInfo(extendERPInfo);
        return easConfig;
    }

    @Override
    protected Map _getSSCconfig(Context ctx, String erpId) throws BOSException, EASBizException {
        Map map = new HashMap();
        ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
        if (service == null) {
            throw new EASBizException(new NumericExceptionSubItem("ERPIMPL_NOTFIND", "can not find ERPWebServiceImpl"));
        }
        try {
            map = service.getSSCConfigFromErp(ctx, erpId);
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u914d\u7f6e\u5931\u8d25,\u8fd4\u56de\u7a7aMap." + e.getMessage()), (Throwable)e);
        }
        return map;
    }

    @Override
    protected Map _getSSCconfig(Context ctx, String erpId, EASLoginBean easLoginBean, String ip, String port) throws BOSException, EASBizException {
        Map map = new HashMap();
        ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, erpId);
        if (service == null) {
            throw new EASBizException(new NumericExceptionSubItem("ERPIMPL_NOTFIND", "can not find ERPWebServiceImpl"));
        }
        try {
            String easLoginWsdl = "http://" + ip + ":" + port + "/ormrpc/services/EASLogin?wsdl";
            map = service.getSSCConfigFromErp(ctx, easLoginBean, easLoginWsdl);
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u914d\u7f6e\u5931\u8d25,\u8fd4\u56de\u7a7aMap." + e.getMessage()), (Throwable)e);
        }
        return map;
    }
}

