/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.IEASSignature;
import com.kingdee.eas.base.ssc.BussinessAttributeExtCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeExtFactory;
import com.kingdee.eas.base.ssc.CAType;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.app.AbstractSSCCAFacadeControllerBean;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SSCCAFacadeControllerBean
extends AbstractSSCCAFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SSCCAFacadeControllerBean");

    @Override
    protected boolean _beforeSaveJobBill(Context ctx, String jobID, Map caParamMap) throws BOSException, EASBizException {
        try {
            String tCaTypeStr = (String)caParamMap.get("caType");
            String billID = (String)caParamMap.get("billID");
            CAType caType = CAType.NONE;
            if (tCaTypeStr == null || tCaTypeStr.trim().length() == 0 || billID == null) {
                BussinessAttributeExtCollection extCollection;
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                if (tCaTypeStr == null) {
                    selector.add("bussAttrID.caType");
                }
                JobInfo jobInfo = JobFactory.getLocalInstance(ctx).getJobInfo((IObjectPK)new ObjectUuidPK(jobID), selector);
                if (tCaTypeStr == null || tCaTypeStr.trim().length() == 0) {
                    caType = jobInfo.getBussAttrID().getCaType();
                }
                if ((extCollection = BussinessAttributeExtFactory.getLocalInstance(ctx).getBussinessAttributeExtCollection("where bussId = '" + jobInfo.getBussAttrID().getId() + "' and shareCenterId = '" + jobInfo.getShareCenterID().getId().toString() + "'")) != null && !extCollection.isEmpty()) {
                    caType = extCollection.get(0).getCaType();
                }
                if (billID == null) {
                    billID = jobInfo.getBillID();
                }
            } else {
                caType = CAType.getEnum(tCaTypeStr);
            }
            if (CAType.BOTH.equals((Object)caType) || CAType.CHECK_ONLY.equals((Object)caType)) {
                IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
                BOSObjectType bosType = BOSUuid.read((String)billID).getType();
                ArrayList<String> tBillIdList = new ArrayList<String>();
                tBillIdList.add(billID);
                iEASSignature.checkSignature(bosType, tBillIdList);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    protected boolean _afterSaveJobBill(Context ctx, String jobID, Map caParamMap) throws BOSException, EASBizException {
        try {
            if (caParamMap == null) {
                logger.error((Object)"_afterSaveJobBill caParamMap is null return true");
                return true;
            }
            String tCaTypeStr = (String)caParamMap.get("caType");
            String billID = (String)caParamMap.get("billID");
            CAType caType = CAType.NONE;
            if (tCaTypeStr == null || tCaTypeStr.trim().length() == 0 || billID == null) {
                BussinessAttributeExtCollection extCollection;
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                if (tCaTypeStr == null) {
                    selector.add("bussAttrID.caType");
                }
                JobHisInfo jobInfo = JobHisFactory.getLocalInstance(ctx).getJobHisInfo((IObjectPK)new ObjectUuidPK(jobID), selector);
                if (tCaTypeStr == null || tCaTypeStr.trim().length() == 0) {
                    caType = jobInfo.getBussAttrID().getCaType();
                }
                if ((extCollection = BussinessAttributeExtFactory.getLocalInstance(ctx).getBussinessAttributeExtCollection("where bussId = '" + jobInfo.getBussAttrID().getId() + "' and shareCenterId = '" + jobInfo.getShareCenterID().getId().toString() + "'")) != null && !extCollection.isEmpty()) {
                    caType = extCollection.get(0).getCaType();
                }
                if (billID == null) {
                    billID = jobInfo.getBillID();
                }
            } else {
                caType = CAType.getEnum(tCaTypeStr);
            }
            if (CAType.SIGN_ONLY.equals((Object)caType) || CAType.BOTH.equals((Object)caType)) {
                IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
                BOSObjectType bosType = BOSUuid.read((String)billID).getType();
                ArrayList<String> tBillIdList = new ArrayList<String>();
                tBillIdList.add(billID);
                if (CAType.BOTH.equals((Object)caType) || CAType.SIGN_ONLY.equals((Object)caType)) {
                    String tPlainText = (String)caParamMap.get("plainText");
                    String tSignature = (String)caParamMap.get("signature");
                    if (StringUtils.isEmpty((String)tPlainText) || StringUtils.isEmpty((String)tSignature)) {
                        return true;
                    }
                    if (tPlainText.indexOf("CANNOTSIGNATURE") > -1) {
                        return true;
                    }
                    iEASSignature.checkSignature4Web(tPlainText, tSignature, bosType.toString());
                    ArrayList<String> tSignaList = new ArrayList<String>();
                    tSignaList.add(tSignature);
                    iEASSignature.checkSignature4Web(tBillIdList, tSignaList, bosType.toString());
                    iEASSignature.saveSignature4Web(tSignature, tPlainText, billID, bosType.toString());
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    protected Map _getCaConfigByJobID(Context ctx, String jobID) throws BOSException, EASBizException {
        Map tMap = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("bussAttrID.caType");
            logger.error((Object)("_getCaConfigByJobID****jobID:" + jobID));
            JobInfo jobInfo = JobFactory.getLocalInstance(ctx).getJobInfo((IObjectPK)new ObjectUuidPK(jobID), selector);
            BussinessAttributeExtCollection extCollection = BussinessAttributeExtFactory.getLocalInstance(ctx).getBussinessAttributeExtCollection("where bussId = '" + jobInfo.getBussAttrID().getId() + "' and shareCenterId = '" + jobInfo.getShareCenterID().getId().toString() + "'");
            tMap = JobUtils.getCaConfig(ctx, jobInfo, extCollection.isEmpty() ? null : extCollection.get(0));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tMap == null ? new HashMap() : tMap;
    }

    @Override
    protected void _caSvaeJobBill(Context ctx, String jobID, Map caParamMap) throws BOSException, EASBizException {
        throw new BOSException("\u6682\u672a\u5b9e\u73b0,\u4e0d\u8c03\u7528\u6b64\u65b9\u6cd5.");
    }
}

