/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.AnalysisEnum;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.CheckSchemeFactory;
import com.kingdee.eas.base.ssc.CheckSchemeInfo;
import com.kingdee.eas.base.ssc.CheckTypeEnum;
import com.kingdee.eas.base.ssc.ConsignationTaskTypeEnum;
import com.kingdee.eas.base.ssc.Operation;
import com.kingdee.eas.base.ssc.RoleInfo;
import com.kingdee.eas.base.ssc.RoleTypeInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SampleLibraryFactory;
import com.kingdee.eas.base.ssc.SampleLibraryInfo;
import com.kingdee.eas.base.ssc.SampleStateEnum;
import com.kingdee.eas.base.ssc.TaskStateTimeFactory;
import com.kingdee.eas.base.ssc.TaskStateTimeInfo;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.analysis.ThreadPoll.AnalysisFlowFactory;
import com.kingdee.eas.base.ssc.analysis.ThreadPoll.IAnalysisFlowCallback;
import com.kingdee.eas.base.ssc.analysis.util.AnalysisData;
import com.kingdee.eas.base.ssc.app.AbstractSampleLibraryFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.CreditDeForAuditThread;
import com.kingdee.eas.base.ssc.app.CreditUpdateScoreForAuditThread;
import com.kingdee.eas.base.ssc.app.assign.util.AssignJobUtils;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SampleLibraryFacadeControllerBean
extends AbstractSampleLibraryFacadeControllerBean {
    private static final long serialVersionUID = 4500785713194658420L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SampleLibraryFacadeControllerBean");
    private static int ONCE_QUERY = 5000;
    private static String UPDATESQL = "update T_SSC_SampleLibraryQualityTask set FExaminerID=?,Fconsigner=?, FTaskState='2', FAllotDate=now() where fid = ?";
    Map<String, QualityTask> qtMap = null;

    @Override
    protected Map _assignAll(Context ctx, String sampleLibId) throws BOSException, EASBizException {
        logger.error((Object)("********_assignAll in begin**************" + System.currentTimeMillis()));
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        SampleLibraryInfo smpLibInfo = SampleLibraryFactory.getLocalInstance(ctx).getSampleLibraryInfo((IObjectPK)new ObjectStringPK(sampleLibId));
        CheckSchemeInfo schemeInfo = smpLibInfo.getCheckScheme();
        if (SampleStateEnum.Completed == smpLibInfo.getState()) {
            ret.put("msg", "state can not be completed");
            return ret;
        }
        schemeInfo = CheckSchemeFactory.getLocalInstance(ctx).getCheckSchemeInfo((IObjectPK)new ObjectStringPK(schemeInfo.getId().toString()));
        RoleTypeInfo rtInfo = this._getRoleTypeInfo(ctx, schemeInfo);
        BillTypeInfo bt = schemeInfo.getBilltype();
        RoleInfo roleInfo = schemeInfo.getAllotRole();
        List<UserNumber> users = null;
        boolean assinged = false;
        if (CheckTypeEnum.afterAudit == schemeInfo.getCheckType()) {
            String orgSql = "select FOrgID from T_SSC_SampleLibraryQualityTask where FParentID=? and ftaskState='1' group by FOrgID";
            IRowSet orgRowSet = DbUtil.executeQuery((Context)ctx, (String)orgSql, (Object[])new Object[]{smpLibInfo.getId().toString()});
            try {
                if (this.qtMap == null) {
                    this.initMap(ctx, smpLibInfo);
                }
                while (orgRowSet.next()) {
                    String orgId = orgRowSet.getString("FOrgID");
                    users = this._getAllUsers(ctx, rtInfo, bt, roleInfo, orgId, schemeInfo.getShareCenterId());
                    HashMap<String, Map> consignationMap = this.getConsignationMap(ctx, users, bt, ConsignationTaskTypeEnum.spotCheckJob);
                    int curCount = 0;
                    String taskCountSQL = "select count(1) totalCount from T_SSC_SampleLibraryQualityTask where FParentID=? and ftaskState='1' and FOrgID=?";
                    IRowSet curCountRS = DbUtil.executeQuery((Context)ctx, (String)taskCountSQL, (Object[])new Object[]{smpLibInfo.getId().toString(), orgId});
                    if (curCountRS.next()) {
                        curCount = curCountRS.getInt("totalCount");
                    }
                    logger.info((Object)("*****orgId:" + (orgId == null ? "null" : orgId) + " total taskCount:" + curCount));
                    Map tmpMap = this._doAssign(ctx, users, curCount, smpLibInfo, schemeInfo, orgId, consignationMap, ConsignationTaskTypeEnum.spotCheckJob);
                    if (!tmpMap.get("assinged").equals(true)) continue;
                    assinged = true;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            users = this._getAllUsers(ctx, rtInfo, bt, roleInfo, null, schemeInfo.getShareCenterId());
            HashMap<String, Map> consignationMap = this.getConsignationMap(ctx, users, bt, ConsignationTaskTypeEnum.qualityJob);
            if (users == null || users.size() == 0) {
                logger.info((Object)"*****no user **");
                ret.put("msg", "user not found");
                return ret;
            }
            logger.info((Object)("*****user size**" + users.size()));
            String taskCountSQL = "select count(1) totalCount from T_SSC_SampleLibraryQualityTask where FParentID=? and ftaskState='1'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)taskCountSQL, (Object[])new Object[]{smpLibInfo.getId().toString()});
            int totalCount = 0;
            try {
                if (this.qtMap == null) {
                    this.initMap(ctx, smpLibInfo);
                }
                if (rs.next()) {
                    totalCount = rs.getInt("totalCount");
                }
                logger.info((Object)("*****total taskCount:" + totalCount));
                Map tmpMap2 = this._doAssign(ctx, users, totalCount, smpLibInfo, schemeInfo, null, consignationMap, ConsignationTaskTypeEnum.qualityJob);
                if (tmpMap2.get("assinged").equals(true)) {
                    assinged = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)"*********update task err***********");
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (smpLibInfo.getCheckBeginTime() == null && assinged) {
            String sampleLibSQL = "update T_SSC_SampleLibrary set FState='2', FCheckBeginTime=now() where fid=?";
            try {
                DbUtil.execute((Context)ctx, (String)sampleLibSQL, (Object[])new Object[]{smpLibInfo.getId().toString()});
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        logger.error((Object)("********_assignAll in end**************" + System.currentTimeMillis()));
        return ret;
    }

    private HashMap<String, Map> getConsignationMap(Context ctx, List<UserNumber> users, BillTypeInfo billtype, ConsignationTaskTypeEnum taskType) {
        HashMap<String, Map> map = new HashMap<String, Map>();
        if (users.isEmpty()) {
            return map;
        }
        ArrayList<String> userList = new ArrayList<String>();
        for (UserNumber user : users) {
            userList.add(user.getUserId());
        }
        StringBuffer sb = new StringBuffer();
        String local = ctx.getLocale().toString();
        sb.append(" SELECT c.FCONSIGNERID,c.FASSIGNEEID,u1.fname_" + local + ",u2.fname_" + local);
        sb.append(" ,(select count(1) from T_SSC_SampleLibraryQualityTask task where task.FExaminerID = c.FASSIGNEEID and task.FTaskState='2' and task.FBillTypeID =ce.fbilltype) assignTaskCount");
        sb.append(" FROM T_ssc_consignation c inner join t_ssc_consignationentry ce on ce.fparentid = c.FID");
        sb.append(" inner join t_ssc_user u1 on c.FCONSIGNERID = u1.fid");
        sb.append(" inner join t_ssc_user u2 on c.FASSIGNEEID = u2.fid");
        sb.append(" where c.FCONSIGNERID in " + FormatUtils.list2Sql(userList));
        sb.append(" and ce.fbilltype = ?");
        sb.append(" and c.FSTATUS = ?");
        sb.append(" and ce.ftaskType = ?");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{billtype.getId().toString(), "30", taskType.getValue()});
            while (rs.next()) {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                tempMap.put("userid", rs.getString(2));
                tempMap.put("consignName", rs.getString(3));
                tempMap.put("assignName", rs.getString(4));
                tempMap.put("curNumber", rs.getString(5));
                map.put(rs.getString(1), tempMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)("consiganation error sql:" + sb.toString()), (Throwable)e);
            logger.error((Object)("params:" + billtype.getId().toString()));
        }
        for (String key : map.keySet()) {
            logger.error((Object)("\u59d4\u6258\u4eba\u662f\uff1a" + key + ",\u53d7\u6258\u4eba\u662f\uff1a" + map.get(key)));
        }
        return map;
    }

    private Map _doAssign(Context ctx, List<UserNumber> users, int totalCount, SampleLibraryInfo smpLibInfo, CheckSchemeInfo checkSchemeInfo, String orgId, Map<String, Map> consignMap, ConsignationTaskTypeEnum taskType) {
        HashMap ret = new HashMap(){
            {
                this.put("assinged", false);
            }
        };
        try {
            for (UserNumber user : users) {
                if (!consignMap.containsKey(user.getUserId())) continue;
                user.setCurNumber(user.getCurNumber() + Integer.valueOf((String)consignMap.get(user.getUserId()).get("curNumber")));
            }
            Collections.sort(users);
            List<String> taskIdList = null;
            do {
                taskIdList = this._queryTask(ctx, smpLibInfo.getId().toString(), ONCE_QUERY, orgId);
                logger.info((Object)("*****taskList size:" + taskIdList.size()));
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                CoreBaseCollection collection = new CoreBaseCollection();
                for (int i = 0; i < taskIdList.size(); ++i) {
                    String taskId = taskIdList.get(i);
                    UserNumber finalUserNumber = this.getFinalAssignUser(ctx, users, taskId);
                    String userIdParam = finalUserNumber.getUserId();
                    if (consignMap.containsKey(userIdParam)) {
                        Map mapMessage = consignMap.get(userIdParam);
                        String consignorId = userIdParam;
                        userIdParam = (String)mapMessage.get("userid");
                        AssignJobUtils.checkPermissionIfNoteExistCreate(ctx, userIdParam, checkSchemeInfo.getBilltype().getId().toString(), checkSchemeInfo.getShareCenterId(), taskType);
                        collection.add((CoreBaseInfo)this.getTaskStateInfo(ctx, taskId, userIdParam, mapMessage.get("consignName") + " \u59d4\u6258 " + mapMessage.get("assignName")));
                        paramList.add(new Object[]{userIdParam, consignorId, taskId});
                    } else {
                        paramList.add(new Object[]{userIdParam, null, taskId});
                        collection.add((CoreBaseInfo)this.getTaskStateInfo(ctx, taskId, userIdParam, ""));
                    }
                    finalUserNumber.addition();
                    Collections.sort(users);
                }
                logger.info((Object)("******update size:" + paramList.size()));
                if (paramList.size() <= 0) continue;
                DbUtil.executeBatch((Context)ctx, (String)UPDATESQL, paramList);
                TaskStateTimeFactory.getLocalInstance(ctx).saveBatchData(collection);
                ret.put("assinged", true);
                logger.info((Object)"*****update compelete!");
            } while (taskIdList.size() == ONCE_QUERY);
        }
        catch (Exception e) {
            logger.error((Object)"*********update task err***********");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    private TaskStateTimeInfo getTaskStateInfo(Context ctx, String taskId, String operator, String advice) {
        TaskStateTimeInfo tsInfo = new TaskStateTimeInfo();
        try {
            tsInfo.setTaskID(taskId);
            tsInfo.setOperation(Operation.AutoAssign);
            tsInfo.setChangeTime(new Time(System.currentTimeMillis()));
            UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(operator));
            com.kingdee.eas.base.permission.UserInfo userInfoPermission = new com.kingdee.eas.base.permission.UserInfo();
            userInfoPermission.setId(BOSUuid.read((String)userInfo.getUserID()));
            tsInfo.setCreator(userInfoPermission);
            tsInfo.setLastUpdateUser(userInfoPermission);
            tsInfo.setOperatorId(userInfo);
            tsInfo.setOperationAdvice(advice);
        }
        catch (Exception e) {
            logger.error((Object)"saveTaskStateChange fail");
        }
        return tsInfo;
    }

    private void initMap(Context ctx, SampleLibraryInfo smpLibInfo) throws BOSException, SQLException {
        this.qtMap = new HashMap<String, QualityTask>();
        StringBuffer buffer = new StringBuffer(500);
        buffer.append(" SELECT dh.FDINAMICVALUE ,his.FPERSONNELIDID ,qt.FID FROM t_ssc_jobhis his ");
        buffer.append(" inner join T_SSC_SampleLibraryQualityTask qt on his.FBILLID = qt.FBILLID ");
        buffer.append(" inner join T_SSC_DynValueHis dh on dh.FJOBIDID =his.fid ");
        buffer.append(" where dh.FDYNAMICIDID ='4VBUlqSUQuO8g8sPkTkXsZvLn80=' and his.FISLASTLEVEL =1 ");
        buffer.append(" and exists(SELECT 1 FROM T_SSC_SampleLibraryQualityTask sqt ");
        buffer.append(" where sqt.FParentID=? and sqt.ftaskState='1' and sqt.fid = qt.fid) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{smpLibInfo.getId().toString()});
        while (rs.next()) {
            QualityTask qt = new QualityTask();
            String taskId = rs.getString(3);
            qt.setCreateUser(rs.getString(1));
            qt.setApproveUser(rs.getString(2));
            qt.setTaskId(taskId);
            this.qtMap.put(taskId, qt);
        }
    }

    private UserNumber getFinalAssignUser(Context ctx, List<UserNumber> users, String taskId) {
        QualityTask qt = this.qtMap.get(taskId);
        UserNumber finalUserNumber = users.get(0);
        boolean matchErpUser = false;
        for (int i = 0; i < users.size(); ++i) {
            UserNumber currentUN = users.get(i);
            if (currentUN.getErpUserId().equals(qt.getCreateUser())) {
                matchErpUser = true;
                continue;
            }
            if (currentUN.getUserId().equals(qt.getApproveUser())) {
                if (!matchErpUser) continue;
                finalUserNumber = currentUN;
                continue;
            }
            finalUserNumber = currentUN;
            break;
        }
        return finalUserNumber;
    }

    private List<String> _queryTask(Context ctx, String libId, int size, String orgId) throws Exception {
        IRowSet rs = null;
        String queryTaskSQL = "select top " + size + " fid from T_SSC_SampleLibraryQualityTask where FParentID=? and ftaskState='1'";
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            rs = DbUtil.executeQuery((Context)ctx, (String)queryTaskSQL, (Object[])new Object[]{libId});
        } else {
            queryTaskSQL = queryTaskSQL + " and FOrgID = ?";
            rs = DbUtil.executeQuery((Context)ctx, (String)queryTaskSQL, (Object[])new Object[]{libId, orgId});
        }
        ArrayList<String> ret = new ArrayList<String>();
        while (rs.next()) {
            ret.add(rs.getString("fid"));
        }
        return ret;
    }

    private List<UserNumber> _getAllUsers(Context ctx, RoleTypeInfo rtInfo, BillTypeInfo bt, RoleInfo roleInfo, String orgId, String shareCenterId) throws BOSException {
        StringBuffer sb = new StringBuffer(500);
        Object[] param = null;
        ArrayList<UserNumber> ret = new ArrayList<UserNumber>();
        if ("ROLE_AUDIT".equals(rtInfo.getNumber())) {
            sb.append(" select  ru.fuseridid as userid,u.fuserId as erpuserid,(select count(1) ");
            sb.append(" from T_SSC_SampleLibraryQualityTask task ");
            sb.append(" where task.FExaminerID=ru.fuseridid and task.FTaskState='2') persontaskcount ");
            sb.append(" from t_ssc_roletype rt inner join ");
            sb.append(" (select role.fid roleid ,role.FRoleTypeIDID roleTypeIDID,role.Fnumber roleNumber,rb.fbillnameid billnameid from t_ssc_role role ");
            sb.append(" inner join T_SSC_RoleBussattr rb on role.fid=rb.fparentid) tem ");
            sb.append(" on rt.fid=tem.roleTypeIDID ");
            sb.append(" inner join t_ssc_roleuser ru on tem.roleid=ru.FRoleIDID ");
            sb.append(" inner join t_ssc_user u on ru.FUSERIDID=u.fid");
            sb.append(" inner join t_ssc_billtype bly on tem.billnameid=bly.fid ");
            sb.append(" where rt.fid=?  and bly.fid=? ");
            if (null != roleInfo && !"".equals(roleInfo.getId().toString()) && !roleInfo.getId().toString().isEmpty()) {
                sb.append(" and tem.roleid =? ");
            }
            sb.append(" and u.fshareCenterId='" + shareCenterId + "' and u.FISENABLED=1 and u.FIsStopAssign =0 ");
            sb.append(" and tem.roleNumber not like '%addFor%' ");
            sb.append(" order by persontaskcount ");
            param = null != roleInfo && !"".equals(roleInfo.getId().toString()) && !roleInfo.getId().toString().isEmpty() ? new Object[]{rtInfo.getId().toString(), bt.getId().toString(), roleInfo.getId().toString()} : new Object[]{rtInfo.getId().toString(), bt.getId().toString()};
        } else if ("ROLE_LATER".equals(rtInfo.getNumber())) {
            sb.append(" select  ru.fuseridid as userid ,u.fuserId as erpuserid");
            sb.append(" ,(select count(1) ");
            sb.append(" from T_SSC_SampleLibraryQualityTask task ");
            sb.append(" where task.FExaminerID=ru.fuseridid and task.FTaskState='2' ");
            sb.append(" ) persontaskcount ");
            sb.append(" from t_ssc_roletype rt inner join ");
            sb.append(" (select role.fid roleid,role.FRoleTypeIDID roleTypeIDID,role.Fnumber roleNumber,rb.fbillnameid billnameid from t_ssc_role role inner join T_SSC_RoleBussattr rb on role.fid=rb.fparentid) tem ");
            sb.append(" on rt.fid=tem.roleTypeIDID ");
            sb.append(" inner join t_ssc_roleorg ro on tem.roleid=ro.FRoleIDID ");
            sb.append(" inner join t_ssc_roleuser ru on tem.roleid=ru.FRoleIDID ");
            sb.append(" inner join t_ssc_user u on ru.FUSERIDID=u.fid");
            sb.append(" inner join t_ssc_billtype bly on tem.billnameid=bly.fid ");
            sb.append(" where rt.fid=? and ro.forgidid=? and bly.fid=? ");
            if (null != roleInfo && !"".equals(roleInfo.getId().toString()) && !roleInfo.getId().toString().isEmpty()) {
                sb.append(" and tem.roleid =? ");
            }
            sb.append(" and u.fshareCenterId='" + shareCenterId + "' and u.FISENABLED=1 and u.FIsStopAssign =0 ");
            sb.append(" and tem.roleNumber not like '%addFor%' ");
            sb.append(" order by persontaskcount ");
            param = null != roleInfo && !"".equals(roleInfo.getId().toString()) && !roleInfo.getId().toString().isEmpty() ? new Object[]{rtInfo.getId().toString(), orgId, bt.getId().toString(), roleInfo.getId().toString()} : new Object[]{rtInfo.getId().toString(), orgId, bt.getId().toString()};
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), param);
            while (rs.next()) {
                UserNumber un = new UserNumber();
                String userId = rs.getString("userid");
                String erpUserId = rs.getString("erpuserid");
                int number = rs.getInt("persontaskcount");
                un.setUserId(userId);
                un.setErpUserId(erpUserId);
                un.setCurNumber(number);
                ret.add(un);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    private RoleTypeInfo _getRoleTypeInfo(Context ctx, CheckSchemeInfo schemeInfo) {
        CheckTypeEnum cte = schemeInfo.getCheckType();
        RoleTypeInfo ret = null;
        if (cte == CheckTypeEnum.afterAudit) {
            ret = new RoleTypeInfo();
            ret.setId(BOSUuid.read((String)"o9Taq/+5QSKDMQrAQo+1uS0WZ4A="));
            ret.setNumber("ROLE_LATER");
        } else if (cte == CheckTypeEnum.AuditCheck) {
            ret = new RoleTypeInfo();
            ret.setId(BOSUuid.read((String)"BqMHsn0QTrafsG4XPzjMpC0WZ4A="));
            ret.setNumber("ROLE_AUDIT");
        }
        return ret;
    }

    @Override
    protected boolean _closeSample(Context ctx, List list) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String closeDate = "{ts'" + sdf.format(new Date()) + "'}";
        String sql = "update t_ssc_samplelibrary  set FState= ? , FCloseLibraryTime=" + closeDate + " where FID = ? ";
        String sql2 = "update t_ssc_samplelibraryqualitytask set FTaskState=? where FParentID= ? ";
        String sql3 = "UPDATE T_SSC_SAMPLELIBRARYQUALITYTASK SET FREVISESTATE=0, FTASKSTATE=? WHERE FPARENTID=? AND FCHECKRESULT='0';";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsList2 = new ArrayList<Object[]>();
        StringBuffer sam = new StringBuffer();
        String sqlsam = "";
        IRowSet rs = null;
        List<String> samList = new ArrayList();
        if (list.size() > 1) {
            int i = 0;
            if (i < list.size() - 1) {
                for (i = 0; i < list.size() - 1; ++i) {
                    sam.append("'" + list.get(i) + "'");
                    sam.append(',');
                }
            }
            if (i == list.size() - 1) {
                sam.append("'" + list.get(i) + "'");
            }
            sqlsam = "select fid from t_ssc_samplelibrary where fid in (" + sam.toString() + ") order by fCheckCompleteTime asc";
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlsam);
            try {
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    samList.add(fid);
                }
            }
            catch (SQLException e1) {
                logger.error((Object)("*************" + e1.getMessage()), (Throwable)e1);
            }
        } else {
            samList = list;
            if (list.size() == 1) {
                sam.append("'" + list.get(0) + "'");
            }
        }
        String taskSql = "SELECT FBILLID  FROM T_SSC_SAMPLELIBRARYQUALITYTASK WHERE FParentID IN (" + sam.toString() + ")";
        IRowSet taskRs = null;
        taskRs = DbUtil.executeQuery((Context)ctx, (String)taskSql);
        String billId = "";
        try {
            IAnalysisFlowCallback ctr = AnalysisFlowFactory.getInstanse("com.kingdee.eas.base.ssc.analysis.ThreadPoll.AnalysisThreadPool");
            while (taskRs.next()) {
                billId = taskRs.getString("FBILLID");
                AnalysisData analysisData = new AnalysisData();
                analysisData.setAnalysisType("bill").setDate(new Date()).setUuid(billId).setOperateType(AnalysisEnum.BILL_FINISH);
                ctr.afterFlow(ctx, analysisData);
            }
        }
        catch (SQLException e1) {
            logger.error((Object)("*************" + e1.getMessage()), (Throwable)e1);
        }
        catch (SSCException e) {
            logger.error((Object)("SSCException" + e.getMessage()), (Throwable)((Object)e));
        }
        catch (EASBizException e) {
            logger.error((Object)("EASBizException" + e.getMessage()), (Throwable)e);
        }
        for (int i = 0; i < samList.size(); ++i) {
            String sampleId = (String)samList.get(i);
            paramsList.add(new Object[]{Integer.valueOf("4"), sampleId});
            paramsList2.add(new Object[]{Integer.valueOf("4"), sampleId});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        DbUtil.executeBatch((Context)ctx, (String)sql2, paramsList2);
        DbUtil.executeBatch((Context)ctx, (String)sql3, paramsList2);
        try {
            CreditDeForAuditThread tCreditDeForAuditThread = new CreditDeForAuditThread(ctx, samList);
            Thread tThread = new Thread(tCreditDeForAuditThread);
            tThread.start();
        }
        catch (Exception e) {
            logger.error((Object)("******CreditDeForAuditThread*******" + e.getMessage()), (Throwable)e);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            CreditUpdateScoreForAuditThread tCreditUpdateScoreForAuditThread = new CreditUpdateScoreForAuditThread(ctx, samList);
            Thread tScoreThread = new Thread(tCreditUpdateScoreForAuditThread);
            tScoreThread.start();
        }
        catch (Exception e) {
            logger.error((Object)("******CreditUpdateScoreForAuditThread*******" + e.getMessage()), (Throwable)e);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    class UserNumber
    implements Comparable<UserNumber> {
        String erpUserId;
        String userId;
        int curNumber;

        UserNumber() {
        }

        public int getCurNumber() {
            return this.curNumber;
        }

        public void setCurNumber(int curNumber) {
            this.curNumber = curNumber;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getErpUserId() {
            return this.erpUserId;
        }

        public void setErpUserId(String erpUserId) {
            this.erpUserId = erpUserId;
        }

        @Override
        public int compareTo(UserNumber userN2) {
            return this.curNumber - userN2.getCurNumber();
        }

        public void subtraction() {
            --this.curNumber;
        }

        public void addition() {
            ++this.curNumber;
        }
    }

    class QualityTask {
        private String taskId;
        private String approveUser;
        private String createUser;

        QualityTask() {
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getApproveUser() {
            return this.approveUser;
        }

        public void setApproveUser(String approveUser) {
            this.approveUser = approveUser;
        }

        public String getCreateUser() {
            return this.createUser;
        }

        public void setCreateUser(String createUser) {
            this.createUser = createUser;
        }
    }
}

