/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.JobHisCollection;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireCollection;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireFactory;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireInfo;
import com.kingdee.eas.base.ssc.SatisfactionBillUnReaFactory;
import com.kingdee.eas.base.ssc.SatisfactionBillUnReaInfo;
import com.kingdee.eas.base.ssc.SatisfactionDataFilterFacadeFactory;
import com.kingdee.eas.base.ssc.SatisfactionDimensionEntryInfo;
import com.kingdee.eas.base.ssc.SatisfactionUnsatisfyReasonFactory;
import com.kingdee.eas.base.ssc.SatisfactionUnsatisfyReasonInfo;
import com.kingdee.eas.base.ssc.StfcBillInquireDimensionEntryCollection;
import com.kingdee.eas.base.ssc.StfcBillInquireDimensionEntryInfo;
import com.kingdee.eas.base.ssc.YesOrNo;
import com.kingdee.eas.base.ssc.app.AbstractSatisfactionReplyFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.SatisfactionEvaluateEnum;
import com.kingdee.eas.base.ssc.app.SatisfactionHisAssess;
import com.kingdee.eas.base.ssc.app.SatisfactionHisSendEnum;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.ERPWebServiceBill;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SatisfactionReplyFacadeControllerBean
extends AbstractSatisfactionReplyFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SatisfactionReplyFacadeControllerBean");

    @Override
    protected boolean _toSatisfactionReply(Context ctx, String radio, String textAr, Map otherParam) throws BOSException, EASBizException {
        if (otherParam.get("jobID") == null) {
            return false;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("jobhisid", (Object)otherParam.get("jobID").toString()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("jobhisid.*");
        sic.add("creditFilesid.*");
        sic.add("billTypeid.*");
        view.setFilter(filter);
        view.setSelector(sic);
        SatisfactionBillInquireCollection coll = SatisfactionBillInquireFactory.getLocalInstance(ctx).getSatisfactionBillInquireCollection(view);
        SatisfactionBillInquireInfo info = coll.get(0);
        info.setEvaluateOfdate(new Timestamp(new Date().getTime()));
        info.setAutoEvaluate(YesOrNo.No);
        if ("1".equals(radio)) {
            info.setEvaluateResult(SatisfactionEvaluateEnum.worst);
        } else if ("2".equals(radio)) {
            info.setEvaluateResult(SatisfactionEvaluateEnum.dissatisfied);
        } else if ("3".equals(radio)) {
            info.setEvaluateResult(SatisfactionEvaluateEnum.ordinary);
        } else if ("4".equals(radio)) {
            info.setEvaluateResult(SatisfactionEvaluateEnum.contentment);
        } else {
            info.setEvaluateResult(SatisfactionEvaluateEnum.exellent);
        }
        String reason = (String)otherParam.get("reason");
        if (reason != null && reason != "") {
            this.saveSatisfactionBillUnReason(ctx, (String)otherParam.get("reason"), info);
        }
        info.setEvaluateContent(textAr);
        info.setIsEvaluate(SatisfactionHisAssess.hisAssess);
        this.setDimensions(ctx, info, otherParam);
        SatisfactionBillInquireFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), info);
        return true;
    }

    private void saveSatisfactionBillUnReason(Context ctx, String reason, SatisfactionBillInquireInfo info) throws EASBizException, BOSException {
        SatisfactionBillUnReaInfo billUnReaInfo = null;
        String[] reasons = reason.split(",");
        StringBuilder sb = new StringBuilder();
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < reasons.length; ++i) {
            billUnReaInfo = new SatisfactionBillUnReaInfo();
            billUnReaInfo.setSatisfactionBill(info);
            SatisfactionUnsatisfyReasonInfo reasonInfo = (SatisfactionUnsatisfyReasonInfo)SatisfactionUnsatisfyReasonFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(reasons[i]));
            billUnReaInfo.setUnReason(reasonInfo);
            sb.append(reasonInfo.getName() + "\uff0c");
            colls.add((CoreBaseInfo)billUnReaInfo);
        }
        if (colls.size() > 0) {
            SatisfactionBillUnReaFactory.getLocalInstance(ctx).saveBatchData(colls);
        }
        if (sb.length() > 0) {
            info.setUnReason(sb.toString().substring(0, sb.toString().length() - 1));
        }
    }

    @Override
    protected String _satisfactionAppraise(Context ctx, String radio, String textAr, Map otherParam) throws BOSException, EASBizException {
        SatisfactionBillInquireInfo info;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String isSatisfaction = "";
        String billID = otherParam.get("billID").toString();
        if (billID == null) {
            result.put("success", false);
            result.put("msg", "\u5355\u636eID\u4e0d\u5b58\u5728");
            logger.error((Object)("******billID*****: " + billID));
            return JSONUtils.convertObjectToJson((Context)ctx, result);
        }
        EntityViewInfo view1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        HashSet<String> jobStateSet = new HashSet<String>();
        jobStateSet.add(JobState.Passed.getValue());
        jobStateSet.add(JobState.ToVouchered.getValue());
        filter1.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        filter1.getFilterItems().add(new FilterItemInfo("isLastLevel", (Object)1));
        filter1.getFilterItems().add(new FilterItemInfo("jobState", jobStateSet, CompareType.INCLUDE));
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add("id");
        sic1.add("shareCenterID");
        sic1.add("bussAttrID.billType.id");
        view1.setFilter(filter1);
        view1.setSelector(sic1);
        JobHisCollection coll1 = JobHisFactory.getLocalInstance(ctx).getJobHisCollection(view1);
        JobHisInfo jobHisInfo = coll1.get(0);
        try {
            isSatisfaction = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(jobHisInfo.getShareCenterID().getId().toString()), (String)"SSC_SatisfactionControl");
            if (!"true".equals(isSatisfaction)) {
                logger.error((Object)("\u6ee1\u610f\u5ea6\u53c2\u6570\u6ca1\u6709\u5f00\u542f*******************SSC_SatisfactionControl**isSatisfaction" + isSatisfaction));
                result.put("success", false);
                result.put("msg", "\u6ee1\u610f\u5ea6\u53c2\u6570\u6ca1\u6709\u5f00\u542f!");
                return JSONUtils.convertObjectToJson((Context)ctx, result);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("EASBizException \u83b7\u53d6\u6ee1\u610f\u5ea6\u53c2\u6570\u5931\u8d25" + isSatisfaction), (Throwable)e);
        }
        if (jobHisInfo == null) {
            result.put("success", false);
            result.put("msg", "\u5171\u4eab\u4e2d\u5fc3\u4e0d\u5b58\u5728\u6b64\u5355\u636e\u7684\u4efb\u52a1\uff01");
            return JSONUtils.convertObjectToJson((Context)ctx, result);
        }
        try {
            boolean flag = SatisfactionDataFilterFacadeFactory.getLocalInstance(ctx).isNeedToSatisfactionTaskByJobhis(jobHisInfo);
            if (!flag) {
                logger.error((Object)("\u5355\u636e\u4e0d\u6ee1\u8db3\u6570\u636e\u8fc7\u6ee4\u89c4\u5219**isNeedToSatisfactionTaskByJobhis***+flag***" + flag + "jobid=" + jobHisInfo.getId().toString()));
                result.put("success", false);
                result.put("msg", "\u5355\u636e\u4e0d\u6ee1\u8db3\u6ee1\u610f\u5ea6\u6570\u636e\u8fc7\u6ee4\u89c4\u5219\uff01");
                return JSONUtils.convertObjectToJson((Context)ctx, result);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("EASBizException---SatisfactionBillInquireToTaskFacadeControllerBean--\u5355\u636e\u6ee1\u610f\u5ea6\u6570\u636e\u8fc7\u6ee4\u89c4\u5219\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        String jobhisid = jobHisInfo.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("jobhisid", (Object)jobhisid));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("jobhisid.*");
        sic.add("creditFilesid.*");
        sic.add("billTypeid.*");
        view.setFilter(filter);
        view.setSelector(sic);
        SatisfactionBillInquireCollection coll = SatisfactionBillInquireFactory.getLocalInstance(ctx).getSatisfactionBillInquireCollection(view);
        boolean addNewFlag = true;
        if (coll.size() > 0) {
            addNewFlag = false;
            info = coll.get(0);
            if (info != null && info.getIsEvaluate() != null && SatisfactionHisAssess.hisAssess.getValue().equals(info.getIsEvaluate().getValue())) {
                result.put("success", false);
                result.put("msg", "\u4efb\u52a1\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7\uff01");
                return JSONUtils.convertObjectToJson((Context)ctx, result);
            }
        } else {
            addNewFlag = true;
            info = new SatisfactionBillInquireInfo();
            info.setSendOfdate(new Timestamp(System.currentTimeMillis()));
            info.setSatisfactionHisSend(SatisfactionHisSendEnum.unSend);
        }
        jobHisInfo.setHisSendSatisfaction(YesOrNo.Yes);
        try {
            JobHisFactory.getLocalInstance(ctx).update(H.PK(jobHisInfo.getId().toString()), (CoreBaseInfo)jobHisInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        info.setJobhisid(jobHisInfo);
        info.setShareCenterId(jobHisInfo.getShareCenterID().getId().toString());
        BillTypeInfo billType = jobHisInfo.getBussAttrID().getBillType();
        info.setBillTypeid(billType);
        CreditFilesNewInfo creditFilesInfo = JobUtils.getCreditFilesByJobHis(ctx, jobHisInfo);
        info.setCreditFilesNew(creditFilesInfo);
        info.setEvaluateOfdate(new Timestamp(System.currentTimeMillis()));
        info.setAutoEvaluate(YesOrNo.No);
        if ("0".equals(radio)) {
            info.setEvaluateResult(SatisfactionEvaluateEnum.worst);
        } else if ("1".equals(radio)) {
            info.setEvaluateResult(SatisfactionEvaluateEnum.dissatisfied);
        } else if ("2".equals(radio)) {
            info.setEvaluateResult(SatisfactionEvaluateEnum.ordinary);
        } else if ("3".equals(radio)) {
            info.setEvaluateResult(SatisfactionEvaluateEnum.contentment);
        } else {
            info.setEvaluateResult(SatisfactionEvaluateEnum.exellent);
        }
        String reason = (String)otherParam.get("reason");
        if (!StringUtils.isEmpty((String)reason)) {
            this.saveSatisfactionBillUnReason(ctx, (String)otherParam.get("reason"), info);
        }
        info.setEvaluateContent(textAr);
        info.setIsEvaluate(SatisfactionHisAssess.hisAssess);
        this.setDimensions(ctx, info, otherParam);
        if (addNewFlag) {
            SatisfactionBillInquireFactory.getLocalInstance(ctx).addnew(info);
        } else {
            SatisfactionBillInquireFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), info);
        }
        ExtendERPInfo extendERPInfo = ERPUtil.getExtendERPInfo(ctx, jobhisid);
        try {
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, extendERPInfo.getId().toString());
            if (service == null) {
                throw new BOSException("can not find ERPWebServiceImpl");
            }
            if (service instanceof ERPWebServiceBill) {
                boolean flag = ((ERPWebServiceBill)((Object)service)).sendSatisfaction(ctx, extendERPInfo, billID);
                result.put("success", flag);
                result.put("msg", "");
                return JSONUtils.convertObjectToJson((Context)ctx, result);
            }
            throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.put("success", true);
            result.put("msg", "\u63d0\u4ea4\u6210\u529f");
            return JSONUtils.convertObjectToJson((Context)ctx, result);
        }
    }

    private void setDimensions(Context ctx, SatisfactionBillInquireInfo info, Map params) throws BOSException {
        if (null == params.get("dimensions") || StringUtils.isEmpty((String)params.get("dimensions").toString())) {
            return;
        }
        String dimensionsStr = params.get("dimensions").toString();
        info.setDimensionStr(dimensionsStr);
        List arrayList = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)dimensionsStr, List.class);
        StfcBillInquireDimensionEntryCollection entries = new StfcBillInquireDimensionEntryCollection();
        for (int i = 0; i < arrayList.size(); ++i) {
            StfcBillInquireDimensionEntryInfo billInquire = new StfcBillInquireDimensionEntryInfo();
            billInquire.setParent(info);
            SatisfactionDimensionEntryInfo satisfactionDimensionEntry = new SatisfactionDimensionEntryInfo();
            Map map = (Map)arrayList.get(i);
            satisfactionDimensionEntry.setId(BOSUuid.read((String)map.get("id").toString()));
            billInquire.setDimension(satisfactionDimensionEntry);
            billInquire.setName(map.get("name").toString());
            billInquire.setNumber(map.get("number").toString());
            String score = map.get("score").toString();
            SatisfactionEvaluateEnum see = this.getEvaluateEnum(score);
            billInquire.setEvaluateResult(see);
            entries.add(billInquire);
        }
        info.put("dimension", (Object)entries);
    }

    private SatisfactionEvaluateEnum getEvaluateEnum(String score) {
        if ("0".equals(score)) {
            return SatisfactionEvaluateEnum.worst;
        }
        if ("1".equals(score)) {
            return SatisfactionEvaluateEnum.dissatisfied;
        }
        if ("2".equals(score)) {
            return SatisfactionEvaluateEnum.ordinary;
        }
        if ("3".equals(score)) {
            return SatisfactionEvaluateEnum.contentment;
        }
        return SatisfactionEvaluateEnum.exellent;
    }
}

