/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.StandardBillRuleInfo;
import com.kingdee.eas.base.ssc.app.AbstractStandardBillRuleControllerBean;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class StandardBillRuleControllerBean
extends AbstractStandardBillRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.StandardBillRuleControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandardBillRuleInfo info = (StandardBillRuleInfo)model;
        info.setShareCenterID(ShareCenterUtils.getShareCenterIdByCtx(ctx));
        info.setIsEnable(true);
        this._checkNumberDup(ctx, (IObjectValue)info);
        this._checkNameDup(ctx, model);
        this._checkPriorityDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        this._checkPriorityDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandardBillRuleInfo standardBillRuleInfo = (StandardBillRuleInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)standardBillRuleInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (standardBillRuleInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)standardBillRuleInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (standardBillRuleInfo.getBussAttr() != null) {
            filterItem = new FilterItemInfo("bussAttr.id", (Object)standardBillRuleInfo.getBussAttr().getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (standardBillRuleInfo.getShareCenterID() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)standardBillRuleInfo.getShareCenterID());
            filter.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, standardBillRuleInfo, "number") + " : " + standardBillRuleInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandardBillRuleInfo standardBillRuleInfo = (StandardBillRuleInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)standardBillRuleInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (standardBillRuleInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)standardBillRuleInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (standardBillRuleInfo.getBussAttr() != null) {
            filterItem = new FilterItemInfo("bussAttr.id", (Object)standardBillRuleInfo.getBussAttr().getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (standardBillRuleInfo.getShareCenterID() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)standardBillRuleInfo.getShareCenterID());
            filter.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, standardBillRuleInfo, "name") + " : " + standardBillRuleInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private void _checkPriorityDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandardBillRuleInfo standardBillRuleInfo = (StandardBillRuleInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("priority", (Object)standardBillRuleInfo.getPriority(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (standardBillRuleInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)standardBillRuleInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (standardBillRuleInfo.getBussAttr() != null) {
            filterItem = new FilterItemInfo("bussAttr.id", (Object)standardBillRuleInfo.getBussAttr().getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (standardBillRuleInfo.getShareCenterID() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)standardBillRuleInfo.getShareCenterID());
            filter.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filter)) {
            throw new SSCException(SSCException.PRIORITY_DUPLICATED);
        }
    }

    @Override
    protected boolean _batchChangeStatus(Context ctx, boolean isEnable, String[] standardBillIds) throws BOSException, EASBizException {
        int FIsEnabled = isEnable ? 1 : 0;
        String sql = "update T_SSC_StandardBillRule set FISEnable = ? where FID = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String standardBillId : standardBillIds) {
            paramsList.add(new Object[]{FIsEnabled, standardBillId});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        return true;
    }
}

