/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.ssc.UserFacadeFactory;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractUserFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.AssignJobFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.StopAssignEnum;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class UserFacadeControllerBean
extends AbstractUserFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.UserFacadeControllerBean");

    @Override
    protected boolean _hasUndoJob(Context ctx, String userId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userId)) {
            return false;
        }
        StringBuffer checkSql = new StringBuffer();
        checkSql.append(" select j.fid from t_ssc_job j ");
        checkSql.append(" inner join (select role.fid,role.FRoleTypeIDID,rb.fbussnameid from T_SSC_RoleBussattr rb inner join  t_ssc_role role on role.fid= rb.fparentid ) tem ");
        checkSql.append(" on tem.fbussnameid = j.FBUSSATTRIDID ");
        checkSql.append(" inner join T_SSC_RoleUser ru on ru.FROLEIDID = tem.fid and ru.FUSERIDID = j.FPERSONNELIDID ");
        checkSql.append(" inner join T_SSC_User u on ru.FUSERIDID = u.fid ");
        checkSql.append(" inner join T_SSC_RoleOrg ro on ro.FROLEIDID = tem.fid and ro.FORGIDID = j.FORGIDID ");
        checkSql.append(" where u.fid = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])new Object[]{userId});
        if (rowSet != null && rowSet.size() > 0) {
            logger.error((Object)"*****************\u5f53\u524d\u7528\u6237\u540d\u4e0b\u6709\u672a\u5904\u7406\u6216\u5904\u7406\u4e2d\u7684\u4efb\u52a1********************");
            return true;
        }
        return false;
    }

    @Override
    protected IObjectCollection _getUndoUserColl(Context ctx, List userIdList) throws BOSException, EASBizException {
        if (userIdList == null || userIdList.isEmpty()) {
            return null;
        }
        HashSet<String> userIdSet = new HashSet<String>();
        for (int i = 0; i < userIdList.size(); ++i) {
            String userId = (String)userIdList.get(i);
            boolean result = this._hasUndoJob(ctx, userId);
            if (!result) continue;
            userIdSet.add(userId);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", userIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        return UserFactory.getLocalInstance(ctx).getUserCollection(view);
    }

    @Override
    protected List _batchChangeStatus(Context ctx, List userIdList, boolean isEnabled) throws BOSException, EASBizException {
        int i;
        int FIsEnabled = isEnabled ? 1 : 0;
        String shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
        ArrayList<UserInfo> failUsers = new ArrayList<UserInfo>();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        if (isEnabled) {
            for (i = 0; i < userIdList.size(); ++i) {
                String userId = (String)userIdList.get(i);
                UserInfo userInfo = this.checkChange2Enable(ctx, userId);
                if (userInfo == null) {
                    paramsList.add(new Object[]{FIsEnabled, userId, shareCenterId});
                    continue;
                }
                failUsers.add(userInfo);
            }
        } else {
            for (i = 0; i < userIdList.size(); ++i) {
                String userId = (String)userIdList.get(i);
                UserInfo userInfo = this.checkChange2Disable(ctx, userId);
                if (userInfo == null) {
                    paramsList.add(new Object[]{FIsEnabled, userId, shareCenterId});
                    continue;
                }
                failUsers.add(userInfo);
            }
        }
        String batchSql = "update T_SSC_User set FISEnabled = ? where FID = ? and FShareCenterId=?";
        DbUtil.executeBatch((Context)ctx, (String)batchSql, paramsList);
        return failUsers;
    }

    private UserInfo checkChange2Enable(Context ctx, String userId) throws EASBizException, BOSException {
        UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo(H.PK(userId));
        try {
            String sql = "select u2.fname_l2 name,u2.fshareCenterId shareCenterId from t_ssc_user u1,t_ssc_user u2 where u1.fid=? and u1.FUSERID = u2.FUSERID and u1.fid != u2.fid and u2.FISENABLED = '1'";
            Object[] params = new Object[]{userId};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs.next()) {
                userInfo = new UserInfo();
                userInfo.setName(rs.getString("name"));
                userInfo.setShareCenterId(rs.getString("shareCenterId"));
                String shareCenterName = ShareCenterUtils.getShareCenterNameById(ctx, userInfo.getShareCenterId());
                userInfo.setDescription(shareCenterName);
                return userInfo;
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return userInfo;
        }
        return null;
    }

    private UserInfo checkChange2Disable(Context ctx, String userId) throws EASBizException, BOSException {
        UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo(H.PK(userId));
        try {
            String sql = "select u.fid from t_ssc_user u inner join t_ssc_roleuser ru on u.fid = ru.FUSERIDID inner join t_ssc_role r on ru.FROLEIDID = r.fid where u.fid = ? and  r.FROLETYPEIDID = '/4qlL+q5zE2iZxXCPaHgBC0WZ4A='";
            Object[] params = new Object[]{userId};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs.next()) {
                userInfo.setDescription("\u5171\u4eab\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u7981\u7528,\u8bf7\u5148\u53d6\u6d88\u5176\u7ba1\u7406\u5458\u6743\u9650!");
                return userInfo;
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return userInfo;
        }
        return null;
    }

    @Override
    protected List _batchUpdateStopAssign(Context ctx, List userIds, boolean isStopAssign) throws BOSException, EASBizException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 0; i < userIds.size(); ++i) {
            String userId = (String)userIds.get(i);
            paramsList.add(new Object[]{isStopAssign, userId});
        }
        String batchSql = "update T_SSC_User set FIsStopAssign = ?, FStopAssignStartTime = null, FStopAssignEndTime =  null where FID = ?";
        DbUtil.executeBatch((Context)ctx, (String)batchSql, paramsList);
        return null;
    }

    @Override
    protected List _batchUpdateStopAssignTime(Context ctx, List userIds, long startTime, long endTime) throws BOSException, EASBizException {
        StopAssignEnum stopAssignState = StopAssignEnum.normal;
        Long now = new Date().getTime();
        if (now < endTime && now > startTime) {
            stopAssignState = StopAssignEnum.suspend;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 0; i < userIds.size(); ++i) {
            String userId = (String)userIds.get(i);
            paramsList.add(new Object[]{stopAssignState.getValue(), new Timestamp(startTime), new Timestamp(endTime), userId});
        }
        String batchSql = "update T_SSC_User set FIsStopAssign = ? , FStopAssignStartTime = ? , FStopAssignEndTime = ? where FID = ?";
        DbUtil.executeBatch((Context)ctx, (String)batchSql, paramsList);
        return null;
    }

    @Override
    protected List<?> _batchUpdateStopAssign(Context ctx) throws BOSException, EASBizException {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select u.FID userId ,u.FStopAssignEndTime endTime ,u.FIsStopAssign isStopAssign from T_SSC_User u");
        checkSql.append(" where u.FStopAssignStartTime < ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])new Object[]{new Timestamp(new Date().getTime())});
        if (rowSet == null || rowSet.size() == 0) {
            logger.error((Object)"*****************\u6240\u6709\u7528\u6237\u7684\u6682\u505c\u5206\u914d\u72b6\u6001\u6b63\u5e38********************");
            return null;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        try {
            ArrayList<String> normalUserList = new ArrayList<String>();
            while (rowSet.next()) {
                Timestamp endTime = rowSet.getTimestamp("endTime");
                Long now = new Date().getTime();
                StopAssignEnum isStopAssign = StopAssignEnum.normal;
                if (now < endTime.getTime() && StopAssignEnum.normal == StopAssignEnum.getEnum(rowSet.getString("isStopAssign"))) {
                    isStopAssign = StopAssignEnum.suspend;
                    paramsList.add(new Object[]{isStopAssign.getValue(), rowSet.getString("userId")});
                    continue;
                }
                if (now < endTime.getTime()) continue;
                normalUserList.add(rowSet.getString("userId"));
            }
            if (normalUserList.size() > 0) {
                UserFacadeFactory.getLocalInstance(ctx).batchUpdateStopAssign(normalUserList, false);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String batchSql = "update T_SSC_User set FIsStopAssign = ? where FID = ?";
        DbUtil.executeBatch((Context)ctx, (String)batchSql, paramsList);
        return null;
    }

    @Override
    protected boolean _batchUpdateApproveCoe(Context ctx, List userIds, double approveCoe) throws BOSException, EASBizException {
        String sql = "update t_Ssc_user set FApproveCoe = ? where FID = ? ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 0; i < userIds.size(); ++i) {
            String userId = (String)userIds.get(i);
            paramsList.add(new Object[]{approveCoe, userId});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        try {
            AssignJobFacadeControllerBean.initUserMap(ctx, null);
        }
        catch (SQLException e) {
            logger.error((Object)"\u521d\u59cb\u5316\u7528\u6237\u7cfb\u6570\u5931\u8d25", (Throwable)e);
        }
        return true;
    }
}

